@/home/salmon/realtime/QL/ASI/common/environment.pro
@/home/salmon/realtime/QL/ASI/common/shift_set.pro
;#####################################################################
;#
;#	Main routine
;#		mk_mpeg_color.pro
;#
;#		This program makes a color MPEG-movie from 5577 & 6300 images.
;#
;#  Change Log:
;#  * 2004/10/29 KUBOTA Minoru <mkubota@nict.go.jp>
;#  * 2004/08/20 KUBOTA Minoru <mkubota@nict.go.jp>
;#  * 2002/01/30 FIP
;#  * 2002/08/20 KUBOTA Minoru <mkubota@crl.go.jp>
;#    - first release.
;#
;#####################################################################

pro mk_mpeg_color, yyyymmdd, step, interval
	;;;;; step: step rate (0..Automatic ditermination, 1..All image, 2, 3, 4, ...)
	;;;;; interval: movie playing speed (1..Fastest, 2, 3, 4, ....)
DEBUG=0	; Display use flag (0..not USE [nomal mode], 1..USE [debug mode])

;=====================================================================
;=	set parameters
;=====================================================================
yyyymmdd=long(yyyymmdd) & date=strtrim(string(yyyymmdd),2)
date2=strmid(date,0,6)
emiss=['5577','6300']
qlpath=strarr(2)
environment, dev_nam, d_div, paths
	qlpath(0)=paths(2)+date+d_div	; path for ASI QL image files
	qlpath(1)=paths(3)+date+d_div	; path for ASI QL image files
	mv_path=paths(13)+date2+d_div	; path for mpeg movie files
	read_jpeg, paths(15), nict
	if dev_nam eq 'win' then begin
		spawn, 'mkdir ' + mv_path, /HIDE
	endif
	if dev_nam eq 'X' then begin
		spawn, 'mkdir -m 775 ' + mv_path
	endif

shift_set, date, xsft, ysft

mpname=mv_path+'ASI'+date+'_color_'+strtrim(string(fix(interval)),2)+'.mpg'

;=====================================================================
;=	Making the list of data-filename and time
;=====================================================================
fnn=strarr(2000,2)
obs_tm=dblarr(2000,2)
obs_tms=strarr(2000,2)
dnum=intarr(2)
for j=0, 1 do begin
	fnn0=findfile(qlpath(j)+'*_1.jpg', count=dnum0)
	if dnum0 eq 0 then begin
		print, 'no '+emiss(j)+' OL image data!'
		goto, exit4
	endif
	dnum(j)=dnum0
	print, emiss(j)+': ',dnum(j), 'files.'
	fnn0=fnn0(sort(fnn0))
	fnn(0:dnum(j)-1,j:j)=fnn0
	for i=0, dnum(j)-1 do begin
		yr=strmid(fnn(i,j),strpos(fnn(i,j), '_1.jpg')-14,4)
		mt=strmid(fnn(i,j),strpos(fnn(i,j), '_1.jpg')-10,2)
		dt=strmid(fnn(i,j),strpos(fnn(i,j), '_1.jpg')-8,2)
		hr=strmid(fnn(i,j),strpos(fnn(i,j), '_1.jpg')-6,2)
		mn=strmid(fnn(i,j),strpos(fnn(i,j), '_1.jpg')-4,2)
		sc=strmid(fnn(i,j),strpos(fnn(i,j), '_1.jpg')-2,2)
		obs_tm(i,j)=double(dt)+double(hr)/24.0+double(mn)/60.0/24.0+double(sc)/60.0/60.0/24.0
		obs_tms(i,j)=dt+'/'+mt+'/'+yr+'  '+hr+':'+mn+':'+sc
	endfor
	exit4:
endfor
if dnum(0) eq 0 then goto, exit2
flag=0
if dnum(1) eq 0 then flag=1

;=====================================================================
;=	Determination of the number of images to make the animation
;=====================================================================
if step eq 0 then begin
	step=fix((dnum(0)+50)/100)
	if step eq 0 then step=1
endif
inum=fix((dnum(0)+step-1)/step)
print, 'the number of 5577 images = '+strtrim(string(fix(dnum(0))),2)
print, 'step = '+strtrim(string(fix(step)),2)
print, 'the number of images used for movie = '+strtrim(string(fix(inum)),2)
fnam=strarr(inum,2) & fnam(*,*)='no_image'
tim=strarr(inum,2)
for i=0, dnum(0)-1, step do begin
	fnam(i/step,0)=fnn(i,0)
	tim(i/step,0)=obs_tms(i,0)
endfor
if flag eq 0 then begin
	for i=0, dnum(0)-1, step do begin
		temp=abs(obs_tm(0:dnum(1)-1, 1:1)-obs_tm(i, 0))
		if min(temp) gt 0.002 then goto, exit3
		temp2=where(temp le min(temp))
		fnam(i/step,1)=fnn(temp2(0),1)
		tim(i/step,1)=obs_tms(temp2(0),1)
		exit3:
		if DEBUG then begin
			print, string(i/step)+': '+fnam(i/step,0)
			print, string(i/step)+': '+fnam(i/step,1)
		endif
	endfor
endif

if flag eq 1 then goto, exit11
;=====================================================================
;=	Making a color MPEG-movie from 5577 & 6300
;=====================================================================
mpegID = OBJ_NEW('IDLgrMPEG', FILENAME=mpname, QUALITY=100)
if DEBUG then begin
	window, 1, xsize=200, ysize=230, title=date+', 5577+6300'
endif else begin
	set_plot, 'Z'
	device, set_resolution = [200,30]
endelse
bk_com=bytarr(200,30)

for i=0, inum-1 do begin
	a=bytarr(3,200,200)
	read_jpeg, fnam(i,0), tmp0
	tmp1=congrid(tmp0,200,200)
	a(1:1,0:199,0:199)=tmp1
	a(2:2,0:199,0:199)=tmp1*2/3
	if fnam(i,1) ne 'no_image' then begin
		read_jpeg, fnam(i,1), tmp00
		tmp0=shift(tmp00,xsft,ysft)
		tmp1=congrid(tmp0,200,200)
		a(0:0,0:199,0:199)=tmp1
	endif
	if DEBUG then tv, a, /true, 0, 30
	tv, bk_com, 0,0
	tv, congrid(nict, 48, 17), 150, 5
	aaa=findgen(100)*(!PI*2/100.)
	xm=130 & ym=15 & rr=14
	for j=0, 98 do begin
		x1=fix(xm+rr*cos(aaa(j)))
		y1=fix(ym+rr*sin(aaa(j)))
		x2=fix(xm+rr*cos(aaa(j+1)))
		y2=fix(ym+rr*sin(aaa(j+1)))
		arrow, x1, y1, x2, y2, HSIZE=0, THICK=1.0
	endfor
	arrow, fix(xm+rr*cos(aaa(99))), fix(ym+rr*sin(aaa(99))), $
		fix(xm+rr*cos(aaa(0))), fix(ym+rr*sin(aaa(0))), $
		HSIZE=0, THICK=1.0
	xyouts, xm-4, ym+rr-9, 'N', charsize=0.8, charthick=0.8, /dev
	xyouts, xm-4, ym-rr+2, 'S', charsize=0.8, charthick=0.8, /dev
	xyouts, xm-rr+1, ym-4, 'E', charsize=0.8, charthick=0.8, /dev
	xyouts, xm+rr-9, ym-4, 'W', charsize=0.8, charthick=0.8, /dev
	xyouts, 10, 21, strmid(tim(i,0),0,10), charsize=0.8, charthick=0.8, /dev
	xyouts, 10, 11, strmid(tim(i,0),12)+' [UT]', charsize=0.8, charthick=0.8, /dev
	xyouts, 10, 1, 'PFRR, 5577+6300', charsize=0.8, charthick=0.8, /dev
	if DEBUG eq 0 then begin
		c=bytarr(3,200,230)
		tmp0 = tvrd()
		for j=0, 2 do c(j:j,0:199,0:29)=tmp0
		c(0:2,0:199,30:229)=a
	endif

	for l=0, interval-1 do  begin
		if DEBUG then $
			MPEG_PUT, mpegID, image=tvrd(true=1), FRAME=i*interval+l, /color, /order
		if DEBUG eq 0 then $
			MPEG_PUT, mpegID, image=c, FRAME=i*interval+l, /color, /order
	endfor
endfor
goto, exit1

exit11:
;=====================================================================
;=	Making a BW MPEG-movie from 5577
;=====================================================================
mpegID = OBJ_NEW('IDLgrMPEG', FILENAME=mpname, QUALITY=100)
if DEBUG then begin
	window, 1, xsize=200, ysize=230, title=date+', 5577'
endif else begin
	set_plot, 'Z'
	device, set_resolution = [200,30]
endelse
bk_com=bytarr(200,30)

for i=0, inum-1 do begin
	read_jpeg, fnam(i,0), tmp0
	a=congrid(tmp0,200,200)
	if DEBUG then tv, a, 0, 30
	tv, bk_com, 0,0
	tv, congrid(nict, 50, 17), 148, 5
	aaa=findgen(100)*(!PI*2/100.)
	xm=130 & ym=15 & rr=14
	for j=0, 98 do begin
		x1=fix(xm+rr*cos(aaa(j)))
		y1=fix(ym+rr*sin(aaa(j)))
		x2=fix(xm+rr*cos(aaa(j+1)))
		y2=fix(ym+rr*sin(aaa(j+1)))
		arrow, x1, y1, x2, y2, HSIZE=0, THICK=1.0
	endfor
	arrow, fix(xm+rr*cos(aaa(99))), fix(ym+rr*sin(aaa(99))), $
		fix(xm+rr*cos(aaa(0))), fix(ym+rr*sin(aaa(0))), $
		HSIZE=0, THICK=1.0
	xyouts, xm-4, ym+rr-9, 'N', charsize=0.8, charthick=0.8, /dev
	xyouts, xm-4, ym-rr+2, 'S', charsize=0.8, charthick=0.8, /dev
	xyouts, xm-rr+1, ym-4, 'E', charsize=0.8, charthick=0.8, /dev
	xyouts, xm+rr-9, ym-4, 'W', charsize=0.8, charthick=0.8, /dev
	xyouts, 10, 21, strmid(tim(i,0),0,10), charsize=0.8, charthick=0.8, /dev
	xyouts, 10, 11, strmid(tim(i,0),12)+' [UT]', charsize=0.8, charthick=0.8, /dev
	xyouts, 10, 1, 'PFRR, 5577 Aurora', charsize=0.8, charthick=0.8, /dev

	if DEBUG eq 0 then begin
		c=bytarr(3,200,230)
		tmp0 = tvrd()
		for j=0, 2 do c(j:j,0:199,0:29)=tmp0
		for j=0, 2 do c(j:j,0:199,30:229)=a
	endif
	for l=0, interval-1 do  begin
		if DEBUG then $
			MPEG_PUT, mpegID, image=tvrd(true=1), FRAME=i*interval+l, /order
		if DEBUG eq 0 then $
			MPEG_PUT, mpegID, image=c, FRAME=i*interval+l, /order
	endfor
endfor

exit1:
;=====================================================================
;=	data saving
;=====================================================================
MPEG_SAVE, mpegID
MPEG_CLOSE, mpegID

exit2:
if DEBUG then begin
	wdelete, 1
endif else begin
	device,/close
	set_plot, dev_nam
endelse

end
