;******************************************************************
;    program HPKimage
;
;    revised from imagespectro.pro
;         on Apr 8,2002 by TS
;
;    revised from imagesakanoi.pro
;      for plotting 'Auroral Spectrograph' data
;      developed at NIPR and now at LYR
;      on Apr. 20, 2000 by Takeshi Sakanoi
;
;    imagesakanoi.pro
;         revised from image20ps by Takeshi Sakanoi
;
;    image20ps
;    draws 20 airglow emission images and Japanese map
;    as a PostScript file. For Zao All-Sky Imager
;
;                              Mar . 21, 1997
;                               programed by K. Nakajima
;******************************************************************

PRO HPKimage_test

; input parameters =====
fna='ch3test3_'
ibin=8
;=======================

close,/all
iscale=1
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin = 40l
smax = 60l

xpx0=1024
ypx0=1024

xpx=xpx0/ibin
ypx=ypx0/ibin

pdate=0l
ptime=0l

fdir = 'C:\Documents and Settings\pparc\My Documents\obuchi\Index\data\'

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'

psdir='C:\Documents and Settings\pparc\My Documents\obuchi\Index\ps\'
;---plot image size factor(nominal:7.5, one image large plot:30)
fac=7.5
;fac=30.0

;--- pdate and ptime for data selection which is avairable when fac=30.0
;pdate=20000319
;ptime=210748
fstartnum='001'

if fac lt 30 then begin
  fact=1.0
  factc=''
endif else begin
  fact=1.8
  factc='l'
endelse

;---image resolution(nominal:100, one image large plot:512)
if fac eq 30 then begin
  res = 512
endif else begin
  res = 100
endelse
;res = 512
;res=100


irot = 5


;=====parameter end=====

;fname1=fdir+fna

fname1=FINDFILE(fdir+fna+'*.img')
fnum=n_elements(fname1)

fs=fix(fstartnum)

fname=strarr(fnum)

;if fs eq 0 and min(sort(fname))/10.0 eq fix(min(sort(fname))/10.0) then begin
;   j=1
;    print, 'start from 1 !'
;endif else begin
;    j=0
;endelse

j=0

for i=0, fnum-1 do begin
  if fnum ge 100 then begin
    if i+fs lt 10 then begin
      fname(i)=fdir+fna+'00'+strmid(string(i+j+fs),7,1)+'.img'
    endif else if i+fs lt 100 then begin
      fname(i)=fdir+fna+'0'+strmid(string(i+j+fs),6,2)+'.img'
    endif else begin
      fname(i)=fdir+fna+strmid(string(i+j+fs),5,3)+'.img'
    endelse
  endif else if fnum ge 10 then begin
    if i+fs lt 10 then begin
      fname(i)=fdir+fna+'00'+strmid(string(i+j+fs),7,1)+'.img'
    endif else begin
      fname(i)=fdir+fna+'0'+strmid(string(i+j+fs),6,2)+'.img'
    endelse
  endif else if fnum ge 1 then begin
    fname(i)=fdir+fna+'00'+strmid(string(i+j+fs),7,1)+'.img'
  endif else begin
    fname(i)=fdir+fna+'.img'
  endelse
endfor



time=strarr(fnum)
date=strarr(fnum)
expo=strarr(fnum)

print, fname
;
print, '---data process start---'
print, 'file number = ',fnum
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
fn=''
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l

if fac eq 30.0 then begin
  imagetotal=LONARR(res,res,1)
endif else begin
  imagetotal=LONARR(res,res,fnum)
endelse
image1=lonarr(res,res)

for i=0, fnum-1 do begin
  fn=fname(i)
  print, i,'/',fnum-1,'     ',fn
  hp_img_HPK, fn, xpx, ypx, data, time1, date1, expo1
  image1=CONGRID(data, res, res, /INTERP)
;  print, data
  if fac eq 30.0 then begin
    time2=strmid(time1,0,2)+strmid(time1,3,2)+strmid(time1,6,2)
    date2=strmid(date1,0,4)+strmid(date1,5,2)+strmid(date1,8,2)
    pdate1=long(date2)
    ptime1=long(time2)
;    print, long(date2),long(time2),pdate,ptime,pdate1-pdate,ptime1-ptime
    if ptime1 eq ptime and pdate1 eq pdate then begin
      print, 'found date and time ',date1,time1
      s0=0
      e0=0
      imagetotal(*,*,0)=image1
;      print, imagetotal
      time(0)=time1
      date(0)=date1
      expo(0)=expo1
      fnum=1
      goto, plot
    endif
  endif else begin
      imagetotal(*,*,i)=image1
      time(i)=time1
      date(i)=date1
      expo(i)=expo1
      help, image1
      sum	= 0.
      for a = 0, 19 do begin
      	for b = 0, 19 do begin
      	    sum	= sum + image1(a, b)
      	endfor
      endfor
      print, sum / 400.
      sum	= 0.
      for a = 40, 59 do begin
      	for b = 40, 59 do begin
      		sum	= sum + image1(a, b)
      	endfor
      endfor
      print, sum / 400.
      sum   = 0.
      for a = 80, 99 do begin
       for b = 80, 99 do begin
            sum = sum + image1(a, b)
        endfor
      endfor
      print, sum / 400.
  endelse

  if fac ne 30.0 then begin
    s0=0
    e0=FIX((fnum-1)/20)
  endif else begin
    s0=0
    e0=0
  endelse
endfor


if iscale eq 1 then begin
  smin=long(min(image1)/5)*5l
  smax=long(max(image1)/5)*5l
endif

plot:

if ihiniti eq 1 then hiniti=date(0)+' to '+date(fnum-1)
year=date(0)+strmid(time(0),0,2)+strmid(time(0),3,2)+factc


if ibin eq 2 then begin
  cbin='2x2'
endif else if ibin eq 4 then begin
  cbin='4x4'
endif else if ibin eq 8 then begin
  cbin='8x8'
endif


;------------------- PS PROT ------------------

SET_PLOT, 'PS'

es=e0

FOR s=s0,es DO BEGIN

fo=STRING(s+1)
fo=STRTRIM(fo,1)

st=0+20*s
et=st+20-1

if et gt fnum-1 then et=fnum-2

DEVICE, BITS_PER_PIXEL=8, /COLOR, $
 FILENAME=psdir+year+strmid(fna,0,3)+cbin+'.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
print, psdir+year+strmid(fna,0,3)+cbin+'.ps'
LOADCT, 13

!P.FONT=0
XYOUTS, 2100, 28000, '!8MAC test data: '+strmid(fna,0,3), $
 CHARSIZE=2.0,  CHARTHICK=1.5,  /DEVICE
XYOUTS,  9800, 26800, cbin+'  binning', $
 CHARSIZE=0.8*fact,  CHARTHICK=1.0,  /DEVICE
datec=''
if fac eq 30.0 then begin
  datec='Date: '+ date(st)+'@ HPK'
endif else begin
  datec= 'Date: '+ date(st)+'@ HPK'
endelse
XYOUTS,  4000, 26800, datec,CHARSIZE=0.8*fact,  CHARTHICK=1.0,   /DEVICE

print,datec

;XYOUTS, 2800, 26100, 'North', $
; CHARSIZE=1.0,  CHARTHICK=1,   /DEVICE
;XYOUTS, 900, 23300, 'East', $
; CHARSIZE=1.0,  CHARTHICK=1,  ORIENTATION=90, /DEVICE
;XYOUTS, 900, 26500-((xpx)*fac)/2.0-500, 'East', $
; CHARSIZE=1.0,  CHARTHICK=1,  ORIENTATION=90, /DEVICE

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=ysi, /DEVICE
plots, [xsc,xsc],[ysc,ysc+ysi+60],/device
plots, [xsc+xsi,xsc+xsi],[ysc,ysc+ysi+60],/device

  XYOUTS, xsc+1000.0, ysc+ysi+100.0, 'intensity (cts)', $
   CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
  xyouts, xsc-700.0, ysc+ysi+100.0, smin, charsize=0.8, charthick=1, /device
  xyouts, xsc-700.0+xsi, ysc+ysi+100.0, long(smax), charsize=0.8, charthick=1, /device


;------------------ DRAW IMAGE DATA  --------------
;

xs=2500.0+1000*(fact-1.0)
xd=4300.0
ys=24500.0
cm=''
yd=800.0
pix=0.0
xpi=0.0
ypi=0.0
xpx=xpx*float(ibin)/2.0
ypx=ypx*float(ibin)/2.0
;---plotting images
FOR l=0, 4 DO BEGIN
 FOR k=0, 3 DO BEGIN
  n=s*20+4*l+k
;  print,n
 IF n EQ fnum THEN GOTO, NODATA
   sx=xs+xd*k
   sy=ys-((xpx)*fac+yd)*(l+1)
   if fac eq 30.0 then begin
     XYOUTS, xs+xd*k+20*fac, ys+fac*50, time(n)+'(UT) / Exp='+expo(n),CHARSIZE=0.8*fact, /DEVICE
   endif else begin
     XYOUTS, xs+xd*k, (ys-400.0)-((xpx)*fac+yd+500*(fact-1))*(l+1), time(n)+'(UT) / Exp='+expo(n)+'(s)',CHARSIZE=0.8*fact, /DEVICE
   endelse

   ;TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin,max=smax),irot), sx, sy, $
   ;   XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin,max=smax),irot), sx, sy, $
      XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE

  ; TVSCL, ROTATE((imagetotal(*,*,n)-smin)/(smax-smin),irot), sx, sy, $
  ;    XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   if fac ne 30.0 then begin
   endif else begin
     if l eq 0 then begin
       for m=0, 512, 50 do begin
         pix=float(m)
         xpi=sx+xpx*fac*pix/xpx
         plots, [xpi,xpi], [sy+ypx*fac,sy+ypx*fac+100*fact],/device
         cm=strmid(string(fix(m)),5,3)
         xyouts, xpi-220*fact, sy+ypx*fac+150*fact, cm, charsize=0.8*fact,/device
         if k eq 0 then xyouts, xs+800*fact+5000*(fact-1), sy+ypx*fac+600*fact,'  CCD pixels', charsize=0.8*fact,/device
       endfor
     endif
   endelse
ENDFOR
ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE

print, 'Normal End! '
END











