;******************************************************************
;    program KOBAimage_obu
;
;    plot for image data by obuchi_QL program (1bin=1byte)
;       Please use KOBAimage.pro for image data by Kobayashi_QL prog.
;
;    revised from imagespectro.pro
;         on Apr 8,2002 by TS
;
;    revised from imagesakanoi.pro
;      for plotting 'Auroral Spectrograph' data
;      developed at NIPR and now at LYR
;      on Apr. 20, 2000 by Takeshi Sakanoi
;
;    imagesakanoi.pro
;         revised from image20ps by Takeshi Sakanoi
;
;    image20ps
;    draws 20 airglow emission images and Japanese map
;    as a PostScript file. For Zao All-Sky Imager
;
;                              Mar . 21, 1997
;                               programed by K. Nakajima
;******************************************************************

PRO KOBAimage_obu
close,/all
iscale=1
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin = 40l
smax = 60l

;fdir = 'C:\Documents and Settings\pparc\My Documents\obuchi\Index\MAC_FM\INDEX_MAC\DL\DL_512x512\'
;dir = 'C:\Documents and Settings\pparc\My Documents\obuchi\Index\MAC_FM\INDEX_MAC\DL\DL_64x64_Particle\'
;fna='51201001'
;fna='6401012_ptc'
;fdir='C:\Usr\tsakanoi\Index\CCD_FM_Thermal_Test\obu_ INDEX_MAC_UNIVERSAL\'
;fna='CAC1_020803230434.DAT'

fdir='C:\Usr\tsakanoi\Index\CCD_FM_Thermal_Test\020803paf1\'
fna='PA045C1.DAT'
ibin=16
notec='2002 Aug.3 @ ISAS'

;col=13
col=13
;--col 0 or 13
;===========================

xpx0=1024
ypx0=1024

xpx=xpx0/ibin
ypx=ypx0/ibin

pdate=0l
ptime=0l

;fdir = 'C:\Usr\tsakanoi\Index\Kobayashi\INDEX_MAC\'
;fdir = 'I:\Lyr\'
;fdir = 'I:\LYRASG_OBS_Oct00\'

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'

psdir='C:\Usr\tsakanoi\Data_analysis\ps\'
;---plot image size factor(nominal:7.5, one image large plot:30)
;fac=7.5
fac=30.0

;--- pdate and ptime for data selection which is avairable when fac=30.0
;pdate=20000319
;ptime=210748

if fac lt 30 then begin
  fact=1.0
  factc=''
endif else begin
  fact=1.8
  factc='l'
endelse

;---image resolution(nominal:100, one image large plot:512)
if fac eq 30 then begin
  res = xpx
endif else begin
  res = 100
endelse
;res = 512
;res=100


irot = 5


;=====parameter end=====

;fname1=fdir+fna


fnum=1


time=strarr(fnum)
date=strarr(fnum)
expo=strarr(fnum)

fname=strarr(fnum)
fname(0)=fdir+fna

print, fname
;
print, '---data process start---'
print, 'file number = ',fnum
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
fn=''
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l

if fac eq 30.0 then begin
  imagetotal=LONARR(res,res,1)
endif else begin
  imagetotal=LONARR(res,res,fnum)
endelse
image1=lonarr(res,res)

for i=0, fnum-1 do begin
  fn=fname(i)
  print, i,'/',fnum-1,'     ',fn
;  hp_img_koba, fn, xpx, ypx, data
  openr,1,fn
    a=bytarr(res,res)
    data=intarr(res,res)
    readu,1,a
    data=fix(a)
  close,1
  image1=CONGRID(data, res, res, /INTERP)
  imagetotal(*,*,i)=image1(*,*)
  help,image1
  sum= 0.
  for a = 0, 11 do begin
   for b = 0, 11 do begin
       sum = sum + image1(a,b)
   endfor
  endfor
  print, sum / 144
  sum = 0.
  for a = 26, 37 do begin
   for b = 26, 37 do begin
       sum = sum + image1(a,b)
   endfor
  endfor
  print, sum / 144
  sum = 0.
  for a = 52, 63 do begin
   for b = 52, 63 do begin
       sum = sum + image1(a,b)
   endfor
  endfor
  print, sum / 144
;  print, data
endfor


if iscale eq 1 then begin
  smin=long(min(image1)/5)*5l
  smax=long(max(image1)/5)*5l
endif

plot:

if ihiniti eq 1 then hiniti=date(0)+' to '+date(fnum-1)
year=date(0)+strmid(time(0),0,2)+strmid(time(0),3,2)+factc


if ibin eq 2 then begin
  cbin='2x2'
endif else if ibin eq 4 then begin
  cbin='4x4'
endif else if ibin eq 8 then begin
  cbin='8x8'
endif else if ibin eq 16 then begin
  cbin='16x16'
endif


;------------------- PS PROT ------------------

SET_PLOT, 'PS'

e0=0
s0=0
es=e0

FOR s=s0,es DO BEGIN

fo=STRING(s+1)
fo=STRTRIM(fo,1)

st=0+20*s
et=st+20-1

if et gt fnum-1 then et=fnum-2

DEVICE, BITS_PER_PIXEL=8, /COLOR, $
 FILENAME=psdir+fna+'.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
;print, psdir+year+strmid(fna,0,3)+cbin+'.ps'
print, psdir+year+strmid(fna,0,3)+cbin+'.ps'
LOADCT, col

!P.FONT=0
XYOUTS, 2100, 28000, '!8MAC test data: '+strmid(fna,0,3), $
 CHARSIZE=2.0,  CHARTHICK=1.5,  /DEVICE
XYOUTS,  11000, 26800, cbin+'  binning', $
 CHARSIZE=0.8*fact,  CHARTHICK=1.0,  /DEVICE
datec=''
if fac eq 30.0 then begin
  datec=notec
endif else begin
  datec=notec
endelse
XYOUTS,  2100, 26800, datec,CHARSIZE=0.8*fact,  CHARTHICK=1.0,   /DEVICE

print,datec

;XYOUTS, 2800, 26100, 'North', $
; CHARSIZE=1.0,  CHARTHICK=1,   /DEVICE
;XYOUTS, 900, 23300, 'East', $
; CHARSIZE=1.0,  CHARTHICK=1,  ORIENTATION=90, /DEVICE
;XYOUTS, 900, 26500-((xpx)*fac)/2.0-500, 'East', $
; CHARSIZE=1.0,  CHARTHICK=1,  ORIENTATION=90, /DEVICE

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=ysi, /DEVICE
plots, [xsc,xsc],[ysc,ysc+ysi+60],/device
plots, [xsc+xsi,xsc+xsi],[ysc,ysc+ysi+60],/device

  XYOUTS, xsc+1000.0, ysc+ysi+100.0, 'intensity (cts)', $
   CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
  xyouts, xsc-700.0, ysc+ysi+100.0, smin, charsize=0.8, charthick=1, /device
  xyouts, xsc-700.0+xsi, ysc+ysi+100.0, long(smax), charsize=0.8, charthick=1, /device


;------------------ DRAW IMAGE DATA  --------------
;

xs=2500.0+1000*(fact-1.0)
xd=4300.0
ys=24500.0
cm=''
yd=800.0
pix=0.0
xpi=0.0
ypi=0.0
xpx=xpx*float(ibin)/2.0
ypx=ypx*float(ibin)/2.0
;---plotting images
FOR l=0, 4 DO BEGIN
 FOR k=0, 3 DO BEGIN
  n=s*20+4*l+k
;  print,n
 IF n EQ fnum THEN GOTO, NODATA
   sx=xs+xd*k
   sy=ys-((xpx)*fac+yd)*(l+1)
   if fac eq 30.0 then begin
     XYOUTS, xs+xd*k+20*fac, ys+fac*50, 'filename='+fna,CHARSIZE=0.8*fact, /DEVICE
   endif else begin
     XYOUTS, xs+xd*k, (ys-400.0)-((xpx)*fac+yd+500*(fact-1))*(l+1), time(n)+'(UT) / Exp='+expo(n)+'(s)',CHARSIZE=0.8*fact, /DEVICE
   endelse

   ;TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin,max=smax),irot), sx, sy, $
   ;   XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin,max=smax),irot), sx, sy, $
      XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE

  ; TVSCL, ROTATE((imagetotal(*,*,n)-smin)/(smax-smin),irot), sx, sy, $
  ;    XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   if fac ne 30.0 then begin
   endif else begin
     if l eq 0 then begin
       for m=0, 512, 50 do begin
         pix=float(m)
         xpi=sx+xpx*fac*pix/xpx
         plots, [xpi,xpi], [sy+ypx*fac,sy+ypx*fac+100*fact],/device
         cm=strmid(string(fix(m)),5,3)
         xyouts, xpi-220*fact, sy+ypx*fac+150*fact, cm, charsize=0.8*fact,/device
         if k eq 0 then xyouts, xs+800*fact+5000*(fact-1), sy+ypx*fac+600*fact,'  CCD pixels', charsize=0.8*fact,/device
       endfor
     endif
   endelse
ENDFOR
ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE

print, 'Normal End! '
END











