PRO MAC_EISA_FFT_plot
; on June 17, 2006, by TS

;=========parameters=======================
;20051222 09:31:40-09:32:20 very disturbed, complicated 09 31 50 512 10, 09 32 10 256 10
;20051226 09:10:40-09:11:00 typical inverted-V + IAW / 09 10 40 128 10 toff=2
;20051229 00:22:00-00:22:25 strong IAW / 00 22 00 128 10 toff=4
;20060125 23:34:30-23:34:50 pulsation(23:34:45-23:34:50) 23 34 45 128(or64) 10
;20060103 10:06:00-10:06:30 fast shear flows 10 06 10 128
;20051112 01:37:25-01:38:00 very dispersed pulsation
;20070127 08:20:30-08:21:30
;20061015 11:14:00-11:16:30
;20061123 085500 090000
;20070110 110430 110600
;20070121 111700 111900
;20070209 091000 091200
;20070214 104300 104600

;plot time
;sh=10
;sm=43
;ss=00
;eh=10
;em=46
;es=00
toffset_mac=0.0

ifilter=01
; --- ifilter=1, then filtered data plot
;tdiv=10
;tdiv; time tick mark period in sec.

;--- parameters for filtering
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20051222093144.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20051222093144.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20051226091034.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20051226091034.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20051229002031.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20051229002031.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20060125233325.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20060125233154.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20060103100541.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20060103100500.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20070127082005.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20070127081755a.txt'
fname_mac='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\MAC20061015111406.M0_CH123__ModeS_L1_ps.txt'
fname_eisa='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\ESA_eflux20061015111325.txt'
sh=11 & sm=14 & ss=00 & eh=11 & em=16 & es=30 & tdiv=10
;fname_mac='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\MAC20061123085525.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\ESA_eflux20061123085525.txt'
;sh=08 & sm=55 & ss=00 & eh=09 & em=00 & es=00 & tdiv=10
;fname_mac='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\MAC20070110110343.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\ESA_eflux20070110110132.txt'
;sh=11 & sm=04 & ss=30 & eh=11 & em=06 & es=00 & tdiv=10
;fname_mac='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\MAC20070121111657.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\ESA_eflux20070121111446.txt'
;sh=11 & sm=17 & ss=00 & eh=11 & em=19 & es=00 & tdiv=10
;fname_mac='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\MAC20070209091004.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\ESA_eflux20070209090753.txt'
;sh=09 & sm=10 & ss=00 & eh=09 & em=12 & es=00 & tdiv=10
;fname_mac='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\MAC20070214104326.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\Themis\data\mac_esa_timeseries\ESA_eflux20070214104043.txt'
;sh=10 & sm=43 & ss=00 & eh=10 & em=46 & es=00 & tdiv=10

ftype=0
; --- ftype : 0 high pass / 1 low pass
tcut = 5.0
; --- tcut : cut off time (sec)
if ftype eq 0 then begin
  fctype='high pass, t<'+string(tcut)+'sec.'
  cwi1='highpass'
endif else begin
  fctype='low pass, t>'+string(tcut)+'sec.'
  cwi1='lowpass'
endelse

;--- parameter for MAC file------------------------------
;-- line of MAC data
ilinefp = 01
;plot emission
pch1=1
pch2=1
pch3=1
;--- parameter for EISA radar data------------------------
;-- line of ESIA data
ilinehf = 1

date1=strmid(fname_mac,strlen(fname_mac)-40,14)
cyy1=strmid(date1,0,4)
cmo1=strmid(date1,4,2)
cdd1=strmid(date1,6,2)
chh1=strmid(date1,8,2)
mo1=fix(cmo1)
mon_num_to_char,mo1,charmon1
hiniti=charmon1+', '+cdd1+', '+cyy1
if sh lt 10 then begin
  csh1='0'+strmid(string(sh),7,1)
endif else begin
  csh1=strmid(string(sh),6,2)
endelse
if sm lt 10 then begin
  csm1='0'+strmid(string(sm),7,1)
endif else begin
  csm1=strmid(string(sm),6,2)
endelse
if ss lt 10 then begin
  css1='0'+strmid(string(ss),7,1)
endif else begin
  css1=strmid(string(ss),6,2)
endelse

if ifilter eq 1 then begin
  cfil=''
endif else begin
  cfil='nofilter'
endelse
if toffset_mac ne 0 then begin
  ctoffset='_'+strmid(string(toffset_mac),6,3)
  ctoff=', t_mac=t_esa+'+strmid(string(toffset_mac),5,4)+' s.'
endif else begin
  ctoffset=''
  ctoff=''
endelse
fout_mac1='C:\usr\tsakanoi\index\mac1_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+cfil+ctoffset+'.xy'
fout_mac2='C:\usr\tsakanoi\index\mac2_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+cfil+ctoffset+'.xy'
fout_mac3='C:\usr\tsakanoi\index\mac3_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+cfil+ctoffset+'.xy'
fout_eisa='C:\usr\tsakanoi\index\eisa_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+cfil+ctoffset+'.xy'
;---PSFILE
psfile='C:\usr\tsakanoi\index\ps\FFT_filter_'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+cfil+ctoffset+'.ps'

;dv only tick; dv2 tick with time
dv=100.0
dv2 =100.0
;--- no plot time range at start and end (sec)
tmer=15.0*60.0
;tmer=0.0*60.0

;---
xofs = 25.0
yofs = 210.0
;=================parameter end========================================
close,/all

icol1=60
icol2=150
icol3=250

sti=0.0d
eti=0.0d
sti = sh*3600.0+sm*60.0+ss
eti = eh*3600.0+em*60.0+es
if eti lt sti then eti = eti + 86400.0

;--- data process for EISA data-------------------------------
if ilinehf eq 1 then begin
  print, '=== EISA data process start ==='
  EISA_efulx_timeseries_read,fname_eisa,tsec_eisa,hh_eisa,mm_eisa,eflux_down,eflux_perp,eflux_up,intotal_eisa,dt_eisa
  ;esa
  vhmax=10^(alog10(max(eflux_down)))*1.5
endif

;---- data processing for MAC data
if ilinefp eq 1 then begin
  print, '=== MAC data process start ==='
  MAC_timeseries_read,fname_mac,tsec_mac,hh_mac,mm_mac,image1,image2,image3,intotal_mac,dt_mac
  tsec_mac(*)=tsec_mac(*)+toffset_mac
  ;mac
  if max(image2) gt max(image3) then begin
    vfmax=(fix(max(image2)/20+1))*20
  endif else begin
    vfmax=(fix(max(image3)/20+1))*20
  endelse
endif

if ilinefp eq 0 then vfmax=vhmax
if ilinehf eq 0 then vhmax=vfmax

vhmin=0.0
vfmin=0.0

;===== filtering
if ifilter eq 1 then begin

  sti2=tsec_eisa(0)
  eti2=tsec_eisa(intotal_eisa-1)

  filt_reimei, tsec_eisa,eflux_down,intotal_eisa,tcut,ftype,sti2,eti2,dt_eisa,feflux_down,fout_eisa

  sti2=tsec_mac(0)
  eti2=tsec_mac(intotal_mac-1)

  filt_reimei, tsec_mac,image1,intotal_mac,tcut,ftype,sti2,eti2,dt_mac,fimage1,fout_mac1
  filt_reimei, tsec_mac,image2,intotal_mac,tcut,ftype,sti2,eti2,dt_mac,fimage2,fout_mac2
  filt_reimei, tsec_mac,image3,intotal_mac,tcut,ftype,sti2,eti2,dt_mac,fimage3,fout_mac3

  ;scale for filtered data
  ;esa
  vhmaxf=10^(alog10(max(abs(feflux_down))/1.5))*2
  vhminf=-vhmaxf
  ;mac
  if max(fimage2) gt max(fimage3) then begin
    vfmaxf=(fix(max(fimage2)/1.5/10)+1)*10
  endif else begin
    vfmaxf=(fix(max(fimage3)/1.5/10)+1)*10
  endelse
  vfminf=-vfmaxf
;  print, 'vfmax,vfmin,vhmax,vhmin,vfmaxf,vfminf,vhmaxf,vhminf',vfmax,vfmin,vhmax,vhmin,vfmaxf,vfminf,vhmaxf,vhminf

endif


;stop
;------------------- PS PLOT ------------------------------------------
print, '=== Plotting ==='
SET_PLOT, 'PS'
LOADCT, 13
;---loadct, 13 - rainbow/ 0 - black&white / 1-bule&white/3-red&white/8-green&white/9-green&white(exponential)
STRETCH, 0, 255
;STRETCH, 0, 140
;
DEVICE, BITS_PER_PIXEL=8, /COLOR, $
FILENAME=psfile, /PORTRAIT, $
XSIZE=21, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
print, psfile
XYOUTS, 5000, 25600,'    !3REIMEI/MAC and ESA Observations', FONT=0, CHARSIZE=1.5, $
CHARTHICK=2., ORIENTATION=0,color=30, /DEVICE
XYOUTS, 3200, 24800, 'Auroral intensity and downward electron total energy flux ', $
FONT=0, CHARSIZE=1.5, CHARTHICK=1.5,ORIENTATION=0, COLOR=30, /DEVICE
XYOUTS, 8200, 24000,hiniti, FONT=0, CHARSIZE=1.5, $
CHARTHICK=2., ORIENTATION=0,color=30, /DEVICE

XYOUTS, 5000, 23200, 'Electron pitch angle: 0-60 deg.', FONT=0, CHARSIZE=1.1, $
  CHARTHICK=2., ORIENTATION=0, /DEVICE

sfnum=''
if pch1 eq 1 then begin
  sfnum=sfnum+'428nm'
endif
if pch2 eq 1 then begin
  sfnum=sfnum+'   558nm'
endif
if pch3 eq 1 then begin
  sfnum=sfnum+'   670nm'
  endif
XYOUTS, 5000, 22500, 'Auroral emission: '+sfnum+ctoff, FONT=0, CHARSIZE=1.1, $
  CHARTHICK=2., ORIENTATION=0, /DEVICE

;-----Drawing section
;
stime=3600.0*sh + 60.0*sm+ss
etime=3600.0*eh + 60.0*em+es
if etime le stime then etime = etime+86400.0

xo=3500.0
yo=11000.0+3500.0
xd=12500.0
yd=7500.0
yoo = yo - yd
ypo = 0.0
ypo1 = 0.0
ypo2 = 0.0
ypo3 = 0.0
yp1=0.0
yp2=0.0
yp3=0.0

ssize=0.5

plots,[xo,xo+xd],[yo,yo],color=0,thick=2.0,/device
plots,[xo,xo+xd],[yo+yd,yo+yd],color=0,thick=2.0,/device
plots,[xo,xo],[yo,yo+yd],color=0,thick=2.0,/device
plots,[xo+xd,xo+xd],[yo,yo+yd],color=0,thick=2.0,/device

if ifilter eq 1 then begin
  plots,[xo,xo+xd],[yoo,yoo],color=0,thick=2.0,/device
  ;plots,[xo,xo+xd],[yoo+yd,yoo+yd],color=0,thick=2.0,/device
  plots,[xo,xo],[yoo,yoo+yd],color=0,thick=2.0,/device
  plots,[xo+xd,xo+xd],[yoo,yoo+yd],color=0,thick=2.0,/device
endif

iflg = 0
jflg = 0
for i=0, intotal_eisa-1 do begin
    xp = xo + (tsec_eisa(i)-stime)/(etime-stime) *xd
    yp = yo + ((eflux_down(i))-vhmin)/(vhmax-vhmin)*yd
    if ifilter eq 1 then begin
      ypo = yoo + ((feflux_down(i))-vhminf)/(vhmaxf-vhminf)*yd
      if ypo gt yoo+yd then ypo=yoo+yd
      if ypo lt yoo then ypo=yoo
    endif
    if yp gt yo+yd then yp=yo+yd
    if yp lt yo then yp=yo
;    print, alog10(eflux_down(i)),alog10(feflux_down(i))
    if (iflg eq 1) then begin
      if (xp0 ge xo and xp le xo+xd and xp ge xo and $
          xp0 le xo+xd) then begin
;        plots,[xp0,xp],[yp0,yp],color=2,thick=4.0,psym=4,symsize=ssize,/device
;        plots,[xp0,xp],[ypo0,ypo],color=2,thick=4.0,psym=4,symsize=ssize,/device
        plots,[xp0,xp],[yp0,yp],color=2,thick=4.0,linestyle=4, /device
        if ifilter eq 1 then plots,[xp0,xp],[ypo0,ypo],color=2,thick=4.0,linestyle=4, /device
        jflg = 1
      endif
    endif
    iflg = 1
    xp0 = xp
    yp0 = yp
    if ifilter eq 1 then ypo0 = ypo
    secn0=tsec_eisa(i)

endfor

;plots,[xo+0.10*xd,xo+0.10*xd],[yo+0.9*yd,yo+0.9*yd],color=2,thick=4.0,psym=4,/device
if (ilinehf eq 1) then begin
 plots,[xo+0.05*xd,xo+0.15*xd],[yo+0.9*yd,yo+0.9*yd],$
  color=2,thick=4.0,linestyle=4, /device
 xyouts, xo+0.17*xd , yo+0.88*yd, 'ESA: Donward total energy flux', FONT=0, CHARSIZE=1.0, $
  CHARTHICK=2.,color = 2, ORIENTATION=0, /DEVICE
endif


if ilinefp eq 1 then begin

if pch1 eq 1 then begin
;  plots,[xo+0.10*xd,xo+0.10*xd],[yo+0.83*yd,yo+0.83*yd],color=icol1,thick=4.0,psym=1,/device
  if (ilinefp eq 1) then plots,[xo+0.05*xd,xo+0.15*xd],[yo+0.83*yd,yo+0.83*yd],$
    color=icol1,thick=4.0, linestyle=3,/device
  xyouts, xo+0.17*xd , yo+0.81*yd, 'MAC: ch1 (428nm)', FONT=0, CHARSIZE=1.0, $
    CHARTHICK=2.,color = icol1, ORIENTATION=0, /DEVICE
endif
if pch2 eq 1 then begin
;  plots,[xo+0.10*xd,xo+0.10*xd],[yo+0.76*yd,yo+0.76*yd],color=icol2,thick=4.0,psym=2,/device
  if (ilinefp eq 1) then plots,[xo+0.05*xd,xo+0.15*xd],[yo+0.76*yd,yo+0.76*yd],$
    color=icol2,thick=4.0, linestyle=2,/device
  xyouts, xo+0.17*xd , yo+0.74*yd, 'MAC: ch2 (558nm)', FONT=0, CHARSIZE=1.0, $
    CHARTHICK=2.,color = icol2, ORIENTATION=0, /DEVICE
endif
if pch3 eq 1 then begin
;  plots,[xo+0.10*xd,xo+0.10*xd],[yo+0.69*yd,yo+0.69*yd],color=icol3,thick=4.0,psym=3,/device
  if (ilinefp eq 1) then plots,[xo+0.05*xd,xo+0.15*xd],[yo+0.69*yd,yo+0.69*yd],$
    color=icol3,thick=4.0, linestyle=0,/device
  xyouts, xo+0.17*xd , yo+0.67*yd, 'MAC: ch3 (670nm)', FONT=0, CHARSIZE=1.0, $
    CHARTHICK=2.,color = icol3, ORIENTATION=0, /DEVICE
endif

endif

;plots,[xo+0.10*xd,xo+0.10*xd],[yoo+0.9*yd,yoo+0.9*yd],color=2,thick=4.0,$
;  psym=4,symsize=ssize,/device
;if (ilinehf eq 1) then plots,[xo+0.05*xd,xo+0.15*xd],[yoo+0.9*yd,yoo+0.9*yd],$
;  color=2,thick=4.0,linestyle=1, /device
;xyouts, xo+0.17*xd , yoo+0.88*yd, 'ESA: Downward total energy flux(filterd: '+fctype+')', FONT=0, CHARSIZE=1.0, $
;  CHARTHICK=2.,color = 2, ORIENTATION=0, /DEVICE
if ifilter eq 1 then xyouts, xo+0.17*xd , yoo+0.88*yd, 'Filtered data: '+fctype, FONT=0, CHARSIZE=1.0, $
  CHARTHICK=2.,color = 2, ORIENTATION=0, /DEVICE

;plots,[xo+0.10*xd,xo+0.10*xd],[yoo+0.83*yd,yoo+0.83*yd],color=icol,thick=4.0,$
;  psym=1,symsize=ssize,/device
;if (ilinefp eq 1) then plots,[xo+0.05*xd,xo+0.15*xd],[yoo+0.83*yd,yoo+0.83*yd],$
;  color=icol,thick=4.0, /device
;xyouts, xo+0.17*xd , yoo+0.81*yd, 'MAC: Auroral intensity(filterd '+fctype+')', FONT=0, CHARSIZE=1.0, $
;  CHARTHICK=2.,color = icol, ORIENTATION=0, /DEVICE

if ilinefp eq 1 then begin

for i=0, intotal_mac-1 do begin
    xp = xo + (tsec_mac(i)-stime)/(etime-stime) *xd
    yp1 = yo + (image1(i)-vfmin)/(vfmax-vfmin)*yd
    yp2 = yo + (image2(i)-vfmin)/(vfmax-vfmin)*yd
    yp3 = yo + (image3(i)-vfmin)/(vfmax-vfmin)*yd
    if ifilter eq 1 then begin
      ypo1 = yoo + (fimage1(i)-vfminf)/(vfmaxf-vfminf)*yd
      ypo2 = yoo + (fimage2(i)-vfminf)/(vfmaxf-vfminf)*yd
      ypo3 = yoo + (fimage3(i)-vfminf)/(vfmaxf-vfminf)*yd
      if ypo1 gt yoo+yd then ypo1=yoo+yd
      if ypo2 gt yoo+yd then ypo2=yoo+yd
      if ypo3 gt yoo+yd then ypo3=yoo+yd
      if ypo1 lt yoo then ypo1=yoo
      if ypo2 lt yoo then ypo2=yoo
      if ypo3 lt yoo then ypo3=yoo
    endif
    if yp1 gt yo+yd then yp1=yo+yd
    if yp2 gt yo+yd then yp2=yo+yd
    if yp3 gt yo+yd then yp3=yo+yd
    if yp1 lt yo then yp1=yo
    if yp2 lt yo then yp2=yo
    if yp3 lt yo then yp3=yo
;    print, tsec_mac(i),image1(i),fimage1(i),xp,yp,ypo
;    print, xp0-xp,xp+xd-xp0
    if (i ge 1) then begin
      if (xp0 ge xo and xp le xo+xd and xp ge xo and $
          xp0 le xo+xd) then begin
        if pch1 eq 1 then begin
 ;         plots,[xp0,xp],[yp10,yp1],color=icol1,thick=4.0,psym=1,symsize=ssize,/device
 ;         plots,[xp0,xp],[ypo10,ypo1],color=icol1,thick=4.0,psym=1,symsize=ssize,/device
          plots,[xp0,xp],[yp10,yp1],color=icol1,thick=4.0,linestyle=3, /device
          if ifilter eq 1 then plots,[xp0,xp],[ypo10,ypo1],color=icol1,thick=4.0,linestyle=3, /device
        endif
        if pch2 eq 1 then begin
  ;        plots,[xp0,xp],[yp20,yp2],color=icol2,thick=4.0,psym=2,symsize=ssize,/device
  ;        plots,[xp0,xp],[ypo20,ypo2],color=icol2,thick=4.0,psym=2,symsize=ssize,/device
          plots,[xp0,xp],[yp20,yp2],color=icol2,thick=4.0,linestyle=2, /device
          if ifilter eq 1 then plots,[xp0,xp],[ypo20,ypo2],color=icol2,thick=4.0,linestyle=2, /device
        endif
        if pch3 eq 1 then begin
   ;       plots,[xp0,xp],[yp30,yp3],color=icol3,thick=4.0,psym=3,symsize=ssize,/device
   ;       plots,[xp0,xp],[ypo30,ypo3],color=icol3,thick=4.0,psym=3,symsize=ssize,/device
          plots,[xp0,xp],[yp30,yp3],color=icol3,thick=4.0,linestyle=0, /device
          if ifilter eq 1 then plots,[xp0,xp],[ypo30,ypo3],color=icol3,thick=4.0,linestyle=0, /device
        endif
        jflg = 1
      endif

    endif
    xp0 = xp
    yp10 = yp1
    yp20 = yp2
    yp30 = yp3
    if ifilter eq 1 then begin
      ypo10 = ypo1
      ypo20 = ypo2
      ypo30 = ypo3
    endif
    tsecf0 = tsec_mac(i)
endfor

endif

;-----Drawing vertical axis
;
;

if ilinefp eq 1 then begin

dvf=(vfmax-vfmin)/8
dvf2=2*dvf
;vfmax=8*dvf
;vfmin=0
for i=vfmin,vfmax,dvf do begin
  ypt = yo+ ((i-vfmin)*yd/(vfmax-vfmin))
    if (fix(i/dvf2)*dvf2 eq i) then begin
    XYOUTS, xo-1800, ypt-100, (fix(i)) , FONT=0, CHARSIZE=1.2, CHARTHICK=2.0, /DEVICE
    plots, [xo,xo-150], [ypt,ypt],color=0,thick=2.0,/device
  endif else begin
    plots, [xo,xo-80], [ypt,ypt],color=0,thick=2.0,/device
  endelse
endfor

if ifilter eq 1 then begin

dvf=(vfmaxf-vfminf)/10
dvf2=2*dvf

;vfmaxf=4*dvf
;vfminf=-4*dvf
;stop
for i=vfminf,vfmaxf-dvf,dvf do begin
  ypto = yoo+ ((i-vfminf)*yd/(vfmaxf-vfminf))
    if (fix(i/dvf2)*dvf2 eq i) then begin
    XYOUTS, xo-1800, ypto-100, (fix(i)) , FONT=0, CHARSIZE=1.2, CHARTHICK=2.0, /DEVICE
    plots, [xo,xo-150], [ypto,ypto],color=0,thick=2.0,/device
  endif else begin
    plots, [xo,xo-80], [ypto,ypto],color=0,thick=2.0,/device
  endelse
endfor

endif

endif

if ilinehf eq 1 then begin

dvh=(vhmax-vhmin)/10
inum=0
for i=vhmin,vhmax,dvh do begin
  ypt = yo+ ((i-vhmin)*yd/(vhmax-vhmin))
  if (inum eq 0) then begin
    XYOUTS, xo+xd+100, ypt-100, string(i) , FONT=0, CHARSIZE=1.0, CHARTHICK=2.0, /DEVICE
    plots, [xo+xd,xo+xd+150], [ypt,ypt],color=0,thick=2.0,/device
    inum=1
  endif else begin
;    XYOUTS, xo+xd-300, ypt-100, string(i) , FONT=0, CHARSIZE=1.2, CHARTHICK=2.0, /DEVICE
    plots, [xo+xd,xo+xd+80], [ypt,ypt],color=0,thick=2.0,/device
    inum=0
  endelse
endfor

if ifilter eq 1 then begin

dvh=(vhmaxf-vhminf)/10
inum=0
for i=vhminf,vhmaxf-dvh,dvh do begin
  ypto = yoo+ ((i-vhminf)*yd/(vhmaxf-vhminf))
  print, i,yoo,ypto
  if (inum eq 0) then begin
    XYOUTS, xo+xd+100, ypto-100, string(i) , FONT=0, CHARSIZE=1.0, CHARTHICK=2.0, /DEVICE
    plots, [xo+xd,xo+xd+150], [ypto,ypto],color=0,thick=2.0,/device
    inum=1
  endif else begin
    plots, [xo+xd,xo+xd+80], [ypto,ypto],color=0,thick=2.0,/device
    inum=0
  endelse
endfor

endif

endif
;
if ilinefp eq 1 then XYOUTS, xo-1500, yo+0.2*yd, 'Auroral intensity (kR)' , FONT=0, CHARSIZE=1.1, orientation=90, CHARTHICK=2.0, /DEVICE
if ilinehf eq 1 then XYOUTS, xo+xd+3800, yo+0.0*yd, 'Total energy flux (eV/cm2/sec/str)' , FONT=0, CHARSIZE=1.0, orientation=90, CHARTHICK=2.0, /DEVICE

if ifilter eq 1 then begin
XYOUTS, xo-1500, yoo+0.2*yd, 'Auroral intensity (kR)' , FONT=0, CHARSIZE=1.1, orientation=90, CHARTHICK=2.0, /DEVICE
XYOUTS, xo+xd+3800, yoo+0.0*yd, 'Total energy flux (eV/cm2/sec/str)' , FONT=0, CHARSIZE=1.0, orientation=90, CHARTHICK=2.0, /DEVICE
endif
;
;-------Drawing time tick mark and time --------
;
dt = (etime-stime)
kflg=0

;print,'stime,etime,dt=',stime,etime,dt_mac,dt_eisa
if (dt gt 3.0*3600.0) then begin
  dtick = 30.0*60.0
  tmark = 60.0*60.0
  iflg = 0
;  print,'1',dtick,tmark
endif else if (dt gt 1.5*3600.0) then begin
  dtick = 10.0*60.0
  tmark = 30.0*60.0
  iflg = 1
;  print,'2',dtick,tmark
endif else if (dt gt 600.0) then begin
  dtick = 5.0*60.0
  tmark = 10.0*60.0
  iflg = 1
;  print,'3',dtick,tmark
endif else if (dt ge 60.0) then begin
  dtick = 30.0
  tmark = 60.0
  iflg = 1
;  print,'3',dtick,tmark
endif else begin
  dtick = 5.0
  tmark = 10.0
  kflg = 1
;  print,'3',dtick,tmark
endelse
;
tflg=0
for i=stime,etime do begin
; print, i, fix(i/dtick),i/dtick
  if (i/tdiv eq fix(i/tdiv)) then begin
    xpt = xo + (i-stime)*(xd / dt)
    if (i/tmark eq fix(i/tmark)) then begin
      tl = 200
      jflg = 1
    endif else begin
      tl = 100
      jflg = 0
    endelse
    yp = yo
    ypo = yoo
    if ifilter eq 0 then ypo=yo
;    print, 'tick',xp,tl
    plots, [xpt,xpt], [yp,yp-tl],color=0,thick=2.0,/device
    plots, [xpt,xpt], [ypo,ypo-tl],color=0,thick=2.0,/device
;    plots, [xpt,xpt], [yp+yd,yp2],color=0,thick=2.0,/device
    if (kflg eq 1) then begin
      hh = fix(i/3600)
      mm = fix((i-long(hh)*long(3600))/60)
      ss = fix(i-long(hh)*3600l-mm*60)
      if (hh ge 24) then hh=hh-24
      if ss lt 10 then begin
        ssc='0'+strmid(string(ss),7,1)
      endif else begin
        ssc=strmid(string(ss),6,2)
      endelse
;      print,hh,mm,ss
      tw = fix(hh*100 + mm)
      if (tw eq 0) then begin
         twr = '0000'
         xofs = 600.0
      endif else if (tw lt 100) then begin
        twr = '00'+strcompress(string(tw),/remove_all)
        xofs = 600.0
      endif else if (tw lt 1000) then begin
        twr = '0'+strcompress(string(tw),/remove_all)
        xofs = 600.0
      endif else begin
        twr = string(tw)
        xofs = 0.0
      endelse

;      charut=0.5
      charut=1.3

      if tflg eq 0 then begin
        XYOUTS, xo-1000, ypo-tl-600, twr+':'+ssc , FONT=0, CHARSIZE=charut, CHARTHICK=2.0, /DEVICE
        XYOUTS, xo+xd/2-1600, ypo-tl-1200, 'U T (hhmm:ss)' , FONT=0, CHARSIZE=1.3, CHARTHICK=2.0, /DEVICE
        tflg=1
      endif else begin
        XYOUTS, xpt-1000+xofs, ypo-tl-600, ssc, FONT=0, CHARSIZE=charut, CHARTHICK=2.0, /DEVICE
      endelse
    endif else if (iflg eq 1) and (jflg eq 1) then begin
;    if (iflg eq 1) then begin
      hh = fix(i/3600)
      mm = (i-long(hh)*long(3600))/60
      if (hh ge 24) then hh=hh-24
;      print,hh,mm
      tw = fix(hh*100 + mm)
      if (tw eq 0) then begin
         twr = '0000'
         xofs = 600.0
      endif else if (tw lt 100) then begin
        twr = '00'+strcompress(string(tw),/remove_all)
        xofs = 600.0
      endif else if (tw lt 1000) then begin
        twr = '0'+strcompress(string(tw),/remove_all)
        xofs = 600.0
      endif else begin
        twr = string(tw)
        xofs = 0.0
      endelse
      XYOUTS, xpt-1200+xofs, ypo-tl-600, twr , FONT=0, CHARSIZE=charut, CHARTHICK=2.0, /DEVICE
      XYOUTS, xo+xd/2-1600, ypo-tl-1200, 'U  T (hhmm)' , FONT=0, CHARSIZE=1.3, CHARTHICK=2.0, /DEVICE
    endif else if (jflg eq 1) and (iflg eq 0) then begin
      hh = fix(i/3600)
      if (hh ge 24) then hh=hh-24
      tw = fix(hh)
      if (hh lt 10) then begin
        xofs = 150.0
      endif else begin
        xofs= 0.0
      endelse
      XYOUTS, xpt-1050-xofs, ypo-tl-600, tw , FONT=0, CHARSIZE=1.3, CHARTHICK=2.0, /DEVIC
      XYOUTS, xo+xd/2-1500, ypo-tl-1200, 'U  T (hr)' , FONT=0, CHARSIZE=1.3, CHARTHICK=2.0, /DEVICE
;      XYOUTS, xo, yp-tl-1800, cdate , FONT=0, CHARSIZE=1.3, CHARTHICK=2.0, /DEVICE
    endif
  endif
endfor
;
;



DEVICE, /CLOSE
;SET_PLOT, 'X'

print, 'end'



theend:
END
