PRO MAC_EISA_FFT_power_spectrum_plot
; on June 17, 2006, by TS

;=========parameters=======================
;20051222 09:31:40-09:33:05 very disturbed, complicated 09 31 50 512 10, 09 32 10 256 10
;20051226 09:10:40-09:11:00 typical inverted-V + IAW / 09 10 40 128 10
;20051229 00:22:00-20:22:28 strong IAW / 00 22 00 128 10
;20060125 23:34:30-23:34:50 pulsation(23:34:45-23:34:50) 23 34 45 128(or64) 10
;20060103 10:06:00-10:06:30 fast shear flows 10 06 10 128
;20051112 01:37:25-01:38:00 very dispersed pulsation
;20070127 08:20:30-08:21:30
;
;--- parameters for filtering
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20051222093144.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20051222093144.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20051226091034.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20051226091034.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20051229002031.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20051229002031.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20060125233325.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20060125233154.txt'
;fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20060103100541.M0_CH123__ModeS_L1_ps.txt'
;fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20060103100500.txt'
fname_mac='C:\Usr\tsakanoi\index\timeseries\MAC20070127082005.M0_CH123__ModeS_L1_ps.txt'
fname_eisa='C:\Usr\tsakanoi\index\timeseries\RE_ESA_TOTALEFLUX_20070127081755a.txt'
;-------------------------------------------------------------
;plot time
sh=08
sm=21
ss=07
;--- FFT parameters ----------------
windows_mac=128
;  data window for FFT for MAC(data points), data window for EISA is set by considering sampling factor between MAC and EISA (usually, 4)
steps_mac=10
;  data number interval for FFT for MAC
minfreq=0.1
maxfreq=10
;  plotting min and max frequency (Hz)
smn=2

;--- parameter for MAC file------------------------------
;-- line of MAC data
ilinefp = 01
;plot emission
pch1=1
pch2=1
pch3=1
;--- parameter for EISA radar data------------------------
;-- line of ESIA data
ilinehf = 1

date1=strmid(fname_mac,strlen(fname_mac)-40,14)
cyy1=strmid(date1,0,4)
cmo1=strmid(date1,4,2)
cdd1=strmid(date1,6,2)
chh1=strmid(date1,8,2)
mo1=fix(cmo1)
mon_num_to_char,mo1,charmon1
hiniti=charmon1+', '+cdd1+', '+cyy1
if sh lt 10 then begin
  csh1='0'+strmid(string(sh),7,1)
endif else begin
  csh1=strmid(string(sh),6,2)
endelse
if sm lt 10 then begin
  csm1='0'+strmid(string(sm),7,1)
endif else begin
  csm1=strmid(string(sm),6,2)
endelse
if ss lt 10 then begin
  css1='0'+strmid(string(ss),7,1)
endif else begin
  css1=strmid(string(ss),6,2)
endelse
if windows_mac lt 1000 then begin
  cwi1='0'+strmid(string(windows_mac),5,3)
endif else begin
  cwi1=strmid(string(windows_mac),4,4)
endelse

fout_mac1='C:\usr\tsakanoi\index\mac1_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+'.xy'
fout_mac2='C:\usr\tsakanoi\index\mac2_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+'.xy'
fout_mac3='C:\usr\tsakanoi\index\mac3_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+'.xy'
fout_eisa='C:\usr\tsakanoi\index\eisa_filt'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+'.xy'
;---PSFILE
psfile='C:\usr\tsakanoi\index\ps\FFT_power_'+cyy1+cmo1+cdd1+csh1+csm1+css1+'_'+cwi1+'.ps'

;---
xofs = 25.0
yofs = 210.0
;=================parameter end========================================
close,/all

icol1=60
icol2=150
icol3=250

sti=0.0d
sti = sh*3600.0+sm*60.0+ss

;--- data process for EISA data-------------------------------

print, '=== EISA data process start ==='
EISA_efulx_timeseries_read,fname_eisa,tsec_eisa,hh_eisa,mm_eisa,eflux_down,eflux_perp,eflux_up,intotal_eisa,dt_eisa

;---- data processing for MAC data
print, '=== MAC data process start ==='

MAC_timeseries_read,fname_mac,tsec_mac,hh_mac,mm_mac,image1,image2,image3,intotal_mac,dt_mac

windows_eisa=0l
steps_eisa=0l

if dt_mac eq 0.12 and dt_eisa eq 0.04d then begin
  windows_eisa=windows_mac*4l
  steps_eisa=steps_mac*3
endif else if dt_mac eq 1.0 and dt_eisa eq 0.04d then begin
  windows_eisa=long(windows_mac)*256l
  steps_eisa=steps_mac*250l
endif else begin
  stop
endelse

fft_power,eflux_down,tsec_eisa,intotal_eisa,windows_eisa,steps_eisa,maxfreq,minfreq,smn,power_eisa,dataout_real_eisa,dataout_img_eisa,timout_eisa,dy_eisa,logpower_eisa,lnpower_eisa

fft_power,image1,tsec_mac,intotal_mac,windows_mac,steps_mac,maxfreq,minfreq,smn,power_mac1,dataout_real_mac1,dataout_img_mac1,timout_mac1,dy_mac1,logpower_mac1,lnpowermac1
fft_power,image2,tsec_mac,intotal_mac,windows_mac,steps_mac,maxfreq,minfreq,smn,power_mac2,dataout_real_mac2,dataout_img_mac2,timout_mac2,dy_mac2,logpower_mac2,lnpowermac2
fft_power,image3,tsec_mac,intotal_mac,windows_mac,steps_mac,maxfreq,minfreq,smn,power_mac3,dataout_real_mac3,dataout_img_mac3,timout_mac3,dy_mac3,logpower_mac3,lnpowermac3

;------------------- PS PLOT ------------------------------------------
print, '=== Plotting ==='
SET_PLOT, 'PS'
LOADCT, 13
;
DEVICE, BITS_PER_PIXEL=8, /COLOR, FILENAME=psfile, /PORTRAIT, $
XSIZE=17, YSIZE=25.7, XOFFSET=2.0, YOFFSET=2.0
print, psfile

kflg=0
for i=1, fix(intotal_eisa/steps_eisa)-1 do begin
  if sti ge timout_eisa(i-1) and sti lt timout_eisa(i) then begin
    num_eisa=i-1
    kflg=1
  endif
endfor
if kflg eq 0 then begin
  print, 'Time of plot is out-of-range.'
  stop
endif
kflg=0
for i=1, fix(intotal_mac/steps_mac)-1 do begin
  if sti ge timout_mac1(i-1) and sti lt timout_mac1(i) then begin
    num_mac=i-1
    kflg=1
  endif
endfor
if kflg eq 0 then begin
  print, 'Time of plot is out-of-range.'
  stop
endif

hh_eisa1=fix(timout_eisa(num_eisa)/3600)
mm_eisa1=(timout_eisa(num_eisa)-hh_eisa1*3600l)/60.0
hh_mac1=fix(timout_mac1(num_mac)/3600)
mm_mac1=(timout_mac1(num_mac)-hh_mac1*3600l)/60.0


ctime_eisa='UT='+strmid(string(hh_eisa1),6,2)+':'+strmid(string(fix(mm_eisa1)),6,2)+':'+$
  strmid(string((mm_eisa1-fix(mm_eisa1))*60),5,6)
cwindows_eisa='Window='+strmid(dt_eisa*windows_eisa,4,9)+' s'

ctime_mac='UT='+strmid(string(hh_mac1),6,2)+':'+strmid(string(fix(mm_mac1)),6,2)+':'+$
  strmid(string((mm_mac1-fix(mm_mac1))*60),5,6)
cwindows_mac='Window='+strmid(dt_mac*windows_mac,4,9)+' s'

maxp_eisa=max(power_eisa(num_eisa,*))
minp_eisa=min(power_eisa(num_eisa,*))
maxmac=fltarr(3)
minmac=fltarr(3)
maxmac(0)=max(power_mac1(num_mac,*))
minmac(0)=min(power_mac1(num_mac,*))
maxmac(1)=max(power_mac2(num_mac,*))
minmac(1)=min(power_mac2(num_mac,*))
maxmac(2)=max(power_mac3(num_mac,*))
minmac(2)=min(power_mac3(num_mac,*))
maxp_mac=max(maxmac)
minp_mac=min(minmac)

!p.multi=[0,1,3]
;-----Drawing section
plot, dy_eisa(*),power_eisa(num_eisa,*),/xlog,/ylog,yrange=[minp_eisa,maxp_eisa],$
  xrange=[minfreq,maxfreq],thick=4,xthick=3,ythick=3,$
  xticklen=0.03,yticklen=0.03,title='Downward electron total energy flux',$
  xtitle='frequency (Hz)',ytitle='power ((eV/cm2/s/str)^2/sec)',$
  /xstyle,/ynozero,charsize=2.5
plot, dy_mac1(*),power_mac1(num_mac,*),/xlog,/ylog,yrange=[minp_mac,maxp_mac],$
  xrange=[minfreq,maxfreq],thick=4,linestyle=3,xthick=3,ythick=3,/nodata,$
  xticklen=0.03,yticklen=0.03,$
  title='Auroral intensity ',$
  xtitle='frequency (Hz)',ytitle='power (kR^2/sec)',$
  /xstyle,/ynozero,charsize=2.5
oplot, dy_mac1(*),power_mac1(num_mac,*),color=icol1,thick=4,linestyle=3
oplot, dy_mac2(*),power_mac2(num_mac,*),color=icol2,thick=4,linestyle=2
oplot, dy_mac3(*),power_mac3(num_mac,*),color=icol3,thick=4,linestyle=0
;plot, dy_mac2(*),power_mac2(num_mac,*),/xlog,/ylog,yrange=[minp_mac,maxp_mac],xrange=[minfreq,maxfreq]
;plot, dy_mac3(*),power_mac3(num_mac,*),/xlog,/ylog,yrange=[minp_mac,maxp_mac],xrange=[minfreq,maxfreq]

XYOUTS, 1000, 26500,'!3REIMEI/MAC and ESA Observations on '+hiniti, FONT=0, CHARSIZE=1.5, $
CHARTHICK=2., ORIENTATION=0,color=30, /DEVICE
;XYOUTS, 3200, 24800, 'Auroral intensity and downward electron total energy flux ', $
;FONT=0, CHARSIZE=1.5, CHARTHICK=1.5,ORIENTATION=0, COLOR=30, /DEVICE
;XYOUTS, 8200, 24000,hiniti, FONT=0, CHARSIZE=1.5, $
;CHARTHICK=2., ORIENTATION=0,color=30, /DEVICE

XYOUTS, 4000, 19200, 'Electron pitch angle: 0-60 deg.', FONT=0, CHARSIZE=1.1, $
  CHARTHICK=2., ORIENTATION=0, /DEVICE
XYOUTS, 4000, 24200, ctime_eisa+' / '+cwindows_eisa, FONT=0, CHARSIZE=1.1, $
  CHARTHICK=2., ORIENTATION=0, /DEVICE

sfnum=''
if pch1 eq 1 then begin
  sfnum=sfnum+'428nm(blue)'
endif
if pch2 eq 1 then begin
  sfnum=sfnum+' 558nm(green)'
endif
if pch3 eq 1 then begin
  sfnum=sfnum+' 670nm(red)'
  endif
XYOUTS, 4000, 10500, 'Auroral emission: '+sfnum, FONT=0, CHARSIZE=1.1, $
  CHARTHICK=2., ORIENTATION=0, /DEVICE
XYOUTS, 4000, 15500, ctime_mac+' / '+cwindows_mac, FONT=0, CHARSIZE=1.1, $
  CHARTHICK=2., ORIENTATION=0, /DEVICE



DEVICE, /CLOSE
;SET_PLOT, 'X'

print, 'end'



theend:
END
