pro MAC_start_end_time

; coded by T. Sakanoi on 28 Oct, 2005
;

;--- Input/Output files -------------------------------------------------------------
;--- orbit file with invlat
ofile='C:\Usr\tsakanoi\Index\orb_pre\orbt0020_stn_20051014_1111_ft_inv.txt'
;  if orbit file is made by asamura, then chose below and set asamura=1
asamura=0
;ofile='C:\Usr\tsakanoi\Index\orb_pre\orbt0022_invlat_20051021000000.txt'

;--- sunshine start/end file
sfile='C:\Usr\tsakanoi\Index\orb_pre\sunlight1027_1122.csv'
;--- obs start/end list file
pfile='C:\Usr\tsakanoi\Index\orb_pre\orbt0020_stn_20051021_1111_asamura_start_end.txt'
;--- SC file
cfile='C:\Usr\tsakanoi\Index\orb_pre\SC_MAC_TEST6.sct'

;--- Input start and end time --------------------------------------------------------

syy=2005
smo=10
sdd=27
shh=20
smm=00
sss=00
;sss should be zero
eyy=2005
emo=10
edd=28
ehh=08
emm=00
ess=00
;ess should be zero

;--- Input higher and lower limits of invlat for start and end of observation ---------
invlimitl=65.0
invlimith=71.0

;--- mergin time of MAC start time when entering the shadow of the earth
delayt=20.0

;--- Observation will be made only in he nothern and/or southern hemisphere? Yes=1 ----
nobs=1
sobs=0

;--- Commands and delay time(dt) in sec -----------------------------------------------
iini=1
initial_command,initial_com,initial_dt,numi
ishus=1
SHU_start_command,shu_s_com,shu_s_dt,numshs
imacs=1
MAC_start_command,mac_s_com,mac_s_dt,numrs
ieisas=0
EISA_start_command,mac_s_com,mac_s_dt,numps
imace=1
MAC_end_command,mac_e_com,mac_e_dt,numre
ieisae=0
EISA_end_command,mac_s_com,mac_s_dt,numpe
ishue=1
SHU_end_command,shu_e_com,shu_e_dt,numshe
ifin=1
final_command,end_com,end_dt,nume


;===main routine start=====================================================================

;--- total day and total second calclation for start and end times ------------------------
totalday,syy,smo,sdd,smd,std
totalday,eyy,emo,edd,emd,etd

totalsec,shh,smm,sss,stsec
totalsec,ehh,emm,ess,etsec

etsec=etsec+86400l*(etd-std)

print,'start & end time ',stsec,etsec

tnum=0l
tnum=(etsec-stsec)/4+1
tsec=lonarr(tnum)

for i=0l, tnum-1 do begin
  tsec(i)=stsec+4l*i
endfor

;--- Reading orbit file --------------------------------------------------------

close,/all

openr,1,ofile

yy2=intarr(2678400l)
mo2=intarr(2678400l)
dd2=intarr(2678400l)
hh2=intarr(2678400l)
mm2=intarr(2678400l)
ss2=intarr(2678400l)
glat2=fltarr(2678400l)
glon2=fltarr(2678400l)
alt2=fltarr(2678400l)
glatf2=fltarr(2678400l)
glonf2=fltarr(2678400l)
altf2=fltarr(2678400l)
invlat2=fltarr(2678400l)
td2=intarr(2678400l)
tsec2=lonarr(2678400l)

onum1=0l
onum=0l
jflg=0
td0=0l

cdum=''
readf,1,cdum


readfile:

;on_ioerror, readfile

if asamura eq 0 then begin
  readf,1,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,geolatf1,geolonf1,altf1,invlat1
endif else begin
  readf,1,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,2x,f7.3,1x,f7.3,1x,f7.3)',$
    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,invlat1
    if invlat1 gt 90.0 then goto, readfile
endelse

totalday,y1,mo1,dd1,md1,td1
totalsec,hh1,mm1,ss1,tsec1

;print, td1,std,etd,tsec1,stsec,etsec

if td1 ge etd and tsec1 gt etsec then goto, nextstep

if (td1 eq std and tsec1 ge stsec) then begin
  td0=td1
  jflg=1
endif
if jflg eq 1 then begin
  tsec1=tsec1+(td1-td0)*86400l
;  print, td1,std,etd,tsec1,stsec,etsec
  if (td1 eq etd and tsec1 gt etsec+60) then goto, nextstep
endif

if jflg eq 1 then begin
; if asamura eq 0 then begin
;  print,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
;    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,geolatf1,geolonf1,altf1,invlat1
; endif else begin
;  print,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
;    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,invlat1
; endelse

  yy2(onum1)=y1
  mo2(onum1)=mo1
  dd2(onum1)=dd1
  hh2(onum1)=hh1
  mm2(onum1)=mm1
  ss2(onum1)=ss1
  td2(onum1)=td1
  tsec2(onum1)=tsec1
  glat2(onum1)=glat1
  glon2(onum1)=glon1
  alt2(onum1)=alt1
  glatf2(onum1)=glat1
  glonf2(onum1)=glon1
  altf2(onum1)=alt1
  invlat2(onum1)=invlat1

  onum1=onum1+1

endif

if eof(1) ne 1 then goto, readfile

nextstep:


onum=onum1

glat=fltarr(onum)
glon=fltarr(onum)
alt=fltarr(onum)
glatf=fltarr(onum)
glonf=fltarr(onum)
altf=fltarr(onum)
invlat=fltarr(onum)
td=intarr(onum)
tsecr=lonarr(onum)

td(0:onum-1)=td2(0:onum-1)
tsecr(0:onum-1)=tsec2(0:onum-1)
glat(0:onum-1)=glat2(0:onum-1)
glon(0:onum-1)=glon2(0:onum-1)
alt(0:onum-1)=alt2(0:onum-1)
glatf(0:onum-1)=glatf2(0:onum-1)
glonf(0:onum-1)=glonf2(0:onum-1)
altf(0:onum-1)=altf2(0:onum-1)
invlat(0:onum-1)=invlat2(0:onum-1)

glatp=fltarr(tnum)
glonp=fltarr(tnum)
altp=fltarr(tnum)
glatfp=fltarr(tnum)
glonfp=fltarr(tnum)
altfp=fltarr(tnum)
invlatp=fltarr(tnum)

glatp=INTERPOL( glat, tsecr, tsec )
glonp=INTERPOL( glon, tsecr, tsec )
altp=INTERPOL( alt, tsecr, tsec )
glatfp=INTERPOL( glatf, tsecr, tsec )
glonfp=INTERPOL( glonf, tsecr, tsec )
altfp=INTERPOL( altf, tsecr, tsec )
invlatp=INTERPOL( invlat, tsecr, tsec )

;--- Reading a file of sunlight start and end times
;
cdum=''
susd1=0
susmon1=''
susy1=0
sush1=0
susm1=0
suss1=0.0
sued1=0
suemon1=''
suey1=0
sueh1=0
suem1=0
sues1=0.0
dur1=0.0
sustsec1=0l
suetsec1=0l
sustsec=lonarr(1000)
suetsec=lonarr(1000)

snum=0
;

;print, sfile,ii
openr,5,sfile

readf,5,cdum

readsunfile:

readf,5,format='(i2,1x,a3,1x,i4,1x,i2,a1,i2,a1,f6.3,1x,i2,1x,a3,1x,i4,1x,i2,a1,i2,a1,f6.3,1x,f8.3)',$
    susd1,susmon1,susy1,sush1,cdum,susm1,cdum,suss1,sued1,suemon1,suey1,sueh1,cdum,suem1,cdum,sues1,dur1

mon_char_to_num,suemon1,suemonn1
mon_char_to_num,susmon1,susmonn1

totalday,susy1,susmonn1,susd1,susmd,sustd
totalday,suey1,suemonn1,sued1,suemd,suetd

totalsec,sush1,susm1,suss1,sustsec1
totalsec,sueh1,suem1,sues1,suetsec1

sustsec(snum)=sustsec1+(sustd-std)*86400
suetsec(snum)=suetsec1+(suetd-std)*86400

if suetsec(snum) ge etsec then goto, nextstep2
;print, snum,sustsec(snum),suetsec(snum),    susd1,susmon1,susy1,sush1,cdum,susm1,cdum,suss1,sued1,suemon1,suey1,sueh1,cdum,suem1,cdum,sues1,dur1

snum=snum+1

if eof(5) ne 1 then goto, readsunfile

nextstep2:

;=== Out put parameters to files ===========================================================

;--- output headers
iflg=0
hh=0
mm=0
ss=0

openw,11,pfile
printf,11, syy,smo,sdd,shh,smm,sss
printf,11, eyy,emo,edd,ehh,emm,ess
printf,11, invlimitl,invlimith
if nobs eq 1 and sobs eq 0 then begin
  printf,11,'only northern hemi.'
endif else if nobs eq 0 and sobs eq 0 then begin
  printf,11,'only southern hemi.'
endif else begin
  printf,11,'northern and southern hemispheres.'
endelse

printf,11,'s/e,yy,mm,dd,hh,mm,ss,glatp,glonp,altp,glatfp,glonfp,altfp,invlatp'
printf,11,'format=(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)'


openw,21,cfile
printf,21,'s,Type,CMD,SM-CODE-H,SM-CODE-L,Coment'

;--- Output obs start and end times

ptd=0
lasttsec=0l

kflg=0
cyy=strarr(4)
cmo=strarr(2)
cdd=strarr(2)
ch=strarr(2)
cm=strarr(2)
cs=strarr(2)

for i=1l, tnum-1 do begin

;--- northern hemisphere case ------------------------------------------------------------------
  if (nobs eq 1 and glatp(i) gt 0) then begin

  jflg=0

;--- start time defined by crossing higher invlat
  if invlatp(i-1) gt invlimith and invlatp(i) le invlimith and iflg eq 0 then begin

;--- if satellite exists in sunlight at the start time, then
;      start time is shfted 30 sec after the time entering the shadow of the earth
   sunflg=0
   for j=0, snum-1 do begin
    if tsec(i) ge sustsec(j) and tsec(i) le suetsec(j) then begin
      tsec(i)=long((suetsec(j)+delayt)/4)*4
      print,'!!!!!!!!! MAC on/off time shift due to sunlight'
      sunflg=1
    endif
   endfor

   tsectohhmmss,tsec(i),hh,mm,ss,aday

;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,syy,pm,pd

;--- output start time
    printf,11,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)

;--- output SC file
;--- initial commands of SC
    if kflg eq 0 then begin
     for j=0, numi-1 do begin
      dt1=initial_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd

      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',initial_com(j)

      kflg = 1
     endfor
    endif

;--- main body of SC

;--- SHU command

    for j=0, numshs-1 do begin
      dt1=shu_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_s_com(j)+cdt
      lasttsec=tsec(i)
    endfor


;--- MAC command
    for j=0, numrs-1 do begin
      dt1=mac_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='obs-north'
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_s_com(j)+cdt
      lasttsec=tsec(i)
    endfor

    iflg = 1
  endif

;--- end time defined by crossing lower invlat (northern hemi. case)
  if invlatp(i-1) ge invlimitl and invlatp(i) lt invlimitl and iflg eq 1 then begin
    tsectohhmmss,tsec(i),hh,mm,ss,aday
;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,eyy,pm,pd

;--- output end time list
    printf,11,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e ',syy,pm,pd,hh,mm,ss,glatp(i-1),glonp(i-1),altp(i-1),glatfp(i-1),glonfp(i-1),altfp(i-1),invlatp(i-1)
    iflg = 0

;--- output SC ---

;--- MAC command
    for j=0, numre-1 do begin
      dt1=mac_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='MAC ON '+strmid(string(tsec(i)-lasttsec),9,4)+'sec'
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_e_com(j)+cdt
      lasttsec=tsec(i)

    endfor


    for j=0, numshe-1 do begin
      dt1=shu_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_e_com(j)+cdt
      lasttsec=tsec(i)

    endfor

  endif


;--- Southren hemisphere case ------------------------------------------------------------------

 endif

 if (sobs eq 1 and glatp(i) lt 0) then begin

  jflg=0

;--- crossing of lower invlat limet
  if invlatp(i-1) lt invlimitl and invlatp(i) ge invlimitl and iflg eq 0 then begin

    tsectohhmmss,tsec(i),hh,mm,ss,aday
;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,syy,pm,pd

;--- output start
    printf,11,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    iflg = 1
  endif

;--- output SC file
;--- initial commands of SC
    if kflg eq 0 then begin
     for j=0, numi-1 do begin
      dt1=initial_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd

      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',initial_com(j)

      kflg = 1
     endfor
    endif

;--- main body of SC

;--- SHU command

    for j=0, numshs-1 do begin
      dt1=shu_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_s_com(j)+cdt
      lasttsec=tsec(i)
    endfor


;--- MAC command
    for j=0, numrs-1 do begin
      dt1=mac_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='obs-south'
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_s_com(j)+cdt
      lasttsec=tsec(i)
    endfor

    iflg = 1

;--- crossing of higher invlat limit
  if invlatp(i-1) le invlimith and invlatp(i) gt invlimith and iflg eq 1 then begin

   sunflg=0
   for j=0, snum-1 do begin
    if tsec(i) ge sustsec(j) and tsec(i) le suetsec(j) then begin
      tsec(i)=long((suetsec(j)-delayt)/4)*4
      print,'!!!!!!!!! MAC on/off time shift due to sunlight'
      sunflg=1
    endif
   endfor

    tsectohhmmss,tsec(i),hh,mm,ss,aday
;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,eyy,pm,pd

;--- output end time
    printf,11,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e ',syy,pm,pd,hh,mm,ss,glatp(i-1),glonp(i-1),altp(i-1),glatfp(i-1),glonfp(i-1),altfp(i-1),invlatp(i-1)
    iflg = 0

;--- output SC ---

;--- MAC command
    for j=0, numre-1 do begin
      dt1=mac_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='MAC ON '+strmid(string(tsec(i)-lasttsec),9,4)+'sec'
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_e_com(j)+cdt
      lasttsec=tsec(i)

    endfor


    for j=0, numshe-1 do begin
      dt1=shu_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_e_com(j)+cdt
      lasttsec=tsec(i)

    endfor



  endif

 endif

endfor

;--- output SCs in the end of sc file -----------------------------------------------------------
for j=0, nume-1 do begin
  dt1=end_dt(j)
  tsectohhmmss,lasttsec+dt1,hh,mm,ss,aday
  ptd=std+aday
  totaldaytoyymmdd,ptd,syy,pm,pd
  cyy=strmid(string(syy),4,4)

  if pm ge 10 then begin
    cmo=strmid(string(pm),6,2)
  endif else begin
    cmo=strmid(string(pm),7,1)
  endelse
  if pd ge 10 then begin
    cdd=strmid(string(pd),6,2)
  endif else begin
    cdd=strmid(string(pd),7,1)
  endelse

  if hh ge 10 then begin
    ch=strmid(string(hh),6,2)
  endif else begin
    ch='0'+strmid(string(hh),7,1)
  endelse
  if mm ge 10 then begin
    cm=strmid(string(mm),6,2)
  endif else begin
    cm='0'+strmid(string(mm),7,1)
  endelse
  if ss ge 10 then begin
    cs=strmid(string(fix(ss)),6,2)
  endif else begin
    cs='0'+strmid(string(fix(ss)),7,1)
  endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
  printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',end_com(j)

endfor



close,/all
print,'normal end'


end
