;******************************************************************
;    program MACimage_DARTS_L1_animation_color_auto.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Jan 16, 2006
;******************************************************************

PRO MACimage_DARTS_L1_PS_multi_color_auto_new_new

iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin=fltarr(4,3)
smax=fltarr(4,3)
smin1=fltarr(4,3)
smax1=fltarr(4,3)
;for mode0
smin(0,0) = 2 & smax(0,0) = 10
smin(0,1) = 5 & smax(0,1) = 70
smin(0,2) = 5 & smax(0,2) = 80
;smin(0,0) = 2 & smax(0,0) = 60
;smin(0,1) = 5 & smax(0,1) = 180
;smin(0,2) = 5 & smax(0,2) = 150
;for mode1
smin(1,0) = 2 & smax(1,0) = 30
smin(1,1) = 2 & smax(1,1) = 80
smin(1,2) = 2 & smax(1,2) = 100
;for mode2
smin(2,0) = 40 & smax(2,0) = 50
smin(2,1) = 10 & smax(2,1) = 100
smin(2,2) = 40 & smax(2,2) = 250
;for mode3
smin(3,0) = 5 & smax(3,0) = 15
smin(3,1) = 5 & smax(3,1) = 50
smin(3,2) = 5 & smax(3,2) = 40

;smax and smin in kR for ch1,2,3

fdir1= 'D:\Index\DARTS\Level-1\'
;fdir1= 'C:\Usr\tsakanoi\Index\DARTS\Level-1\'
;ymdir=['2005\09\','2005\10\','2005\11\','2005\12\','2006\01\','2006\02\','2006\03\']
;ymdir=['2005\10\','2005\11\','2005\12\','2006\01\','2006\02\','2006\03\']
;ymdir=['2006\01\','2006\02\']
;ymdir=['2005\12\a\']
ymdir=['each\']
ymnum=n_elements(ymdir)


;status file read? yes-1
ista=1
;status file type 1-1month total file, 0-1day file
istatype=0

;footprint plotting 1 yes
footp=1
;fovdir='C:\Usr\tsakanoi\Index\DARTS\Level-2\MACFOV\'
fovdir='D:\Index\DARTS\Level-2\MACFOV\'
;fovdir='C:\Usr\tsakanoi\Index\MAC_FOV\landpointing\'
;--- if you choose landpointing directory, set nstep=1, and sub_fov_read_land.
;fovdir='C:\cygwin\home\Administrator\MAC_FOV\macfov060320_2\work\'


;offsets for alignment adjust
phioffset=dblarr(3)
tetaoffset=dblarr(3)
phioffset1=dblarr(3)
tetaoffset1=dblarr(3)
teta=dblarr(3)
phi=dblarr(3)
teta1=dblarr(3)
phi1=dblarr(3)
phi1=[-0.187481079,-0.557762731,-0.737182143]
teta1=[45.5681735,46.1965292,45.9116745]

phioffset1(0)=0.0
tetaoffset1(0)=0.0
phioffset1(1)=0.0
tetaoffset1(1)=0.0
;phioffset1(2)=-0.32
phioffset1(2)=0.3
;phioffset1(2)=0.58
tetaoffset1(2)=-0.68
;tetaoffset1(2)=-0.58

phi(2)=phi1(2)+phioffset1(2)
teta(2)=teta1(2)+tetaoffset1(2)
;phi(0)=phi1(0)+phioffset1(0)
;teta(0)=teta1(0)+tetaoffset1(0)
;phi(1)=phi1(1)+phioffset1(1)
;teta(1)=teta1(1)+tetaoffset1(1)
phi(0)=phi(2)+0.44302663d
teta(0)=teta(2)-0.29254145d
phi(1)=phi(2)+0.51826331d
teta(1)=teta(2)+0.39899596d

kxshift=3
kyshift=-1

print, phi
print, teta
;stop




;write text file of auroral intensities at footprint ? yes-1
icrosssec=1

; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
radimagefile='H:\Index\obs\051110\051110004943_radcorrect_flame2.dat'
; count to rayleigh convertion yes=1
rayleigh=1
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0

if radcorrect eq 1 then rayleigh=1

select_frame=0
;select_frame=1 then set pnums and pnume
;select_frame=0 then all frame are played
  pnums=0
  pnume=500

;nstep plotting image step
;nstep0 for mode0, nstep1 for mode1, nstep2 for mode2, nstep3 for mode3
;nstep=16
;nstep0=1
nstep0=24
nstep1=3
nstep2=1
nstep3=6

col=0
;col=3 is red
;col=1 is blue
;col=13 rainbow

anime_fac=3.0

factor=1.0
;factor is brightness factor
;irot = 6
irot=7
;irot 7 or 2?? is correct, maybe.

;exman : exposure time manual setting=1
exman=0
expos1=60.0

;mpeg file overwrite? yes-1 no-0
ioverw=01

;---plot image size factor(nominal:7.5, one image large plot:30)
fac=7.5
;fac=30.0
if fac lt 30 then begin
  fact=1.0
  factc=''
  psl='_kR_m'
endif else begin
  fact=1.8
  factc=''
  psl='l_kR_m'
endelse

igrey=0
;if igrey=1 then plot in grey scale
;col=0 is grey
;col=3 is red
;col=1 is blue
;col=13 is rainbow

;log plot ilog=1
ilog=1

;iut=1, then plot UT
iut=1
;iti=1, then plot TI
iti=0

;irot = 5
irot=4
;irot=2


debug=0
cadd=''
;=====parameter end=====

close,/all

for jj=0, ymnum-1 do begin

psdir=fdir1+'MAC_ps\'+ymdir(jj)

print, fdir1,psdir

fdir=fdir1+ymdir(jj)

filesel=''
;mpgdir=strmid(fdir,0,15)+'mpeg\'+strmid(fdir,15,16)
;print, jj,fdir,mpgdir
;
print, '---data process start---'
;
find_L1data_combination,fdir+filesel,fna1,fna2,fna3,fnanum1,fnum1_1,fnum2_1,fnum3_1,fnum2o_1,fnum3o_1,mode1_1,mode2_1,mode3_1,numo_2,fnum2_2,fnum3_2,mode2_2,mode3_2,numo_3,fnum3_3,mode3_3


;  number of data: 0 to fnanum1-1
;  file combination: fnum1_1(i),fnum2_1(i),fnum3_1(i)
;      available only when fnum2o_1=1 and/or fnum3o_1=1
;  mode: mode1_1(i),mode2_1(i),mode3_1(i)
;      available only when mode1_1(i), mode2_1(i),mode3_1(i)>=0
;---ch2-3,and 2
;  number of data: 0 to numo_2-1
;  file combination: fnum2_2(i),fnum3_2(i)
;      available only when fnum2o_1=2 and/or fnum3o_1=2
;  mode: mode2_2(i),mode3_2(i)
;      available only when mode2_2(i), mode3_2(i)>=0
;---ch3
;  number of data: 0 to numo_3-1
;  file combination: fnum3_3(i)
;      available only when fnum3o_1=3
;  mode: mode3_3(i)
;      available only when mode3_3(i)>=0

if debug eq 1 then print,fna1,fna2,fna3
print, fna1,fna2,fna3

if ista eq 1 and istatype eq 1 then begin

  stafind,fdir,stanum,stadir,stafile
;  stafindn,fdir,stanum,stadir,stafile

  if debug eq 1 then print, stanum
  print, stafile
  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
    mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
    mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
    esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
    esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
    esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
    rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for i=0, n_elements(expor)-2 do begin
    if expor(i) eq 0 and expor(i+1) ne 0 then expor(i)=expor(i+1)
    if expor(i) ne 0 and expor(i+1) eq 0 then expor(i+1)=expor(i)
  endfor

endif

if debug eq 1 then goto, debug_end


print, ' === for channels 1-2-3, 1-2, 1-3, and 1 ==='
for i=0,fnanum1-1 do begin
  simul=0
  chn=''
  if fnum1_1(i) ge 0 then begin
    simul=simul+1 & chn=chn+'1' & print, i,fna1(fnum1_1(i))
  endif
  if fnum2_1(i) ge 0 then begin
    simul=simul+1 & chn=chn+'2' & print, fna2(fnum2_1(i))
  endif
  if fnum3_1(i) ge 0 then begin
    simul=simul+1 & chn=chn+'3' & print, fna3(fnum3_1(i))
  endif
  print, simul,'==============================='

  psname=psdir+'MAC'+strmid(fna1(fnum1_1(i)),strlen(fdir)+11,14)+strmid(fna1(fnum1_1(i)),strlen(fdir)+8,3)+'CH'+chn

  print, psname,i
  mpnum1=strlen((findfile(psname+'*L1*.ps')))
  if max(mpnum1) ge 1 and ioverw eq 0 then begin
    print,'this mpeg files already exist, num=',mpnum1
    goto, nextfile1
  endif

;  print, mpname

;filename =fna1(fnum1_1(i)) & fna2(fnum2_1(i)) & fna3(fnum3_1(i))

  imode=mode1_1(i)
  imode2=mode2_1(i)
  imode3=mode3_1(i)
  print, 'mode ',imode,imode2,imode3

  if imode eq 0 or imode eq 1 then begin
    ibin=16
    res=64
    anime_fac=3.0
    if imode eq 0 then begin
      nstep=nstep0
    endif else begin
      nstep=nstep1
    endelse
  endif else if imode eq 2 then begin
    ibin=2
    res=512
    anime_fac=1.0
    nstep=nstep2
  endif else begin
    ibin=8
    res=128
    anime_fac=2.0
    nstep=nstep3
  endelse

;stop

  fna=fna1(fnum1_1(i))
  read_L1data,fna,imode,res,ymd1,time1,ti1,temp1,imagetotal_1o,fnum1
  if fnum2_1(i) ge 0 then begin
    fna=fna2(fnum2_1(i))
    read_L1data,fna,imode,res,ymd2,time2,ti2,temp2,imagetotal_2o,fnum2
  endif else begin
    time2=0
    ti2=0
    ymd2=0
    temp2=0
    imagetotal_2o=0
    fnum2=fnum1
  endelse
  if fnum3_1(i) ge 0 then begin
    fna=fna3(fnum3_1(i))
    read_L1data,fna,imode,res,ymd3,time3,ti3,temp3,imagetotal_3o,fnum3
  endif else begin
    time3=0
    ti3=0
    ymd3=0
    temp3=0
    imagetotal_3o=0
    fnum3=fnum1
  endelse

;  imagesort,imode,time1,time2,time3,ti1,ti2,ti3,imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3,time,ti,ich,imagetotal_o,fnum


;reading status parameters from L1 status file --------------
staexis=0
if ista eq 1 and istatype eq 0 then begin
  stafind_1day,fna,stanum,stadir,stafile

  if max(strlen(stafile)) gt 0 then begin

  if debug eq 1 then print, stanum
  print, stafile
  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
    mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
    mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
    esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
    esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
    esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
    rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for ii=0, n_elements(expor)-2 do begin
    if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
    if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
  endfor
  cadd=''
  staexis=1

  endif else begin
    expor=41.0
    cadd='_no_stafile'
    staexis=0
  endelse

  psname=psname+cadd
endif


if ista eq 1 and max(strlen(stafile)) gt 0 then begin
  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss,yyr,mor,ddr,hhr,mmr,ssr,expor,ymd1,time1,tsec_obs1,$
    yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1
  expos=fltarr(fnum1)
  if max(expo_obs1) eq 0 then begin
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs1(*)
    cexp=''
  endelse
endif else begin
  expos=fltarr(fnum1)
  expos(*)=60.0
  cexp=' assumed'

endelse


if exman eq 1 then begin
  expos=fltarr(fnum1)
  expos(*)=expos1
endif

   if rayleigh eq 1 then begin
    if max(imagetotal_1o) gt 0 then begin
     exposure_1=fltarr(fnum1)
     exposure_1(*)=expos
     count_to_rayleigh,imagetotal_1o,radcorrect,radimagefile,imode,1,res,exposure_1,fnum1,imagetotal_linear_1,imagetotal_log10_1
     imagetotal_1=fltarr(res,res,fnum1)
     if ilog eq 1 then begin
       imagetotal_1=imagetotal_log10_1
     endif else begin
       imagetotal_1=imagetotal_linear_1
     endelse
    endif else begin
      imagetotal_1=0
    endelse
    if max(imagetotal_2o) gt 0 then begin
     exposure_2=fltarr(fnum2)
     if n_elements(exposure_2) ne n_elements(expos) then begin
       if fnum2 gt fnum1 then begin
         exposure_2(0:fnum1-1)=expos(*)
         exposure_2(fnum1:fnum2-1)=expos(fnum1-1)
       endif else begin
         exposure_2(*)=expos(0:fnum2-1)
       endelse
      endif else begin
       exposure_2(*)=expos
     endelse
     count_to_rayleigh,imagetotal_2o,radcorrect,radimagefile,imode,2,res,exposure_2,fnum2,imagetotal_linear_2,imagetotal_log10_2
     imagetotal_2=fltarr(res,res,fnum2)
     if ilog eq 1 then begin
       imagetotal_2=imagetotal_log10_2
     endif else begin
       imagetotal_2=imagetotal_linear_2
     endelse
    endif else begin
      imagetotal_2=0
    endelse
    if max(imagetotal_3o) gt 0 then begin
     exposure_3=fltarr(fnum3)
     if n_elements(exposure_3) ne n_elements(expos) then begin
       if fnum3 gt fnum1 then begin
         exposure_3(0:fnum1-1)=expos(*)
         exposure_3(fnum1:fnum3-1)=expos(fnum1-1)
       endif else begin
         exposure_3(*)=expos(0:fnum3-1)
       endelse

     endif else begin
        exposure_3(*)=expos
     endelse
     count_to_rayleigh,imagetotal_3o,radcorrect,radimagefile,imode,3,res,exposure_3,fnum3,imagetotal_linear_3,imagetotal_log10_3
     imagetotal_3=fltarr(res,res,fnum3)
     if ilog eq 1 then begin
       imagetotal_3=imagetotal_log10_3
     endif else begin
       imagetotal_3=imagetotal_linear_3
     endelse
    endif else begin
      imagetotal_3=0
    endelse
   endif else begin
     imagetotal_1=fltarr(res,res,fnum1)
     imagetotal_2=fltarr(res,res,fnum2)
     imagetotal_3=fltarr(res,res,fnum3)
     imagetotal_1=imagetotal_1o
     imagetotal_2=imagetotal_2o
     imagetotal_3=imagetotal_3o
   endelse
   if simple_radcorrect eq 1 then begin
     radimage=fltarr(3,res,res)
     openr,2,radimagefile
     readf,2,radimage
     close,2
     imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
     imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
     imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
     imagetotal_1(where(imagetotal_1 lt 0)) =0
     imagetotal_2(where(imagetotal_2 lt 0)) =0
     imagetotal_3(where(imagetotal_3 lt 0)) =0
   endif

if footp eq 1 and staexis eq 1 and max(imagetotal_1) gt 0 then begin

  symd1=ymd1(0)
  eymd1=ymd1(n_elements(ymd1)-1)
  stime1=tsec_obs1(0)
  etime1=tsec_obs1(n_elements(tsec_obs1)-1)

if res ne 512 then begin
;  sub_fov_read_land,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
  sub_fov_read,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endif else begin
;  sub_fov_read_land,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
  sub_fov_read,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endelse


  if fovnum eq 0 then goto, nextfoop

  kn=n_elements(tsec_obs1)

  ;ch=0
  ;fov_pixel_dir,res,ch,fovx,fovy,fovz
  ;find_footp_dir,fovnum,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx1,footpixy1
  ;ch=1
  ;fov_pixel_dir,res,ch,fovx,fovy,fovz
  ;find_footp_dir,fovnum,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx2,footpixy2
  ;ch=2
  ;fov_pixel_dir,res,ch,fovx,fovy,fovz
  ;find_footp_dir,fovnum,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx3,footpixy3

  ch=0
  fov_pixel_dir_n,teta,phi,res,ch,fovx,fovy,fovz
  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx1,footpixy1
print, (fovy(0,0)-fovy(res-1,0))*360/2/3.14
if   (fovy(0,0)-fovy(res-1,0))*360/2/3.14 lt 7 then begin
  print,'abnormal end, maybe you should reboot idl'
  stop
endif
  ch=1
  fov_pixel_dir_n,teta,phi,res,ch,fovx,fovy,fovz
  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx2,footpixy2
print, (fovy(0,0)-fovy(res-1,0))*360/2/3.14
if   (fovy(0,0)-fovy(res-1,0))*360/2/3.14 lt 7 then begin
  print,'abnormal end, maybe you should reboot idl'
  stop
endif
  ch=2
  fov_pixel_dir_n,teta,phi,res,ch,fovx,fovy,fovz
  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx3,footpixy3
print, (fovy(0,0)-fovy(res-1,0))*360/2/3.14
if   (fovy(0,0)-fovy(res-1,0))*360/2/3.14 lt 7 then begin
  print,'abnormal end, maybe you should reboot idl'
  stop
endif

  footpixx1n=intarr(kn)
  footpixy1n=intarr(kn)
  footpixx2n=intarr(kn)
  footpixy2n=intarr(kn)
  footpixx3n=intarr(kn)
  footpixy3n=intarr(kn)

  footpixx1n=fix(interpol(footpixx1,timfov,tsec_obs1))
  footpixy1n=fix(interpol(footpixy1,timfov,tsec_obs1))
  footpixx2n=fix(interpol(footpixx2,timfov,tsec_obs1))
  footpixy2n=fix(interpol(footpixy2,timfov,tsec_obs1))
  footpixx3n=fix(interpol(footpixx3,timfov,tsec_obs1))
  footpixy3n=fix(interpol(footpixy3,timfov,tsec_obs1))



 if max(footpixx1n) gt 0 or max(footpixx2n) gt 0 or max(footpixx3n) gt 0 and icrosssec eq 1 then begin
  openw,2,psdir+'MAC'+strmid(fna1(fnum1_1(i)),strlen(fdir)+11,15)+strmid(fna1(fnum1_1(i)),strlen(fdir)+8,3)+'CH'+chn+'_'+cadd+'_ModeS_L1_ps.txt'
  for km=0,kn-1 do begin
    num1=km
    num2=min(where(time2 eq time1(num1)))
    num3=min(where(time3 eq time1(num1)))
    xpix=footpixx1n(km)
    ypix=footpixy1n(km)

    if footpixx1n(km) ge 0 and footpixy1n(km) ge 0 and $
      footpixx1n(km) lt res and footpixy1n(km) lt res then begin
      if max(num2) lt 0 or footpixx2n(km) lt 0 or footpixy2n(km) lt 0 or $
        footpixx2n(km) ge res or footpixy2n(km) ge res then begin
        image2=-9.999
      endif else begin
        image2= 10^(imagetotal_2(footpixx2n(km),footpixy2n(km),num2))
      endelse
      if max(num3) lt 0 or footpixx3n(km) lt 0 or footpixy3n(km) lt 0 or $
        footpixx3n(km) ge res or footpixy3n(km) ge res then begin
        image3=-9.999
      endif else begin
        image3= 10^(imagetotal_3(footpixx3n(km),footpixy3n(km),num3))
      endelse
        printf,2,format='(f10.3,i4,f10.6,3f15.10)',tsec_obs1(km),fix(tsec_obs1(km)/3600.0) ,$
           (tsec_obs1(km)-fix(tsec_obs1(km)/3600.0)*3600.0)/60.0,$
           10^(imagetotal_1(xpix,ypix,km)),image2,image3

    endif
;    if footpixx2n(km) ge 0 and footpixy2n(km) ge 0 then begin
;      print, tsec_obs1(km),imagetotal_2(footpixx2n(km),footpixy2n(km),num2)
;    endif
;    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 then begin
;      print, tsec_obs1(km),imagetotal_3(footpixx3n(km),footpixy3n(km),num3)
;    endif
  endfor
  close,2

  endif


  kmflg=0
  for km=0,kn-1 do begin
    if footpixx1n(km) ge 0 and footpixy1n(km) ge 0 then begin
      if kmflg eq 0 then begin
        kmflg=1
        psname=psname+'_ModeS'
      endif
      circle_mark,res,kn,imagetotal_1(*,*,km),footpixx1n(km),footpixy1n(km),imagetotal,2.0,0.0
      imagetotal_1(*,*,km)=imagetotal(*,*)
    endif
    num1=km
    num2=min(where(time2 eq time1(num1)))
    num3=min(where(time3 eq time1(num1)))
;  print, num1,num2,num3
    if footpixx2n(km) ge 0 and footpixy2n(km) ge 0 and max(num2) ge 0 then begin
      circle_mark,res,kn,imagetotal_2(*,*,num2),footpixx2n(km),footpixy2n(km),imagetotal,5.0,0.0
      imagetotal_2(*,*,num2)=imagetotal(*,*)
    endif
    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 and max(num3) ge 0 then begin
      circle_mark,res,kn,imagetotal_3(*,*,num3),footpixx3n(km),footpixy3n(km),imagetotal,5.0,0.0
      imagetotal_3(*,*,num3)=imagetotal(*,*)
    endif
  endfor

  nextfoop:

  endif

;   mpname1=mpgdir+'MAC'+strmid(fna1(fnum1_1(i)),strlen(fdir)+11,15)+strmid(fna1(fnum1_1(i)),strlen(fdir)+8,3)+'_CH'+chn+'_L1'+cadd+'.mpg'
    if max(imagetotal_1) eq 0 and max(imagetotal_2) eq 0 and max(imagetotal_3) eq 0 then begin
      goto, nextfile1
    endif else begin
      psname=psname+'_L1_'
      MAC_PS_create_L1,nstep,simul,imode,irot,fnum1,iut,iti,select_frame,pnums,pnume,igrey,fact,fac,ilog,res,smax,smin,fna,psname,exposure_1,cexp,time1,time2,time3,ti1,ti2,ti3,ymd1,ymd2,ymd3,imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3
    endelse

   nextfile1:
endfor

channel2:
print, ' === for channels 2-3 and 2 ==='
for i=0,numo_2-1 do begin
  simul=0
  chn=''
  if fnum2_2(i) ge 0 then begin
    simul=simul+1 & chn=chn+'2' & print, i,fna2(fnum2_2(i))
  endif
  if fnum3_2(i) ge 0 then begin
    simul=simul+1 & chn=chn+'3' & print, fna3(fnum3_2(i))
  endif
  print, simul

  psname=psdir+'MAC'+strmid(fna2(fnum2_2(i)),strlen(fdir)+11,14)+strmid(fna2(fnum2_2(i)),strlen(fdir)+8,3)+'_CH'+chn
  print, psname

  mpnum1=strlen((findfile(psname+'*L1*.ps')))
  if max(mpnum1) ge 1 and ioverw eq 0 then begin
    print,'this PS files already exist, num=',mpnum1
    goto, nextfile2
  endif

  imode=mode2_2(i)
  imode2=mode3_2(i)
  print, 'mode ',imode,imode2

  if imode eq 0 or imode eq 1 then begin
    ibin=16
    res=64
    anime_fac=3.0
    if imode eq 0 then begin
      nstep=nstep0
    endif else begin
      nstep=nstep1
    endelse
  endif else if imode eq 2 then begin
    ibin=2
    res=512
    anime_fac=1.0
    nstep=nstep2
  endif else begin
    ibin=8
    res=128
    anime_fac=2.0
    nstep=nstep3
  endelse

  fna=fna2(fnum2_2(i))
  read_L1data,fna,imode,res,ymd2,time2,ti2,temp2,imagetotal_2o,fnum2
  if fnum3_2(i) ge 0 then begin
    fna=fna3(fnum3_2(i))
    read_L1data,fna,imode,res,ymd3,time3,ti3,temp3,imagetotal_3o,fnum3
  endif else begin
    time3=0
    ti3=0
    ymd3=0
    temp3=0
    imagetotal_3o=0
    fnum3=fnum2
  endelse
  imagetotal_1o=0
  time1=0
  ti1=0
  ymd1=0
  temp1=0
  fnum1=fnum2

staexis=0
if ista eq 1 and istatype eq 0 then begin

  stafind_1day,fna,stanum,stadir,stafile

  if max(strlen(stafile)) gt 0 then begin

  if debug eq 1 then print, stanum
  print, stafile
  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
    mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
    mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
    esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
    esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
    esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
    rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for ii=0, n_elements(expor)-2 do begin
    if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
    if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
  endfor
  cadd=''
  staexis=1

  endif else begin
    expor=41.0
    cadd='_no_stafile'
    staexis=0
  endelse

  psname=psname+cadd


endif


if ista eq 1 and max(strlen(stafile)) gt 0 then begin
  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss,yyr,mor,ddr,hhr,mmr,ssr,expor,ymd2,time2,tsec_obs2,$
    yy_obs2,mo_obs2,dd_obs2,hh_obs2,mm_obs2,ss_obs2,expo_obs2
  expos=fltarr(fnum2)
  if max(expo_obs2) eq 0 then begin
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs2(*)
    cexp=''
  endelse
endif else begin
  expos=fltarr(fnum2)
  expos(*)=60.0
  cexp=' assumed'
endelse

if exman eq 1 then begin
  expos=fltarr(fnum2)
  expos(*)=expos1
endif


   if rayleigh eq 1 then begin
       exposure_2=fltarr(fnum2)
       exposure_2(*)=expos(*)
       count_to_rayleigh,imagetotal_2o,radcorrect,radimagefile,imode,2,res,exposure_2,fnum2,imagetotal_linear_2,imagetotal_log10_2
       imagetotal_2=fltarr(res,res,fnum2)
       if ilog eq 1 then begin
         imagetotal_2=imagetotal_log10_2
       endif else begin
         imagetotal_2=imagetotal_linear_2
       endelse
     if max(imagetotal_3o) gt 0 then begin
       exposure_3=fltarr(fnum3)
       if fnum2 eq fnum3 then begin
         exposure_3(0:fnum2-1)=expos(*)
         if fnum3 gt fnum2 then exposure_3(fnum2:fnum3-1)=expos(fnum2-1)
       endif else begin
         if fnum3 gt fnum2 then begin
           exposure_3(0:fnum2-1)=expos(*)
           exposure_3(fnum2:fnum3-1)=expos(fnum2-1)
         endif else begin
           exposure_3(*)=expos(0:fnum2-1)
         endelse
       endelse
       count_to_rayleigh,imagetotal_3o,radcorrect,radimagefile,imode,3,res,exposure_3,fnum3,imagetotal_linear_3,imagetotal_log10_3
       imagetotal_3=fltarr(res,res,fnum3)
       if ilog eq 1 then begin
         imagetotal_3=imagetotal_log10_3
       endif else begin
         imagetotal_3=imagetotal_linear_3
       endelse
     endif else begin
       imagetotal_3=fltarr(res,res,fnum2)
       imagetotal_3=0
     endelse
     imagetotal_1=fltarr(res,res,fnum2)
     imagetotal_1=0
   endif else begin
     imagetotal_1=fltarr(res,res,fnum2)
     imagetotal_2=fltarr(res,res,fnum2)
     if max(imagetotal_3o) gt 0 then begin
       imagetotal_3=fltarr(res,res,fnum3)
       imagetotal_3=imagetotal_3o
     endif else begin
       imagetotal_3=fltarr(res,res,fnum2)
       imagetotal_3=0
     endelse
     imagetotal_2=imagetotal_2o
     imagetotal_1=0
   endelse


   if simple_radcorrect eq 1 then begin
     radimage=fltarr(3,res,res)
     openr,2,radimagefile
     readf,2,radimage
     close,2
     imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
     imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
     imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
     imagetotal_1(where(imagetotal_1 lt 0)) =0
     imagetotal_2(where(imagetotal_2 lt 0)) =0
     imagetotal_3(where(imagetotal_3 lt 0)) =0
   endif


if footp eq 1 and staexis eq 1 then begin
;if footp eq 1 then begin

  symd2=ymd2(0)
  eymd2=ymd2(n_elements(ymd2)-1)
  stime2=tsec_obs2(0)
  etime2=tsec_obs2(n_elements(tsec_obs2)-1)

if res ne 512 then begin
  sub_fov_read,fovdir,symd2,stime2,eymd2,etime2,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endif else begin
  sub_fov_read,fovdir,symd2,stime2,eymd2,etime2,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endelse

  if fovnum eq 0 then goto, nextfootp2

  kn=n_elements(tsec_obs2)

  ch=1
  fov_pixel_dir_n,teta,phi,res,ch,fovx,fovy,fovz
  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx2,footpixy2
  ch=2
  fov_pixel_dir_n,teta,phi,res,ch,fovx,fovy,fovz
  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx3,footpixy3

  footpixx2n=intarr(kn)
  footpixy2n=intarr(kn)
  footpixx3n=intarr(kn)
  footpixy3n=intarr(kn)

  footpixx2n=interpol(footpixx2,timfov,tsec_obs2)
  footpixy2n=interpol(footpixy2,timfov,tsec_obs2)
  footpixx3n=interpol(footpixx3,timfov,tsec_obs2)
  footpixy3n=interpol(footpixy3,timfov,tsec_obs2)


 if max(footpixx2n) gt 0 or max(footpixx3n) gt 0 and icrosssec eq 1 then begin
  openw,2,psdir+'MAC'+strmid(fna2(fnum2_2(i)),strlen(fdir)+11,15)+strmid(fna2(fnum2_2(i)),strlen(fdir)+8,3)+'CH'+chn+'_'+cadd+'_ModeS_L1_ps.txt'

  for km=0,kn-1 do begin

    num2=km
    num3=min(where(time3 eq time2(num2)))
    xpix=footpixx2n(km)
    ypix=footpixy2n(km)

    if footpixx2n(km) ge 0 and footpixy2n(km) ge 0 and $
          footpixx2n(km) lt res and footpixy2n(km) lt res then begin

      if max(num3) lt 0 or footpixx3n(km) lt 0 or footpixy3n(km) lt 0 or $
      footpixx3n(km) ge res or footpixy3n(km) ge res then begin
        image3=-9.999
      endif else begin
        image3= 10^(imagetotal_3(footpixx3n(km),footpixy3n(km),num3))
      endelse

      printf,2,format='(f10.3,i4,f10.6,3f15.10)',tsec_obs2(km),fix(tsec_obs2(km)/3600.0) ,$
         (tsec_obs2(km)-fix(tsec_obs2(km)/3600.0)*3600.0)/60.0, -1.0,$
           10^(imagetotal_2(xpix,ypix,km)),image3

    endif
;    if footpixx2n(km) ge 0 and footpixy2n(km) ge 0 then begin
;      print, tsec_obs1(km),imagetotal_2(footpixx2n(km),footpixy2n(km),num2)
;    endif
;    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 then begin
;      print, tsec_obs1(km),imagetotal_3(footpixx3n(km),footpixy3n(km),num3)
;    endif
  endfor
  close,2

  endif



  kmflg=0
  for km=0,kn-1 do begin
    if footpixx2n(km) ge 0 and footpixy2n(km) ge 0 then begin
      if kmflg eq 0 then begin
        kmflg=1
        psname=psname+'_ModeS'
      endif
      circle_mark,res,kn,imagetotal_2(*,*,km),footpixx2n(km),footpixy2n(km),imagetotal,2.0,0.0
      imagetotal_2(*,*,km)=imagetotal(*,*)
    endif
    num2=km
    num3=min(where(time3 eq time2(num2)))
;  print, num1,num2,num3
    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 then begin
      circle_mark,res,kn,imagetotal_3(*,*,num3),footpixx3n(km),footpixy3n(km),imagetotal,5.0,0.0
      imagetotal_3(*,*,num3)=imagetotal(*,*)
    endif
  endfor

  nextfootp2:

  endif


;   mpname1=mpgdir+'MAC'+strmid(fna2(fnum2_2(i)),strlen(fdir)+11,15)+strmid(fna2(fnum2_2(i)),strlen(fdir)+8,3)+'_CH'+chn+'_L1'+cadd+'.mpg'

    if max(imagetotal_1) eq 0 and max(imagetotal_2) eq 0 and max(imagetotal_3) eq 0 then begin
      goto, nextfile2
    endif else begin
      psname=psname+'_L1_'
      MAC_PS_create_L1,nstep,simul,imode,irot,fnum2,iut,iti,select_frame,pnums,pnume,igrey,fact,fac,ilog,res,smax,smin,fna,psname,exposure_2,cexp,time1,time2,time3,ti1,ti2,ti3,ymd1,ymd2,ymd3,imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3
    endelse

   nextfile2:
endfor

;---ch3
;  number of data: 0 to numo_3-1
;  file combination: fnum3_3(i)
;      available only when fnum3o_1=3
;  mode: mode3_3(i)
;      available only when mode3_3(i)>=0

channel3:

print, ' === for channels 3 ==='
for i=0,numo_3-1 do begin
  simul=0
  chn=''
  if fnum3_3(i) ge 0 then begin
    simul=simul+1 & chn=chn+'3'& print, i,fnum3_3(i),fna3(fnum3_3(i))
  endif
  print, simul

;  mpname='MAC_'+'CH'+strmid(fna3(i),strlen(fdir)+7,16)+'_L1.mpg'
;  mpname=mpgdir+'MAC'+strmid(fna3(fnum3_3(i)),strlen(fdir)+11,15)+strmid(fna3(fnum3_3(i)),strlen(fdir)+8,3)+'_CH'+chn+'_L1.mpg'
  psname=psdir+'MAC'+strmid(fna3(fnum3_3(i)),strlen(fdir)+11,14)+strmid(fna3(fnum3_3(i)),strlen(fdir)+8,3)+'_CH'+chn

  mpnum1=strlen((findfile(psname+'*L1*.ps')))
  if max(mpnum1) ge 1 and ioverw eq 0 then begin
    print,'this PS files already exist, num=',mpnum1
    goto, nextfile3
  endif

;filename =fna3(fnum3_3(i))
;  read_L1data


  imode=mode3_3(i)

  print, 'mode ',imode

  if imode eq 0 or imode eq 1 then begin
    ibin=16
    res=64
    anime_fac=3.0
    if imode eq 0 then begin
      nstep=nstep0
    endif else begin
      nstep=nstep1
    endelse
  endif else if imode eq 2 then begin
    ibin=2
    res=512
    anime_fac=1.0
    nstep=nstep2
  endif else begin
    ibin=8
    res=128
    anime_fac=2.0
    nstep=nstep3
  endelse

   fna=fna3(fnum3_3(i))
   read_L1data,fna,imode,res,ymd3,time3,ti3,temp3,imagetotal_3o,fnum3

   imagetotal_1o=0
   time1=0
   ti1=0
   ymd1=0
   temp1=0
   fnum1=fnum3
   imagetotal_2o=0
   time2=0
   ti2=0
   ymd2=0
   temp2=0
   fnum2=fnum3

staexis=0

if ista eq 1 and istatype eq 0 then begin

  stafind_1day,fna,stanum,stadir,stafile
  if max(strlen(stafile)) gt 0 then begin

  if debug eq 1 then print, stanum
  print, stafile
  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
    mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
    mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
    esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
    esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
    esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
    rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for ii=0, n_elements(expor)-2 do begin
    if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
    if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
  endfor
  cadd=''
  staexis=1

  endif else begin
    expor=41.0
    cadd='_no_stafile'
    staexis=0
  endelse

  psname=psname+cadd

endif


if ista eq 1 and max(strlen(stafile)) gt 0 then begin
  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss,yyr,mor,ddr,hhr,mmr,ssr,expor,ymd3,time3,tsec_obs3,$
    yy_obs3,mo_obs3,dd_obs3,hh_obs3,mm_obs3,ss_obs3,expo_obs3
  expos=fltarr(fnum3)
  if max(expo_obs3) eq 0 then begin
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs3(*)
    cexp=''
  endelse
endif else begin
  expos=fltarr(fnum3)
  expos(*)=60.0
  cexp=' assumed'

endelse

if exman eq 1 then begin
  expos=fltarr(fnum2)
  expos(*)=expos1
endif

   if rayleigh eq 1 then begin
     exposure_3=fltarr(fnum3)
     exposure_3(*)=expos(*)
     count_to_rayleigh,imagetotal_3o,radcorrect,radimagefile,imode,3,res,exposure_3,fnum3,imagetotal_linear_3,imagetotal_log10_3
     imagetotal_3=fltarr(res,res,fnum3)
     if ilog eq 1 then begin
       imagetotal_3=imagetotal_log10_3
     endif else begin
       imagetotal_3=imagetotal_linear_3
     endelse
     imagetotal_1=fltarr(res,res,fnum3)
     imagetotal_1=0
     imagetotal_2=fltarr(res,res,fnum3)
     imagetotal_2=0
   endif else begin
     imagetotal_1=fltarr(res,res,fnum2)
     imagetotal_2=fltarr(res,res,fnum2)
     imagetotal_3=fltarr(res,res,fnum3)
     imagetotal_3=imagetotal_3o
     imagetotal_1=0
     imagetotal_2=0
   endelse

   if simple_radcorrect eq 1 then begin
     radimage=fltarr(3,res,res)
     openr,2,radimagefile
     readf,2,radimage
     close,2
     imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
     imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
     imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
     imagetotal_1(where(imagetotal_1 lt 0)) =0
     imagetotal_2(where(imagetotal_2 lt 0)) =0
     imagetotal_3(where(imagetotal_3 lt 0)) =0
   endif

if footp eq 1 and staexis eq 1 then begin

  symd3=ymd3(0)
  eymd3=ymd3(n_elements(ymd3)-1)
  stime3=tsec_obs3(0)
  etime3=tsec_obs3(n_elements(tsec_obs3)-1)

if res ne 512 then begin
  sub_fov_read,fovdir,symd3,stime3,eymd3,etime3,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endif else begin
  sub_fov_read,fovdir,symd3,stime3,eymd3,etime3,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endelse

  if fovnum eq 0 then goto, nextfootp3

  kn=n_elements(tsec_obs3)

  ch=2
  fov_pixel_dir_n,teta,phi,res,ch,fovx,fovy,fovz
  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx3,footpixy3

  footpixx3n=intarr(kn)
  footpixy3n=intarr(kn)

  footpixx3n=interpol(footpixx3,timfov,tsec_obs3)
  footpixy3n=interpol(footpixy3,timfov,tsec_obs3)


 if max(footpixx3n) gt 0 and icrosssec eq 1 then begin
  openw,2,psdir+'MAC'+strmid(fna3(fnum3_3(i)),strlen(fdir)+11,15)+strmid(fna3(fnum3_3(i)),strlen(fdir)+8,3)+'CH'+chn+'_'+cadd+'_ModeS_L1_ps.txt'

  for km=0,kn-1 do begin
    num3=km
    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 and footpixx3n(km) lt res and footpixy3n(km) lt res then begin
      xpix=footpixx3n(km)
      ypix=footpixy3n(km)

        printf,2,format='(f10.3,i4,f10.6,3f15.10)',tsec_obs3(km),fix(tsec_obs3(km)/3600.0) ,$
           (tsec_obs3(km)-fix(tsec_obs3(km)/3600.0)*3600.0)/60.0,$
           -9.999,$
           -9.999,$
           10^(imagetotal_3(xpix,ypix,km))
    endif
;    if footpixx2n(km) ge 0 and footpixy2n(km) ge 0 then begin
;      print, tsec_obs1(km),imagetotal_2(footpixx2n(km),footpixy2n(km),num2)
;    endif
;    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 then begin
;      print, tsec_obs1(km),imagetotal_3(footpixx3n(km),footpixy3n(km),num3)
;    endif
  endfor
  close,2

endif


  kmflg=0
  for km=0,kn-1 do begin
    if footpixx3n(km) ge 0 and footpixy3n(km) ge 0 then begin
      if kmflg eq 0 then begin
        kmflg=1
        psname=psname+'_ModeS'
      endif
      circle_mark,res,kn,imagetotal_3(*,*,km),footpixx3n(km),footpixy3n(km),imagetotal,5.0,0.0
      imagetotal_3(*,*,km)=imagetotal(*,*)
     endif
  endfor

  nextfootp3:

  endif

    if max(imagetotal_1) eq 0 and max(imagetotal_2) eq 0 and max(imagetotal_3) eq 0 then begin
      goto, nextfile3
    endif else begin
      psname=psname+'_L1_'
      MAC_PS_create_L1,nstep,simul,imode,irot,fnum3,iut,iti,select_frame,pnums,pnume,igrey,fact,fac,ilog,res,smax,smin,fna,psname,exposure_3,cexp,time1,time2,time3,ti1,ti2,ti3,ymd1,ymd2,ymd3,imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3
    endelse

   nextfile3:
endfor

debug_end:
endfor

print, 'Normal End! '
END
