;******************************************************************
;    program MACimage_DARTS_L1_animation_color_auto.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Jan 16, 2006
;******************************************************************

PRO MACimage_DARTS_L1_cal_darkframe

;mode for calculation
imode=0
;durtion of frames for each file
dur=50


if imode eq 1 then begin
  med_coef=8
  smo_coef=4
endif else begin
  med_coef=4
  smo_coef=4
endelse

;output data? yes-1
dataout=0

refnum0=16
refnum1=3

iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin=fltarr(4,3)
smax=fltarr(4,3)
;for mode0
;smin(0,0) = 10 & smax(0,0) = 35
;smin(0,1) = 10 & smax(0,1) = 35
;smin(0,2) = 10 & smax(0,2) = 35
smin(0,0) = 70 & smax(0,0) = 130
smin(0,1) = 70 & smax(0,1) = 130
smin(0,2) =-10 & smax(0,2) = 10
;smin(0,2) = 0.8 & smax(0,2) = 1.2
;for mode1
smin(1,0) = 70 & smax(1,0) = 170
smin(1,1) = 70 & smax(1,1) = 170
smin(1,2) = -10 & smax(1,2) = 10
;for mode2
smin(2,0) = 40 & smax(2,0) = 50
smin(2,1) = 10 & smax(2,1) = 100
smin(2,2) = 40 & smax(2,2) = 250
;for mode3
smin(3,0) = 5 & smax(3,0) = 15
smin(3,1) = 5 & smax(3,1) = 50
smin(3,2) = 5 & smax(3,2) = 40

;smax and smin in kR for ch1,2,3

fdir1= 'E:\Usr\tsakanoi\Index\DARTS\Level-1\'
fdirps1= 'C:\Usr\tsakanoi\Index\DARTS\Level-1\'

fname1=strarr(100,3,2)
stime=lonarr(100,2)
etime=lonarr(100,2)
;for mode0=========================================================
;2005 10------------------------------------------------------
fname1(0,0,0)=fdir1+'2005\10\RE_MAC1_M0_20051004034653.L1'
fname1(0,1,0)=fdir1+'2005\10\RE_MAC2_M0_20051004034653.L1'
fname1(0,2,0)=fdir1+'2005\10\RE_MAC3_M0_20051004034728.L1'
stime(0,0)=0
etime(0,0)=0
;
fname1(1,0,0)=fdir1+'2005\10\RE_MAC1_M0_20051004070107.L1'
fname1(1,1,0)=fdir1+'2005\10\RE_MAC2_M0_20051004070107.L1'
fname1(1,2,0)=fdir1+'2005\10\RE_MAC3_M0_20051004070208.L1'
stime(1,0)=0
etime(1,0)=0
;
fname1(2,0,0)=fdir1+'2005\10\RE_MAC1_M0_20051005022824.L1'
fname1(2,1,0)=fdir1+'2005\10\RE_MAC2_M0_20051005022824.L1'
fname1(2,2,0)=fdir1+'2005\10\RE_MAC3_M0_20051005022924.L1'
stime(2,0)=0
etime(2,0)=0
;2005 11------------------------------------------------------
fname1(3,0,0)=fdir1+'2005\11\RE_MAC1_M0_20051102081103.L1'
fname1(3,1,0)=fdir1+'2005\11\RE_MAC2_M0_20051102081103.L1'
fname1(3,2,0)=fdir1+'2005\11\RE_MAC3_M0_20051102081103.L1'
stime(3,0)=0
etime(3,0)=081133
;
fname1(4,0,0)=fdir1+'2005\11\RE_MAC1_M0_20051102125955.L1'
fname1(4,1,0)=fdir1+'2005\11\RE_MAC2_M0_20051102125955.L1'
fname1(4,2,0)=fdir1+'2005\11\RE_MAC3_M0_20051102125956.L1'
stime(4,0)=0
etime(4,0)=130013
;2005 12------------------------------------------------------
fname1(5,0,0)=fdir1+'2005\12\RE_MAC1_M0_20051204020702.L1'
fname1(5,1,0)=fdir1+'2005\12\RE_MAC2_M0_20051204020702.L1'
fname1(5,2,0)=fdir1+'2005\12\RE_MAC3_M0_20051204020702.L1'
stime(5,0)=0
etime(5,0)=0
;
fname1(6,0,0)=fdir1+'2005\12\RE_MAC1_M0_20051204034402.L1'
fname1(6,1,0)=fdir1+'2005\12\RE_MAC2_M0_20051204034402.L1'
fname1(6,2,0)=fdir1+'2005\12\RE_MAC3_M0_20051204034402.L1'
stime(6,0)=0
etime(6,0)=0
;
fname1(7,0,0)=fdir1+'2005\12\RE_MAC1_M0_20051204231103.L1'
fname1(7,1,0)=fdir1+'2005\12\RE_MAC2_M0_20051204231103.L1'
fname1(7,2,0)=fdir1+'2005\12\RE_MAC3_M0_20051204231103.L1'
stime(7,0)=0
etime(7,0)=231135
;2006 01------------------------------------------------------
fname1(8,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060102000038.L1'
fname1(8,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060102000038.L1'
fname1(8,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060102000038.L1'
stime(8,0)=0
etime(8,0)=000216
;
fname1(9,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060102094639.L1'
fname1(9,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060102094639.L1'
fname1(9,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060102094639.L1'
stime(9,0)=094648
etime(9,0)=094656
;
fname1(10,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060129132739.L1'
fname1(10,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060129132739.L1'
fname1(10,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060129132739.L1'
stime(10,0)=0
etime(10,0)=0
;
fname1(11,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060130040208.L1'
fname1(11,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060130040208.L1'
fname1(11,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060130040208.L1'
stime(11,0)=0
etime(11,0)=040323
;2006 02------------------------------------------------------
fname1(12,0,0)=fdir1+'2006\02\RE_MAC1_M0_20060228051425.L1'
fname1(12,1,0)=fdir1+'2006\02\RE_MAC2_M0_20060228051425.L1'
fname1(12,2,0)=fdir1+'2006\02\RE_MAC3_M0_20060228051425.L1'
stime(12,0)=0
etime(12,0)=0
;
fname1(13,0,0)=fdir1+'2006\02\RE_MAC1_M0_20060228065226.L1'
fname1(13,1,0)=fdir1+'2006\02\RE_MAC2_M0_20060228065226.L1'
fname1(13,2,0)=fdir1+'2006\02\RE_MAC3_M0_20060228065226.L1'
stime(13,0)=0
etime(13,0)=0
;2006 03------------------------------------------------------
fname1(14,0,0)=fdir1+'2006\03\RE_MAC1_M0_20060331070224.L1'
fname1(14,1,0)=fdir1+'2006\03\RE_MAC2_M0_20060331070224.L1'
fname1(14,2,0)=fdir1+'2006\03\RE_MAC3_M0_20060331070224.L1'
stime(14,0)=0
etime(14,0)=0
;2006 04------------------------------------------------------
fname1(15,0,0)=fdir1+'2006\04\RE_MAC1_M0_20060402073838.L1'
fname1(15,1,0)=fdir1+'2006\04\RE_MAC2_M0_20060402073838.L1'
fname1(15,2,0)=fdir1+'2006\04\RE_MAC3_M0_20060402073838.L1'
stime(15,0)=0
etime(15,0)=073850
;
fname1(16,0,0)=fdir1+'2006\04\RE_MAC1_M0_20060429115149.L1'
fname1(16,1,0)=fdir1+'2006\04\RE_MAC2_M0_20060429115149.L1'
fname1(16,2,0)=fdir1+'2006\04\RE_MAC3_M0_20060429115149.L1'
stime(16,0)=0
etime(16,0)=0
;2006 05------------------------------------------------------
fname1(17,0,0)=fdir1+'2006\05\RE_MAC1_M0_20060501122935.L1'
fname1(17,1,0)=fdir1+'2006\05\RE_MAC2_M0_20060501122935.L1'
fname1(17,2,0)=fdir1+'2006\05\RE_MAC3_M0_20060501122935.L1'
stime(17,0)=0
etime(17,0)=0
;
fname1(18,0,0)=''
fname1(18,1,0)=fdir1+'2006\05\RE_MAC2_M0_20060527092927.L1'
fname1(18,2,0)=fdir1+'2006\05\RE_MAC3_M0_20060527092927.L1'
stime(18,0)=0
etime(18,0)=0
;
fname1(19,0,0)=''
fname1(19,1,0)=fdir1+'2006\05\RE_MAC2_M0_20060527155327.L1'
fname1(19,2,0)=fdir1+'2006\05\RE_MAC3_M0_20060527155327.L1'
stime(19,0)=0
etime(19,0)=155421
;2006 06------------------------------------------------------
fname1(20,0,0)=''
fname1(20,1,0)=fdir1+'2006\06\RE_MAC2_M0_20060626091524.L1'
fname1(20,2,0)=fdir1+'2006\06\RE_MAC3_M0_20060626091524.L1'
stime(20,0)=0
etime(20,0)=091618
;
fname1(21,0,0)=''
fname1(21,1,0)=fdir1+'2006\06\RE_MAC2_M0_20060626153925.L1'
fname1(21,2,0)=fdir1+'2006\06\RE_MAC3_M0_20060626153925.L1'
stime(21,0)=0
etime(21,0)=0
;
fname1(22,0,0)=''
fname1(22,1,0)=fdir1+'2006\06\RE_MAC2_M0_20060626221126.L1'
fname1(22,2,0)=fdir1+'2006\06\RE_MAC3_M0_20060626221126.L1'
stime(22,0)=0
etime(22,0)=0
;2006 07------------------------------------------------------
fname1(23,0,0)=''
fname1(23,1,0)=fdir1+'2006\07\RE_MAC2_M0_20060725115235.L1'
fname1(23,2,0)=fdir1+'2006\07\RE_MAC3_M0_20060725115235.L1'
stime(23,0)=0
etime(23,0)=0
;
fname1(24,0,0)=''
fname1(24,1,0)=fdir1+'2006\07\RE_MAC2_M0_20060727042829.L1'
fname1(24,2,0)=fdir1+'2006\07\RE_MAC3_M0_20060727042829.L1'
stime(24,0)=0
etime(24,0)=0
;2006 08------------------------------------------------------
fname1(25,0,0)=fdir1+'2006\08\RE_MAC1_M0_20060823090842.L1'
fname1(25,1,0)=fdir1+'2006\08\RE_MAC2_M0_20060823090841.L1'
fname1(25,2,0)=fdir1+'2006\08\RE_MAC3_M0_20060823090841.L1'
stime(25,0)=0
etime(25,0)=0
;
fname1(26,0,0)=''
fname1(26,1,0)=fdir1+'2006\08\RE_MAC2_M0_20060823125258.L1'
fname1(26,2,0)=fdir1+'2006\08\RE_MAC3_M0_20060823125258.L1'
stime(26,0)=0
etime(26,0)=0
;
;for mode1=========================================================
;2005 10------------------------------------------------------
;fname1(0,0,1)=fdir1+'2005\10\RE_MAC1_M1_20051006011114.L1'
;fname1(0,1,1)=fdir1+'2005\10\RE_MAC2_M1_20051006011114.L1'
;fname1(0,2,1)=fdir1+'2005\10\RE_MAC3_M1_20051006011105.L1'
;fname1(0,0,1)=''
;fname1(0,1,1)=''
;fname1(0,2,1)=''
;stime(0,1)=0
;etime(0,1)=0
;2005 12------------------------------------------------------
fname1(0,0,1)=fdir1+'2005\12\RE_MAC1_M1_20051201074116.L1'
fname1(0,1,1)=fdir1+'2005\12\RE_MAC2_M1_20051201074116.L1'
fname1(0,2,1)=fdir1+'2005\12\RE_MAC3_M1_20051201074116.L1'
stime(0,1)=0
etime(0,1)=0
;
fname1(1,0,1)=fdir1+'2005\12\RE_MAC1_M1_20051203064143.L1'
fname1(1,1,1)=fdir1+'2005\12\RE_MAC2_M1_20051203064143.L1'
fname1(1,2,1)=fdir1+'2005\12\RE_MAC3_M1_20051203064143.L1'
stime(1,1)=0
etime(1,1)=0
;2006 03------------------------------------------------------
fname1(2,0,1)=fdir1+'2006\03\RE_MAC1_M1_20060328190122.L1'
fname1(2,1,1)=fdir1+'2006\03\RE_MAC2_M1_20060328190122.L1'
fname1(2,2,1)=fdir1+'2006\03\RE_MAC3_M1_20060328190122.L1'
stime(2,1)=0
etime(2,1)=0
;
fname1(3,0,1)=fdir1+'2006\03\RE_MAC1_M1_20060329174319.L1'
fname1(3,1,1)=fdir1+'2006\03\RE_MAC2_M1_20060329174319.L1'
fname1(3,2,1)=fdir1+'2006\03\RE_MAC3_M1_20060329174319.L1'
stime(3,1)=0
etime(3,1)=0
;
fname1(4,0,1)=fdir1+'2006\03\RE_MAC1_M1_20060329192020.L1'
fname1(4,1,1)=fdir1+'2006\03\RE_MAC2_M1_20060329192020.L1'
fname1(4,2,1)=fdir1+'2006\03\RE_MAC3_M1_20060329192020.L1'
stime(4,1)=0
etime(4,1)=0
;2006 05------------------------------------------------------
fname1(5,0,1)=fdir1+'2006\05\RE_MAC1_M1_20060501183020.L1'
fname1(5,1,1)=fdir1+'2006\05\RE_MAC2_M1_20060501183020.L1'
fname1(5,2,1)=fdir1+'2006\05\RE_MAC3_M1_20060501183020.L1'
stime(5,1)=0
etime(5,1)=0
;
fname1(6,0,1)=fdir1+'2006\05\RE_MAC1_M1_20060501200821.L1'
fname1(6,1,1)=fdir1+'2006\05\RE_MAC2_M1_20060501200821.L1'
fname1(6,2,1)=fdir1+'2006\05\RE_MAC3_M1_20060501200821.L1'
stime(6,1)=0
etime(6,1)=0
;

psdir=fdirps1+'dark\'
logname=psdir+'log.txt'
calname='cal_'
ch1m0name=psdir+'Ch1M0.txt'
ch2m0name=psdir+'Ch2M0.txt'
ch3m0name=psdir+'Ch3M0.txt'
ch1m1name=psdir+'Ch1M1.txt'
ch2m1name=psdir+'Ch2M2.txt'
ch3m1name=psdir+'Ch3M3.txt'



; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
radimagefile='H:\Index\obs\051110\051110004943_radcorrect_flame2.dat'

;=====parameter end=====

close,/all

openw,10,logname
if imode eq 0 then begin
  openw,11,ch1m0name
  openw,12,ch2m0name
  openw,13,ch3m0name
endif else begin
  openw,14,ch1m1name
  openw,15,ch2m1name
  openw,26,ch3m1name
endelse

if imode eq 0 or imode eq 1 then begin
  ibin=16
  res=64
endif else if imode eq 2 then begin
  ibin=2
  res=512
endif else begin
  ibin=8
  res=128
endelse

print, ' === start ==='

num=0
for i=0,1000-1 do begin
  if strlen(fname1(i,0,imode)+fname1(i,1,imode)+fname1(i,2,imode)) lt 5 then goto, nextstep0
  num=num+1
endfor

nextstep0:
;num=5

printf,10,'total number ',num

for st=0,1500,200 do begin
  et=st+dur

ave_imagetotal=fltarr(res,res,3,num)
ave_imagetotal_o=fltarr(res,res,3,num)
med_imagetotal=fltarr(res,res,3,num)
smo_imagetotal=fltarr(res,res,3,num)
smo2_imagetotal=fltarr(res,res,3,num)
smo3_imagetotal=fltarr(res,res,3,num)
smo4_imagetotal=fltarr(res,res,3,num)
fit_imagetotal=fltarr(res,res,3,num)
ave_expo=fltarr(num)
ave_mac_t=fltarr(num)
ave_mac_ccd=fltarr(3,num)
ave_mac_fil=fltarr(3,num)
fnum_o=intarr(num)

psname=psdir+'darkframe'

if st lt 10 then begin
  st1=7
endif else if st lt 100 then begin
  st1=6
endif else if st lt 1000 then begin
  st1=5
endif else begin
  st1=4
endelse
if et lt 10 then begin
  et1=7
endif else if et lt 100 then begin
  et1=6
endif else if et lt 1000 then begin
  et1=5
endif else begin
  et1=4
endelse
psname=psname+'_'+strmid(st,st1,8-st1)+'_'+strmid(et,et1,8-et1)+'_'
print, psname
;stop

for i=0,num-1 do begin

for j=0,2 do begin

  fna=fname1(i,j,imode)
  if strlen(fna) lt 5 then goto,nextfile2

  print,i, fna
  read_L1data,fna,imode,res,ymd1,time1,ti1,temp1,imagetotal_1o,fnum1
  print,'Ch1 file name, fnum= ',fna,fnum1
  print,'start and end times= ',time1(0),time1(fnum1-1)
  printf,10,'Ch1 file name, fnum= ',fna,fnum1
  printf,10,'start and end times= ',time1(0),time1(fnum1-1)

  if et gt fnum1 then goto, nextst

;  reading status parameters from L1 status file --------------
  stafind_1day,fna,stanum,stadir,stafile
  print,'STA file=',stafile
  printf,10,'STA file=',stafile

  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
      mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
      mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
      esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
      esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
      esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
      rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for ii=0, n_elements(expor)-2 do begin
    if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
    if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
  endfor
  cadd=''

  print, 'Finding obseravation time and exposure time...'
;  find_obstime_hhmmss,yyr,mor,ddr,hhr,mmr,ssr,expor,ymd1,time1,tsec_obs1,$
;    yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1
  find_obstime_hhmmss_l2,yyr,mor,ddr,hhr,mmr,ssr,expor,mac_tr,mac_c1_tr,mac_c2_tr,mac_c3_tr,mac_f1_tr,$
    mac_f2_tr,mac_f3_tr,ymd1,time1,tsec_obs1,yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1,$
    mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t

  expos=fltarr(fnum1)
  if max(expo_obs1) eq 0 then begin
    stop
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
    printf,10,'exposure time assumed! case A, time and exposure time= ',time1,expos
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs1(*)
    cexp=''
    print,'time and exposure time= ',time1(0),time1(fnum1-1),expos(0),expos(fnum1-1)
    printf,10,'time and exposure time= ',time1(0),time1(fnum1-1),expos(0),expos(fnum1-1)
  endelse

  fnum=fnum1
  if expos(0) ne expos(fnum-1) then begin
    n1=n_elements(where(expos(0) eq expos(*)))
    n2=n_elements(where(expos(fnum-1) eq expos(*)))
    if n1 gt n2 then begin
      expos(*)=expos(0)
    endif else begin
      expos(*)=expos(fnum-1)
    endelse
  endif

  result=moment(expos(*))
  if result(0) ne expos(0) or result(0) ne expos(fnum1-1) then begin
    if imode eq 1 then begin
      result(0)=max(expos)
    endif else begin
      stop
    endelse
  endif

  ave_expo(i)=result(0)
  ave_expo1=fltarr(fnum1) & ave_expo1(*)=ave_expo(i)

  count_to_rayleigh_count,imagetotal_1o,radcorrect,radfile,imode,j+1,res,ave_expo1,fnum1,imagetotal_linear,imagetotal_log10,mac_count

  ;if stime(i,imode) gt 0 then begin
  ;  st=min(where(stime(i,imode) ge time1(*)))
  ;endif else begin
  ;  st=0
  ;endelse
  ;if etime(i,imode) gt 0 then begin
  ;  et=max(where(etime(i,imode) gt time1(*)))
  ;endif else begin
  ;  et=dur
  ;endelse

  ;if et gt st+dur then et=st+dur

  printf,10,'st,et ',st,et



if imode eq 1 then begin
  if j eq 0 then begin
    thres=180
    fitfac=2
    fac=0.94
  endif else if j eq 1 then begin
    thres=180
    fitfac=2
    fac=0.95
  endif else begin
    thres=300
    fitfac=3
    fac=0.93
  endelse
endif else begin
  thres=9999
endelse

  for x=0,res-1 do begin
    for y=0,res-1 do begin
      result=moment(mac_count(x,y,st:et))
      ave_imagetotal_o(x,y,j,i)=result(0)
      if result(0) lt thres then begin
        ave_imagetotal(x,y,j,i)=result(0)
      endif else begin
        ave_imagetotal(x,y,j,i)=0
      endelse
    endfor
  endfor

  for x=0,res-1 do begin
    for y=0,res-1 do begin
      if ave_imagetotal(x,y,j,i) eq 0 then begin
         x0=x-2 & if x0 lt 0 then x0=0
         x1=x+2 & if x1 ge res then x1=res-1
         y0=y-2 & if y0 lt 0 then y0=0
         y1=y+2 & if y1 ge res then y1=res-1
         nu=0
         ave=0.0
         for xi=x0,x1-1 do begin
           for yi=y0,y1-1 do begin
             nu=nu+1
             if ave_imagetotal(xi,yi,j,i) gt 0 then ave=ave+ave_imagetotal(xi,yi,j,i)
           endfor
         endfor
         ave_imagetotal(x,y,j,i)=ave/float(nu)
       endif
     endfor
   endfor

; med_imagetotal(*,*,j,i)=median(ave_imagetotal(*,*,j,i),med_coef)
  med_imagetotal(*,*,j,i)=median(ave_imagetotal(*,*,j,i),med_coef,/even)
if imode eq 0 then begin
   smo_imagetotal(*,*,j,i)=smooth(med_imagetotal(*,*,j,i),smo_coef,/EDGE_TRUNCATE)
endif else begin
;  med_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i),2)
;  smo_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i),2)*0.95
  smo_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i),fitfac)*fac
;  smo3_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i),1)
;  smo2_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i)-smo3_imagetotal(*,*,j,i),2)
;  smo4_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i)-smo3_imagetotal(*,*,j,i)-smo2_imagetotal(*,*,j,i),1)
;  smo_imagetotal(*,*,j,i)=(smo2_imagetotal(*,*,j,i)+smo3_imagetotal(*,*,j,i)+smo4_imagetotal(*,*,j,i))*0.95


endelse
  yy=fix(long(ymd1(0))/10000l)
  mm=fix((long(ymd1(0))-10000l*yy)/100)
  dd=long(ymd1(0))-10000l*yy-100*mm
  totalday,yy,mm,dd,md,td
  td=td+(yy-2005)*365

  printf,10,i,mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
  if imode eq 0 then begin
    if j eq 0 then begin
      printf,11,i,td,time1(i),mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
    endif else if j eq 1 then begin
      printf,12,i,td,time1(i),mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
    endif else if j eq 2 then begin
      printf,13,i,td,time1(i),mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
    endif
  endif else if imode eq 1 then begin
    if j eq 0 then begin
      printf,14,i,td,time1(i),mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
    endif else if j eq 1 then begin
      printf,15,i,td,time1(i),mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
    endif else if j eq 2 then begin
      printf,26,i,td,time1(i),mean(med_imagetotal(*,*,j,i)),mean(smo_imagetotal(*,*,j,i)),ave_expo(i)
    endif
  endif

  nextfile2:
endfor

  result=moment(mac_t(st:et-1))
  ave_mac_t(i)=result(0)
  result=moment(mac_1t(st:et-1))
  ave_mac_ccd(0,i)=result(0)
  result=moment(mac_2t(st:et-1))
  ave_mac_ccd(1,i)=result(0)
  result=moment(mac_3t(st:et-1))
  ave_mac_ccd(2,i)=result(0)
  result=moment(mac_f1t(st:et-1))
  ave_mac_fil(0,i)=result(0)
  result=moment(mac_f2t(st:et-1))
  ave_mac_fil(1,i)=result(0)
  result=moment(mac_f3t(st:et-1))
  ave_mac_fil(2,i)=result(0)
  nextfile1:
endfor




if imode eq 1 then begin
  ave_imagetotal_0=fltarr(res,res,3,2)
  med_imagetotal_0=fltarr(res,res,3,2)
  smo_imagetotal_0=fltarr(res,res,3,2)
  ratio_0=fltarr(res,res,3)
  ave_expo_0=fltarr(2)

for ii=0,1 do begin

for j=0,2 do begin
  if ii eq 0 then begin
    i=0
  endif else begin
    i=refnum0
  endelse

  fna=fname1(i,j,0)
  if strlen(fna) lt 5 then goto,nextfile4

  print,i, fna
  read_L1data,fna,imode,res,ymd1,time1,ti1,temp1,imagetotal_1o,fnum1
  print,'Ch1 file name, fnum= ',fna,fnum1
  print,'start and end times= ',time1(0),time1(fnum1-1)
  printf,10,'Ch1 file name, fnum= ',fna,fnum1
  printf,10,'start and end times= ',time1(0),time1(fnum1-1)

;  reading status parameters from L1 status file --------------
  stafind_1day,fna,stanum,stadir,stafile
  print,'STA file=',stafile
  printf,10,'STA file=',stafile

  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
      mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
      mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
      esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
      esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
      esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
      rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for iii=0, n_elements(expor)-2 do begin
    if expor(iii) eq 0 and expor(iii+1) ne 0 then expor(iii)=expor(iii+1)
    if expor(iii) ne 0 and expor(iii+1) eq 0 then expor(iii+1)=expor(iii)
  endfor
  cadd=''

  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss,yyr,mor,ddr,hhr,mmr,ssr,expor,ymd1,time1,tsec_obs1,$
    yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1
  expos=fltarr(fnum1)
  if max(expo_obs1) eq 0 then begin
    stop
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
    printf,10,'exposure time assumed! case A, time and exposure time= ',time1,expos
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs1(*)
    cexp=''
    print,'time and exposure time= ',time1(0),time1(fnum1-1),expos(0),expos(fnum1-1)
    printf,10,'time and exposure time= ',time1(0),time1(fnum1-1),expos(0),expos(fnum1-1)
  endelse

  fnum=fnum1
  if expos(0) ne expos(fnum-1) then begin
    n1=n_elements(where(expos(0) eq expos(*)))
    n2=n_elements(where(expos(fnum-1) eq expos(*)))
    if n1 gt n2 then begin
      expos(*)=expos(0)
    endif else begin
      expos(*)=expos(fnum-1)
    endelse
  endif

  result=moment(expos(*))
  if result(0) ne expos(0) or result(0) ne expos(fnum1-1) then begin
    if imode eq 1 then begin
      result(0)=max(expos)
    endif else begin
      stop
    endelse
  endif

  ave_expo_0(ii)=result(0)
  ave_expo1=fltarr(fnum1) & ave_expo1(*)=ave_expo_0(ii)

  count_to_rayleigh_count,imagetotal_1o,radcorrect,radfile,imode,j+1,res,ave_expo1,fnum1,imagetotal_linear,imagetotal_log10,mac_count
  if stime(ii,imode) gt 0 then begin
    st=min(where(stime(ii,imode) ge time1(*)))
  endif else begin
    st=0
  endelse
  if etime(ii,imode) gt 0 then begin
    et=max(where(etime(ii,imode) gt time1(*)))
  endif else begin
    et=dur
  endelse

  if et gt st+dur then et=st+dur

  printf,10,'st,et ',st,et
  print,'st,et ',st,et

  for x=0,res-1 do begin
    for y=0,res-1 do begin
      result=moment(mac_count(x,y,st:et))
      ave_imagetotal_0(x,y,j,ii)=result(0)
    endfor
  endfor


; med_imagetotal(*,*,j,i)=median(ave_imagetotal(*,*,j,i),med_coef)
  med_imagetotal_0(*,*,j,ii)=median(ave_imagetotal(*,*,j,ii),med_coef,/even)
;  smo_imagetotal_0(*,*,j,ii)=smooth(med_imagetotal(*,*,j,ii),smo_coef,/EDGE_TRUNCATE)
;  med_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i),2)
;  smo_imagetotal(*,*,j,i)=sfit(ave_imagetotal(*,*,j,i),4)

  nextfile4:
endfor
  nextfile3:
endfor

for i=0,res-1 do begin
  for j=0,res-1 do begin
    for k=0,2 do begin
      ratio_0(i,j,k)=(smo_imagetotal_0(i,j,k,1)-smo_imagetotal_0(i,j,k,0))/(ave_expo_0(1)-ave_expo_0(0))
    endfor
  endfor
endfor

endif

ratio=fltarr(res,res,3)

;fac=fltarr(3,2)
;fac(0,0)=0.206
;fac(1,0)=0.427
;fac(2,0)=0.316
;fac(0,1)=0.0266
;fac(1,1)=0.0211
;fac(2,1)=0.0216

dt=fltarr(num)

if imode eq 1 then begin


  for i=0,res-1 do begin
    for j=0,res-1 do begin
      for k=0,2 do begin
        ratio(i,j,k)=(smo_imagetotal(i,j,k,0)-smo_imagetotal_0(i,j,k,0))/(ave_expo(0)-ave_expo_0(0))
;        fit_imagetotal(i,j,k,*)=ave_imagetotal(i,j,k,*)-(smo_imagetotal_0(i,j,k,0)+ratio_0(i,j,k)*(ave_expo(*)-ave_expo(0)))
;        fit_imagetotal(i,j,k,*)=ave_imagetotal(i,j,k,*)-(smo_imagetotal_0(i,j,k,0)+ratio(i,j,k)*(ave_expo(*)-ave_expo_0(0)))
        fit_imagetotal(i,j,k,*)=ave_imagetotal(i,j,k,*)-(smo_imagetotal(i,j,k,1))
      endfor
    endfor
  endfor
endif else begin

  dt(*)=ave_expo(*)-ave_expo(0)

  for i=0,res-1 do begin
    for j=0,res-1 do begin
      for k=0,2 do begin
        ratio(i,j,k)=(smo_imagetotal(i,j,k,refnum0)-smo_imagetotal(i,j,k,0))/(ave_expo(refnum0)-ave_expo(0))
        fit_imagetotal(i,j,k,*)=smo_imagetotal(i,j,k,*)-(smo_imagetotal(i,j,k,0)+ratio(i,j,k)*dt(*))
      endfor
    endfor
  endfor

endelse

if dataout eq 1 then begin

  if imode eq 0 then begin
    ccal='mode0.txt'
  endif else begin
    ccal='mode1.txt'
  endelse

  openw,20,psdir+calname+ccal
  printf,20,'mode, number of image files, coef of median filtering, coef of smoothing, num of dataset'
  printf,20, imode,dur,med_coef,smo_coef
  printf,20,'data number: origin and refnum'
  printf,20,0,refnum
  printf,20,fname1(0,0,imode)
  printf,20,fname1(0,1,imode)
  printf,20,fname1(0,2,imode)
  printf,20,fname1(refnum,0,imode)
  printf,20,fname1(refnum,1,imode)
  printf,20,fname1(refnum,2,imode)
  printf,20, 'exposure times: origin and refnum'
  printf,20,ave_expo(0),ave_expo(refnum)
  printf,20,'equation:result(i,j,k,*)=ave_image(i,j,k,*)-(smo_image(i,j,k,0)+ratio(i,j,k)*(ave_expo(*)-ave_expo(0))'
  printf,20,'data:origin'
  printf,20,smo_imagetotal(*,*,*,imode)
  printf,20,'ratio'
  printf,20,ratio(*,*,*)
  close,20
endif

;ich=0
;MAC_PS_create_darkframe,ich,imode,num,res,smax,smin,fname1,psname,expos,time1,$
;    ave_imagetotal,med_imagetotal,smo_imagetotal,'Ageraged','Median','Poly fit'
;ich=1
;MAC_PS_create_darkframe,ich,imode,num,res,smax,smin,fname1,psname,expos,time1,$
;    ave_imagetotal,med_imagetotal,smo_imagetotal,'Ageraged','Median','Poly fit'
;;ich=2
;;MAC_PS_create_darkframe,ich,imode,num,res,smax,smin,fname1,psname,expos,time1,$
;    ave_imagetotal,med_imagetotal,smo_imagetotal,'Ageraged','Median','Poly fit'

nextst:

ich=0
MAC_PS_create_darkframe,ich,imode,num,res,smax,smin,fname1,psname,ave_expo,$
    ave_mac_t,ave_mac_ccd,ave_mac_fil,time1,$
    ave_imagetotal,smo_imagetotal,fit_imagetotal,'Ageraged','Smoothed','Difference'
MAC_PS_create_darkframe,ich,imode,anum,p,res,smax1,smin1,fname1,psname,expos,$
    ave_mac_t,ave_mac_ccd,ave_mac_fil,time1,$
    ave_imagetotal,med_imagetotal,smo_imagetotal,ct1,ct2,ct3
ich=1
MAC_PS_create_darkframe,ich,imode,num,res,smax,smin,fname1,psname,ave_expo,$
    ave_mac_t,ave_mac_ccd,ave_mac_fil,time1,$
    ave_imagetotal,smo_imagetotal,fit_imagetotal,'Ageraged','Smoothed','Difference'
smin(1,0) = 70 & smax(1,0) = 250
smin(1,1) = 70 & smax(1,1) = 250
ich=2
MAC_PS_create_darkframe,ich,imode,num,res,smax,smin,fname1,psname,ave_expo,$
    ave_mac_t,ave_mac_ccd,ave_mac_fil,time1,$
    ave_imagetotal,smo_imagetotal,fit_imagetotal,'Ageraged','Smoothed','Difference'




;close,/all

endfor

programend:

close,/all

print, 'Normal End! '
END
