;******************************************************************
;    program MACimage_DARTS_L1_animation_color_auto.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Jan 16, 2006
;******************************************************************

PRO MACimage_DARTS_L1_cal_darkframe_new

close,/all

;mode for calculation
imode=0
;durtion of frames for each file
;dur=6
dur=50
;st and et step
sstep=dur


if imode eq 1 then begin
  med_coef=4
  smo_coef=4
endif else begin
  med_coef=6
  smo_coef=6
endelse

;output data? yes-1
dataout=1

;refnum0=16
;refnum1=3

iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin=fltarr(4,4)
smax=fltarr(4,4)
smin(0,0) = 70 & smax(0,0) = 170
smin(0,1) = 70 & smax(0,1) = 170
smin(0,2) =-20 & smax(0,2) = 20
;smin(0,2) = 0.8 & smax(0,2) = 1.2
;for mode1
smin(1,0) = 70 & smax(1,0) = 250
smin(1,1) = 70 & smax(1,1) = 250
smin(1,2) = 70 & smax(1,2) = 250
smin(1,3) = -20 & smax(1,3) = 20
;for mode2
smin(2,0) = 40 & smax(2,0) = 50
smin(2,1) = 10 & smax(2,1) = 100
smin(2,2) = 40 & smax(2,2) = 250
;for mode3
smin(3,0) = 5 & smax(3,0) = 15
smin(3,1) = 5 & smax(3,1) = 50
smin(3,2) = 5 & smax(3,2) = 40

;smax and smin in kR for ch1,2,3

fdir1= 'E:\Usr\tsakanoi\Index\DARTS\Level-1\'
fdirps1= 'C:\Usr\tsakanoi\Index\DARTS\Level-1\'

fname1=strarr(100,3,2)
stime=lonarr(100,2)
etime=lonarr(100,2)
ctime=dblarr(100,2)
expt1=fltarr(100,2)
expt2=fltarr(100,2)

ii=-1
;for mode0=========================================================
;2005 10------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\10\RE_MAC1_M0_20051004034653.L1'
fname1(ii,1,0)=fdir1+'2005\10\RE_MAC2_M0_20051004034653.L1'
fname1(ii,2,0)=fdir1+'2005\10\RE_MAC3_M0_20051004034728.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\10\RE_MAC1_M0_20051004070107.L1'
fname1(ii,1,0)=fdir1+'2005\10\RE_MAC2_M0_20051004070107.L1'
fname1(ii,2,0)=fdir1+'2005\10\RE_MAC3_M0_20051004070208.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\10\RE_MAC1_M0_20051005022824.L1'
fname1(ii,1,0)=fdir1+'2005\10\RE_MAC2_M0_20051005022824.L1'
fname1(ii,2,0)=fdir1+'2005\10\RE_MAC3_M0_20051005022924.L1'
stime(ii,0)=0
etime(ii,0)=0
;2005 11------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\11\RE_MAC1_M0_20051102081103.L1'
fname1(ii,1,0)=fdir1+'2005\11\RE_MAC2_M0_20051102081103.L1'
fname1(ii,2,0)=fdir1+'2005\11\RE_MAC3_M0_20051102081103.L1'
stime(ii,0)=0
etime(ii,0)=081133
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\11\RE_MAC1_M0_20051102125955.L1'
fname1(ii,1,0)=fdir1+'2005\11\RE_MAC2_M0_20051102125955.L1'
fname1(ii,2,0)=fdir1+'2005\11\RE_MAC3_M0_20051102125956.L1'
stime(ii,0)=0
etime(ii,0)=130013
;2005 12------------------------------------------------------
;---
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\12\RE_MAC1_M0_20051204020702.L1'
fname1(ii,1,0)=fdir1+'2005\12\RE_MAC2_M0_20051204020702.L1'
fname1(ii,2,0)=fdir1+'2005\12\RE_MAC3_M0_20051204020702.L1'
stime(ii,0)=0
etime(ii,0)=0
;---
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\12\RE_MAC1_M0_20051204034402.L1'
fname1(ii,1,0)=fdir1+'2005\12\RE_MAC2_M0_20051204034402.L1'
fname1(ii,2,0)=fdir1+'2005\12\RE_MAC3_M0_20051204034402.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2005\12\RE_MAC1_M0_20051204231103.L1'
fname1(ii,1,0)=fdir1+'2005\12\RE_MAC2_M0_20051204231103.L1'
fname1(ii,2,0)=fdir1+'2005\12\RE_MAC3_M0_20051204231103.L1'
stime(ii,0)=0
etime(ii,0)=231135
;2006 01------------------------------------------------------
;---
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060102000038.L1'
fname1(ii,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060102000038.L1'
fname1(ii,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060102000038.L1'
stime(ii,0)=0
etime(ii,0)=000216
;---
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060102094639.L1'
fname1(ii,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060102094639.L1'
fname1(ii,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060102094639.L1'
stime(ii,0)=094648
etime(ii,0)=094656
;---
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060129132739.L1'
fname1(ii,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060129132739.L1'
fname1(ii,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060129132739.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\01\RE_MAC1_M0_20060130040208.L1'
fname1(ii,1,0)=fdir1+'2006\01\RE_MAC2_M0_20060130040208.L1'
fname1(ii,2,0)=fdir1+'2006\01\RE_MAC3_M0_20060130040208.L1'
stime(ii,0)=0
etime(ii,0)=040323
;2006 02------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\02\RE_MAC1_M0_20060228051425.L1'
fname1(ii,1,0)=fdir1+'2006\02\RE_MAC2_M0_20060228051425.L1'
fname1(ii,2,0)=fdir1+'2006\02\RE_MAC3_M0_20060228051425.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\02\RE_MAC1_M0_20060228065226.L1'
fname1(ii,1,0)=fdir1+'2006\02\RE_MAC2_M0_20060228065226.L1'
fname1(ii,2,0)=fdir1+'2006\02\RE_MAC3_M0_20060228065226.L1'
stime(ii,0)=0
etime(ii,0)=0
;2006 03------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\03\RE_MAC1_M0_20060331070224.L1'
fname1(ii,1,0)=fdir1+'2006\03\RE_MAC2_M0_20060331070224.L1'
fname1(ii,2,0)=fdir1+'2006\03\RE_MAC3_M0_20060331070224.L1'
stime(ii,0)=0
etime(ii,0)=0
;2006 04------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\04\RE_MAC1_M0_20060402073838.L1'
fname1(ii,1,0)=fdir1+'2006\04\RE_MAC2_M0_20060402073838.L1'
fname1(ii,2,0)=fdir1+'2006\04\RE_MAC3_M0_20060402073838.L1'
stime(ii,0)=0
etime(ii,0)=073850
;
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\04\RE_MAC1_M0_20060429115149.L1'
fname1(ii,1,0)=fdir1+'2006\04\RE_MAC2_M0_20060429115149.L1'
fname1(ii,2,0)=fdir1+'2006\04\RE_MAC3_M0_20060429115149.L1'
stime(ii,0)=0
etime(ii,0)=0
;2006 05------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\05\RE_MAC1_M0_20060501122935.L1'
fname1(ii,1,0)=fdir1+'2006\05\RE_MAC2_M0_20060501122935.L1'
fname1(ii,2,0)=fdir1+'2006\05\RE_MAC3_M0_20060501122935.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\05\RE_MAC2_M0_20060527092927.L1'
fname1(ii,2,0)=fdir1+'2006\05\RE_MAC3_M0_20060527092927.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\05\RE_MAC2_M0_20060527155327.L1'
fname1(ii,2,0)=fdir1+'2006\05\RE_MAC3_M0_20060527155327.L1'
stime(ii,0)=0
etime(ii,0)=155421
;2006 06------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\06\RE_MAC2_M0_20060626091524.L1'
fname1(ii,2,0)=fdir1+'2006\06\RE_MAC3_M0_20060626091524.L1'
stime(ii,0)=0
etime(ii,0)=091618
;
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\06\RE_MAC2_M0_20060626153925.L1'
fname1(ii,2,0)=fdir1+'2006\06\RE_MAC3_M0_20060626153925.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\06\RE_MAC2_M0_20060626221126.L1'
fname1(ii,2,0)=fdir1+'2006\06\RE_MAC3_M0_20060626221126.L1'
stime(ii,0)=0
etime(ii,0)=0
;2006 07------------------------------------------------------
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\07\RE_MAC2_M0_20060725115235.L1'
fname1(ii,2,0)=fdir1+'2006\07\RE_MAC3_M0_20060725115235.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\07\RE_MAC2_M0_20060727042829.L1'
fname1(ii,2,0)=fdir1+'2006\07\RE_MAC3_M0_20060727042829.L1'
stime(ii,0)=0
etime(ii,0)=0
;2006 08------------------------------------------------------
;---
ii=ii+1
fname1(ii,0,0)=fdir1+'2006\08\RE_MAC1_M0_20060823090842.L1'
fname1(ii,1,0)=fdir1+'2006\08\RE_MAC2_M0_20060823090841.L1'
fname1(ii,2,0)=fdir1+'2006\08\RE_MAC3_M0_20060823090841.L1'
stime(ii,0)=0
etime(ii,0)=0
;
ii=ii+1
fname1(ii,0,0)=''
fname1(ii,1,0)=fdir1+'2006\08\RE_MAC2_M0_20060823125258.L1'
fname1(ii,2,0)=fdir1+'2006\08\RE_MAC3_M0_20060823125258.L1'
stime(ii,0)=0
etime(ii,0)=0


iii=-1

;for mode1=========================================================
;2005 10------------------------------------------------------
;iii=iii+1
;fname1(iii,0,1)=fdir1+'2005\10\RE_MAC1_M1_20051006011114.L1'
;fname1(iii,1,1)=fdir1+'2005\10\RE_MAC2_M1_20051006011114.L1'
;fname1(iii,2,1)=fdir1+'2005\10\RE_MAC3_M1_20051006011105.L1'
;stime(iii,1)=0
;etime(iii,1)=0
;ctime(iii,1)=0

;2005 12------------------------------------------------------
iii=iii+1
fname1(iii,0,1)=fdir1+'2005\12\RE_MAC1_M1_20051201074116.L1'
fname1(iii,1,1)=fdir1+'2005\12\RE_MAC2_M1_20051201074116.L1'
fname1(iii,2,1)=fdir1+'2005\12\RE_MAC3_M1_20051201074116.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=0
;
iii=iii+1
fname1(iii,0,1)=fdir1+'2005\12\RE_MAC1_M1_20051203064143.L1'
fname1(iii,1,1)=fdir1+'2005\12\RE_MAC2_M1_20051203064143.L1'
fname1(iii,2,1)=fdir1+'2005\12\RE_MAC3_M1_20051203064143.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=0

;2006 03------------------------------------------------------
iii=iii+1
fname1(iii,0,1)=fdir1+'2006\03\RE_MAC1_M1_20060328190122.L1'
fname1(iii,1,1)=fdir1+'2006\03\RE_MAC2_M1_20060328190122.L1'
fname1(iii,2,1)=fdir1+'2006\03\RE_MAC3_M1_20060328190122.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=190422.80
;
iii=iii+1
fname1(iii,0,1)=fdir1+'2006\03\RE_MAC1_M1_20060329174319.L1'
fname1(iii,1,1)=fdir1+'2006\03\RE_MAC2_M1_20060329174319.L1'
fname1(iii,2,1)=fdir1+'2006\03\RE_MAC3_M1_20060329174319.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=174518.40
;
iii=iii+1
fname1(iii,0,1)=fdir1+'2006\03\RE_MAC1_M1_20060329192020.L1'
fname1(iii,1,1)=fdir1+'2006\03\RE_MAC2_M1_20060329192020.L1'
fname1(iii,2,1)=fdir1+'2006\03\RE_MAC3_M1_20060329192020.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=192220.39

;2006 05------------------------------------------------------
iii=iii+1
fname1(iii,0,1)=fdir1+'2006\05\RE_MAC1_M1_20060501183020.L1'
fname1(iii,1,1)=fdir1+'2006\05\RE_MAC2_M1_20060501183020.L1'
fname1(iii,2,1)=fdir1+'2006\05\RE_MAC3_M1_20060501183020.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=183220.03
;
iii=iii+1
fname1(iii,0,1)=fdir1+'2006\05\RE_MAC1_M1_20060501200821.L1'
fname1(iii,1,1)=fdir1+'2006\05\RE_MAC2_M1_20060501200821.L1'
fname1(iii,2,1)=fdir1+'2006\05\RE_MAC3_M1_20060501200821.L1'
stime(iii,1)=0
etime(iii,1)=0
ctime(iii,1)=201020.47
;

psdir=fdirps1+'dark\'
logname=psdir+'log.txt'
calname='cal_'
ch1m0name=psdir+'Ch1M0.txt'
ch1m0name_n=psdir+'Ch1M0_N.txt'
ch1m0name_s=psdir+'Ch1M0_S.txt'
ch2m0name=psdir+'Ch2M0.txt'
ch2m0name_n=psdir+'Ch2M0_N.txt'
ch2m0name_s=psdir+'Ch2M0_S.txt'
ch3m0name=psdir+'Ch3M0.txt'
ch3m0name_n=psdir+'Ch3M0_N.txt'
ch3m0name_s=psdir+'Ch3M0_S.txt'
ch1m1name=psdir+'Ch1M1.txt'
ch1m1name_n=psdir+'Ch1M1_N.txt'
ch1m1name_s=psdir+'Ch1M1_S.txt'
ch2m1name=psdir+'Ch2M1.txt'
ch2m1name_n=psdir+'Ch2M1_N.txt'
ch2m1name_s=psdir+'Ch2M1_S.txt'
ch3m1name=psdir+'Ch3M1.txt'
ch3m1name_n=psdir+'Ch3M1_N.txt'
ch3m1name_s=psdir+'Ch3M1_S.txt'



; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
radimagefile='H:\Index\obs\051110\051110004943_radcorrect_flame2.dat'

;=====parameter end=====

close,/all

openw,10,logname
if imode eq 0 then begin
  openw,11,ch1m0name
  openw,12,ch2m0name
  openw,13,ch3m0name
  openw,51,ch1m0name_n
  openw,52,ch2m0name_n
  openw,53,ch3m0name_n
  openw,61,ch1m0name_s
  openw,62,ch2m0name_s
  openw,63,ch3m0name_s
endif else begin
  openw,14,ch1m1name
  openw,15,ch2m1name
  openw,26,ch3m1name
  openw,54,ch1m1name_n
  openw,55,ch2m1name_n
  openw,56,ch3m1name_n
  openw,64,ch1m1name_s
  openw,65,ch2m1name_s
  openw,66,ch3m1name_s
endelse

if imode eq 0 or imode eq 1 then begin
  ibin=16
  res=64
endif else if imode eq 2 then begin
  ibin=2
  res=512
endif else begin
  ibin=8
  res=128
endelse

print, ' === start ==='

num=0
for i=0,1000-1 do begin
  if strlen(fname1(i,0,imode)+fname1(i,1,imode)+fname1(i,2,imode)) lt 5 then goto, nextstep0
  num=num+1
endfor

nextstep0:
;num=5

printf,10,'total number ',num


n1=50
ave_imagetotal=fltarr(res,res,3,num,n1)
ave_imagetotal_o=fltarr(res,res,3,num,n1)
med_imagetotal=fltarr(res,res,3,num,n1)
smo_imagetotal=fltarr(res,res,3,num,n1)
smo2_imagetotal=fltarr(res,res,3,num,n1)
smo3_imagetotal=fltarr(res,res,3,num,n1)
smo4_imagetotal=fltarr(res,res,3,num,n1)
fit_imagetotal=fltarr(res,res,3,num,n1)
dif_imagetotal=fltarr(res,res,3,num,n1)
dev_imagetotal=fltarr(res,res,3,num,n1)
ave_expo=fltarr(num,2000)
ave_mac_t=fltarr(num,n1)
ave_mac_ccd=fltarr(3,num,n1)
ave_mac_fil=fltarr(3,num,n1)
dev_num=intarr(3,num,n1)
fnum_o=intarr(num,3)
pnum=intarr(n1)
satglat=fltarr(num)

;ratio=fltarr(res,res,3,num,n1)
dt=fltarr(num)
time=fltarr(num,2000)

;stop

for i=0,num-1 do begin

  for j=0,2 do begin

      fna=fname1(i,j,imode)
      if strlen(fna) lt 5 then goto,nextfile2

      print,i, fna
      read_L1data,fna,imode,res,ymd1,time1,ti1,temp1,imagetotal_1o,fnum1
      print,'Ch1 file name, fnum= ',fna,fnum1
      print,'start and end times= ',time1(0),time1(fnum1-1)
      printf,10,'Ch1 file name, fnum= ',fna,fnum1
      printf,10,'start and end times= ',time1(0),time1(fnum1-1)
      fnum_o(i,j)=fnum1

;  reading status parameters from L1 status file --------------
      stafind_1day,fna,stanum,stadir,stafile
      print,'STA file=',stafile
      printf,10,'STA file=',stafile

      print, 'STA file reading...'
      status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
        mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
        mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
        esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
        esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
        esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
        rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

      print, 'Changing from EST number to exposure time in msec...'
      est_to_sec,mac_exposurer,expor
;      if ctime(i,imode,j) ne 0 then stop

      print, expor

      for ii=0, n_elements(expor)-2 do begin
        if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
        if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
      endfor
      cadd=''


      print, 'Finding obseravation time and exposure time...'
      find_obstime_hhmmss_l2_new,yyr,mor,ddr,hhr,mmr,ssr,expor,mac_tr,mac_c1_tr,mac_c2_tr,mac_c3_tr,mac_f1_tr,$
        mac_f2_tr,mac_f3_tr,ymd1,time1,tsec_obs1,yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1,$
        mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t,fna,fnum1,expos,cexp,change

      time1_0=time1(0)
      time(i,0:fnum1-1)=time1(0:fnum1-1)-time1_0
      for p1=0,fix(fnum1/sstep)-1 do begin
        pnum1=p1*sstep
        ave_expo(i,p1)=expos(pnum1)
      endfor
;      dt=fltarr(fnum1) & dt(*)=ave_expo(*)-ave_expo(0)

      print, expos
 ;     print, ave_expo

      count_to_rayleigh_count,imagetotal_1o,radcorrect,radfile,imode,j+1,res,expos,fnum1,imagetotal_linear,imagetotal_log10,mac_count

      if imode eq 1 then begin
        if j eq 0 then begin
          thres=180
          fitfac=2
;          fac=0.94
        endif else if j eq 1 then begin
          thres=180
          fitfac=2
;          fac=0.95
        endif else begin
          thres=300
          fitfac=3
;          fac=0.93
        endelse
      endif else begin
        thres=9999
      endelse

      orbfind_new,fna,orbnum,orbdir,orbfile
      read_orbit_data_L1,orbfile,fnum1,ymd1,time1,orbtime,orbsatglat1,orbsatglon1,orbsatalt1,$
         glatfoot,glonfoot,altfoot,invlat,mlt,satglat2,satglon2,satalt2
      printf,10,'Orbit file=',orbfile
      printf,10,'satglat, time sequence is the same as exposure time= ',satglat2
      printf,10,'satglon, time sequence is the same as exposure time= ',satglon2

      satglat(i)=satglat2(n_elements(satglat2)/2)

      p=0
      med1=0.0
      thres=99999.9
      for st=0,fnum1-1-dur,sstep do begin
        et=st+dur
        p=fix(st/sstep)
        printf,10,'st,et ',st,et

        for x=0,res-1 do begin
          for y=0,res-1 do begin
            result=moment(mac_count(x,y,st:et))
            ave_imagetotal_o(x,y,j,i,p)=result(0)
            if result(0) lt thres then begin
              ave_imagetotal(x,y,j,i,p)=result(0)
            endif else begin
              ave_imagetotal(x,y,j,i,p)=0
            endelse
          endfor
        endfor


        sd_dev=0.0

        for x=0,res-1 do begin
          for y=0,res-1 do begin
            if ave_imagetotal(x,y,j,i,p) eq 0 then begin
              x0=x-2 & if x0 lt 0 then x0=0
              x1=x+2 & if x1 ge res then x1=res-1
              y0=y-2 & if y0 lt 0 then y0=0
              y1=y+2 & if y1 ge res then y1=res-1
              nu=0
              ave=0.0
              for xi=x0,x1-1 do begin
                for yi=y0,y1-1 do begin
                  nu=nu+1
                  if ave_imagetotal(xi,yi,j,i) gt 0 then ave=ave+ave_imagetotal(xi,yi,j,i,p)
                endfor
              endfor
              ave_imagetotal(x,y,j,i,p)=ave/float(nu)
            endif
          endfor
        endfor

;       med_imagetotal(*,*,j,i)=median(ave_imagetotal(*,*,j,i),med_coef)
        med_imagetotal(*,*,j,i,p)=median(ave_imagetotal(*,*,j,i,p),med_coef,/even)
        if imode eq 0 then begin
          smo_imagetotal(*,*,j,i,p)=smooth(med_imagetotal(*,*,j,i,p),smo_coef,/EDGE_TRUNCATE)
        endif else begin
;          smo_imagetotal(*,*,j,i,p)=sfit(ave_imagetotal(*,*,j,i,p),fitfac)
          smo_imagetotal(*,*,j,i,p)=smooth(med_imagetotal(*,*,j,i,p),smo_coef,/EDGE_TRUNCATE)
        endelse

        dev_imagetotal(*,*,j,i,p)=ave_imagetotal(*,*,j,i,p)-smo_imagetotal(*,*,j,i,p)
        result=moment(dev_imagetotal(*,*,j,i,p))
        sd_dev=sqrt(result(1))
        dev_num(j,i,p)=n_elements(where(dev_imagetotal(*,*,j,i,p) gt 2*sd_dev))
;       fac=fltarr(3,2)
;       fac(0,0)=0.206
;       fac(1,0)=0.427
;       fac(2,0)=0.316
;       fac(0,1)=0.0266
;       fac(1,1)=0.0211
;       fac(2,1)=0.0216



        yy=fix(long(ymd1(0))/10000l)
        mm=fix((long(ymd1(0))-10000l*yy)/100)
        dd=long(ymd1(0))-10000l*yy-100*mm
        totalday,yy,mm,dd,md,td
        td=td+(yy-2005)*365

        result=moment(mac_t(st:et-1))
        ave_mac_t(i,p)=result(0)
        result=moment(mac_1t(st:et-1))
        ave_mac_ccd(0,i,p)=result(0)
        result=moment(mac_2t(st:et-1))
        ave_mac_ccd(1,i,p)=result(0)
        result=moment(mac_3t(st:et-1))
        ave_mac_ccd(2,i,p)=result(0)
        result=moment(mac_f1t(st:et-1))
        ave_mac_fil(0,i,p)=result(0)
        result=moment(mac_f2t(st:et-1))
        ave_mac_fil(1,i,p)=result(0)
        result=moment(mac_f3t(st:et-1))
        ave_mac_fil(2,i,p)=result(0)

        sn=fix(st+dur/2)
        printf,10,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
             mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
        if imode eq 0 then begin
          if j eq 0 and ave_mac_t(i,p) gt 0 and ave_mac_ccd(j,i,p) gt -80 and ave_mac_fil(j,i,p) gt -80 then begin
            printf,11,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            if satglat2(sn) gt 0 then begin
              printf,51,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endif else begin
              printf,61,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endelse

          endif else if j eq 1 and ave_mac_t(i,p) gt 0 and ave_mac_ccd(j,i,p) gt -80 and ave_mac_fil(j,i,p) gt -80 then begin
            printf,12,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            if satglat2(sn) gt 0 then begin
              printf,52,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endif else begin
              printf,62,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endelse

          endif else if j eq 2 and ave_mac_t(i,p) gt 0 and ave_mac_ccd(j,i,p) gt -80 and ave_mac_fil(j,i,p) gt -80 then begin
            printf,13,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            if satglat2(sn) gt 0 then begin
              printf,53,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endif else begin
              printf,63,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),$
                 mean(med_imagetotal(*,*,j,i,p)),mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endelse

          endif
        endif else if imode eq 1 then begin
          if j eq 0 and ave_mac_t(i,p) gt 0 and ave_mac_ccd(j,i,p) gt -80 and ave_mac_fil(j,i,p) gt -80 then begin
            printf,14,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            if satglat2(sn) gt 0 then begin
              printf,54,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endif else begin
              printf,64,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endelse

          endif else if j eq 1 and ave_mac_t(i,p) gt 0 and ave_mac_ccd(j,i,p) gt -80 and ave_mac_fil(j,i,p) gt -80 then begin
            printf,15,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            if satglat2(sn) gt 0 then begin
              printf,55,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endif else begin
              printf,65,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endelse

          endif else if j eq 2 and ave_mac_t(i,p) gt 0 and ave_mac_ccd(j,i,p) gt -80 and ave_mac_fil(j,i,p) gt -80 then begin
            printf,26,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            if satglat2(sn) gt 0 then begin
              printf,56,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endif else begin
              printf,66,format='(i2,2i5,i3,i4,1x,f8.1,3(1x,f7.3),2(1x,f7.3),1x,f5.1,1x,i2,i5)',i,st,et,p,td,time(i,sn),$
                 ave_mac_t(i,p),ave_mac_ccd(j,i,p),ave_mac_fil(j,i,p),mean(med_imagetotal(*,*,j,i,p)),$
                 mean(smo_imagetotal(*,*,j,i,p)),ave_expo(i,p),fix(satglat2(sn)/abs(satglat2(sn))),dev_num(j,i,p)
            endelse

          endif
        endif

      endfor

    nextfile2:
  endfor
endfor

nextfile1:

refnumi=intarr(2,2,3)
refnump=intarr(2,2,3)
addfac=fltarr(2,2,3)
alpha=fltarr(2,2,3)
beta=fltarr(2,2,3)
factor=fltarr(2,2,3)
rexpo=fltarr(2)

;for mode-0
refnumi(0,0,*)=[3,1,1]
;refnumi(0,1,*)=[12,12,12]
refnumi(0,1,*)=[3,1,1]
refnump(0,0,*)=[0,0,0]
refnump(0,1,*)=[0,0,0]
addfac(0,0,*)=[0.5,0.75,0.75]
addfac(0,1,*)=[0.,0.,0.]
alpha(0,0,*)=[0.9159,2.7882,2.4646]
;alpha(0,1,*)=[0.814,2.4233,1.1907]
alpha(0,1,*)=[0.814,2.415,1.1907]
beta(0,0,*)=[2.1601,4.8525,0.9204]
;beta(0,1,*)=[0.2017,4.3038,2.6961]
beta(0,1,*)=[-8.2259,4.424,-2.7381]
factor(0,0,*)=[0.9,1.0,0.97]
factor(0,1,*)=[1,1,1]
rexpo(0)=40.0

;for mode-1
;refnumi(1,0,*)=[6,6,6]
;refnumi(1,1,*)=[6,6,6]
;refnump(1,0,*)=[21,21,21]
;refnump(1,1,*)=[21,21,21]
refnumi(1,0,*)=[1,1,1]
refnumi(1,1,*)=[1,1,1]
refnump(1,0,*)=[0,0,0]
refnump(1,1,*)=[0,0,0]
;addfac(1,0,*)=[0.030405,0.030321,0.139175]
addfac(1,0,*)=[0.01,0.01,0.05]
addfac(1,1,*)=[0.030405,0.030321,0.139175]
addfac(*,*,*)=addfac(*,*,*)
;alpha(1,0,*)=[1.1146,2.1134,0.8849]
;alpha(1,1,*)=[1.1146,2.1134,0.8849]
alpha(1,0,*)=[0.541,1.3615,1.1813]
alpha(1,1,*)=[0.541,1.3615,1.1813]
;for refnumi=6,refnump=21
;beta(1,0,*)=[-1.4032,-0.1754,0.4347]
;beta(1,1,*)=[-1.4032,-0.1754,0.4347]
;for refnumi=1,refnump=1
beta(1,0,*)=[7.8003,8.7452,1.0191]
beta(1,1,*)=[7.8003,8.7452,1.0191]
factor(1,0,*)=[0.97,0.97,0.97]
factor(1,1,*)=[0.97,0.97,0.97]
rexpo(1)=609.0

for i=0,num-1 do begin
  for j=0,2 do begin
    for st=0,fnum_o(i,j)-1,sstep do begin
      et=st+dur
      sn=fix(st+dur/2)
      p=fix(st/sstep)
      if satglat(i) gt 0 then begin
        h=0
      endif else begin
        h=1
      endelse
      if imode eq 0 then begin
;        print, i,satglat(i),h

        fit_imagetotal(*,*,j,i,p)=(smo_imagetotal(*,*,j,refnumi(imode,h,j),refnump(imode,h,j))+$
             (ave_expo(i,p)-rexpo(0))*addfac(imode,h,j)+alpha(imode,h,j)*(ave_mac_t(i,p)-$
             ave_mac_t(refnumi(imode,h,j),refnump(imode,h,j)))+beta(imode,h,j))*factor(imode,h,j)
        dif_imagetotal(*,*,j,i,p)=smo_imagetotal(*,*,j,i,p)-fit_imagetotal(*,*,j,i,p)
      endif else begin
        fit_imagetotal(*,*,j,i,p)=(smo_imagetotal(*,*,j,refnumi(imode,h,j),refnump(imode,h,j))+$
             (ave_expo(i,p)-rexpo(1))*addfac(imode,h,j)+alpha(imode,h,j)*(ave_mac_t(i,p)-$
             ave_mac_t(refnumi(imode,h,j),refnump(imode,h,j)))+beta(imode,h,j))*factor(imode,h,j)
;        dif_imagetotal(*,*,j,i,p)=smo_imagetotal(*,*,j,i,p)-fit_imagetotal(*,*,j,i,p)
        dif_imagetotal(*,*,j,i,p)=ave_imagetotal(*,*,j,i,p)-fit_imagetotal(*,*,j,i,p)
;        if j eq 2 then stop
      endelse
    endfor
  endfor
endfor

if dataout eq 1 then begin

  openw,30,psdir+'dark_cal_data.txt'

  for im=0,1 do begin
    for hm=0,1 do begin
      for jm=0,2 do begin
        printf,30,format='(3i5)',im,hm,jm
        printf,30,format='(i5)',refnumi(im,hm,jm)
        printf,30,format='(i5)',refnump(im,hm,jm)
        printf,30,format='(f12.5)',addfac(im,hm,jm)
        printf,30,format='(f12.5)',alpha(im,hm,jm)
        printf,30,format='(f12.5)',beta(im,hm,jm)
        printf,30,format='(f12.5)',factor(im,hm,jm)
        printf,30,format='(f12.5)',rexpo(im)
        printf,30,format='(f12.5)',ave_mac_t(refnumi(im,hm,jm),refnump(im,hm,jm))
        printf,30,smo_imagetotal(*,*,jm,refnumi(im,hm,jm),refnump(im,hm,jm))
      endfor
    endfor
  endfor
  close,30

endif
stop


for st=0,max(fnum_o)-1,sstep do begin
  et=st+dur
  p=fix(st/sstep)

  psname=psdir+'darkframe'

  if st lt 10 then begin
    st1=7
  endif else if st lt 100 then begin
    st1=6
  endif else if st lt 1000 then begin
    st1=5
  endif else begin
    st1=4
  endelse
  if et lt 10 then begin
    et1=7
  endif else if et lt 100 then begin
    et1=6
  endif else if et lt 1000 then begin
    et1=5
  endif else begin
    et1=4
  endelse

  psname=psname+'_'+strmid(st,st1,8-st1)+'_'+strmid(et,et1,8-et1)+'_'
  print, psname

  if imode eq 0 then begin

  ich=0
;  MAC_PS_create_darkframe,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
;      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,$
;      smo_imagetotal,fit_imagetotal,dif_imagetotal,'Smoothed','Dark','Difference'
  MAC_PS_create_darkframe,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,$
      smo_imagetotal,fit_imagetotal,dev_imagetotal,'Smoothed','Dark','Difference'
  ich=1
;  MAC_PS_create_darkframe,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
;      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,$
;      smo_imagetotal,fit_imagetotal,dif_imagetotal,'Smoothed','Dark','Difference'
  MAC_PS_create_darkframe,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,$
      smo_imagetotal,fit_imagetotal,dev_imagetotal,'Smoothed','Dark','Difference'
  smin(1,0) = 70 & smax(1,0) = 250
  smin(1,1) = 70 & smax(1,1) = 250
  ich=2
;  MAC_PS_create_darkframe,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
;      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,$
;      smo_imagetotal,fit_imagetotal,dif_imagetotal,'Smoothed','Dark','Difference'
  MAC_PS_create_darkframe,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,$
      smo_imagetotal,fit_imagetotal,dev_imagetotal,'Smoothed','Dark','Difference'

  endif else begin

  ich=0
  MAC_PS_create_darkframe_1,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,ave_imagetotal,$
      smo_imagetotal,fit_imagetotal,dif_imagetotal,'Averaged','Smoothed','Dark','Difference'
  ich=1
  MAC_PS_create_darkframe_1,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,ave_imagetotal,$
      smo_imagetotal,fit_imagetotal,dif_imagetotal,'Averaged','Smoothed','Dark','Difference'
  smin(1,0) = 70 & smax(1,0) = 250
  smin(1,1) = 70 & smax(1,1) = 250
  ich=2
  MAC_PS_create_darkframe_1,ich,imode,num,p,res,smax,smin,fname1,psname,ave_expo,$
      ave_mac_t,ave_mac_ccd,ave_mac_fil,time,ave_imagetotal,$
      smo_imagetotal,fit_imagetotal,dif_imagetotal,'Averaged','Smoothed','Dark','Difference'

  endelse

endfor

programend:

close,/all

print, 'Normal End! '
END
