;******************************************************************
;    program MACimage_DARTS_L1_to_L2.pro
;          by TS on Apr 27, 2006
;******************************************************************
PRO MACimage_DARTS_L1_to_L2

;===== parameter set start ====================================================================

fdir1= 'H:\Index\DARTS\Level-1\'
;fdir1= 'C:\Usr\tsakanoi\Index\DARTS\Level-1\'
ymdir=['2005\09\','2005\10\','2005\11\','2005\12\','2006\01\','2006\02\','2006\03\']
;ymdir=['each\']
ymnum=n_elements(ymdir)

outdir='H:\Index\DARTS\Level-2'

;status file read? yes-1
ista=1

;footprint plotting
footp=1
;fovdir='C:\Usr\tsakanoi\Index\DARTS\Level-2\MACFOV\'
fovdir='H:\Index\DARTS\Level-2\MACFOV\'
;fovdir='C:\cygwin\home\Administrator\MAC_FOV\macfov060320_2\work\'

; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
radimagefile='051110004943_radcorrect_flame2.dat'
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0

; count to rayleigh convertion yes=1
rayleigh=1

; offsets of the direction of field-of-view for each channel of MAC
; !!! These values are tentative !!! should be revised soon !!!
xoffset=intarr(3)
yoffset=intarr(3)
xoffset1=dblarr(3)
yoffset1=dblarr(3)
theta=dblarr(3)
phi=dblarr(3)
theta1=dblarr(3)
phi1=dblarr(3)
phi1=[-0.187481079,-0.557762731,-0.737182143]
theta1=[45.5681735,46.1965292,45.9116745]

xoffset1(0)=( (-0.5)*tan( (phi1(1)-phi1(0))*3.14159265d*2.0d/360.0d) / tan(7.56/64.0*3.14159265d*2.0d/360.0d) )
yoffset1(0)=( 1.1*tan((theta1(1)-theta1(0))*3.14159265d*2.0d/360.0d) / tan(7.56/64.0*3.14159265d*2.0d/360.0d) )
xoffset1(1)=0.0
yoffset1(1)=0.0
xoffset1(2)=( 3.5*tan( (phi1(1)-phi1(2))*3.14159265d*2.0d/360.0d) / tan(7.56/64.0*3.14159265d*2.0d/360.0d) )
yoffset1(2)=( 1.4*tan((theta1(1)-theta1(2))*3.14159265d*2.0d/360.0d) / tan(7.56/64.0*3.14159265d*2.0d/360.0d) )

xoffset(*)=fix(xoffset1(*))
yoffset(*)=fix(yoffset1(*))

phi(0)=phi1(1)-atan((-0.5)*tan((phi1(1)-phi1(0))*3.14159265d*2.0d/360.0d))*360d/2d/3.14d
phi(1)=phi1(1)
phi(2)=phi1(1)-atan((3.5)*tan((phi1(1)-phi1(2))*3.14159265d*2.0d/360.0d))*360d/2d/3.14d
theta(0)=theta1(1)-atan(1.1*tan((theta1(1)-theta1(0))*3.14159265d*2.0d/360.0d))*360d/2d/3.14d
theta(1)=theta1(1)
theta(2)=theta1(1)-atan(1.4*tan((theta1(1)-theta1(2))*3.14159265d*2.0d/360.0d))*360d/2d/3.14d


;===== parameter set end========================================================================

close,/all

for jj=0, ymnum-1 do begin

;--- finding file name -------------------------------------
  fdir=fdir1+ymdir(jj)

  print, '---data process start---'

  fnanum1=n_elements(findfile(fdir+'*MAC*'))
  fna1=strarr(fnanum1)
  fna1=findfile(fdir+'*MAC*')
  fna=''

  for i=0,fnanum1-1 do begin

;--- determine observation mode (0-3) ----------------------
    imode= fix(strmid(fna1(i),strlen(fdir)+9,1))
    print, 'mode ',imode

    if imode eq 0 or imode eq 1 then begin
      ibin=16
      res=64
    endif else if imode eq 2 then begin
      ibin=2
      res=512
    endif else begin
      ibin=8
      res=128
    endelse

;--- reading MAC L1 data ----------------------------------------
    fna=fna1(i)
    read_L1data,fna,imode,res,ymd1,time1,ti1,temp1,imagetotal_1o,fnum1

;--- reading status parameters from L1 status file --------------
    staexis=0
    if ista eq 1 then begin
      stafind_1day,fna,stanum,stadir,stafile

      if max(strlen(stafile)) gt 0 then begin

        print, stafile
        print, 'STA file reading...'
        status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
          mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
          mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
          esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
          esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
          esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
          rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

;--- change exposure time from EST number to time in msec ------------------------
        print, 'Changing from EST number to exposure time in msec...'
        est_to_sec,mac_exposurer,expor
        for ii=0, n_elements(expor)-2 do begin
          if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
          if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
        endfor
        cadd=''
        staexis=1

      endif else begin
        expor=41.0
        cadd='_no_stafile'
        staexis=0
      endelse
    endif

    if ista eq 1 and max(strlen(stafile)) gt 0 then begin

;--- compare between time in MAC-L1 data and time in status-L1 data ----------------
;---   and interporate exposure time for MAC-L1 data                ----------------
      print, 'Finding obseravation time and exposure time...'
      find_obstime_hhmmss,yyr,mor,ddr,hhr,mmr,ssr,expor,ymd1,time1,tsec_obs1,$
        yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1

      expos=fltarr(fnum1)

      if max(expo_obs1) eq 0 then begin
        if max(expor) eq 0 then begin
          expos(*)=60.0
        endif else begin
          expos(*)=expor(max(where(expor gt 0)))
        endelse
        cexp=' assumed'
      endif else begin
        expos(*)=expo_obs1(*)
        cexp=''
      endelse
    endif else begin
      expos=fltarr(fnum1)
      expos(*)=60.0
      cexp=' assumed'

    endelse

;--- conversion from count to rayleigh ----------------------------------------------
    if rayleigh eq 1 then begin
      if max(imagetotal_1o) gt 0 then begin
        exposure_1=fltarr(fnum1)
        exposure_1(*)=expos
        count_to_rayleigh,imagetotal_1o,radcorrect,radimagefile,imode,1,res,exposure_1,fnum1,imagetotal_linear_1,imagetotal_log10_1
          imagetotal_1=fltarr(res,res,fnum1)
        imagetotal_1=imagetotal_linear_1
      endif
    endif

;--- correction of radiation-damaged pixel data --------------------------------------
    if simple_radcorrect eq 1 then begin
      radimage=fltarr(3,res,res)
      openr,2,radimagefile
      readf,2,radimage
      close,2
      imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
      imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
      imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
      imagetotal_1(where(imagetotal_1 lt 0)) =0
      imagetotal_2(where(imagetotal_2 lt 0)) =0
      imagetotal_3(where(imagetotal_3 lt 0)) =0
    endif

;--- calculaion of footprint direction in the satellite coordinated system
    if footp eq 1 and staexis eq 1 and max(imagetotal_1) gt 0 then begin

      symd1=ymd1(0)
      eymd1=ymd1(n_elements(ymd1)-1)
      stime1=tsec_obs1(0)
      etime1=tsec_obs1(n_elements(tsec_obs1)-1)

      sub_fov_read,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
        footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
        lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
        lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
        lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum

      if fovnum eq 0 then goto, nextfootp

      kn=n_elements(tsec_obs1)

      fov_pixel_dir_n,theta,phi,res,ch,fovx,fovy,fovz
      find_footp_dir,fovnum,footdirsx,footdirsy,footdirsz,res,fovx,fovy,fovz,footpixx1,footpixy1

      footpixx1n=intarr(kn)
      footpixy1n=intarr(kn)
      footpixx1n=fix(interpol(footpixx1,timfov,tsec_obs1))
      footpixy1n=fix(interpol(footpixy1,timfov,tsec_obs1))

      nextfootp:

    endif

;--- data output ----------------------------------------------------------------------
    outname=strmid(fna1(i),0,strlen(fna1(i))-1)+'2'+cadd

;    MAC_create_L2,nstep,simul,imode,irot,fnum1,iut,iti,select_frame,pnums,pnume,igrey,fact,fac,ilog,res,smax,smin,fna,psname,exposure_1,cexp,time1,time2,time3,ti1,ti2,ti3,ymd1,ymd2,ymd3,imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3

  endfor
endfor

print, 'Normal End! '
END
