;******************************************************************
;    program MACimage_DARTS_L2_make
;       rev. from MACimage_DARTS_L1_PS_multi_color_auto_map on Aug. 2006
;       rev. from MACimage_DARTS_L1_animation_color_auto on Jan 16 2006
;          by TS
;******************************************************************

PRO MACimage_DARTS_L2_make

;input
fdir1= 'E:\Usr\tsakanoi\Index\DARTS\Level-1\'
;output
fdirl21= 'C:\Usr\tsakanoi\Index\DARTS\Level-2\'
fdirl2d1= fdirl21
;fdir1= 'C:\Usr\tsakanoi\Index\DARTS\Level-1\'
;
;ymdir=['2005\12\','2006\01\','2006\02\','2006\03\','2006\04\','2006\05\','2006\06\','2006\07\','2005\11\','2005\10\']
;ymdir=['2006\02\','2005\10\','2005\11\','2006\03\','2006\04\','2006\05\','2006\06\']
;ymdir=['2005\10\','2005\11\','2005\12\','2006\01\','2006\02\','2006\03\']
ymdir=['2005\12\']
;ymdir=['2005\12\b\']
;ymdir=['2006\07\']
;ymdir=['each\']
ymnum=n_elements(ymdir)


;status file read? yes-1
ista=1
;status file type 1-1month total file, 0-1day file
istatype=0

;mode-2 L2-data analysis and output? yes-1 no-0
imode2out=0
;mode-3 L2-data analysis and output? yes-1 no-0
imode3out=1

;mapping altitude, ground-0, certain altitude-1
imapalt=1
;if imapalt=1, specify altitude below:
mapalt=110.0d

;footprint plotting 1 yes
footp=1
fovdir='E:\Usr\tsakanoi\Index\DARTS\Level-2\MACFOV\'
;fovdir='D:\Index\DARTS\Level-2\MACFOV\'
;fovdir='C:\Usr\tsakanoi\Index\MAC_FOV\landpointing\'
;--- if you choose landpointing directory, set nstep=1, and sub_fov_read_land_land.
;fovdir='C:\cygwin\home\Administrator\MAC_FOV\macfov060320_2\work\'

kxshift=0
kyshift=0

;offsets for alignment adjust
;phioffset=dblarr(3)
;tetaoffset=dblarr(3)
;phioffset1=dblarr(3)
;tetaoffset1=dblarr(3)
;teta=dblarr(3)
;phi=dblarr(3)
;teta1=dblarr(3)
;phi1=dblarr(3)

;phi1=[-0.187481079,-0.557762731,-0.737182143]
;teta1=[45.5681735,46.1965292,45.9116745]
;phioffset1(0)=0.0
;tetaoffset1(0)=0.0
;phioffset1(1)=0.0
;tetaoffset1(1)=0.0
;phioffset1(2)=0.3
;tetaoffset1(2)=-0.68
;phi(2)=phi1(2)+phioffset1(2)
;teta(2)=teta1(2)+tetaoffset1(2)
;phi(0)=phi(2)+0.44302663d
;teta(0)=teta(2)-0.29254145d
;phi(1)=phi(2)+0.51826331d
;teta(1)=teta(2)+0.39899596d


; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
;radimagefile='H:\Index\obs\051110\051110004943_radcorrect_flame2.dat'
radimagefile=''
; count to rayleigh convertion yes=1
rayleigh=1
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0

if radcorrect eq 1 then rayleigh=1

select_frame=0
;select_frame=0 then all frame are played

;nstep plotting image step
;nstep0 for mode0, nstep1 for mode1, nstep2 for mode2, nstep3 for mode3
;nstep=16
;nstep0=1
nstep0=24
nstep1=1
nstep2=1
nstep3=1
timres=0.0

;exman : exposure time manual setting=1
exman=0
expos1=60.0

;PS file overwrite? yes-1 no-0
ioverw=0

;log10 scale intensity yes=1
ilog=0

debug=0
cadd=''

errorsumt=0l
dummysum=0l

;=====parameter end=====

close,/all

for jj=0, ymnum-1 do begin

l2dir=fdirl21+'MAC_L2\'+ymdir(jj)
l2dird=fdirl2d1+'MAC_L2\result\'+ymdir(jj)

print, fdir1,l2dir

fdir=fdir1+ymdir(jj)

filesel=''
;mpgdir=strmid(fdir,0,15)+'PS\'+strmid(fdir,15,16)
;print, jj,fdir,mpgdir
;
print, '---data process start---'
;
find_L1data_combination,fdir+filesel,fna1,fna2,fna3,fnanum1,fnum1_1,fnum2_1,fnum3_1,fnum2o_1,fnum3o_1,$
   mode1_1,mode2_1,mode3_1,numo_2,fnum2_2,fnum3_2,mode2_2,mode3_2,numo_3,fnum3_3,mode3_3
;stop

;  number of data: 0 to fnanum1-1
;  file combination: fnum1_1(i),fnum2_1(i),fnum3_1(i)
;      available only when fnum2o_1=1 and/or fnum3o_1=1
;  mode: mode1_1(i),mode2_1(i),mode3_1(i)
;      available only when mode1_1(i), mode2_1(i),mode3_1(i)>=0
;---ch2-3,and 2
;  number of data: 0 to numo_2-1
;  file combination: fnum2_2(i),fnum3_2(i)
;      available only when fnum2o_1=2 and/or fnum3o_1=2
;  mode: mode2_2(i),mode3_2(i)
;      available only when mode2_2(i), mode3_2(i)>=0
;---ch3
;  number of data: 0 to numo_3-1
;  file combination: fnum3_3(i)
;      available only when fnum3o_1=3
;  mode: mode3_3(i)
;      available only when mode3_3(i)>=0

;if debug eq 1 then print,fna1,fna2,fna3
;print, fna1,fna2,fna3

;if debug eq 1 then goto, debug_end

print, ' === for channels 1-2-3, 1-2, 1-3, and 1 ==='
for i=0,fnanum1-1 do begin
  simul=0
  chn=''
  if fnum1_1(i) ge 0 then begin
    simul=simul+1 & chn=chn+'1' & print, i,fna1(fnum1_1(i))
    l2name_1=l2dir+strmid(fna1(fnum1_1(i)),strpos(fna1(fnum1_1(i)),'RE'),26)+'L2'
  endif else begin
    l2name_1=''
  endelse
  if fnum2_1(i) ge 0 then begin
    simul=simul+1 & chn=chn+'2' & print, fna2(fnum2_1(i))
    l2name_2=l2dir+strmid(fna2(fnum2_1(i)),strpos(fna2(fnum2_1(i)),'RE'),26)+'L2'
  endif else begin
    l2name_2=''
  endelse
  if fnum3_1(i) ge 0 then begin
    simul=simul+1 & chn=chn+'3' & print, fna3(fnum3_1(i))
    l2name_3=l2dir+strmid(fna3(fnum3_1(i)),strpos(fna3(fnum3_1(i)),'RE'),26)+'L2'
  endif else begin
    l2name_3=''
  endelse

  print, simul,'==============================='


  print, l2name_1,l2name_2,l2name_3,i

  mpnum1=strlen((findfile(l2name_1)))
  if max(mpnum1) ge 1 and ioverw eq 0 then begin
    print,'this L2 file already exist'
    goto, nextfile1
  endif

  dummysum=dummysum+1
  ndummysum=fix(dummysum/10)+1
  cdummysum=strmid(string(dummysum),strlen(dummysum)-1,ndummysum)
;  openw,37,psdir+'MAC'+strmid(fna1(fnum1_1(i)),strlen(fdir)+11,14)+strmid(fna1(fnum1_1(i)),strlen(fdir)+8,3)+'CH'+chn+'_L1_map_'+cdummysum+'.dummy'
  openw,37,l2dird+'MAC'+strmid(fna1(fnum1_1(i)),strlen(fdir)+11,14)+strmid(fna1(fnum1_1(i)),strlen(fdir)+8,3)+'CH'+chn+'_L2_'+cdummysum+'_result.txt'
    printf,37,'Program proceeding result'

  imode=mode1_1(i)
  imode2=mode2_1(i)
  imode3=mode3_1(i)
  print, 'mode ',imode,imode2,imode3
  printf,37,'Simultaneous channels, mode1,mode2,mode3= ',simul,imode,imode2,imode3

  if imode2out eq 0 and imode eq 2 then goto,nextfile1
  if imode3out eq 0 and imode eq 3 then goto,nextfile1

  if imode eq 0 or imode eq 1 then begin
    ibin=16
    res=64
    anime_fac=3.0
    if imode eq 0 then begin
      nstep=nstep0
      timres=0.12*nstep
    endif else begin
      nstep=nstep1
      timres=1.0*nstep
    endelse
  endif else if imode eq 2 then begin
    ibin=2
    res=512
    nstep=nstep2
    timres=4.04*nstep
  endif else begin
    ibin=8
    res=128
    nstep=nstep3
    timres=0.48*nstep
  endelse

  fna=fna1(fnum1_1(i))
  read_L1data,fna,imode,res,ymd1,time1,ti1,temp1,imagetotal_1o,fnum1
;  stop
  printf,37,'Ch1 file name, fnum= ',fna,fnum1
  printf,37,'start and end times= ',time1(0),time1(fnum1-1)
   if fnum2_1(i) ge 0 then begin
    fna=fna2(fnum2_1(i))
    read_L1data,fna,imode,res,ymd2,time2,ti2,temp2,imagetotal_2o,fnum2
  printf,37,'Ch2 file name, fnum= ',fna,fnum2
  printf,37,'start and end times= ',time2(0),time2(fnum2-1)
  endif else begin
    time2=0
    ti2=0
    ymd2=0
    temp2=0
    imagetotal_2o=0
    fnum2=fnum1
  endelse
  if fnum3_1(i) ge 0 then begin
    fna=fna3(fnum3_1(i))
    read_L1data,fna,imode,res,ymd3,time3,ti3,temp3,imagetotal_3o,fnum3
  printf,37,'Ch3 file name, fnum= ',fna,fnum3
  printf,37,'start and end times= ',time3(0),time3(fnum3-1)
    printf,37,fna,fnum3
  endif else begin
    time3=0
    ti3=0
    ymd3=0
    temp3=0
    imagetotal_3o=0
    fnum3=fnum1
  endelse


;reading status parameters from L1 status file --------------
staexis=0
if ista eq 1 and istatype eq 0 then begin
  stafind_1day,fna,stanum,stadir,stafile
  printf,37,'STA file=',stafile

  if max(strlen(stafile)) gt 0 then begin

    if debug eq 1 then print, stanum
    print, stafile
    print, 'STA file reading...'
    status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
      mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
      mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
      esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
      esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
      esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
      rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

    print, 'Changing from EST number to exposure time in msec...'
    est_to_sec,mac_exposurer,expor
    for ii=0, n_elements(expor)-2 do begin
      if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
      if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
    endfor
    staexis=1
  endif else begin
    totalday,yyr(0),mor(0),ddr(0),md,td
    if imode eq 0 then begin
      if yyr(0) eq 2005 and (td le 305 or (td eq 306 and h lt 3)) then begin
        expor=40.0
      endif else begin
        expor=60.0
      endelse
    endif else begin
      expor=899.0
    endelse
    staexis=0
  endelse

endif

if ista eq 1 and max(strlen(stafile)) gt 0 then begin
  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss_l2,yyr,mor,ddr,hhr,mmr,ssr,expor,mac_tr,mac_c1_tr,mac_c2_tr,mac_c3_tr,mac_f1_tr,$
    mac_f2_tr,mac_f3_tr,ymd1,time1,tsec_obs1,yy_obs1,mo_obs1,dd_obs1,hh_obs1,mm_obs1,ss_obs1,expo_obs1,$
    mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t

  expos=fltarr(fnum1)

  if max(expo_obs1) eq 0 then begin
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
    printf,37,'exposure time assumed! case A, time and exposure time= ',time1,expos
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs1(*)
    cexp=''
    printf,37,'time and exposure time= ',time1,expos
  endelse
endif else begin
  expos=fltarr(fnum1)
  expos(*)=60.0
  cexp=' assumed'
  printf,37,'exposure time assumed! case B, time and exposure time= ',time1,expos
endelse


if exman eq 1 then begin
  expos=fltarr(fnum1)
  expos(*)=expos1
endif

y = 0.0072x + 10.39
y = 0.0663x + 7.8369

fnum=fnum1
if expos(0) ne expos(fnum-1) then begin
  n1=n_elements(where(expos(0) eq expos(*)))
  n2=n_elements(where(expos(fnum-1) eq expos(*)))
  if n1 gt n2 then begin
    expos(*)=expos(0)
  endif else begin
    expos(*)=expos(fnum-1)
  endelse
endif

m1=where((mac_t) lt 3.0)
m2=where((mac_t) ge 3.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_t(m1(e1))=mac_t(dm)
  endfor
stop
endif

m1=where((mac_1t) lt -30.0)
m2=where((mac_1t) ge -30.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_1t(m1(e1))=mac_1t(dm)
  endfor
stop
endif

m1=where((mac_2t) lt -30.0)
m2=where((mac_2t) ge -30.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_2t(m1(e1))=mac_2t(dm)
  endfor
stop
endif

m1=where((mac_3t) lt -30.0)
m2=where((mac_3t) ge -30.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_3t(m1(e1))=mac_3t(dm)
  endfor
stop
endif

m1=where((mac_f1t) lt 0.0)
m2=where((mac_f1t) ge 0.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_f1t(m1(e1))=mac_f1t(dm)
  endfor
stop
endif

m1=where((mac_f2t) lt 0.0)
m2=where((mac_f2t) ge 0.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_f2t(m1(e1))=mac_f2t(dm)
  endfor
stop
endif

m1=where((mac_f3t) lt 0.0)
m2=where((mac_f3t) ge 0.0)
if max(m1) ge 0 then begin
  for e1=0,n_elements(m1)-1 do begin
    dm1=abs(max(m2)-m1(e1))
    dm2=abs(min(m2)-m1(e1))
    if dm1 lt dm2 then begin
      dm=max(m2)
    endif else begin
      dm=min(m2)
    endelse
    mac_f3t(m1(e1))=mac_f3t(dm)
  endfor
stop
endif

   if rayleigh eq 1 then begin
    if max(imagetotal_1o) gt 0 then begin
     exposure_1=fltarr(fnum1)
     exposure_1(*)=expos
     count_to_rayleigh,imagetotal_1o,radcorrect,radimagefile,imode,1,res,exposure_1,fnum1,imagetotal_linear_1,imagetotal_log10_1
     imagetotal_1=fltarr(res,res,fnum1)
     if ilog eq 1 then begin
       imagetotal_1=imagetotal_log10_1
     endif else begin
       imagetotal_1=imagetotal_linear_1
     endelse
    endif else begin
      imagetotal_1=0
    endelse
    if max(imagetotal_2o) gt 0 then begin
     exposure_2=fltarr(fnum2)
     if n_elements(exposure_2) ne n_elements(expos) then begin
       if fnum2 gt fnum1 then begin
         exposure_2(0:fnum1-1)=expos(*)
         exposure_2(fnum1:fnum2-1)=expos(fnum1-1)
       endif else begin
         exposure_2(*)=expos(0:fnum2-1)
       endelse
      endif else begin
       exposure_2(*)=expos
     endelse
     count_to_rayleigh,imagetotal_2o,radcorrect,radimagefile,imode,2,res,exposure_2,fnum2,imagetotal_linear_2,imagetotal_log10_2
     imagetotal_2=fltarr(res,res,fnum2)
     if ilog eq 1 then begin
       imagetotal_2=imagetotal_log10_2
     endif else begin
       imagetotal_2=imagetotal_linear_2
     endelse
    endif else begin
      imagetotal_2=0
    endelse
    if max(imagetotal_3o) gt 0 then begin
     exposure_3=fltarr(fnum3)
     if n_elements(exposure_3) ne n_elements(expos) then begin
       if fnum3 gt fnum1 then begin
         exposure_3(0:fnum1-1)=expos(*)
         exposure_3(fnum1:fnum3-1)=expos(fnum1-1)
       endif else begin
         exposure_3(*)=expos(0:fnum3-1)
       endelse

     endif else begin
        exposure_3(*)=expos
     endelse
     count_to_rayleigh,imagetotal_3o,radcorrect,radimagefile,imode,3,res,exposure_3,fnum3,imagetotal_linear_3,imagetotal_log10_3
     imagetotal_3=fltarr(res,res,fnum3)
     if ilog eq 1 then begin
       imagetotal_3=imagetotal_log10_3
     endif else begin
       imagetotal_3=imagetotal_linear_3
     endelse
    endif else begin
      imagetotal_3=0
    endelse
   endif else begin
     imagetotal_1=fltarr(res,res,fnum1)
     imagetotal_2=fltarr(res,res,fnum2)
     imagetotal_3=fltarr(res,res,fnum3)
     imagetotal_1=imagetotal_1o
     imagetotal_2=imagetotal_2o
     imagetotal_3=imagetotal_3o
   endelse
   if simple_radcorrect eq 1 then begin
     radimage=fltarr(3,res,res)
     openr,2,radimagefile
     readf,2,radimage
     close,2
     imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
     imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
     imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
     imagetotal_1(where(imagetotal_1 lt 0)) =0
     imagetotal_2(where(imagetotal_2 lt 0)) =0
     imagetotal_3(where(imagetotal_3 lt 0)) =0
   endif

if footp eq 1 and staexis eq 1 and max(imagetotal_1) gt 0 then begin

;---reading att L1 data
  attfind,fna,attnum,attdir,attfile
  read_attdata_L1,attfile,dataintarval,fnum1,ymd1,time1,q1c,q2c,q3c,q4c,idate1,itime1
  printf,37,'ATT file= ',attfile
  printf,37,'q-values, time sequence is the same as exposure time'
  printf,37,'q1= ',q1c
  printf,37,'q2= ',q2c
  printf,37,'q3= ',q3c
  printf,37,'q4= ',q4c
  orbfind_new,fna,orbnum,orbdir,orbfile
  read_orbit_data_L1,orbfile,fnum1,ymd1,time1,orbtime,orbsatglat1,orbsatglon1,orbsatalt1,$
     glatfoot,glonfoot,altfoot,invlat,mlt,satglat2,satglon2,satalt2
  printf,37,'Orbit file=',orbfile
  printf,37,'satglat, time sequence is the same as exposure time= ',satglat2
  printf,37,'satglon, time sequence is the same as exposure time= ',satglon2

  symd1=ymd1(0)
  eymd1=ymd1(n_elements(ymd1)-1)
  stime1=tsec_obs1(0)
  etime1=tsec_obs1(n_elements(tsec_obs1)-1)

if res ne 512 then begin
;  sub_fov_read_land_land,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
  sub_fov_read_land,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum

endif else begin
;  sub_fov_read_land_land,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
  sub_fov_read_land,fovdir,symd1,stime1,eymd1,etime1,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum

endelse

  printf,37,'macfov fovdir,fovnum= ',fovdir,fovnum
  if fovnum gt 0 then printf,37,'footdirx= ',footdirx

  glon=fltarr(res,res,fnum1,3)
  glat=fltarr(res,res,fnum1,3)
  ch=0
  fovdet_ino_n_alt,res,ch,fnum1,nstep,ymd1,time1,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
     fovx1,fovy1,fovz1,macfovgeix1,macfovgeiy1,macfovgeiz1,glat1,glon1,galt1,errorsum,imapalt,mapalt
  glon(*,*,*,ch)=glon1(*,*,*)
  glat(*,*,*,ch)=glat1(*,*,*)
  print, 'ch1 errorsum=',errorsum
  errorsum1=errorsum

  numg1=n_elements(where(glat1(0,0,*) ne 0))
  if numg1 gt 1 then begin
    printf,37,'Ch1: fovdet_ino_n glat1,glon1, and errorsum= ',glat1(0,0,where(glat1(0,0,*) ne 0)),glon1(0,0,where(glon1(0,0,*) ne 0)),errorsum
  endif else begin
    printf,37,'Ch1: fovdet_ino_n glat1,glon1, and errorsum= ',0.0,0.0,errorsum
  endelse

  ch=1
  fovdet_ino_n_alt,res,ch,fnum1,nstep,ymd1,time1,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
     fovx2,fovy2,fovz2,macfovgeix2,macfovgeiy2,macfovgeiz2,glat1,glon1,galt1,errorsum,imapalt,mapalt
  glon(*,*,*,ch)=glon1(*,*,*)
  glat(*,*,*,ch)=glat1(*,*,*)
  print, 'ch2 errorsum=',errorsum
  errorsum2=errorsum
  numg1=n_elements(where(glat1(0,0,*) ne 0))
  if numg1 gt 1 then begin
    printf,37,'Ch2: fovdet_ino_n glat1,glon1, and errorsum= ',glat1(0,0,where(glat1(0,0,*) ne 0)),glon1(0,0,where(glon1(0,0,*) ne 0)),errorsum
  endif else begin
    printf,37,'Ch2: fovdet_ino_n glat1,glon1, and errorsum= ',0.0,0.0,errorsum
  endelse

  ch=2
  fovdet_ino_n_alt,res,ch,fnum1,nstep,ymd1,time1,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
     fovx3,fovy3,fovz3,macfovgeix3,macfovgeiy3,macfovgeiz3,glat1,glon1,galt1,errorsum,imapalt,mapalt
  glon(*,*,*,ch)=glon1(*,*,*)
  glat(*,*,*,ch)=glat1(*,*,*)
  print, 'ch3 errorsum=',errorsum
  errorsum3=errorsum
  numg1=n_elements(where(glat1(0,0,*) ne 0))
  if numg1 gt 1 then begin
    printf,37,'Ch3: fovdet_ino_n glat1,glon1, and errorsum= ',glat1(0,0,where(glat1(0,0,*) ne 0)),glon1(0,0,where(glon1(0,0,*) ne 0)),errorsum
  endif else begin
    printf,37,'Ch3: fovdet_ino_n glat1,glon1, and errorsum= ',0.0,0.0,errorsum
  endelse

  errorsumt=errorsum1+errorsum2+errorsum3
 ; if errorsumt gt 1 then stop

;  if max(glat(*,*,*,*)) eq 0 and max(glon(*,*,*,*)) eq 0 and min(glat(*,*,*,*)) eq -999,9 and $
;    min(glon(*,*,*,*)) eq -999.9 then goto, nextfile1

  kn=n_elements(tsec_obs1)

  footpixx1n=intarr(kn)&footpixx1n(*)=-9
  footpixy1n=intarr(kn)&footpixy1n(*)=-9
  footpixx2n=intarr(kn)&footpixx2n(*)=-9
  footpixy2n=intarr(kn)&footpixy2n(*)=-9
  footpixx3n=intarr(kn)&footpixx3n(*)=-9
  footpixy3n=intarr(kn)&footpixy3n(*)=-9
  footpixx1m=intarr(kn)&footpixx1m(*)=-9
  footpixy1m=intarr(kn)&footpixy1m(*)=-9
  footpixx2m=intarr(kn)&footpixx2m(*)=-9
  footpixy2m=intarr(kn)&footpixy2m(*)=-9
  footpixx3m=intarr(kn)&footpixx3m(*)=-9
  footpixy3m=intarr(kn)&footpixy3m(*)=-9

  footlatn=fltarr(kn)&footlatn(*)=-99.9
  footlonn=fltarr(kn)&footlonn(*)=-999.9
  footaltn=fltarr(kn)&footaltn(*)=-99.9
  footdirxn=fltarr(kn)&footdirxn(*)=-9.9
  footdiryn=fltarr(kn)&footdiryn(*)=-9.9
  footdirzn=fltarr(kn)&footdirzn(*)=-9.9

  if errorsumt gt 10000 then goto, interpol_fov1

  if fovnum le 1 then goto, nextfootp

  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx1,fovy1,fovz1,footpixx1,footpixy1
  print, (fovy1(0,0)-fovy1(res-1,0))*360/2/3.14
  if   (fovy1(0,0)-fovy1(res-1,0))*360/2/3.14 lt 7 then begin
    print,'abnormal end, maybe you should reboot idl'
    stop
  endif
  printf,37,'Ch1:find_footp_dir_n kxshift,kyshift,fovx1(0,0),fovy1(0,0),fovz1(0,0)= ',kxshift,kyshift,fovx1(0,0),fovy1(0,0),fovz1(0,0)
  printf,37,'Ch1:footpixx1,footpixy1= ',footpixx1,footpixy1

  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx2,fovy2,fovz2,footpixx2,footpixy2
  print, (fovy2(0,0)-fovy2(res-1,0))*360/2/3.14
  if   (fovy2(0,0)-fovy2(res-1,0))*360/2/3.14 lt 7 then begin
    print,'abnormal end, maybe you should reboot idl'
    stop
  endif
  printf,37,'Ch2:find_footp_dir_n kxshift,kyshift,fovx2(0,0),fovy2(0,0),fovz2(0,0)= ',kxshift,kyshift,fovx2(0,0),fovy2(0,0),fovz2(0,0)
  printf,37,'Ch2:footpixx2,footpixy2= ',footpixx2,footpixy2

  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx3,fovy3,fovz3,footpixx3,footpixy3
  print, (fovy3(0,0)-fovy3(res-1,0))*360/2/3.14
  if   (fovy3(0,0)-fovy3(res-1,0))*360/2/3.14 lt 7 then begin
    print,'abnormal end, maybe you should reboot idl'
    stop
  endif
  printf,37,'Ch3:find_footp_dir_n kxshift,kyshift,fovx3(0,0),fovy3(0,0),fovz3(0,0)= ',kxshift,kyshift,fovx3(0,0),fovy3(0,0),fovz3(0,0)
  printf,37,'Ch3:footpixx3,footpixy3= ',footpixx3,footpixy3


if max(footpixx1) ge 0 and n_elements(footpixx1) gt 1 and max(footpixy1) ge 0 $
and n_elements(footpixy1) gt 1 then begin
  footpixx1n=fix(interpol(footpixx1,timfov,tsec_obs1))
  footpixy1n=fix(interpol(footpixy1,timfov,tsec_obs1))
endif
if max(footpixx2) ge 0 and n_elements(footpixx2) gt 1 and max(footpixy2) ge 0 $
and n_elements(footpixy2) gt 1 then begin
  footpixx2n=fix(interpol(footpixx2,timfov,tsec_obs1))
  footpixy2n=fix(interpol(footpixy2,timfov,tsec_obs1))
endif
if max(footpixx3) ge 0 and n_elements(footpixx3) gt 1 and max(footpixy3) ge 0 $
and n_elements(footpixy3) gt 1 then begin
  footpixx3n=fix(interpol(footpixx3,timfov,tsec_obs1))
  footpixy3n=fix(interpol(footpixy3,timfov,tsec_obs1))
endif

  interpol_fov1:

  footlatn=float(interpol(footlat,timfov,tsec_obs1))
  footlonn=float(interpol(footlon,timfov,tsec_obs1))
  footaltn=float(interpol(footalt,timfov,tsec_obs1))
  footdirxn=float(interpol(footdirx,timfov,tsec_obs1))
  footdiryn=float(interpol(footdiry,timfov,tsec_obs1))
  footdirzn=float(interpol(footdirz,timfov,tsec_obs1))


  nextfootp:

  endif

  quality=0

    if max(imagetotal_1) eq 0 and max(imagetotal_2) eq 0 and max(imagetotal_3) eq 0 then begin
      goto, nextfile1
    endif else if staexis eq 0 then begin
      quality=1
      mac_t=fltarr(fnum1)&mac_t(*)=-99.9
      mac_1t=fltarr(fnum1)&mac_1t(*)=-99.9
      mac_2t=fltarr(fnum1)&mac_2t(*)=-99.9
      mac_3t=fltarr(fnum1)&mac_3t(*)=-99.9
      mac_f1t=fltarr(fnum1)&mac_f1t(*)=-99.9
      mac_f2t=fltarr(fnum1)&mac_f2t(*)=-99.9
      mac_f3t=fltarr(fnum1)&mac_f3t(*)=-99.9
      footpixx1n=intarr(fnum1)&footpixx1n(*)=-9
      footpixy1n=intarr(fnum1)&footpixy1n(*)=-9
      footpixx2n=intarr(fnum1)&footpixx2n(*)=-9
      footpixy2n=intarr(fnum1)&footpixy2n(*)=-9
      footpixx3n=intarr(fnum1)&footpixx3n(*)=-9
      footpixy3n=intarr(fnum)&footpixy3n(*)=-9
      footlatn=fltarr(fnum1)&footlatn(*)=-99.9
      footlonn=fltarr(fnum1)&footlonn(*)=-999.9
      footaltn=fltarr(fnum1)&footaltn(*)=-99.9
      footdirxn=fltarr(fnum1)&footdirxn(*)=-9.9
      footdiryn=fltarr(fnum1)&footdiryn(*)=-9.9
      footdirzn=fltarr(fnum1)&footdirzn(*)=-9.9
      glon=fltarr(res,res,fnum1,3)&glat(*,*,*,*)=-99.9
      glat=fltarr(res,res,fnum1,3)&glon(*,*,*,*)=-999.9
      goto, create1
    endif else if max(glat(*,*,*,*)) le 0.0 and max(glon(*,*,*,*)) le 0.0 then begin
      quality=quality+10
      goto, create1
    endif else if max(abs(glat)) gt 90 and max(abs(glon)) gt 360 then begin
      quality=quality+100
      goto, create1
    endif else begin
      quality=255
    endelse

    create1:
    mac_l2_create,simul,imode,fnum1,nstep,res,l2name_1,l2name_2,l2name_3,expos,time1,time2,time3,ti1,ti2,ti3,$
      ymd1,ymd2,ymd3,mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t,quality,footlatn,footlonn,footaltn,$
      footdirxn,footdiryn,footdirzn,footpixx1n,footpixy1n,footpixx2n,footpixy2n,footpixx3n,footpixy3n,$
      imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3,glat,glon,timres


   nextfile1:

   close,37
endfor

channel2:
print, ' === for channels 2-3 and 2 ==='
for i=0,numo_2-1 do begin
  simul=0
  chn=''
  if fnum2_2(i) ge 0 then begin
    simul=simul+1 & chn=chn+'2' & print, i,fna2(fnum2_2(i))
    l2name_2=l2dir+strmid(fna2(fnum2_2(i)),strpos(fna2(fnum2_2(i)),'RE'),26)+'L2'
  endif else begin
    l2name_2=''
  endelse
  if fnum3_2(i) ge 0 then begin
    simul=simul+1 & chn=chn+'3' & print, fna3(fnum3_2(i))
    l2name_3=l2dir+strmid(fna3(fnum3_2(i)),strpos(fna3(fnum3_2(i)),'RE'),26)+'L2'
  endif else begin
    l2name_3=''
  endelse
  print, simul

  l2name_1=''

  print, l2name_2,l2name_3,i

  mpnum1=strlen((findfile(l2name_2)))
  if max(mpnum1) ge 1 and ioverw eq 0 then begin
    print,'this L2 file already exist'
    goto, nextfile2
  endif

  dummysum=dummysum+1
  ndummysum=fix(dummysum/10)+1
  cdummysum=strmid(string(dummysum),strlen(dummysum)-1,ndummysum)
;  openw,37,psdir+'MAC'+strmid(fna1(fnum1_1(i)),strlen(fdir)+11,14)+strmid(fna1(fnum1_1(i)),strlen(fdir)+8,3)+'CH'+chn+'_L1_map_'+cdummysum+'.dummy'
  openw,37,l2dird+'MAC'+strmid(fna2(fnum2_2(i)),strlen(fdir)+11,14)+strmid(fna2(fnum2_2(i)),strlen(fdir)+8,3)+'CH'+chn+'_L2_'+cdummysum+'_result.txt'
    printf,37,'Program proceeding result'

  imode=mode2_2(i)
  imode2=mode3_2(i)
  print, 'mode ',imode,imode2
  printf,37,'Simultaneous channels, mode1,mode2,mode3= ',simul,-1,imode,imode2

  if imode2out eq 0 and imode eq 2 then goto,nextfile2
  if imode3out eq 0 and imode eq 3 then goto,nextfile2

  if imode eq 0 or imode eq 1 then begin
    ibin=16
    res=64
    anime_fac=3.0
    if imode eq 0 then begin
      nstep=nstep0
      timres=0.12*nstep
    endif else begin
      nstep=nstep1
      timres=1.0*nstep
    endelse
  endif else if imode eq 2 then begin
    ibin=2
    res=512
    nstep=nstep2
    timres=4.04*nstep
  endif else begin
    ibin=8
    res=128
    nstep=nstep3
    timres=0.48*nstep
  endelse

  fna=fna2(fnum2_2(i))
  read_L1data,fna,imode,res,ymd2,time2,ti2,temp2,imagetotal_2o,fnum2
  printf,37,'Ch2 file name, fnum= ',fna,fnum2
  printf,37,'start and end times= ',time2(0),time2(fnum2-1)
  if fnum3_2(i) ge 0 then begin
    fna=fna3(fnum3_2(i))
    read_L1data,fna,imode,res,ymd3,time3,ti3,temp3,imagetotal_3o,fnum3
  printf,37,'Ch3 file name, fnum= ',fna,fnum3
  printf,37,'start and end times= ',time3(0),time3(fnum3-1)
  endif else begin
    time3=0
    ti3=0
    ymd3=0
    temp3=0
    imagetotal_3o=0
    fnum3=fnum2
  endelse
  imagetotal_1o=0
  time1=0
  ti1=0
  ymd1=0
  temp1=0
  fnum1=fnum2

staexis=0
if ista eq 1 and istatype eq 0 then begin

  stafind_1day,fna,stanum,stadir,stafile
  printf,37,'STA file=',stafile

  if max(strlen(stafile)) gt 0 then begin

  if debug eq 1 then print, stanum
  print, stafile
  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
    mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
    mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
    esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
    esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
    esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
    rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for ii=0, n_elements(expor)-2 do begin
    if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
    if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
  endfor
  staexis=1

  endif else begin
    expor=60.0
    staexis=0
  endelse

endif


if ista eq 1 and max(strlen(stafile)) gt 0 then begin
  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss_l2,yyr,mor,ddr,hhr,mmr,ssr,expor,mac_tr,mac_c1_tr,mac_c2_tr,mac_c3_tr,mac_f1_tr,$
    mac_f2_tr,mac_f3_tr,ymd2,time2,tsec_obs2,yy_obs2,mo_obs2,dd_obs2,hh_obs2,mm_obs2,ss_obs2,expo_obs2,$
    mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t
  expos=fltarr(fnum2)
  if max(expo_obs2) eq 0 then begin
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
    printf,37,'exposure time assumed! case A, time and exposure time= ',time2,expos
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs2(*)
    cexp=''
    printf,37,'time and exposure time= ',time2,expos
  endelse
endif else begin
  expos=fltarr(fnum2)
  expos(*)=60.0
  cexp=' assumed'
  printf,37,'exposure time assumed! case B, time and exposure time= ',time2,expos
endelse

if exman eq 1 then begin
  expos=fltarr(fnum2)
  expos(*)=expos1
endif

fnum=fnum2
if expos(0) ne expos(fnum-1) then begin
  n1=n_elements(where(expos(0) eq expos(*)))
  n2=n_elements(where(expos(fnum-1) eq expos(*)))
  if n1 gt n2 then begin
    expos(*)=expos(0)
  endif else begin
    expos(*)=expos(fnum-1)
  endelse
endif

   if rayleigh eq 1 then begin
       exposure_2=fltarr(fnum2)
       exposure_2(*)=expos(*)
       count_to_rayleigh,imagetotal_2o,radcorrect,radimagefile,imode,2,res,exposure_2,fnum2,imagetotal_linear_2,imagetotal_log10_2
       imagetotal_2=fltarr(res,res,fnum2)
       if ilog eq 1 then begin
         imagetotal_2=imagetotal_log10_2
       endif else begin
         imagetotal_2=imagetotal_linear_2
       endelse
     if max(imagetotal_3o) gt 0 then begin
       exposure_3=fltarr(fnum3)
       if fnum2 eq fnum3 then begin
         exposure_3(0:fnum2-1)=expos(*)
         if fnum3 gt fnum2 then exposure_3(fnum2:fnum3-1)=expos(fnum2-1)
       endif else begin
         if fnum3 gt fnum2 then begin
           exposure_3(0:fnum2-1)=expos(*)
           exposure_3(fnum2:fnum3-1)=expos(fnum2-1)
         endif else begin
           exposure_3(*)=expos(0:fnum3-1)
         endelse
       endelse
       count_to_rayleigh,imagetotal_3o,radcorrect,radimagefile,imode,3,res,exposure_3,fnum3,imagetotal_linear_3,imagetotal_log10_3
       imagetotal_3=fltarr(res,res,fnum3)
       if ilog eq 1 then begin
         imagetotal_3=imagetotal_log10_3
       endif else begin
         imagetotal_3=imagetotal_linear_3
       endelse
     endif else begin
       imagetotal_3=fltarr(res,res,fnum2)
       imagetotal_3=0
     endelse
     imagetotal_1=fltarr(res,res,fnum2)
     imagetotal_1=0
   endif else begin
     imagetotal_1=fltarr(res,res,fnum2)
     imagetotal_2=fltarr(res,res,fnum2)
     if max(imagetotal_3o) gt 0 then begin
       imagetotal_3=fltarr(res,res,fnum3)
       imagetotal_3=imagetotal_3o
     endif else begin
       imagetotal_3=fltarr(res,res,fnum2)
       imagetotal_3=0
     endelse
     imagetotal_2=imagetotal_2o
     imagetotal_1=0
   endelse


   if simple_radcorrect eq 1 then begin
     radimage=fltarr(3,res,res)
     openr,2,radimagefile
     readf,2,radimage
     close,2
     imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
     imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
     imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
     imagetotal_1(where(imagetotal_1 lt 0)) =0
     imagetotal_2(where(imagetotal_2 lt 0)) =0
     imagetotal_3(where(imagetotal_3 lt 0)) =0
   endif


if footp eq 1 and staexis eq 1 and max(imagetotal_2) gt 0 then begin
;---reading att L1 data
  attfind,fna,attnum,attdir,attfile
  read_attdata_L1,attfile,dataintarval,fnum2,ymd2,time2,q1c,q2c,q3c,q4c,idate1,itime1
  printf,37,'ATT file= ',attfile
  printf,37,'q-values, time sequence is the same as exposure time'
  printf,37,'q1= ',q1c
  printf,37,'q2= ',q2c
  printf,37,'q3= ',q3c
  printf,37,'q4= ',q4c

  orbfind_new,fna,orbnum,orbdir,orbfile
  read_orbit_data_L1,orbfile,fnum2,ymd2,time2,orbtime,orbsatglat1,orbsatglon1,orbsatalt1,$
     glatfoot,glonfoot,altfoot,invlat,mlt,satglat2,satglon2,satalt2

  printf,37,'Orbit file=',orbfile
  printf,37,'satglat, time sequence is the same as exposure time= ',satglat2
  printf,37,'satglon, time sequence is the same as exposure time= ',satglon2

  symd2=ymd2(0)
  eymd2=ymd2(n_elements(ymd2)-1)
  stime2=tsec_obs2(0)
  etime2=tsec_obs2(n_elements(tsec_obs2)-1)

  if res ne 512 then begin
    sub_fov_read_land,fovdir,symd2,stime2,eymd2,etime2,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
      footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
      lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
      lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
      lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
 endif else begin
    sub_fov_read_land,fovdir,symd2,stime2,eymd2,etime2,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
      footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
      lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
      lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
      lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
  endelse

  printf,37,'macfov fovdir,fovnum= ',fovdir,fovnum
  if fovnum gt 0 then printf,37,'footdirx= ',footdirx

  glon=fltarr(res,res,fnum1,3)
  glat=fltarr(res,res,fnum1,3)
  ch=1
  fovdet_ino_n_alt,res,ch,fnum2,nstep,ymd2,time2,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
     fovx2,fovy2,fovz2,macfovgeix2,macfovgeiy2,macfovgeiz2,glat1,glon1,galt1,errorsum,imapalt,mapalt
  glon(*,*,*,ch)=glon1(*,*,*)
  glat(*,*,*,ch)=glat1(*,*,*)
  print, 'ch2 errorsum=',errorsum
  errorsum2=errorsum

  numg1=n_elements(where(glat1(0,0,*) ne 0))
  if numg1 gt 1 then begin
    printf,37,'Ch2: fovdet_ino_n glat1,glon1, and errorsum= ',glat1(0,0,where(glat1(0,0,*) ne 0)),glon1(0,0,where(glon1(0,0,*) ne 0)),errorsum
  endif else begin
    printf,37,'Ch2: fovdet_ino_n glat1,glon1, and errorsum= ',0.0,0.0,errorsum
  endelse

  ch=2
  fovdet_ino_n_alt,res,ch,fnum2,nstep,ymd2,time2,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
     fovx3,fovy3,fovz3,macfovgeix3,macfovgeiy3,macfovgeiz3,glat1,glon1,galt1,errorsum,imapalt,mapalt
  glon(*,*,*,ch)=glon1(*,*,*)
  glat(*,*,*,ch)=glat1(*,*,*)
  print, 'ch3 errorsum=',errorsum
  errorsum3=errorsum

  numg1=n_elements(where(glat1(0,0,*) ne 0))
  if numg1 gt 1 then begin
    printf,37,'Ch3: fovdet_ino_n glat1,glon1, and errorsum= ',glat1(0,0,where(glat1(0,0,*) ne 0)),glon1(0,0,where(glon1(0,0,*) ne 0)),errorsum
  endif else begin
    printf,37,'Ch3: fovdet_ino_n glat1,glon1, and errorsum= ',0.0,0.0,errorsum
  endelse

  errorsumt=errorsum2+errorsum3

;  if max(glat(*,*,*,*)) eq 0 and max(glon(*,*,*,*)) eq 0 and min(glat(*,*,*,*)) eq -999,9 and $
;    min(glon(*,*,*,*)) eq -999.9 then goto, nextfile1
  kn=n_elements(tsec_obs2)

;  footpixx1n=intarr(kn)&footpixx1n(*)=-9
;  footpixy1n=intarr(kn)&footpixy1n(*)=-9
  footpixx2n=intarr(kn)&footpixx2n(*)=-9
  footpixy2n=intarr(kn)&footpixy2n(*)=-9
  footpixx3n=intarr(kn)&footpixx3n(*)=-9
  footpixy3n=intarr(kn)&footpixy3n(*)=-9

  footlatn=fltarr(kn)&footlatn(*)=-99.9
  footlonn=fltarr(kn)&footlonn(*)=-999.9
  footaltn=fltarr(kn)&footaltn(*)=-99.9
  footdirxn=fltarr(kn)&footdirxn(*)=-9.9
  footdiryn=fltarr(kn)&footdiryn(*)=-9.9
  footdirzn=fltarr(kn)&footdirzn(*)=-9.9


  if errorsumt gt 6600 then goto, interpol_fov2

  if fovnum eq 0 then goto, nextfootp2

  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx2,fovy2,fovz2,footpixx2,footpixy2
  print, (fovy2(0,0)-fovy2(res-1,0))*360/2/3.14
  if   (fovy2(0,0)-fovy2(res-1,0))*360/2/3.14 lt 7 then begin
    print,'abnormal end, maybe you should reboot idl'
    stop
  endif
  printf,37,'Ch2:find_footp_dir_n kxshift,kyshift,fovx2(0,0),fovy2(0,0),fovz2(0,0)= ',kxshift,kyshift,fovx2(0,0),fovy2(0,0),fovz2(0,0)
  printf,37,'Ch2:footpixx2,footpixy2= ',footpixx2,footpixy2

  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx3,fovy3,fovz3,footpixx3,footpixy3
  print, (fovy3(0,0)-fovy3(res-1,0))*360/2/3.14
  if   (fovy3(0,0)-fovy3(res-1,0))*360/2/3.14 lt 7 then begin
    print,'abnormal end, maybe you should reboot idl'
    stop
  endif
  printf,37,'Ch3:find_footp_dir_n kxshift,kyshift,fovx3(0,0),fovy3(0,0),fovz3(0,0)= ',kxshift,kyshift,fovx3(0,0),fovy3(0,0),fovz3(0,0)
  printf,37,'Ch3:footpixx3,footpixy3= ',footpixx3,footpixy3


  if max(footpixx2) ge 0 and n_elements(footpixx2) gt 1 and max(footpixy2) ge 0 $
    and n_elements(footpixy2) gt 1 then begin
     footpixx2n=interpol(footpixx2,timfov,tsec_obs2)
     footpixy2n=interpol(footpixy2,timfov,tsec_obs2)
  endif
  if max(footpixx3) ge 0 and n_elements(footpixx3) gt 1 and max(footpixy3) ge 0 $
    and n_elements(footpixy3) gt 1 then begin
      footpixx3n=interpol(footpixx3,timfov,tsec_obs2)
      footpixy3n=interpol(footpixy3,timfov,tsec_obs2)
  endif

  interpol_fov2:

  footlatn=float(interpol(footlat,timfov,tsec_obs2))
  footlonn=float(interpol(footlon,timfov,tsec_obs2))
  footaltn=float(interpol(footalt,timfov,tsec_obs2))
  footdirxn=float(interpol(footdirx,timfov,tsec_obs2))
  footdiryn=float(interpol(footdiry,timfov,tsec_obs2))
  footdirzn=float(interpol(footdirz,timfov,tsec_obs2))

  nextfootp2:

  endif

  quality=0

    if max(imagetotal_1) eq 0 and max(imagetotal_2) eq 0 and max(imagetotal_3) eq 0 then begin
      goto, nextfile2
    endif else if staexis eq 0 then begin
      quality=1
      mac_t=fltarr(fnum1)&mac_t(*)=-99.9
      mac_1t=fltarr(fnum1)&mac_1t(*)=-99.9
      mac_2t=fltarr(fnum1)&mac_2t(*)=-99.9
      mac_3t=fltarr(fnum1)&mac_3t(*)=-99.9
      mac_f1t=fltarr(fnum1)&mac_f1t(*)=-99.9
      mac_f2t=fltarr(fnum1)&mac_f2t(*)=-99.9
      mac_f3t=fltarr(fnum1)&mac_f3t(*)=-99.9
      footpixx1n=intarr(fnum1)&footpixx1n(*)=-9
      footpixy1n=intarr(fnum1)&footpixy1n(*)=-9
      footpixx2n=intarr(fnum1)&footpixx2n(*)=-9
      footpixy2n=intarr(fnum1)&footpixy2n(*)=-9
      footpixx3n=intarr(fnum1)&footpixx3n(*)=-9
      footpixy3n=intarr(fnum)&footpixy3n(*)=-9
      footlatn=fltarr(fnum1)&footlatn(*)=-99.9
      footlonn=fltarr(fnum1)&footlonn(*)=-999.9
      footaltn=fltarr(fnum1)&footaltn(*)=-99.9
      footdirxn=fltarr(fnum1)&footdirxn(*)=-9.9
      footdiryn=fltarr(fnum1)&footdiryn(*)=-9.9
      footdirzn=fltarr(fnum1)&footdirzn(*)=-9.9
      glon=fltarr(res,res,fnum1,3)&glat(*,*,*,*)=-99.9
      glat=fltarr(res,res,fnum1,3)&glon(*,*,*,*)=-999.9
      goto, create2
    endif else if max(glat(*,*,*,*)) le 0.0 and max(glon(*,*,*,*)) le 0.0 then begin
      quality=quality+10
      goto, create2
    endif else if max(abs(glat)) gt 90 and max(abs(glon)) gt 360 then begin
      quality=quality+100
      goto, create2
    endif else begin
      quality=255
    endelse

    create2:
    mac_l2_create,simul,imode,fnum2,nstep,res,l2name_1,l2name_2,l2name_3,expos,time1,time2,time3,ti1,ti2,ti3,$
      ymd1,ymd2,ymd3,mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t,quality,footlatn,footlonn,footaltn,$
      footdirxn,footdiryn,footdirzn,footpixx1n,footpixy1n,footpixx2n,footpixy2n,footpixx3n,footpixy3n,$
      imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3,glat,glon,timres

   nextfile2:
   close,37
endfor

;---ch3
;  number of data: 0 to numo_3-1
;  file combination: fnum3_3(i)
;      available only when fnum3o_1=3
;  mode: mode3_3(i)
;      available only when mode3_3(i)>=0

channel3:

print, ' === for channels 3 ==='
for i=0,numo_3-1 do begin
  simul=0
  chn=''
  if fnum3_3(i) ge 0 then begin
    simul=simul+1 & chn=chn+'3'& print, i,fnum3_3(i),fna3(fnum3_3(i))
    l2name_3=l2dir+strmid(fna3(fnum3_3(i)),strpos(fna3(fnum3_3(i)),'RE'),26)+'L2'
  endif else begin
    l2name_3=''
  endelse
  print, simul

  l2name_1=''
  l2name_2=''

  print, l2name_3,i

  mpnum1=strlen((findfile(l2name_3)))
  if max(mpnum1) ge 1 and ioverw eq 0 then begin
    print,'this L2 file already exist'
    goto, nextfile3
  endif

  dummysum=dummysum+1
  ndummysum=fix(dummysum/10)+1
  cdummysum=strmid(string(dummysum),strlen(dummysum)-1,ndummysum)
  openw,37,l2dird+'MAC'+strmid(fna3(fnum3_3(i)),strlen(fdir)+11,14)+strmid(fna3(fnum3_3(i)),strlen(fdir)+8,3)+'CH'+chn+'_L2_'+cdummysum+'_result.txt'
    printf,37,'Program proceeding result'


  imode=mode3_3(i)

  print, 'mode ',imode
  printf,37,'Simultaneous channels, mode1,mode2,mode3= ',simul,-1,-1,imode

  if imode2out eq 0 and imode eq 2 then goto,nextfile3
  if imode3out eq 0 and imode eq 3 then goto,nextfile3

  if imode eq 0 or imode eq 1 then begin
    ibin=16
    res=64
    anime_fac=3.0
    if imode eq 0 then begin
      nstep=nstep0
      timres=0.12*nstep
    endif else begin
      nstep=nstep1
      timres=1.0*nstep
    endelse
  endif else if imode eq 2 then begin
    ibin=2
    res=512
    nstep=nstep2
    timres=4.04*nstep
  endif else begin
    ibin=8
    res=128
    nstep=nstep3
    timres=0.48*nstep
  endelse

   fna=fna3(fnum3_3(i))
   read_L1data,fna,imode,res,ymd3,time3,ti3,temp3,imagetotal_3o,fnum3
   printf,37,'Ch3 file name, fnum= ',fna,fnum3
   printf,37,'start and end times= ',time3(0),time3(fnum3-1)

   imagetotal_1o=0
   time1=0
   ti1=0
   ymd1=0
   temp1=0
   fnum1=fnum3
   imagetotal_2o=0
   time2=0
   ti2=0
   ymd2=0
   temp2=0
   fnum2=fnum3

staexis=0

if ista eq 1 and istatype eq 0 then begin

  stafind_1day,fna,stanum,stadir,stafile
  printf,37,'STA file=',stafile

  if max(strlen(stafile)) gt 0 then begin

  if debug eq 1 then print, stanum
  print, stafile
  print, 'STA file reading...'
  status_read_multi_newti_DARTSL1,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
    mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
    mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
    esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
    esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
    esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
    rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

  print, 'Changing from EST number to exposure time in msec...'
  est_to_sec,mac_exposurer,expor
  for ii=0, n_elements(expor)-2 do begin
    if expor(ii) eq 0 and expor(ii+1) ne 0 then expor(ii)=expor(ii+1)
    if expor(ii) ne 0 and expor(ii+1) eq 0 then expor(ii+1)=expor(ii)
  endfor
  staexis=1

  endif else begin
    expor=60.0
    staexis=0
  endelse

endif



if ista eq 1 and max(strlen(stafile)) gt 0 then begin
  print, 'Finding obseravation time and exposure time...'
  find_obstime_hhmmss_l2,yyr,mor,ddr,hhr,mmr,ssr,expor,mac_tr,mac_c1_tr,mac_c2_tr,mac_c3_tr,mac_f1_tr,$
    mac_f2_tr,mac_f3_tr,ymd3,time3,tsec_obs3,yy_obs3,mo_obs3,dd_obs3,hh_obs3,mm_obs3,ss_obs3,expo_obs3,$
    mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t

  expos=fltarr(fnum3)
  if max(expo_obs3) eq 0 then begin
    if max(expor) eq 0 then begin
      expos(*)=60.0
    endif else begin
      expos(*)=expor(max(where(expor gt 0)))
    endelse
    cexp=' assumed'
    printf,37,'exposure time assumed! case A, time and exposure time= ',time3,expos
;    expos(*)=expos1
  endif else begin
    expos(*)=expo_obs3(*)
    cexp=''
    printf,37,'time and exposure time= ',time3,expos
  endelse
endif else begin
  expos=fltarr(fnum3)
  expos(*)=60.0
  cexp=' assumed'
  printf,37,'exposure time assumed! case B, time and exposure time= ',time3,expos
endelse


if exman eq 1 then begin
  expos=fltarr(fnum2)
  expos(*)=expos1
endif

fnum=fnum3
if expos(0) ne expos(fnum-1) then begin
  n1=n_elements(where(expos(0) eq expos(*)))
  n2=n_elements(where(expos(fnum-1) eq expos(*)))
  if n1 gt n2 then begin
    expos(*)=expos(0)
  endif else begin
    expos(*)=expos(fnum-1)
  endelse
endif


   if rayleigh eq 1 then begin
     exposure_3=fltarr(fnum3)
     exposure_3(*)=expos(*)
     count_to_rayleigh,imagetotal_3o,radcorrect,radimagefile,imode,3,res,exposure_3,fnum3,imagetotal_linear_3,imagetotal_log10_3
     imagetotal_3=fltarr(res,res,fnum3)
     if ilog eq 1 then begin
       imagetotal_3=imagetotal_log10_3
     endif else begin
       imagetotal_3=imagetotal_linear_3
     endelse
     imagetotal_1=fltarr(res,res,fnum3)
     imagetotal_1=0
     imagetotal_2=fltarr(res,res,fnum3)
     imagetotal_2=0
   endif else begin
     imagetotal_1=fltarr(res,res,fnum2)
     imagetotal_2=fltarr(res,res,fnum2)
     imagetotal_3=fltarr(res,res,fnum3)
     imagetotal_3=imagetotal_3o
     imagetotal_1=0
     imagetotal_2=0
   endelse

   if simple_radcorrect eq 1 then begin
     radimage=fltarr(3,res,res)
     openr,2,radimagefile
     readf,2,radimage
     close,2
     imagetotal_1(*,*,i)=imagetotal_1(*,*,i)-radimage(0,*,*)
     imagetotal_2(*,*,i)=imagetotal_2(*,*,i)-radimage(1,*,*)
     imagetotal_3(*,*,i)=imagetotal_3(*,*,i)-radimage(2,*,*)
     imagetotal_1(where(imagetotal_1 lt 0)) =0
     imagetotal_2(where(imagetotal_2 lt 0)) =0
     imagetotal_3(where(imagetotal_3 lt 0)) =0
   endif

if footp eq 1 and staexis eq 1 and max(imagetotal_3) gt 0 then begin
;---reading att L1 data
  attfind,fna,attnum,attdir,attfile
  read_attdata_L1,attfile,dataintarval,fnum3,ymd3,time3,q1c,q2c,q3c,q4c,idate1,itime1
  printf,37,'ATT file= ',attfile
  printf,37,'q-values, time sequence is the same as exposure time'
  printf,37,'q1= ',q1c
  printf,37,'q2= ',q2c
  printf,37,'q3= ',q3c
  printf,37,'q4= ',q4c

  orbfind_new,fna,orbnum,orbdir,orbfile
  read_orbit_data_L1,orbfile,fnum3,ymd3,time3,orbtime,orbsatglat1,orbsatglon1,orbsatalt1,$
     glatfoot,glonfoot,altfoot,invlat,mlt,satglat2,satglon2,satalt2
  printf,37,'Orbit file=',orbfile
  printf,37,'satglat, time sequence is the same as exposure time= ',satglat2
  printf,37,'satglon, time sequence is the same as exposure time= ',satglon2


  symd3=ymd3(0)
  eymd3=ymd3(n_elements(ymd3)-1)
  stime3=tsec_obs3(0)
  etime3=tsec_obs3(n_elements(tsec_obs3)-1)

if res ne 512 then begin
  sub_fov_read_land,fovdir,symd3,stime3,eymd3,etime3,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endif else begin
  sub_fov_read_land,fovdir,symd3,stime3,eymd3,etime3,ymdfov,timfov,sclat,sclon,scalt,scx,scy,scz,$
    footlat,footlon,footalt,fangle,frange,footdirx,footdiry,footdirz,footdirsx,footdirsy,footdirsz,$
    lat0,lon0,alt0,angle0,range0,dirx0,diry0,dirz0,lat1,lon1,alt1,angle1,range1,dirx1,diry1,dirz1,$
    lat2,lon2,alt2,angle2,range2,dirx2,diry2,dirz2,lat3,lon3,alt3,angle3,range3,dirx3,diry3,dirz3,$
    lat4,lon4,alt4,angle4,range4,dirx4,diry4,dirz4,fovnum
endelse

  printf,37,'macfov fovdir,fovnum= ',fovdir,fovnum
  if fovnum gt 0 then printf,37,'footdirx= ',footdirx

  glon=fltarr(res,res,fnum1,3)
  glat=fltarr(res,res,fnum1,3)

  ch=2
  fovdet_ino_n_alt,res,ch,fnum3,nstep,ymd3,time3,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
     fovx3,fovy3,fovz3,macfovgeix3,macfovgeiy3,macfovgeiz3,glat1,glon1,galt1,errorsum,imapalt,mapalt
  glon(*,*,*,ch)=glon1(*,*,*)
  glat(*,*,*,ch)=glat1(*,*,*)
  print, 'ch3 errorsum=',errorsum
  errorsum3=errorsum
  errorsumt=errorsum3
  numg1=n_elements(where(glat1(0,0,*) ne 0))
  if numg1 gt 1 then begin
    printf,37,'Ch3: fovdet_ino_n glat1,glon1, and errorsum= ',glat1(0,0,where(glat1(0,0,*) ne 0)),glon1(0,0,where(glon1(0,0,*) ne 0)),errorsum
  endif else begin
    printf,37,'Ch3: fovdet_ino_n glat1,glon1, and errorsum= ',0.0,0.0,errorsum
  endelse

;  if max(glat(*,*,*,*)) eq 0 and max(glon(*,*,*,*)) eq 0 and min(glat(*,*,*,*)) eq -999,9 and $
;    min(glon(*,*,*,*)) eq -999.9 then goto, nextfile1

  kn=n_elements(tsec_obs3)

  footpixx1n=intarr(kn)&footpixx1n(*)=-9
  footpixy1n=intarr(kn)&footpixy1n(*)=-9
  footpixx2n=intarr(kn)&footpixx2n(*)=-9
  footpixy2n=intarr(kn)&footpixy2n(*)=-9
  footpixx3n=intarr(kn)&footpixx3n(*)=-9
  footpixy3n=intarr(kn)&footpixy3n(*)=-9

  footlatn=fltarr(kn)&footlatn(*)=-99.9
  footlonn=fltarr(kn)&footlonn(*)=-999.9
  footaltn=fltarr(kn)&footaltn(*)=-99.9
  footdirxn=fltarr(kn)&footdirxn(*)=-9.9
  footdiryn=fltarr(kn)&footdiryn(*)=-9.9
  footdirzn=fltarr(kn)&footdirzn(*)=-9.9

  if errorsumt gt 3300 then goto, interpol_fov3

  if fovnum eq 0 then goto, nextfootp3

  find_footp_dir_n,fovnum,kxshift,kyshift,footdirsx,footdirsy,footdirsz,res,fovx3,fovy3,fovz3,footpixx3,footpixy3
  print, (fovy3(0,0)-fovy3(res-1,0))*360/2/3.14
  if   (fovy3(0,0)-fovy3(res-1,0))*360/2/3.14 lt 7 then begin
    print,'abnormal end, maybe you should reboot idl'
    stop
  endif
  printf,37,'Ch3:find_footp_dir_n kxshift,kyshift,fovx3(0,0),fovy3(0,0),fovz3(0,0)= ',kxshift,kyshift,fovx3(0,0),fovy3(0,0),fovz3(0,0)
  printf,37,'Ch3:footpixx3,footpixy3= ',footpixx3,footpixy3

  if max(footpixx3) ge 0 and n_elements(footpixx3) gt 1 and max(footpixy3) ge 0 $
  and n_elements(footpixy3) gt 1 then begin
    footpixx3n=interpol(footpixx3,timfov,tsec_obs3)
    footpixy3n=interpol(footpixy3,timfov,tsec_obs3)
  endif

  interpol_fov3:

  footlatn=float(interpol(footlat,timfov,tsec_obs3))
  footlonn=float(interpol(footlon,timfov,tsec_obs3))
  footaltn=float(interpol(footalt,timfov,tsec_obs3))
  footdirxn=float(interpol(footdirx,timfov,tsec_obs3))
  footdiryn=float(interpol(footdiry,timfov,tsec_obs3))
  footdirzn=float(interpol(footdirz,timfov,tsec_obs3))

  nextfootp3:

  endif

  quality=0

    if max(imagetotal_1) eq 0 and max(imagetotal_2) eq 0 and max(imagetotal_3) eq 0 then begin
      goto, nextfile3
    endif else if staexis eq 0 then begin
      quality=1
      mac_t=fltarr(fnum1)&mac_t(*)=-99.9
      mac_1t=fltarr(fnum1)&mac_1t(*)=-99.9
      mac_2t=fltarr(fnum1)&mac_2t(*)=-99.9
      mac_3t=fltarr(fnum1)&mac_3t(*)=-99.9
      mac_f1t=fltarr(fnum1)&mac_f1t(*)=-99.9
      mac_f2t=fltarr(fnum1)&mac_f2t(*)=-99.9
      mac_f3t=fltarr(fnum1)&mac_f3t(*)=-99.9
      footpixx1n=intarr(fnum1)&footpixx1n(*)=-9
      footpixy1n=intarr(fnum1)&footpixy1n(*)=-9
      footpixx2n=intarr(fnum1)&footpixx2n(*)=-9
      footpixy2n=intarr(fnum1)&footpixy2n(*)=-9
      footpixx3n=intarr(fnum1)&footpixx3n(*)=-9
      footpixy3n=intarr(fnum)&footpixy3n(*)=-9
      footlatn=fltarr(fnum1)&footlatn(*)=-99.9
      footlonn=fltarr(fnum1)&footlonn(*)=-999.9
      footaltn=fltarr(fnum1)&footaltn(*)=-99.9
      footdirxn=fltarr(fnum1)&footdirxn(*)=-9.9
      footdiryn=fltarr(fnum1)&footdiryn(*)=-9.9
      footdirzn=fltarr(fnum1)&footdirzn(*)=-9.9
      glon=fltarr(res,res,fnum1,3)&glat(*,*,*,*)=-99.9
      glat=fltarr(res,res,fnum1,3)&glon(*,*,*,*)=-999.9
      goto, create3
    endif else if max(glat(*,*,*,*)) le 0.0 and max(glon(*,*,*,*)) le 0.0 then begin
      quality=quality+10
      goto, create3
    endif else if max(abs(glat)) gt 90 and max(abs(glon)) gt 360 then begin
      quality=quality+100
      goto, create3
    endif else begin
      quality=255
    endelse

    create3:
    mac_l2_create,simul,imode,fnum3,nstep,res,l2name_1,l2name_2,l2name_3,expos,time1,time2,time3,ti1,ti2,ti3,$
      ymd1,ymd2,ymd3,mac_t,mac_1t,mac_2t,mac_3t,mac_f1t,mac_f2t,mac_f3t,quality,footlatn,footlonn,footaltn,$
      footdirxn,footdiryn,footdirzn,footpixx1n,footpixy1n,footpixx2n,footpixy2n,footpixx3n,footpixy3n,$
      imagetotal_1,imagetotal_2,imagetotal_3,fnum1,fnum2,fnum3,glat,glon,timres

   nextfile3:
   close,37
endfor

debug_end:
endfor

close,/all
print, 'Normal End! '
END
