;******************************************************************
;    program MACimage_si_mem.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on July 31, 2003
;******************************************************************

PRO MACimage_si_mem

close,/all
iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin = 0
smax = 250

fdir = 'C:\Usr\tsakanoi\Index\MAC_DATA\2004_06_17\'
;C:\Usr\tsakanoi\index\20040518TTM\'
;fdir = 'C:\Usr\tsakanoi\index\1kami\'
;
;fna='040516EISA_MAC_0deg1.dat'
;fna='040517EISA_MAC_0deg2.dat'
;fna='040517EISA_MAC_20deg1.dat'
;fna='040517EISA_MAC_20deg2.dat'
;fna='040517EISA_MAC_30deg-1.dat'
;fna='040517EISA_MAC_40deg-1.dat'
;fna='040517EISA_MAC_47deg-1.dat'
;fna='040517EISA_MAC_m20deg1.dat'

;fna='040519EISA_m20deg1.dat'
;fna='040519EISA_MAC_m20deg1.dat'
;fna='040519EISA_MACmode1_1f_m20deg1.dat'
;fna='040519EISA_MACmode2_1f_m20deg1.dat'
;fna='040519EISA_MACmode3_1f_m20deg1.dat'
;fna='040519EISA_MACmode4_1f_m20deg1.dat'
;fna='040519EISA_MAC_m20deg2.dat'
;fna='040519EISA_MAC_m20deg3.dat'
fna='pa3chon.dat'

;fna='L2_DATA_SC_030912PM_1.dat'
;fna='L2_DATA_SC_030912PM_2.dat'
;fna='L2_DATA_SC_030912PM_3.dat'
;fna='L2_DATA_SC_030912AM1_4.dat'
;fna='L2_DATA_SC_030912AM1_3.dat'

;fna='030730_test1_L2_DATA_SC.dat'
;fna='030730_test2_L2_DATA_SC.dat'
;fna='030730_test3_L2_DATA_SC.dat'

psdir='C:\Usr\tsakanoi\index\ps\'

hiniti='June 17, 2004'
year=''

;--- pixel binning number !!
;ibin=16

;col=13
col=13
;--col 0 or 13
;===========================

pdate=0l
ptime=0l

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'


;---plot image size factor(nominal:7.5, one image large plot:30)
fac=7.5
;fac=30.0

;--- pdate and ptime for data selection which is avairable when fac=30.0
;pdate=20000319
;ptime=210748

if fac lt 30 then begin
  fact=1.0
  factc=''
endif else begin
  fact=1.8
  factc='l'
endelse

;---image resolution(nominal:100, one image large plot:512)
if fac eq 30 then begin
  res = xpx
endif else begin
;  res = 100
  res=64
endelse
;res = 512

irot = 5


;=====parameter end=====

close,/all

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
fn=''
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l
image1=intarr(res,res)

sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal,fnum

print, 'file number = ',fnum

ave=fltarr(fnum,3)
rms=fltarr(fnum,3)
avech=strarr(fnum,3)
rmsch=strarr(fnum,3)

for i=0, fnum-1 do begin
  image1=imagetotal(*,*,i)
  ibin1=ibin(i)
  set_xs_ys,ibin1,res,xst,yst,xen,yen

  for j=0,2 do begin
    result=moment(imagetotal(xst(j):xen(j),yst(j):yen(j),i))
    ave(i,j)=result(0)
    rms(i,j)=sqrt(result(1))
;    print,'average:',ave(i,j)
;    print,'rms:',rms(i,j)
    avech(i,j)=string(ave(i,j))
    rmsch(i,j)=string(rms(i,j))
  endfor
;  print, data
endfor


if iscale eq 1 then begin
  smin=fix(min(imagetotal)/5)*5l
  smax=fix((max(imagetotal))/5)*5l
endif

plot:

;------------------- PS PROT ------------------

SET_PLOT, 'PS'

e0=fix((fnum-1)/16)+1
s0=0
es=e0

FOR s=s0,es DO BEGIN

fo=STRING(s+1)
fo=STRTRIM(fo,1)

st=0+20*s
et=st+20-1

if et gt fnum-1 then et=fnum-2

DEVICE, BITS_PER_PIXEL=16, /COLOR, $
 FILENAME=psdir+strmid(fna,0,strlen(fna)-4)+fo+'.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
;print, psdir+year+strmid(fna,0,3)+cbin+'.ps'
print,psdir+strmid(fna,0,strlen(fna)-4)+fo+'.ps'
LOADCT, col

!P.FONT=0
XYOUTS, 2100, 28000, '!8MAC image (SI memory data) ' + hiniti, $
 CHARSIZE=1.5,  CHARTHICK=1.5,  /DEVICE
XYOUTS, 2200, 27000, 'filename='+fna+'            page = '+fo+'  /'+string(es), CHARSIZE=1.0, /DEVICE

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=ysi, /DEVICE
plots, [xsc,xsc],[ysc,ysc+ysi+60],/device
plots, [xsc+xsi,xsc+xsi],[ysc,ysc+ysi+60],/device

  XYOUTS, xsc+1000.0, ysc+ysi+100.0, 'intensity (cts)', $
   CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
  xyouts, xsc-700.0, ysc+ysi+100.0, smin, charsize=0.8, charthick=1, /device
  xyouts, xsc-700.0+xsi, ysc+ysi+100.0, long(smax), charsize=0.8, charthick=1, /device


;------------------ DRAW IMAGE DATA  --------------
;

xs=2500.0+1000*(fact-1.0)
xd=4300.0
ys=24500.0
cm=''
yd=2500.0
if fact ne 30.0 then ys=ys+yd+1500
pix=0.0
xpi=0.0
ypi=0.0
xpx=512
ypx=512

;---plotting images
FOR l=0, 3 DO BEGIN
 FOR k=0, 3 DO BEGIN

n=s*16+4*l+k

;print,n,imode(n)

 IF n EQ fnum-1 THEN GOTO, NODATA

if imode(n) eq 0 then begin
  cbin='Mode-S'
endif else if imode(n) eq 1 then begin
  cbin='Mode-H'
endif else if imode(n) eq 2 then begin
  cbin='Mode-IH'
endif else if imode(n) eq 3 then begin
  cbin='Mode-IM'
endif

if ich(n) eq 0 then begin
  ch=' Ch.1'
endif else if ich(n) eq 1 then begin
  ch=' Ch.2'
endif else if ich(n) eq 2 then begin
  ch=' Ch.3'
endif

cbin=cbin+ch

   sx=xs+xd*k
   sy=ys-((xpx)*fac+yd)*(l+1)
   if fac eq 30.0 then begin
     XYOUTS, xs+xd*k+20*fac, ys+fac*50, 'filename='+fna,CHARSIZE=0.8*fact, /DEVICE
     XYOUTS,  2100, 26800, datec,CHARSIZE=0.8*fact,  CHARTHICK=1.0,   /DEVICE
     xyouts, 5000,7500,'Average: '+avech , $
      charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 7000,7500, ave(0),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 10500,7500, ave(1),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 14000,7500, ave(2),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 5000,6500,'SD(rms): ',charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 7000,6500, rms(0),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 10500,6500, rms(1),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, 14000,6500, rms(2),charsize=0.8*fact, charthick=1.0,  /DEVICE
   endif else begin
     XYOUTS, xs+xd*k, (ys-400.0)-((xpx)*fac+yd+500*(fact-1))*(l+1), 'TI='+string(time(n)),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, xs+xd*k+500,(ys-800.0)-((xpx)*fac+yd+500*(fact-1))*(l+1), cbin,CHARSIZE=0.8*fact, /DEVICE
     xyouts, xs+xd*k,(ys-800.0-300*1)-((xpx)*fac+yd+500*(fact-1))*(l+1),'average: ', $
      charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k,(ys-800.0-300*2)-((xpx)*fac+yd+500*(fact-1))*(l+1),avech(n,0),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k,(ys-800.0-300*3)-((xpx)*fac+yd+500*(fact-1))*(l+1),avech(n,1),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k,(ys-800.0-300*4)-((xpx)*fac+yd+500*(fact-1))*(l+1),avech(n,2),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k+1700,(ys-800.0-300*1)-((xpx)*fac+yd+500*(fact-1))*(l+1),'SD(rms): ',charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k+1700,(ys-800.0-300*2)-((xpx)*fac+yd+500*(fact-1))*(l+1),rmsch(n,0),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k+1700,(ys-800.0-300*3)-((xpx)*fac+yd+500*(fact-1))*(l+1),rmsch(n,1),charsize=0.8*fact, charthick=1.0,  /DEVICE
     xyouts, xs+xd*k+1700,(ys-800.0-300*4)-((xpx)*fac+yd+500*(fact-1))*(l+1),rmsch(n,2),charsize=0.8*fact, charthick=1.0,  /DEVICE
  endelse

   TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin,max=smax),irot), sx, sy, $
      XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE



ENDFOR
ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE

print, 'Normal End! '
END
