;******************************************************************
;    program MACimage_si_mem_animation.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Sep 3, 2005
;******************************************************************

PRO MACimage_si_mem_animation
close,/all

iscale=01
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
imax=30.0
imin=0.0
;  imax and imin in kilo-Rayleigh

;fdir = 'C:\Usr\tsakanoi\Index\obs\050830\'
;fna='050830_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050902\'
;fna='L0_0509020500SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050907\'
;fna='L0_0509070400SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050907\'
;fna='L0_0509070500SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130400SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130500SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050916\'
;fna='20050916073009_DATA_SC.dat'
;fna='20050916221033_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050917074903_DATA_SC.dat'
;fna='20050917222943_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050918080801_DATA_SC.dat'
;fna='20050918211145_DATA_SC.dat'

fdir = 'C:\Usr\tsakanoi\Index\obs\050919\'
;fna='L0_0509190400SCA-N_DATA_SC.dat'
fna='050919195333_DATA_SC.dat'

select_frame=0
;select_frame=1 then set pnums and pnume
;select_frame=0 then all frame are played
  pnums=240
  pnume=300
;pnume=fnum-1

col=0
;col=3 is red
;col=1 is blue
;col=13 rainbow
;
simul=2
;ch simulaneous on number
exposure=40.0
;exposure in ms
res=64
anime_fac=2.0
anime_resv=res*anime_fac
anime_resh=(res+1)*anime_fac*3-anime_fac

factor=1.0
;factor is brightness factor

;irot = 6
irot=7
;irot 7 or 2?? is correct, maybe.

;=====parameter end=====

if res eq 64 then begin
  ibin=16
endif else if res eq 128 then begin
  ibin=8
endif else begin
  ibin=2
endelse

close,/all

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels


;sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal1,fnum,pnume+1
sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal,fnum,pnume+1


print, 'file number = ',fnum

if simul eq 1 then begin
  print, '1ch ON'
endif else if simul eq 2 then begin
  print, '2ch simultaneous ON'
endif else if simul eq 3 then begin
  print, '3ch simultaneous ON'
endif

;count_to_rayleigh,imagetotal1,imode,ich,res,exposure,fnum,imagetotal

if select_frame eq 0 then begin
  pnums=0
  pnume=fnum-1
endif

anum=0

if simul eq 1 then begin

imagetotal_a=intarr(anime_resh,anime_resv,pnume-pnums+1)

image1=intarr(res,res)
ich_a=intarr(pnume-pnums+1)

for i=pnums,pnume do begin
  if iscale eq 1 then begin
    imax=max(imagetotal(*,*,i))
    imin=min(imagetotal(*,*,i))
  endif

  image1(*,*)=(float(imagetotal(*,*,i))-imin)/(imax-imin)*255.0
  for j=0,res-1 do begin
    for k=0,res-1 do begin
      if image1(j,k) lt 0.0 then image1(j,k)=0.0
      if image1(j,k) gt 255.0 then image1(j,k)=255.0
    endfor
  endfor
  imagetotal_a(*,*,i-pnums)=congrid(rotate(image1(*,*),irot),anime_res,anime_res,pnume-pnums+1)*factor
  ich_a(i-pnums)=ich(i)

  print, i,i-pnums
endfor

xinteranimate, set=[anime_res, anime_res, pnume-pnums+1], /showload
for m=0,pnume-pnums do begin
  print, ich_a(m)
  xinteranimate, frame=m, image=imagetotal_a(*,*,m)
  print, m
endfor

xinteranimate, 5, /keep_pixmaps

endif else begin

imagetotal_a=intarr(anime_resh,anime_resv,pnume-pnums+1)
imagetotal_a(*,*,*)=0

image1=intarr(res,res)
ich_a=intarr(pnume-pnums+1)

for i=pnums,pnume do begin
  if iscale eq 1 then begin
    imax=max(imagetotal(*,*,i))
    imin=min(imagetotal(*,*,i))
  endif

  image1(*,*)=(float(imagetotal(*,*,i))-imin)/(imax-imin)*255.0
  for j=0,res-1 do begin
    for k=0,res-1 do begin
      if image1(j,k) lt 0.0 then image1(j,k)=0.0
      if image1(j,k) gt 255.0 then image1(j,k)=255.0
    endfor
  endfor
  imagetotal_a((res+1)*ich(i):(res+1)*ich(i)+res-1,*,anum)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
;  ich_a(i-pnums)=ich(i)
  if i ne fnum-1 then begin
    print, time(i+1),time(i)
    if time(i+1)-time(i) gt 1 then begin
      anum=anum+1
    endif
  endif

;  imagetotal_a(*,*,i-pnums)=congrid(rotate(imagetotal(*,*,i),irot),anime_res,anime_res,pnume-pnums+1)*factor
  print, i-pnums,anum
endfor

print, 'animation number=',anum

xinteranimate, set=[anime_resh, anime_resv, anum], /showload
for m=0,anum-1 do begin
  print, ich_a(m)
  xinteranimate, frame=m, image=imagetotal_a(*,*,m)
  print, m
endfor

xinteranimate, 5, /keep_pixmaps


endelse


print, 'Normal End! '
END
