;******************************************************************
;    program MACimage_si_mem_animation.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Sep 3, 2005
;******************************************************************

PRO MACimage_si_mem_animation_multi_color
close,/all

iscale=01
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
imax=fltarr(3)
imin=fltarr(3)
imax(0)=30.0
imin(0)=10.0
imax(1)=80.0
imin(1)=10.0
imax(2)=70.0
imin(2)=10.0
;  imax and imin in kilo-Rayleigh

;fdir = 'C:\Usr\tsakanoi\Index\obs\050830\'
;fna='050830_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050902\'
;fna='L0_0509020500SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050907\'
;fna='L0_0509070400SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050907\'
;fna='L0_0509070500SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130400SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130500SCA-N_DATA_SC.dat'
;
;fdir = 'C:\Usr\tsakanoi\Index\obs\050916\'
;fna='20050916073009_DATA_SC.dat'
;fna='20050916221033_DATA_SC.dat'
;simul=1

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050917074903_DATA_SC.dat'
;fna='20050917222943_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050918080801_DATA_SC.dat'
;fna='20050918211145_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050919\'
;fna='L0_0509190400SCA-N_DATA_SC.dat'
;fna='050919195333_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050920\'
;fna='050920070948_DATA_SC.dat'
;fna='050920133752_DATA_SC.dat'
;fna='050920201247_DATA_SC.dat'

;fdir='G:\Index\obs\050921\'
;fdir = 'C:\Usr\tsakanoi\Index\obs\050921\'
;fna='0509210400SCA-N_DATA_SC.dat'
;fna='050921072855_DATA_SC.dat'
;fna='050921135721_DATA_SC.dat'
;fna='050921203202_DATA_SC.dat'
;simul=2
;station='SVL'


;fdir = 'C:\Usr\tsakanoi\Index\obs\050922\'
;fna='050922043610_DATA_SC.dat'
;fna='050922074748_DATA_SC.dat'
;fna='050922205117_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\050923\'
;fna='050923031856_DATA_SC.dat'
;fna='050923063058_DATA_SC.dat'
;fna='050923125746_DATA_SC.dat'
;fna='050923211029_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\050924\'
;fna='050924033828_DATA_SC.dat'
;fna='050924064954_DATA_SC.dat'
;fna='050924131715_DATA_SC.dat'
;fna='050924212940_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050925\'
;fna='050925035653_DATA_SC.dat'
;fna='050925070832_DATA_SC.dat'
;fna='050925133634_DATA_SC.dat'
;fna='050925201130_DATA_SC.dat'


;fdir = 'C:\Usr\tsakanoi\Index\obs\050926\'
;fna='050926041630_DATA_SC.dat'
;fna='050926072739_DATA_SC.dat'
;fna='050926135553_DATA_SC.dat'
;fna='050926185258_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050927\'
;fna='050927012141_DATA_SC.dat'
;fna='050927025838_DATA_SC.dat'
;fna='050927043450_DATA_SC.dat'
;fna='050927061048_DATA_SC.dat'


;fdir = 'C:\Usr\tsakanoi\Index\obs\051004\'
;fna='051004064717_DATA_SC.dat'
;fna='051004131435_DATA_SC.dat'
;fna='051004212658_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051005\'
;fna='051005021734_DATA_SC.dat'
;fna='051005070552_DATA_SC.dat'
;fna='051005133347_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051006\'
;fna='051006023564_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051012\'
;fna='051012043035_DATA_SC.dat'
;fna='051012074232_DATA_SC.dat'
;fna='051012074232_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051013\'
;fna='051013044952_DATA_SC.dat'
;fna='051013080125_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051014\'
;fna='051014064433_DATA_SC.dat'
;fna='051014082018_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051015\'
;fna='051015003803_DATA_SC.dat'
;fna='051015035123_DATA_SC.dat'
;fna='051015070305_DATA_SC.dat'
;fna='051015101631_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051016\'
;fna='051016005707_DATA_SC.dat'
;fna='051016041022_DATA_SC.dat'
;fna='051016054624_DATA_SC.dat'
;fna='051016103554_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051017\'
;fna='051017042911_DATA_SC.dat'
;fna='051017060517_DATA_SC.dat'
;fna='051017074106_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051018\'
;fna='051018031206_DATA_SC.dat'
;fna='051018062405_DATA_SC.dat'
;fna='051018075959_DATA_SC.dat'
;fna='051018062405_DATA_SC.dat'
;fna='051018031206_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\051019\'
;fna='051019050717_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051020\'
;fna='051020070139_DATA_SC.dat'
;fna='051020115150_DATA_SC.dat'
;fna='051020214151_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051021\'
;fna='051021005542_DATA_SC.dat'
;fna='051021072037_DATA_SC.dat'
;fna='051021121113_DATA_SC.dat'
;fna='051021220058_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051022\'
;fna='051022011442_DATA_SC.dat'
;fna='051022073937_DATA_SC.dat'
;fna='051022222007_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051023\'
;fna='051023013343_DATA_SC.dat'
;fna='051023044658_DATA_SC.dat'
;fna='051023075833_DATA_SC.dat'
;fna='051023111231_DATA_SC.dat'
;fna='051023210156_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051024\'
;fna='051024064140_DATA_SC.dat'
;fna='051024082043_DATA_SC.dat'
;fna='051024113114_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051025\'
;fna='051025003511_DATA_SC.dat':;noMACdata
;fna='051025052433_DATA_SC.dat'
;fna='051025083629_DATA_SC.dat'
;fna='051025115019_DATA_SC.dat'
;fna='051025132817_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051026\'
;fna='051026054330_DATA_SC.dat'
;fna='051026071908_DATA_SC.dat'
;fna='051026120936_DATA_SC.dat'
;fna='051026134721_DATA_SC.dat':;noMACdata
;fna='051026215928_DATA_SC.dat':;noMACdata
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051027\'
;fna='051027011313_DATA_SC.dat'
;fna='051027060222_DATA_SC.dat'
;fna='051027073805_DATA_SC.dat'
;fna='051027122903_DATA_SC.dat'
;fna='051027140645_DATA_SC.dat'
;fna='051027221836_DATA_SC.dat'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051028\'
;fna='05102811104_DATA_SC.dat'
;fna='051028013215_DATA_SC.dat'
;fna='051028075704_DATA_SC.dat'
;fna='051028124750_DATA_SC.dat'
;fna='051028142625_DATA_SC.dat':;noMACdata
;fna='051028223743_DATA_SC.dat':;noMACdata
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051029\'
;fna='051029015114_DATA_SC.dat'
;fna='051029032752_DATA_SC.dat'
;fna='051029050420_DATA_SC.dat'
;fna='051029081558_DATA_SC.dat'
;fna='051029112946_DATA_SC.dat'
;fna='051029211942_DATA_SC.dat':;noMACdata
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051030\'
;fna='051030003341_DATA_SC.dat'
;fna='051030021016_DATA_SC.dat':;In this file, MAC data are all zero!
;fna='051030034659_DATA_SC.dat'
;fna='051030052306_DATA_SC.dat'
;fna='051030065847_DATA_SC.dat'
;fna='051030083459_DATA_SC.dat'
;fna='051030114847_DATA_SC.dat':;noMACdata
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051031\'
;fna='051031005244_DATA_SC.dat'
;fna='051031054201_DATA_SC.dat'
;fna='051031071737_DATA_SC.dat'
;fna='051031120806_DATA_SC.dat':;noMACdata
;fna='051031134556_DATA_SC.dat':;noMACdata
;fna='051031215800_DATA_SC.dat':;noMACdata
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051101\'
;fna='051101011145_DATA_SC.dat':;noMACdata
;fna='051101140523_DATA_SC.dat':;noMACdata
;fna='051101140523_DATA_SC.dat':;noMACdata
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051102\'
;fna='051102013046_DATA_SC.dat'
;fna='051102030738_DATA_SC.dat'
;fna='051102042309_DATA_SC.dat'
;station='SCA'
;fna='051102061948_DATA_SC.dat'
;fna='051102075536_DATA_SC.dat'
;fna='051102110937_DATA_SC.dat'
;fna='051102124620_DATA_SC.dat'
;fna='0511020444401_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051103\'
;fna='051103001309_DATA_SC.dat'
;fna='051103013540_DATA_SC.dat':;noMACdata
;station='SCA'
;fna='051103014945_DATA_SC.dat'
;station='SVL'
;fna='051103030819_DATA_SC.dat'
;station='SCA'
;fna='051103032622_DATA_SC.dat'
;fna='051103130546_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051104\'
;fna='051104003210_DATA_SC.dat':;nomacdata
;fna='051104020847_DATA_SC.dat'
;fna='051104032642_DATA_SC.dat'
;fna='051104034523_DATA_SC.dat'
;fna='051104052135_DATA_SC.dat'
;fna='051104065721_DATA_SC.dat'
;fna='051104083327_DATA_SC.dat'
;fna='051104114716_DATA_SC.dat'
;fna='051104132458_DATA_SC.dat'
;fna='051104213721_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051105\'
;fna='051105005113_DATA_SC.dat'
;fna='051105040425_DATA_SC.dat'
;fna='051105054030_DATA_SC.dat'
;fna='051105071606_DATA_SC.dat'
;fna='051105120633_DATA_SC.dat'
;fna='051105134424_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051106\'
;fna='051106011014_DATA_SC.dat'
;fna='051106024710_DATA_SC.dat'
;fna='051106042314_DATA_SC.dat'
;fna='051106055914_DATA_SC.dat'
;fna='051106073505_DATA_SC.dat'
;fna='051106122604_DATA_SC.dat':;nomacdata
;fna='051106140341_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051107\'
;fna='051107012915_DATA_SC.dat'
;fna='051107030607_DATA_SC.dat'
;fna='051107044231_DATA_SC.dat'
;fna='051107061818_DATA_SC.dat'
;fna='051107075404_DATA_SC.dat':;nomacdata
;fna='051107110807_DATA_SC.dat':;nomacdata
;fna='051107124456_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051108\'
;fna='051108001135_DATA_SC.dat'
;fna='051108014814_DATA_SC.dat'
;fna='051108032450_DATA_SC.dat'
;fna='051108050119_DATA_SC.dat'
;fna='051108063709_DATA_SC.dat'
;fna='051108081257_DATA_SC.dat':;nomacdata
;fna='051108112644_DATA_SC.dat':;nomacdata
;fna='051108130411_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051109\'
;fna='051109003039_DATA_SC.dat'
;fna='051109015048_DATA_SC.dat'
;fna='051109020714_DATA_SC.dat'
;fna='051109032338_DATA_SC.dat'
;fna='051109034356_DATA_SC.dat'

;fna='051109052013_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051110\'
;fna='051110004943_DATA_SC.dat'
;fna='051110020853_DATA_SC.dat'
;fna='051110053901_DATA_SC.dat'
;fna='051110071433_DATA_SC.dat'
;fna='051110120502_DATA_SC.dat'
;fna='051110120502_DATA_SC.dat'
;fna='051110134250_DATA_SC.dat'
;fna='051110153201_DATA_SC.dat'
;fna='051110170603_DATA_SC.dat':;nomacdata
;fna='051110215455_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051111\'
;fna='051111154831_DATA_SC.dat'
;fna='051111221402_DATA_SC.dat'
;fna='051112010842_DATA_SC.dat'
;fna='051112022833_DATA_SC.dat'
;fna='051112024539_DATA_SC.dat'
;fna='051112040211_DATA_SC.dat'
;fna='051112042144_DATA_SC.dat'
;fna='051112055740_DATA_SC.dat'
;fna='051112122432_DATA_SC.dat'
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051112\'
;fna='051112012743_DATA_SC.dat'
;fna='051112024149_DATA_SC.dat'
;fna='051112030435_DATA_SC.dat':;nomacdata
;fna='051112042548_DATA_SC.dat'
;fna='051112044056_DATA_SC.dat'
;fna='051112061646_DATA_SC.dat'
;fna='051112075233_DATA_SC.dat'
;fna='051112110637_DATA_SC.dat'
;fna='051112124319_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051113\'
;fna='051113001005_DATA_SC.dat'
;fna='051113014642_DATA_SC.dat'
;fna='051113032327_DATA_SC.dat'
;fna='051113045948_DATA_SC.dat'
;fna='051113081125_DATA_SC.dat'
;fna='051113130238_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051114\'
;fna='051114002908_DATA_SC.dat'
;fna='051114014808_DATA_SC.dat'
;fna='051114020542_DATA_SC.dat'
;fna='051114032548_DATA_SC.dat'
;fna='051114034221_DATA_SC.dat'
;fna='051114051844_DATA_SC.dat'
;fna='051114065418_DATA_SC.dat'
;fna='051114083025_DATA_SC.dat'
;fna='051114132155_DATA_SC.dat
;fna='051114213416_DATA_SC.dat'
;fna='0511140114410_DATA_SC.dat'
;fna='051114114410_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051115\'
;fna='051115004809_DATA_SC.dat'
;fna='051115040125_DATA_SC.dat'
;fna='051115053730_DATA_SC.dat'
;fna='051115071302_DATA_SC.dat'
;fna='051115084927_DATA_SC.dat'
;fna='051115120329_DATA_SC.dat'
;fna='051115134113_DATA_SC.dat'
;fna='051115215325_DATA_SC.dat'
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051116\'
;fna='051116010711_DATA_SC.dat'
;fna='051116024407_DATA_SC.dat':;nomacdata
;fna='051116042013_DATA_SC.dat'
;fna='051116055607_DATA_SC.dat'
;fna='051116073204_DATA_SC.dat'
;fna='051116090824_DATA_SC.dat'
;fna='051116122257_DATA_SC.dat'
;fna='051116221228_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051117\'
;fna='051117012610_DATA_SC.dat'
;fna='051117030305_DATA_SC.dat'
;fna='051117043927_DATA_SC.dat'
;fna='051117061512_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051118\'
;fna='051118000833_DATA_SC.dat'
;fna='051118014511_DATA_SC.dat'
;fna='051118032147_DATA_SC.dat'
;fna='051118045821_DATA_SC.dat'
;fna='051118063404_DATA_SC.dat'
;fna='051118080952_DATA_SC.dat'
;fna='051118112342_DATA_SC.dat'
;fna='051118130102_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051119\'
;fna='051119002735_DATA_SC.dat'
;fna='051119020409_DATA_SC.dat'
;fna='051119034051_DATA_SC.dat'
;fna='051119051733_DATA_SC.dat'
;fna='051119065255_DATA_SC.dat'
;fna='051119082852_DATA_SC.dat':;nomacdata
;fna='051119132020_DATA_SC.dat':;nomacdata
;fna='051119213241_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051120\'
;fna='051120004637_DATA_SC.dat'
;fna='051120040029_DATA_SC.dat'
;fna='051120053611_DATA_SC.dat'
;fna='051120071130_DATA_SC.dat'
;fna='051120084752_DATA_SC.dat'
;fna='051120120155_DATA_SC.dat'
;fna='051120133939_DATA_SC.dat':;nomacdata
;fna='051120215150_DATA_SC.dat':;nomacdata
;fna='051121035818_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051121\'
;fna='051121035818_DATA_SC.dat'
;fna='051121041842_DATA_SC.dat'
;fna='051121055432_DATA_SC.dat'
;fna='051121073033_DATA_SC.dat'
;fna='051121122122_DATA_SC.dat'
;fna='051121135852_DATA_SC.dat'
;fna='051121153926_DATA_SC.dat':;nomacdata
;fna='051121221057_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051122\'
;fna='051122012438_DATA_SC.dat'
;fna='051122030134_DATA_SC.dat'
;fna='051122043747_DATA_SC.dat'
;fna='051122061339_DATA_SC.dat'
;fna='051122074928_DATA_SC.dat'
;fna='051122110333_DATA_SC.dat'
;fna='051122124016_DATA_SC.dat':;nomacdata
;fna='051122160743_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051123\'
;fna='051123030454_DATA_SC.dat'
;fna='051123045643_DATA_SC.dat'
;fna='051123063232_DATA_SC.dat'
;fna='051123080819_DATA_SC.dat'
;fna='051123112210_DATA_SC.dat'
;fna='051123125923_DATA_SC.dat'
;fna='051123145223_DATA_SC.dat'
;fna='051123162430_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051124\'
;fna='051124002601_DATA_SC.dat'
;station='SVL'
;simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\051128\'
;fna='051128112037_DATA_SC.dat'
;fna='051128125746_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051129\'
;fna='051129002428_DATA_SC.dat'
;fna='051129020103_DATA_SC.dat'
;fna='051129033744_DATA_SC.dat'
;fna='051129051401_DATA_SC.dat'
;fna='051129064949_DATA_SC.dat'
;fna='051129113926_DATA_SC.dat'
;fna='051129131711_DATA_SC.dat'
;fna='051129212934_DATA_SC.dat'
;station='SVL'
;simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051130\'
;fna='051130004327_DATA_SC.dat'
fna='051130020946_DATA_SC.dat'
;fna='051130035648_DATA_SC.dat'
;fna='051130053252_DATA_SC.dat'
;fna='051130070825_DATA_SC.dat'
;fna='051130115839_DATA_SC.dat'
;fna='051130133626_DATA_SC.dat'
;fna='051130214841_DATA_SC.dat':;nomacdata
station='SVL'
simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051201\'
;fna='051201010231_DATA_SC.dat'
;fna='051201041533_DATA_SC.dat'
;fna='051201055125_DATA_SC.dat'
;fna='051201072726_DATA_SC.dat'
;fna='051201121805_DATA_SC.dat'
;fna='051201135544_DATA_SC.dat'
;fna='051201220747_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051202\'
;fna='051202012130_DATA_SC.dat'
;fna='051202025827_DATA_SC.dat'
;fna='051202043435_DATA_SC.dat'
;fna='051202061034_DATA_SC.dat'
;fna='051202074616_DATA_SC.dat'
;fna='051202092253_DATA_SC.dat'
;fna='051202123710_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051203\'
;fna='051203000348_DATA_SC.dat'
;fna='051203014030_DATA_SC.dat'
;fna='051203031716_DATA_SC.dat'
;fna='051203045338_DATA_SC.dat'
;fna='051203062924_DATA_SC.dat'
;fna='051203080509_DATA_SC.dat'
;fna='051203111904_DATA_SC.dat'
;fna='051203125612_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051204\'
;fna='051204002253_DATA_SC.dat'
;fna='051204015928_DATA_SC.dat'
;fna='051204033606_DATA_SC.dat'
;fna='051204051234_DATA_SC.dat'
;fna='051204064814_DATA_SC.dat'
;fna='051204082402_DATA_SC.dat'
;fna='051204113749_DATA_SC.dat'
;fna='051204131533_DATA_SC.dat'
;fna='051204212759_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051205\'
;fna='05120507649_DATA_SC.dat'
;fna='051205004153_DATA_SC.dat'
;fna='051205035514_DATA_SC.dat'
;fna='051205053118_DATA_SC.dat'
;fna='051205084304_DATA_SC.dat'
;fna='051205115703_DATA_SC.dat'
;fna='051205133449_DATA_SC.dat'
;fna='051205214706_DATA_SC.dat':;nomacdata
;fna='051205152350_DATA_SC.dat'
;station='SVL'
;simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051206\'
;fna='051206010055_DATA_SC.dat'
;fna='051206041358_DATA_SC.dat'
;fna='051206054951_DATA_SC.dat'
;fna='051206072552_DATA_SC.dat'
;fna='051206121628_DATA_SC.dat'
;fna='051206135408_DATA_SC.dat'
;fna='051206153406_DATA_SC.dat'
fna='051206172629_DATA_SC.dat'
;fna='051206220611_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051207\'
;fna='051207011954_DATA_SC.dat'
;fna='051207025652_DATA_SC.dat'
;fna='051207043306_DATA_SC.dat'
;fna='051207060859_DATA_SC.dat'
;fna='051207074440_DATA_SC.dat'
;fna='051207092118_DATA_SC.dat'
;fna='051207123536_DATA_SC.dat'
fna='051207160602_DATA_SC.dat'
station='SVL'
simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051208\'
;fna='051208000212_DATA_SC.dat'
;fna='051208013854_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051209\'
;fna='051209002116_DATA_SC.dat'
;fna='051209015751_DATA_SC.dat'
;fna='051209033428_DATA_SC.dat'
;fna='051209051055_DATA_SC.dat'
;fna='051209064639_DATA_SC.dat'
;fna='051209082225_DATA_SC.dat'
;fna='051209113615_DATA_SC.dat'
;fna='051209131357_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051210\'
;fna='051210004017_DATA_SC.dat'
;fna='051210035337_DATA_SC.dat'
;fna='051210052942_DATA_SC.dat'
;fna='051210070514_DATA_SC.dat'
;fna='051210115525_DATA_SC.dat'
;fna='051210133310_DATA_SC.dat'
;fna='051210214529_DATA_SC.dat'
;station='SVL'
;simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051211\'
fna='051211005918_DATA_SC.dat'
fna='051211041219_DATA_SC.dat'
fna='051211054815_DATA_SC.dat'
fna='051211072417_DATA_SC.dat'
fna='051211121449_DATA_SC.dat'
fna='051211135232_DATA_SC.dat'
fna='051211220435_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051212\'
fna='051212011819_DATA_SC.dat'
fna='051212025515_DATA_SC.dat'
fna='051212043128_DATA_SC.dat'
fna='051212060723_DATA_SC.dat'
fna='051212074305_DATA_SC.dat'
fna='051212123359_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051213\'
fna='051213000036_DATA_SC.dat'
fna='051213031409_DATA_SC.dat'
fna='051213045028_DATA_SC.dat'
fna='051213111554_DATA_SC.dat'
fna='051213125257_DATA_SC.dat'
fna='051213013718_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051214\'
fna='051214001939_DATA_SC.dat'
fna='051214015616_DATA_SC.dat'
fna='051214033253_DATA_SC.dat'
fna='051214050920_DATA_SC.dat'
fna='051214064503_DATA_SC.dat'
fna='051214082049_DATA_SC.dat'
fna='051214113437_DATA_SC.dat'
fna='051214131220_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051215\'
fna='051215003840_DATA_SC.dat'
fna='051215035200_DATA_SC.dat'
fna='051215052805_DATA_SC.dat'
fna='051215070337_DATA_SC.dat'
fna='051215083952_DATA_SC.dat'
fna='051215115347_DATA_SC.dat'
fna='051215133132_DATA_SC.dat'
fna='051215214353_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051216\'
fna='051216005742_DATA_SC.dat'
fna='051216041041_DATA_SC.dat'
fna='051216054643_DATA_SC.dat'
fna='051216072238_DATA_SC.dat'
fna='051216121312_DATA_SC.dat'
fna='051216135056_DATA_SC.dat'
fna='051216220258_DATA_SC.dat'
station='SVL'
simul=3


fdir = 'C:\Usr\tsakanoi\Index\obs\051217\'
fna='051217011641_DATA_SC.dat'
fna='051217025338_DATA_SC.dat'
;fna='051217042948_DATA_SC.dat'
;fna='051217060545_DATA_SC.dat'
;fna='051217074131_DATA_SC.dat'
fna='051217091803_DATA_SC.dat'
fna='051217123222_DATA_SC.dat'
fna='051217222203_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051218\'
fna='051218013540_DATA_SC.dat'
fna='051218031234_DATA_SC.dat'
fna='051218044851_DATA_SC.dat'
fna='051218062433_DATA_SC.dat'
fna='051218080021_DATA_SC.dat'
fna='051218111418_DATA_SC.dat'
fna='051218125115_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051219\'
fna='051219001802_DATA_SC.dat'
fna='051219015438_DATA_SC.dat'
fna='051219033113_DATA_SC.dat'
fna='051219050742_DATA_SC.dat'
fna='051219064327_DATA_SC.dat'
fna='051219081912_DATA_SC.dat'
fna='051219113301_DATA_SC.dat'
fna='051219131039_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051220\'
fna='051220003702_DATA_SC.dat'
fna='051220035022_DATA_SC.dat'
fna='051220052626_DATA_SC.dat'
fna='051220070157_DATA_SC.dat'
fna='051220083816_DATA_SC.dat'
fna='051220115208_DATA_SC.dat'
fna='051220132952_DATA_SC.dat'
fna='051220214214_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051221\'
fna='051221005604_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051222\'
fna='051222042807_DATA_SC.dat'
fna='051222060408_DATA_SC.dat'
fna='051222073955_DATA_SC.dat'
fna='051222091624_DATA_SC.dat'
fna='051222123042_DATA_SC.dat'
fna='051222222026_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051223\'
fna='051223013402_DATA_SC.dat'
fna='051223031057_DATA_SC.dat'
fna='051223044713_DATA_SC.dat'
fna='051223062251_DATA_SC.dat'
fna='051223111241_DATA_SC.dat'
fna='051223124929_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051224\'
fna='051224001623_DATA_SC.dat'
fna='051224015258_DATA_SC.dat'
fna='051224032934_DATA_SC.dat'
fna='051224050602_DATA_SC.dat'
fna='051224064150_DATA_SC.dat'
fna='051224130859_DATA_SC.dat'
station='SVL'
simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\051225\'
fna='051225003523_DATA_SC.dat'
fna='051225021158_DATA_SC.dat'
fna='051225034839_DATA_SC.dat'
fna='051225052448_DATA_SC.dat'
fna='051225070018_DATA_SC.dat'
fna='051225132811_DATA_SC.dat'
station='SVL'
simul=3



fdir = 'G:\Index\obs\051226\'
;fna='051226005424_DATA_SC.dat':;nomacdata
;fna='051226040726_DATA_SC.dat'
;fna='051226054337_DATA_SC.dat'
;fna='051226071916_DATA_SC.dat'
;fna='051226120946_DATA_SC.dat'
;fna='051226134733_DATA_SC.dat'
fna='051226215940_DATA_SC.dat'
station='SVL'
simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051227\'
;fna='051227011323_DATA_SC.dat'
;fna='051227021513_DATA_SC.dat'
;fna='051227025018_DATA_SC.dat'
;fna='051227040158_DATA_SC.dat'
;fna='051227042620_DATA_SC.dat'
;fna='051227060227_DATA_SC.dat'
;fna='051227073814_DATA_SC.dat'
;fna='051227091444_DATA_SC.dat'
;fna='051227122903_DATA_SC.dat'
;fna='051227221846_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051228\'
;fna='051228013220_DATA_SC.dat'
;fna='051228030917_DATA_SC.dat'
;fna='051228044534_DATA_SC.dat'
;fna='051228062111_DATA_SC.dat'
;fna='051228075703_DATA_SC.dat'
;fna='051228111105_DATA_SC.dat'
;fna='051228124750_DATA_SC.dat'
;fna='051228161815_DATA_SC.dat'
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051229\'
;fna='051229001443_DATA_SC.dat'
;fna='051229015118_DATA_SC.dat'
;fna='051229032755_DATA_SC.dat'
;fna='051229050421_DATA_SC.dat'
;fna='051229064011_DATA_SC.dat'
;fna='051229081554_DATA_SC.dat'
;fna='051229112942_DATA_SC.dat'
;fna='051229130716_DATA_SC.dat'
;fna='051229163902_DATA_SC.dat'
;fna='051229150346_DATA_SC.dat'
;station='SVL'
;simul=3
;;
;fdir = 'C:\Usr\tsakanoi\Index\obs\051230\'
;fna='051230003343_DATA_SC.dat'
;fna='051230021019_DATA_SC.dat'
;fna='051230032930_DATA_SC.dat'
;fna='051230052304_DATA_SC.dat'
;fna='051230065839_DATA_SC.dat'
;fna='051230083452_DATA_SC.dat':;nomacdata
;station='SVL'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\060101\'
;fna='060101011139_DATA_SC(Mode-IM,IH).dat'
;fna='060101024836_DATA_SC(Mode-IH).dat'
;fna='060101042439_DATA_SC(Mode-IH).dat'
;fna='060101060043_DATA_SC.dat'
;fna='060101073628_DATA_SC.dat'
;fna='060101073628_DATA_SC(Mode-IH).dat'
;fna='060101091301_DATA_SC(Mode-IH).dat'
;fna='060101122720_DATA_SC.dat'
;fna='060101221656_DATA_SC.dat'
;station='SVL'
;simul=1

;fdir = 'C:\Usr\tsakanoi\Index\obs\060102\'
;fna='060102013037_DATA_SC.dat'
;fna='060102030733_DATA_SC.dat'
;fna='060102044352_DATA_SC.dat'
;fna='060102110922_DATA_SC.dat'
;fna='060102124605_DATA_SC.dat'
;station='SVL'
;simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\060110\'
fna='060110120428_DATA_SC.dat'
;fna='060103014934_DATA_SC.dat'
station='SVL'
simul=3


;fdir = 'C:\Usr\tsakanoi\Index\obs\060110\'
;fna='060110040231_DATA_SC(Mode-IM).dat'
;fna='060103014934_DATA_SC.dat'
;station='SVL'
;simul=3

fdir = 'C:\Usr\tsakanoi\Index\obs\new\'
fna='060214003611_SC.L0'
;fna='060103014934_DATA_SC.dat'
station='SVL'
simul=3

imode=0
;mode0(S), mode1(H), mode2(IH), mode3(IM)

exposure1=60.0
;exposure in ms



radimagefile='C:\Usr\tsakanoi\Index\obs\051110\051110004943_radcorrect_flame2.dat'

; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
; count to rayleigh convertion yes=1
rayleigh=0
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0

if radcorrect eq 1 then rayleigh=1

select_frame=0
;select_frame=1 then set pnums and pnume
;select_frame=0 then all frame are played
;0510150730metor event
;  pnums=600
;  pnume=700
  pnums=0
  pnume=500

;pnume=fnum-1

col=0
;col=3 is red
;col=1 is blue
;col=13 rainbow
;
;simul=3
;ch simulaneous on number

anime_fac=3.0

if imode eq 0 or imode eq 1 then begin
 ibin=16
 res=64
 anime_fac=3.0
endif else if imode eq 2 then begin
 ibin=2
 res=512
 anime_fac=1.0
endif else begin
 ibin=8
 res=128
 anime_fac=2.0
endelse

anime_resv=res*anime_fac
anime_resh=(res+1)*anime_fac*3-anime_fac

factor=1.0
;factor is brightness factor

;irot = 6
irot=7
;irot 7 or 2?? is correct, maybe.

mpname=fdir+strmid(fna,0,12)+'_'+strmid(string(simul),7,1)+'ch_'+station+'.mpg'

;=====parameter end=====

;if res eq 64 then begin
;  ibin=16
;endif else if res eq 128 then begin
;  ibin=8
;endif else begin
;  ibin=2
;endelse


close,/all

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels


sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal_o,fnum,pnume-1
;sub_read_si_mem,fname,res,imode,ibin,ich,mode,ti,imagetotal,fnum

print, 'file number = ',fnum
print, 'mpeg file name = ',mpname


if rayleigh eq 1 then begin

  exposure=fltarr(fnum)
  exposure(*)=exposure1
  count_to_rayleigh,imagetotal_o,radcorrect,radimagefile,imode,ich,res,exposure,fnum,imagetotal_linear,imagetotal_log10

  imagetotal=fltarr(res,res,fnum)
 ; imagetotal=imagetotal_log10
  imagetotal=imagetotal_linear

endif else begin
  imagetotal=fltarr(res,res,fnum)
 ; imagetotal=imagetotal_log10
  imagetotal=imagetotal_o
endelse

if simple_radcorrect eq 1 then begin
  radimage=fltarr(3,res,res)
  openr,2,radimagefile
  readf,2,radimage
  close,2

;imagetotal(*,*,where(ich eq 0))=imagetotal(*,*,where(ich eq 0))-radimage(0,*,*)
;imagetotal(*,*,where(ich eq 1))=imagetotal(*,*,where(ich eq 1))-radimage(1,*,*)
;imagetotal(*,*,where(ich eq 2))=imagetotal(*,*,where(ich eq 2))-radimage(2,*,*)
 for i=0,fnum-1 do begin
  if ich(i) eq 0 then begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(0,*,*)*0.8
  endif else if ich(i) eq 1 then begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(1,*,*)*0.6
  endif else begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(2,*,*)*0.9
  endelse
 endfor
 imagetotal(where(imagetotal lt 0)) =0

endif



;stop

if simul eq 1 then begin
  print, '1ch ON'
endif else if simul eq 2 then begin
  print, '2ch simultaneous ON'
endif else if simul eq 3 then begin
  print, '3ch simultaneous ON'
endif

;count_to_rayleigh,imagetotal1,imode,ich,res,exposure,fnum,imagetotal

if select_frame eq 0 then begin
  pnums=0
  pnume=fnum-1
endif

anum=0
anump=0

imagetotal_a=intarr(3,anime_resh,anime_resv)
imagetotal_a(*,*,*)=0

image1=intarr(res,res)
image1n=intarr(res,res)
image1m=intarr(res,res)

ich_a=intarr(pnume-pnums+1,3)

mpegID = OBJ_NEW('IDLgrMPEG', FILENAME=mpname, QUALITY=100)
set_plot, 'Z'
device, set_resolution = [anime_resh,anime_resv]

if res eq 64 then begin
  dtime=2
endif else if res eq 512 then begin
    dtime=45
endif else if res eq 128 then begin
  dtime=9
  ;this dtime will be revised later
endif


ipflg=0

for i=pnums,pnume do begin
  ich_a(anum,ich(i))=1

if i gt 0 then print, i,ich(i),time(i),time(i-1),'time(i)-time(i-1)=',time(i)-time(i-1),' / dtime=',dtime,'  notice time(i+2)-time(i)<dtime then animation is produced. '

  if simul eq 2 and i lt fnum-1 then begin
;    if time(i+1)-time(i) le dtime and time(i+1)-time(i) ge 1 then begin
    if time(i)-time(i-1) ge dtime then begin
 ;     print, 'anime'
      if iscale eq 1 then begin
        imaxf=max(imagetotal(*,*,i))
        iminf=min(imagetotal(*,*,i))
        imaxn=max(imagetotal(*,*,i+1))
        iminn=min(imagetotal(*,*,i+1))
      endif else begin
        imaxf=imax(ich(i))
        iminf=imin(ich(i))
        imaxn=imax(ich(i+1))
        iminn=imin(ich(i+1))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-iminf)/(imaxf-iminf)*255.0
      image1n(*,*)=(float(imagetotal(*,*,i+1))-iminn)/(imaxn-iminn)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
          if image1n(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1n(j,k) gt 255.0 then image1n(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
      endif else if ich(i) eq 1 then begin
        ichm=1
      endif else begin
        ichm=0
      endelse

      if ich(i+1) eq 0 then begin
        ichmn=2
      endif else if ich(i+1) eq 1 then begin
        ichmn=1
      endif else begin
        ichmn=0
      endelse

      if (ichm eq 0 and ichmn eq 1) or (ichm eq 1 and ichmn eq 0)then begin
        ichr=2
      endif else if (ichm eq 0 and ichmn eq 2) or (ichm eq 2 and ichmn eq 0) then begin
        ichr=1
      endif else begin
        ichr=0
      endelse

      imagetotal_a(ichm,(anime_resv+1)*(2-ichm):(anime_resv+1)*(2-ichm)+anime_resv-1,*)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichmn,(anime_resv+1)*(2-ichmn):(anime_resv+1)*(2-ichmn)+anime_resv-1,*)=congrid(rotate(image1n(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichr,(anime_resv+1)*(2-ichr):(anime_resv+1)*(2-ichr)+anime_resv-1,*)=0

;      print, i,anum,time(i),time(i+1),ichm
    endif else begin
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
      anum=anum+1
    endelse

   endif else if simul eq 3 and i gt 1 and i+2 lt fnum then begin
    if time(i)-time(i-1) ge dtime then begin
;   if time(i+1)-time(i) le dtime and time(i+1)-time(i) lt time(i+2)-time(i+1) then begin
;      print, 'anime'
      if iscale eq 1 then begin
        imax1=max(imagetotal(*,*,i))
        imin1=min(imagetotal(*,*,i))
        imax2=max(imagetotal(*,*,i+1))
        imin2=min(imagetotal(*,*,i+1))
        imax3=max(imagetotal(*,*,i+2))
        imin3=min(imagetotal(*,*,i+2))
;        imax1=max(imagetotal(*,*,where(ich eq 0)))*0.15
;        imin1=min(imagetotal(*,*,where(ich eq 0)))+2
;        imax2=max(imagetotal(*,*,where(ich eq 1)))*0.4
;        imin2=min(imagetotal(*,*,where(ich eq 1)))+25
;        imax3=max(imagetotal(*,*,where(ich eq 2)))*0.4
;        imin3=min(imagetotal(*,*,where(ich eq 2)))+10
      endif else begin
        imax1=imax(ich(i))
        imin1=imin(ich(i))
        imax2=imax(ich(i+1))
        imin2=imin(ich(i+1))
        imax3=imax(ich(i+2))
        imin3=imin(ich(i+2))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-imin1)/(imax1-imin1)*255.0
      image1n(*,*)=(float(imagetotal(*,*,i+1))-imin2)/(imax2-imin2)*255.0
      image1m(*,*)=(float(imagetotal(*,*,i+2))-imin3)/(imax3-imin3)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
          if image1n(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1n(j,k) gt 255.0 then image1n(j,k)=255.0
          if image1m(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1m(j,k) gt 255.0 then image1n(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
      endif else if ich(i) eq 1 then begin
        ichm=1
      endif else begin
        ichm=0
      endelse

      if ich(i+1) eq 0 then begin
        ichmn=2
      endif else if ich(i+1) eq 1 then begin
        ichmn=1
      endif else begin
        ichmn=0
      endelse

      if ich(i+2) eq 0 then begin
        ichr=2
      endif else if ich(i+2) eq 1 then begin
        ichr=1
      endif else begin
        ichr=0
      endelse

      imagetotal_a(ichm,(anime_resv+1)*(2-ichm):(anime_resv+1)*(2-ichm)+anime_resv-1,*)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichmn,(anime_resv+1)*(2-ichmn):(anime_resv+1)*(2-ichmn)+anime_resv-1,*)=congrid(rotate(image1n(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichr,(anime_resv+1)*(2-ichr):(anime_resv+1)*(2-ichr)+anime_resv-1,*)=congrid(rotate(image1m(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor

     ; stop
;      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
;      anum=anum+1

    endif else begin
;      print, i,time(i)
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
      anum=anum+1
      print, i,anum,time(i),time(i-1),ich(i),ich(i-1),time(i)-time(i-1),dtime
    endelse


  endif else if simul eq 1 then begin
      if iscale eq 1 then begin
        imax1=max(imagetotal(*,*,i))
        imin1=min(imagetotal(*,*,i))
      endif else begin
        imax1=imax(ich(i))
        imin1=imin(ich(i))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-imin1)/(imax1-imin1)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
        ichmn=0
        ichr=1
      endif else if ich(i) eq 1 then begin
        ichm=1
        ichmn=0
        ichr=2
      endif else begin
        ichm=0
        ichmn=2
        ichr=1
      endelse

      imagetotal_a(ichm,(anime_resv+1)*(2-ichm):(anime_resv+1)*(2-ichm)+anime_resv-1,*)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichmn,(anime_resv+1)*(2-ichmn):(anime_resv+1)*(2-ichmn)+anime_resv-1,*)=0
      imagetotal_a(ichr,(anime_resv+1)*(2-ichr):(anime_resv+1)*(2-ichr)+anime_resv-1,*)=0

      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      anum=anum+1
;      print, i,anum,time(i),time(i+1),ichm
    endif




;  imagetotal_a(*,*,i-pnums)=congrid(rotate(imagetotal(*,*,i),irot),anime_res,anime_res,pnume-pnums+1)*factor
;  print, i-pnums,anum
endfor

print, 'animation number=',anum



;for m=0,anum-1 do begin
;  print, m,'   ch',ich_a(m,0),ich_a(m,1),ich_a(m,2)
;endfor

MPEG_SAVE, mpegID
MPEG_CLOSE, mpegID

device,/close

print, 'Normal End! '
END
