;******************************************************************
;    program MACimage_si_mem_animation.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Sep 3, 2005
;******************************************************************

PRO MACimage_si_mem_animation_multi_color_auto
close,/all

iscale=01
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
imax=fltarr(3)
imin=fltarr(3)
imax(0)=100.0
imin(0)=20.0
imax(1)=80.0
imin(1)=30.0
imax(2)=80.0
imin(2)=30.0
;  imax and imin in kilo-Rayleigh

fdir = 'C:\Usr\tsakanoi\Index\obs\060110\'
station='SVL'
simul=3
fnanum1=n_elements(findfile(fdir+'*SC.dat'))
fna1=strarr(fnanum1)
fna1=findfile(fdir+'*SC.dat')

for fnanum=0, fnanum1-1 do begin
  fna=''
  fna2=''
  fna2=fna1(fnanum)
  fna=strmid(fna2,strlen(fdir),strlen(fna2)-strlen(fdir))
;station='SVL'

imode=0
;mode0(S), mode1(H), mode2(IH), mode3(IM)

exposure1=60.0
;exposure in ms



radimagefile='C:\Usr\tsakanoi\Index\obs\051110\051110004943_radcorrect_flame2.dat'

; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
; count to rayleigh convertion yes=1
rayleigh=0
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0

if radcorrect eq 1 then rayleigh=1

select_frame=0
;select_frame=1 then set pnums and pnume
;select_frame=0 then all frame are played
;0510150730metor event
;  pnums=600
;  pnume=700
  pnums=1100
  pnume=1637

;pnume=fnum-1

col=0
;col=3 is red
;col=1 is blue
;col=13 rainbow
;
;simul=3
;ch simulaneous on number

anime_fac=3.0

if imode eq 0 or imode eq 1 then begin
 ibin=16
 res=64
 anime_fac=3.0
endif else if imode eq 2 then begin
 ibin=2
 res=512
 anime_fac=1.0
endif else begin
 ibin=8
 res=128
 anime_fac=2.0
endelse

anime_resv=res*anime_fac
anime_resh=(res+1)*anime_fac*3-anime_fac

factor=1.0
;factor is brightness factor

;irot = 6
irot=7
;irot 7 or 2?? is correct, maybe.

mpname=fdir+strmid(fna,0,12)+'_'+strmid(string(simul),7,1)+'ch_'+station+'.mpg'

;=====parameter end=====


close,/all

fname=''
fname=fdir+fna

print, fname
;
print, 'filename='+fna
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels


sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal_o,fnum,pnume-1
;sub_read_si_mem,fname,res,imode,ibin,ich,mode,ti,imagetotal,fnum

print, 'file number = ',fnum
print, 'mpeg file name = ',mpname

if fnum lt 1 then goto, nextfile

if rayleigh eq 1 then begin

  exposure=fltarr(fnum)
  exposure(*)=exposure1
  count_to_rayleigh,imagetotal_o,radcorrect,radimagefile,imode,ich,res,exposure,fnum,imagetotal_linear,imagetotal_log10

  imagetotal=fltarr(res,res,fnum)
 ; imagetotal=imagetotal_log10
  imagetotal=imagetotal_linear

endif else begin
  imagetotal=fltarr(res,res,fnum)
 ; imagetotal=imagetotal_log10
  imagetotal=imagetotal_o
endelse

if simple_radcorrect eq 1 then begin
  radimage=fltarr(3,res,res)
  openr,2,radimagefile
  readf,2,radimage
  close,2

;imagetotal(*,*,where(ich eq 0))=imagetotal(*,*,where(ich eq 0))-radimage(0,*,*)
;imagetotal(*,*,where(ich eq 1))=imagetotal(*,*,where(ich eq 1))-radimage(1,*,*)
;imagetotal(*,*,where(ich eq 2))=imagetotal(*,*,where(ich eq 2))-radimage(2,*,*)
 for i=0,fnum-1 do begin
  if ich(i) eq 0 then begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(0,*,*)*0.8
  endif else if ich(i) eq 1 then begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(1,*,*)*0.6
  endif else begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(2,*,*)*0.9
  endelse
 endfor
 imagetotal(where(imagetotal lt 0)) =0

endif



;stop

if simul eq 1 then begin
  print, '1ch ON'
endif else if simul eq 2 then begin
  print, '2ch simultaneous ON'
endif else if simul eq 3 then begin
  print, '3ch simultaneous ON'
endif

;count_to_rayleigh,imagetotal1,imode,ich,res,exposure,fnum,imagetotal

if select_frame eq 0 then begin
  pnums=0
  pnume=fnum-1
endif

anum=0
anump=0

imagetotal_a=intarr(3,anime_resh,anime_resv)
imagetotal_a(*,*,*)=0

image1=intarr(res,res)
image1n=intarr(res,res)
image1m=intarr(res,res)

ich_a=intarr(pnume-pnums+1,3)

mpegID = OBJ_NEW('IDLgrMPEG', FILENAME=mpname, QUALITY=100)
set_plot, 'Z'
device, set_resolution = [anime_resh,anime_resv]

if res eq 64 then begin
  dtime=2
endif else if res eq 512 then begin
    dtime=45
endif else if res eq 128 then begin
  dtime=9
  ;this dtime will be revised later
endif


ipflg=0

for i=pnums,pnume do begin
  ich_a(anum,ich(i))=1

if i gt 0 then print, i,ich(i),time(i),time(i-1),'time(i)-time(i-1)=',time(i)-time(i-1),' / dtime=',dtime,'  notice time(i+2)-time(i)<dtime then animation is produced. '

  if simul eq 2 and i lt fnum-1 then begin
;    if time(i+1)-time(i) le dtime and time(i+1)-time(i) ge 1 then begin
    if time(i)-time(i-1) ge dtime then begin
 ;     print, 'anime'
      if iscale eq 1 then begin
        imaxf=max(imagetotal(*,*,i))
        iminf=min(imagetotal(*,*,i))
        imaxn=max(imagetotal(*,*,i+1))
        iminn=min(imagetotal(*,*,i+1))
      endif else begin
        imaxf=imax(ich(i))
        iminf=imin(ich(i))
        imaxn=imax(ich(i+1))
        iminn=imin(ich(i+1))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-iminf)/(imaxf-iminf)*255.0
      image1n(*,*)=(float(imagetotal(*,*,i+1))-iminn)/(imaxn-iminn)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
          if image1n(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1n(j,k) gt 255.0 then image1n(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
      endif else if ich(i) eq 1 then begin
        ichm=1
      endif else begin
        ichm=0
      endelse

      if ich(i+1) eq 0 then begin
        ichmn=2
      endif else if ich(i+1) eq 1 then begin
        ichmn=1
      endif else begin
        ichmn=0
      endelse

      if (ichm eq 0 and ichmn eq 1) or (ichm eq 1 and ichmn eq 0)then begin
        ichr=2
      endif else if (ichm eq 0 and ichmn eq 2) or (ichm eq 2 and ichmn eq 0) then begin
        ichr=1
      endif else begin
        ichr=0
      endelse

      imagetotal_a(ichm,(anime_resv+1)*(2-ichm):(anime_resv+1)*(2-ichm)+anime_resv-1,*)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichmn,(anime_resv+1)*(2-ichmn):(anime_resv+1)*(2-ichmn)+anime_resv-1,*)=congrid(rotate(image1n(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichr,(anime_resv+1)*(2-ichr):(anime_resv+1)*(2-ichr)+anime_resv-1,*)=0

;      print, i,anum,time(i),time(i+1),ichm
    endif else begin
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
      anum=anum+1
    endelse

   endif else if simul eq 3 and i gt 1 and i+2 lt fnum then begin
    if time(i)-time(i-1) ge dtime then begin
;   if time(i+1)-time(i) le dtime and time(i+1)-time(i) lt time(i+2)-time(i+1) then begin
;      print, 'anime'
      if iscale eq 1 then begin
        imax1=max(imagetotal(*,*,i))
        imin1=min(imagetotal(*,*,i))
        imax2=max(imagetotal(*,*,i+1))
        imin2=min(imagetotal(*,*,i+1))
        imax3=max(imagetotal(*,*,i+2))
        imin3=min(imagetotal(*,*,i+2))
;        imax1=max(imagetotal(*,*,where(ich eq 0)))*0.15
;        imin1=min(imagetotal(*,*,where(ich eq 0)))+2
;        imax2=max(imagetotal(*,*,where(ich eq 1)))*0.4
;        imin2=min(imagetotal(*,*,where(ich eq 1)))+25
;        imax3=max(imagetotal(*,*,where(ich eq 2)))*0.4
;        imin3=min(imagetotal(*,*,where(ich eq 2)))+10
      endif else begin
        imax1=imax(ich(i))
        imin1=imin(ich(i))
        imax2=imax(ich(i+1))
        imin2=imin(ich(i+1))
        imax3=imax(ich(i+2))
        imin3=imin(ich(i+2))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-imin1)/(imax1-imin1)*255.0
      image1n(*,*)=(float(imagetotal(*,*,i+1))-imin2)/(imax2-imin2)*255.0
      image1m(*,*)=(float(imagetotal(*,*,i+2))-imin3)/(imax3-imin3)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
          if image1n(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1n(j,k) gt 255.0 then image1n(j,k)=255.0
          if image1m(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1m(j,k) gt 255.0 then image1n(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
      endif else if ich(i) eq 1 then begin
        ichm=1
      endif else begin
        ichm=0
      endelse

      if ich(i+1) eq 0 then begin
        ichmn=2
      endif else if ich(i+1) eq 1 then begin
        ichmn=1
      endif else begin
        ichmn=0
      endelse

      if ich(i+2) eq 0 then begin
        ichr=2
      endif else if ich(i+2) eq 1 then begin
        ichr=1
      endif else begin
        ichr=0
      endelse

      imagetotal_a(ichm,(anime_resv+1)*(2-ichm):(anime_resv+1)*(2-ichm)+anime_resv-1,*)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichmn,(anime_resv+1)*(2-ichmn):(anime_resv+1)*(2-ichmn)+anime_resv-1,*)=congrid(rotate(image1n(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichr,(anime_resv+1)*(2-ichr):(anime_resv+1)*(2-ichr)+anime_resv-1,*)=congrid(rotate(image1m(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor

     ; stop
;      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
;      anum=anum+1

    endif else begin
;      print, i,time(i)
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
      anum=anum+1
      print, i,anum,time(i),time(i-1),ich(i),ich(i-1),time(i)-time(i-1),dtime
    endelse


  endif else if simul eq 1 then begin
      if iscale eq 1 then begin
        imax1=max(imagetotal(*,*,i))
        imin1=min(imagetotal(*,*,i))
      endif else begin
        imax1=imax(ich(i))
        imin1=imin(ich(i))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-imin1)/(imax1-imin1)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
        ichmn=0
        ichr=1
      endif else if ich(i) eq 1 then begin
        ichm=1
        ichmn=0
        ichr=2
      endif else begin
        ichm=0
        ichmn=2
        ichr=1
      endelse

      imagetotal_a(ichm,(anime_resv+1)*(2-ichm):(anime_resv+1)*(2-ichm)+anime_resv-1,*)=congrid(rotate(image1(*,*),irot),anime_resv,anime_resv,pnume-pnums+1)*factor
      imagetotal_a(ichmn,(anime_resv+1)*(2-ichmn):(anime_resv+1)*(2-ichmn)+anime_resv-1,*)=0
      imagetotal_a(ichr,(anime_resv+1)*(2-ichr):(anime_resv+1)*(2-ichr)+anime_resv-1,*)=0

      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anump, /color, /order
      anump=anump+1
      anum=anum+1
;      print, i,anum,time(i),time(i+1),ichm
    endif




;  imagetotal_a(*,*,i-pnums)=congrid(rotate(imagetotal(*,*,i),irot),anime_res,anime_res,pnume-pnums+1)*factor
;  print, i-pnums,anum
endfor

print, 'animation number=',anum



;for m=0,anum-1 do begin
;  print, m,'   ch',ich_a(m,0),ich_a(m,1),ich_a(m,2)
;endfor

MPEG_SAVE, mpegID
MPEG_CLOSE, mpegID

device,/close

nextfile:
endfor

print, 'Normal End! '
END
