;******************************************************************
;    program MACimage_si_mem_animation.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on Sep 3, 2005
;******************************************************************

PRO MACimage_si_mem_animation_multi_color_composite
close,/all

iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
imax=fltarr(3)
imin=fltarr(3)
imax(0)=300.0
imin(0)=0.0
imax(1)=150.0
imin(1)=10.0
imax(2)=150.0
imin(2)=10.0
;  imax and imin in kilo-Rayleigh

;offsets for alignment adjust
xoffset=intarr(3)
yoffset=intarr(3)
theta=dblarr(3)
phi=dblarr(3)
phi=[-0.187481079,-0.557782731,-0.737182143]
theta=[45.5681735,46.1965292,45.9116745]
xoffset(0)=fix(707.1/1.4578*tan((phi(0)-phi(1))*3.14159265*2.0/360.0))
yoffset(0)=fix(707.1/2.073*tan((theta(0)-theta(1))*3.14159265*2.0/360.0))
xoffset(1)=0
yoffset(1)=0
xoffset(2)=fix(707.1/1.4578*tan((phi(0)-phi(2))*3.14159265*2.0/360.0))
yoffset(2)=fix(707.1/2.073*tan((theta(1)-theta(0))*3.14159265*2.0/360.0))
center=20
center=20

;fdir = 'C:\Usr\tsakanoi\Index\obs\050830\'
;fna='050830_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050902\'
;fna='L0_0509020500SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050907\'
;fna='L0_0509070400SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050907\'
;fna='L0_0509070500SCA_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130400SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130500SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050916\'
;fna='20050916073009_DATA_SC.dat'
;fna='20050916221033_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050917074903_DATA_SC.dat'
;fna='20050917222943_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050918080801_DATA_SC.dat'
;fna='20050918211145_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050919\'
;fna='L0_0509190400SCA-N_DATA_SC.dat'
;fna='050919195333_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050920\'
;fna='050920070948_DATA_SC.dat'
;fna='050920133752_DATA_SC.dat'
;fna='050920201247_DATA_SC.dat'

;fdir = 'h:\Index\obs\050921\'
;fna='0509210400SCA-N_DATA_SC.dat'
;fna='050921072855_DATA_SC.dat'
;fna='050921135721_DATA_SC.dat'
;fna='050921203202_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\050922\'
;fna='050922043610_DATA_SC.dat'
;fna='050922074748_DATA_SC.dat'
;fna='050922205117_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050923\'
;fna='050923031856_DATA_SC.dat'
;fna='050923063058_DATA_SC.dat'
;fna='050923125746_DATA_SC.dat'
;fna='050923211029_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050924\'
;fna='050924033828_DATA_SC.dat'
;fna='050924064954_DATA_SC.dat'
;fna='050924131715_DATA_SC.dat'
;fna='050924212940_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050925\'
;fna='050925035653_DATA_SC.dat'
;fna='050925070832_DATA_SC.dat'
;fna='050925133634_DATA_SC.dat'
;fna='050925201130_DATA_SC.dat'


;fdir = 'C:\Usr\tsakanoi\Index\obs\050926\'
;fna='050926041630_DATA_SC.dat'
;fna='050926072739_DATA_SC.dat'
;fna='050926135553_DATA_SC.dat'
;fna='050926185258_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050927\'
;fna='050927012141_DATA_SC.dat'
;fna='050927025838_DATA_SC.dat'
;fna='050927043450_DATA_SC.dat'
;fna='050927061048_DATA_SC.dat'


;fdir = 'C:\Usr\tsakanoi\Index\obs\051004\'
;fna='051004064717_DATA_SC.dat'
;fna='051004131435_DATA_SC.dat'
;fna='051004212658_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051005\'
;fna='051005021734_DATA_SC.dat'
;fna='051005070552_DATA_SC.dat'
;fna='051005133347_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051006\'
;fna='051006023564_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051012\'
;fna='051012043035_DATA_SC.dat'
;fna='051012074232_DATA_SC.dat'
;fna='051012074232_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051013\'
;fna='051013044952_DATA_SC.dat'
;fna='051013080125_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051014\'
;fna='051014064433_DATA_SC.dat'
;fna='051014082018_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051015\'
;fna='051015003803_DATA_SC.dat'
;fna='051015035123_DATA_SC.dat'
;fna='051015070305_DATA_SC.dat'
;fna='051015101631_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051016\'
;fna='051016005707_DATA_SC.dat'
;fna='051016041022_DATA_SC.dat'
;fna='051016054624_DATA_SC.dat'
;fna='051016103554_DATA_SC.dat'
;simul=2

;fdir = 'C:\Usr\tsakanoi\Index\obs\051017\'
;fna='051017042911_DATA_SC.dat'
;fna='051017060517_DATA_SC.dat'
;fna='051017074106_DATA_SC.dat'
;simul=2

fdir = 'H:\Index\obs\051220\'
;fna='051017042911_DATA_SC.dat'
;fna='051017060517_DATA_SC.dat'
;fna='051017074106_DATA_SC.dat'
;simul=2


station='SVL'

select_frame=01
;select_frame=1 then set pnums and pnume
;select_frame=0 then all frame are played
  pnums=350
  pnume=1040
;pnume=fnum-1


;simul=3
;ch simulaneous on number
exposure=40.0
;exposure in ms
res=64
anime_fac=3.0
anime_resv=fix((res+2*center)*anime_fac)
anime_resvi=fix((res)*anime_fac)

factor=1.0
;factor is brightness factor

;irot = 6
irot=7
;irot 7 or 2?? is correct, maybe.


mpname=fdir+strmid(fna,0,12)+'_'+strmid(string(simul),7,1)+'ch_comp_'+station+'.mpg'


;=====parameter end=====

if res eq 64 then begin
  ibin=16
endif else if res eq 128 then begin
  ibin=8
endif else begin
  ibin=2
endelse

close,/all

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels


;sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal1,fnum,pnume+1
sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal,fnum,pnume+1


print, 'file number = ',fnum
print, 'mpeg file name = ',mpname

if simul eq 1 then begin
  print, '1ch ON'
endif else if simul eq 2 then begin
  print, '2ch simultaneous ON'
endif else if simul eq 3 then begin
  print, '3ch simultaneous ON'
endif

;count_to_rayleigh,imagetotal1,imode,ich,res,exposure,fnum,imagetotal

if select_frame eq 0 then begin
  pnums=0
  pnume=fnum-1
endif

anum=0


imagetotal_a=intarr(3,anime_resv,anime_resv)
imagetotal_a(*,*,*)=0

image1=intarr(res,res)
image1n=intarr(res,res)
image1m=intarr(res,res)

ich_a=intarr(pnume-pnums+1,3)

mpegID = OBJ_NEW('IDLgrMPEG', FILENAME=mpname, QUALITY=100)
set_plot, 'Z'
device, set_resolution = [anime_resv,anime_resv]

centern=center*anime_fac

for i=pnums,pnume do begin

  ich_a(anum,ich(i))=1

;    print, time(i+1),time(i)
  if simul eq 2 and i lt fnum-1 then begin
    if time(i+1)-time(i) le 2 then begin
      if iscale eq 1 then begin
        imaxf=max(imagetotal(*,*,i))
        iminf=min(imagetotal(*,*,i))
        imaxn=max(imagetotal(*,*,i+1))
        iminn=min(imagetotal(*,*,i+1))
      endif else begin
        imaxf=imax(ich(i))
        iminf=imin(ich(i))
        imaxn=imax(ich(i+1))
        iminn=imin(ich(i+1))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-iminf)/(imaxf-iminf)*255.0
      image1n(*,*)=(float(imagetotal(*,*,i+1))-iminn)/(imaxn-iminn)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
          if image1n(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1n(j,k) gt 255.0 then image1n(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
      endif else if ich(i) eq 1 then begin
        ichm=1
      endif else begin
        ichm=0
      endelse
      startx1=(center+xoffset(2-ichm))*anime_fac
      starty1=(center+yoffset(2-ichm))*anime_fac

      if ich(i+1) eq 0 then begin
        ichmn=2
      endif else if ich(i+1) eq 1 then begin
        ichmn=1
      endif else begin
        ichmn=0
      endelse
      startx2=(center+xoffset(2-ichmn))*anime_fac
      starty2=(center+yoffset(2-ichmn))*anime_fac

      if (ichm eq 0 and ichmn eq 1) or (ichm eq 1 and ichmn eq 0)then begin
        ichr=2
      endif else if (ichm eq 0 and ichmn eq 2) or (ichm eq 2 and ichmn eq 0) then begin
        ichr=1
      endif else begin
        ichr=0
      endelse
      startx3=(center+xoffset(2-ichr))*anime_fac
      starty3=(center+yoffset(2-ichr))*anime_fac

      imagetotal_a(ichm,startx1:startx1+anime_resvi-1,starty1:starty1+anime_resvi-1)=congrid(rotate(image1(*,*),irot),anime_resvi,anime_resvi,pnume-pnums+1)*factor
      imagetotal_a(ichmn,startx2:startx2+anime_resvi-1,starty2:starty2+anime_resvi-1)=congrid(rotate(image1n(*,*),irot),anime_resvi,anime_resvi,pnume-pnums+1)*factor
;      imagetotal_a(ichr,startx3:startx3+anime_resvi-1,starty3:starty3+anime_resvi-1)=congrid(rotate(image1n(*,*),irot),anime_resvi,anime_resvi,pnume-pnums+1)*factor
      imagetotal_a(ichr,startx3:startx3+anime_resvi-1,starty3:starty3+anime_resvi-1)=0

;      print, i,anum,time(i),time(i+1),ichm
    endif else begin
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
      anum=anum+1
    endelse
   endif else if simul eq 3 and i lt fnum-2 then begin
    if time(i+2)-time(i) le 2 then begin
      if iscale eq 1 then begin
        imax1=max(imagetotal(*,*,i))
        imin1=min(imagetotal(*,*,i))
        imax2=max(imagetotal(*,*,i+1))
        imin2=min(imagetotal(*,*,i+1))
        imax3=max(imagetotal(*,*,i+2))
        imin3=min(imagetotal(*,*,i+2))
      endif else begin
        imax1=imax(ich(i))
        imin1=imin(ich(i))
        imax2=imax(ich(i+1))
        imin2=imin(ich(i+1))
        imax3=imax(ich(i+2))
        imin3=imin(ich(i+2))
      endelse

      image1(*,*)=(float(imagetotal(*,*,i))-imin1)/(imax1-imin1)*255.0
      image1n(*,*)=(float(imagetotal(*,*,i+1))-imin2)/(imax2-imin2)*255.0
      image1m(*,*)=(float(imagetotal(*,*,i+2))-imin3)/(imax3-imin3)*255.0

      for j=0,res-1 do begin
        for k=0,res-1 do begin
          if image1(j,k) lt 0.0 then image1(j,k)=0.0
          if image1(j,k) gt 255.0 then image1(j,k)=255.0
          if image1n(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1n(j,k) gt 255.0 then image1n(j,k)=255.0
          if image1m(j,k) lt 0.0 then image1n(j,k)=0.0
          if image1m(j,k) gt 255.0 then image1n(j,k)=255.0
        endfor
      endfor

      if ich(i) eq 0 then begin
        ichm=2
      endif else if ich(i) eq 1 then begin
        ichm=1
      endif else begin
        ichm=0
      endelse
      startx1=(center+xoffset(2-ichm))*anime_fac
      starty1=(center+yoffset(2-ichm))*anime_fac

      if ich(i+1) eq 0 then begin
        ichmn=2
      endif else if ich(i+1) eq 1 then begin
        ichmn=1
      endif else begin
        ichmn=0
      endelse
      startx2=(center+xoffset(2-ichmn))*anime_fac
      starty2=(center+yoffset(2-ichmn))*anime_fac

      if ich(i+2) eq 0 then begin
        ichr=2
      endif else if ich(i+2) eq 1 then begin
        ichr=1
      endif else begin
        ichr=0
      endelse
      startx3=(center+xoffset(2-ichr))*anime_fac
      starty3=(center+yoffset(2-ichr))*anime_fac

      imagetotal_a(ichm,startx1:startx1+anime_resvi-1,starty1:starty1+anime_resvi-1)=congrid(rotate(image1(*,*),irot),anime_resvi,anime_resvi,pnume-pnums+1)*factor
      imagetotal_a(ichmn,startx2:startx2+anime_resvi-1,starty2:starty2+anime_resvi-1)=congrid(rotate(image1n(*,*),irot),anime_resvi,anime_resvi,pnume-pnums+1)*factor
      imagetotal_a(ichr,startx3:startx3+anime_resvi-1,starty3:starty3+anime_resvi-1)=congrid(rotate(image1m(*,*),irot),anime_resvi,anime_resvi,pnume-pnums+1)*factor

    endif else begin
      MPEG_PUT, mpegID, image=imagetotal_a, FRAME=anum, /color, /order
      anum=anum+1
    endelse

;      print, i,anum,time(i),time(i+1),ichm
  endif


;  imagetotal_a(*,*,i-pnums)=congrid(rotate(imagetotal(*,*,i),irot),anime_res,anime_res,pnume-pnums+1)*factor
;  print, i-pnums,anum
endfor

print, 'animation number=',anum



;for m=0,anum-1 do begin
;  print, m,'   ch',ich_a(m,0),ich_a(m,1),ich_a(m,2)
;endfor

MPEG_SAVE, mpegID
MPEG_CLOSE, mpegID

device,/close

print, 'Normal End! '
END
