;******************************************************************
;    program MACimage_si_mem.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on July 31, 2003
;******************************************************************

PRO MACimage_si_mem_kR

close,/all
iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin=fltarr(3)
smax=fltarr(3)
smin(0) = 1
smax(0) = 10
smin(1) = 2
smax(1) = 20
smin(2) = 2
smax(2) = 30
;smax and smin in kR for ch1,2,3


;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130400SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130500SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050916073009_DATA_SC.dat'
;fna='20050916221033_DATA_SC.dat'
;fna='20050917074903_DATA_SC.dat'
;fna='20050917222943_DATA_SC.dat'
;fna='20050918080801_DATA_SC.dat'
;fna='20050918211145_DATA_SC.dat'

fdir = 'C:\Usr\tsakanoi\Index\obs\051227\'
;fna='L0_0509190400SCA-N_DATA_SC.dat'
fna='051222222026_DATA_SC.dat'
;fna='051227040158_DATA_SC.dat'

fdir = 'C:\Usr\tsakanoi\Index\obs\060101\'
fna='060101011139_DATA_SC(Mode-IM,IH).dat'
;fna='060101042439_DATA_SC(Mode-IH).dat':;madrid
;fna='060101073628_DATA_SC(Mode-IH).dat'
;fna='060101091301_DATA_SC(Mode-IH).dat'

imode=3
;mode0(S), mode1(H), mode2(IH), mode3(IM)

exposure1=60.0
;exposure time in msec


;---plot image size factor(nominal:7.5, one image large plot:30)
;fac=7.5
fac=30.0
  pnums=0
  pnume=1000


psdir='C:\Usr\tsakanoi\index\ps\'

hiniti=''
year=''
datec=''

radimagefile='C:\Usr\tsakanoi\Index\obs\051110\051110004943_radcorrect_flame2.dat'

; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
; count to rayleigh convertion yes=1
rayleigh=01
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0



igrey=01
;if igrey=1 then plot in grey scale
;col=0 is grey
;col=3 is red
;col=1 is blue
;col=13 is rainbow

;--col 0 or 13
;===========================

pdate=0l
ptime=0l

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'


;--- pdate and ptime for data selection which is avairable when fac=30.0

;pdate=20000319
;ptime=210748


;---image resolution(nominal:100, one image large plot:512)
;if fac eq 30 then begin
;  res = 512
;  res = 128
;  res=64
;endif else begin
;  res = 100
;  res=64
;endelse
;res = 512
;res=64

if imode eq 0 or imode eq 1 then begin
 ibin=16
 res=64
endif else if imode eq 2 then begin
 ibin=2
 res=512
endif else begin
 ibin=8
 res=128
endelse


;irot = 5
irot=7
;irot=2

;ibin=8

;plot in log scale?-1
ilog=1


;=====parameter end=====

close,/all

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
fn=''
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l
image1=intarr(res,res)

sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal1,fnum,pnume+1

print, 'file number = ',fnum

  exposure=fltarr(fnum)
  exposure(*)=exposure1

;count_to_rayleigh,imagetotal1,imode,ich,res,exposure,fnum,imagetotal
count_to_rayleigh,imagetotal1,radcorrect,radfile,imode,ich,res,exposure,fnum,imagetotal_linear,imagetotal_log10

  imagetotal=fltarr(res,res,fnum)

psmax=fltarr(3)
psmin=fltarr(3)

if ilog eq 1 then begin
  imagetotal=imagetotal_log10
  for ii=0,2 do begin
    psmax(ii)=alog10(smax(ii))
    psmin(ii)=alog10(smin(ii))
  endfor
endif else begin
  imagetotal=imagetotal_linear
  for ii=0,2 do begin
    psmax(ii)=(smax(ii))
    psmin(ii)=(smin(ii))
  endfor
endelse

ave=fltarr(fnum,3)
rms=fltarr(fnum,3)
avech=strarr(fnum,3)
rmsch=strarr(fnum,3)

for i=0, fnum-1 do begin
  image1=imagetotal(*,*,i)
  ibin1=ibin(i)
  set_xs_ys,ibin1,res,xst,yst,xen,yen

  for j=0,2 do begin
    result=moment(imagetotal(xst(j):xen(j),yst(j):yen(j),i))
    ave(i,j)=result(0)
    rms(i,j)=sqrt(result(1))
;    print,'average:',ave(i,j)
;    print,'rms:',rms(i,j)
    avech(i,j)=string(ave(i,j))
    rmsch(i,j)=string(rms(i,j))
  endfor
;  print, data
endfor


if iscale eq 1 then begin
  smin(*)=long(min(imagetotal)/5)*5l
  smax(*)=long((max(imagetotal))/5)*5l
  psmax(*)=smax(*)
  psmin(*)=psmin(*)
endif

plot:

;------------------- PS PROT ------------------

SET_PLOT, 'PS'

if fac lt 30 then begin
  fact=1.0
  factc=''
  psl='_kR'
endif else begin
  fact=1.8
  psl='l_kR'
endelse

e0=fix((fnum-1)/16)+1
s0=0
es=e0

FOR s=s0,es DO BEGIN

  fo=STRING(s+1)
  fo=STRTRIM(fo,1)

  st=0+20*s
  et=st+20-1

  if et gt fnum-1 then et=fnum-2



;------------------ DRAW IMAGE DATA  --------------
;

  xs=2500.0+1000*(fact-1.0)
  xd=4300.0
  ys=24500.0
  cm=''
  yd=2500.0
;if fac eq 30 then begin
;  xd=0.0
;  yd=0.0
;endif
  if fact ne 30.0 then ys=ys+yd+1500
  pix=0.0
  xpi=0.0
  ypi=0.0
  xpx=512
  ypx=512

;---plotting images
  FOR l=0, 3 DO BEGIN
    FOR k=0, 3 DO BEGIN

    n=s*16+4*l+k


    IF n gt fnum-1 THEN GOTO, NODATA

    if imode(n) eq 0 then begin
      cbin='Mode-S'
    endif else if imode(n) eq 1 then begin
      cbin='Mode-H'
    endif else if imode(n) eq 2 then begin
      cbin='Mode-IH'
    endif else if imode(n) eq 3 then begin
      cbin='Mode-IM'
    endif

    if ich(n) eq 0 then begin
      ch=' Ch.1'
      col=1
    endif else if ich(n) eq 1 then begin
      ch=' Ch.2'
      col=8
    endif else if ich(n) eq 2 then begin
      ch=' Ch.3'
      col=3
    endif

    if igrey eq 1 then col=0


    cbin=cbin+ch+strmid(fix(exposure),4,4)+' msec Exp.'

    if (fac eq 30.0) or (fac ne 30.0 and l eq 0 and k eq 0) then begin

      if fac eq 30 then begin
        if n le 9 then begin
          fo='000'+strmid(n,7,1)
        endif else if n le 99 then begin
          fo='00'+strmid(n,6,2)
        endif else if n le 999 then begin
          fo='0'+strmid(n,5,3)
        endif else begin
          fo=strmid(n,4,4)
        endelse
      endif

DEVICE, BITS_PER_PIXEL=16, /COLOR, $
 FILENAME=psdir+strmid(fna,0,strlen(fna)-4)+psl+fo+'IM.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
; XSIZE=21.0/5, YSIZE=29.7/5, XOFFSET=0.0, YOFFSET=0.0
 print,psdir+strmid(fna,0,strlen(fna)-4)+psl+fo+'.ps'
 print, fo,n,psl,s

 LOADCT, 0

!P.FONT=0
XYOUTS, 2100, 28000, '!8MAC image  ' + hiniti, $
 CHARSIZE=1.5,  CHARTHICK=1.5,  /DEVICE
if fac eq 30 then begin
  XYOUTS, 2200, 27000, 'filename='+fna+' page = '+string(n)+' /'+string(fnum), CHARSIZE=0.7, /DEVICE
endif else begin
  XYOUTS, 2200, 27000, 'filename='+fna+' page = '+fo+'  /'+string(es), CHARSIZE=0.7, /DEVICE
endelse

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
yd1=(ysi+400)/3.0
loadct,3
if igrey eq 1 then loadct,0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=yd1, /DEVICE
xyouts, xsc-1400.0, ysc+ysi-yd1-100.0, 'Ch.3:'+strmid(fix(smin(2)),5,3), charsize=0.8, charthick=1, /device
xyouts, xsc-1000.0+xsi+500.0, ysc+ysi-yd1-100.0, long(smax(2)), charsize=0.8, charthick=1, /device
loadct,8
if igrey eq 1 then loadct,0
TV, colorbar, xsc, ysc+yd1, XSIZE=xsi, YSIZE=yd1, /DEVICE
xyouts, xsc-1400.0,ysc+ysi-100.0, 'Ch.2:'+strmid(fix(smin(1)),5,3), charsize=0.8, charthick=1, /device
xyouts, xsc-1000.0+xsi+500.0, ysc+ysi-100.0, long(smax(1)), charsize=0.8, charthick=1, /device
loadct,1
if igrey eq 1 then loadct,0
TV, colorbar, xsc, ysc+2*yd1, XSIZE=xsi, YSIZE=yd1, /DEVICE
xyouts, xsc-1400.0, ysc+ysi+yd1-100.0, 'Ch.1:'+strmid(fix(smin(0)),5,3), charsize=0.8, charthick=1, /device
xyouts, xsc-1000.0+xsi+500.0, ysc+ysi+yd1-100.0, long(smax(0)), charsize=0.8, charthick=1, /device

plots, [xsc,xsc],[ysc+ysi+400,ysc+ysi+400+60],/device
plots, [xsc+xsi,xsc+xsi],[ysc+ysi+400,ysc+ysi+400+60],/device

if ilog eq 0 then begin
  XYOUTS, xsc+1000.0, ysc+ysi+2*yd1-100.0, 'intensity (kR)', CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
endif else begin
  XYOUTS, xsc+1000.0, ysc+ysi+2*yd1-100.0, 'log intensity (kR)', CHARSIZE=0.6,  CHARTHICK=1,   /DEVICE
endelse

endif

loadct,col

  if (fac eq 30.0) then begin

     sx=xs
     sy=ys-((xpx)*fac+yd)*(1)
;     XYOUTS, xs+xd*k+20*fac, ys+fac*50, 'filename='+fna,CHARSIZE=0.8*fact, /DEVICE
     XYOUTS,  2100, 26800, datec,CHARSIZE=0.8*fact,  CHARTHICK=1.0,   /DEVICE
     XYOUTS, 5000, 8500, 'TI='+string(time(n))+', No.='+string(n),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, 5000,7500, cbin,CHARSIZE=0.8*fact, /DEVICE
     TV, ROTATE(bytscl(imagetotal(*,*,n),min=psmin(ich(n)),max=psmax(ich(n))),irot), sx, sy, $
       XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   endif else if fac ne 30 then begin
     sx=xs+xd*k
     sy=ys-((xpx)*fac+yd)*(l+1)
     XYOUTS, xs+xd*k, (ys-400.0)-((xpx)*fac+yd+500*(fact-1))*(l+1), 'TI='+string(time(n))+', No.='+string(n),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, xs+xd*k,(ys-800.0)-((xpx)*fac+yd+500*(fact-1))*(l+1), cbin,CHARSIZE=0.8*fact, /DEVICE
     TV, ROTATE(bytscl(imagetotal(*,*,n),min=psmin(ich(n)),max=psmax(ich(n))),irot), sx, sy, $
       XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
  endif



ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE
endfor

print, 'Normal End! '
END
