;******************************************************************
;    program MACimage_si_mem.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on July 31, 2003
;******************************************************************

PRO MACimage_si_mem_kR_2ch

close,/all
iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin=fltarr(3)
smax=fltarr(3)
smin(0) = 0
smax(0) = 20
smin(1) = 0
smax(1) = 12
smin(2) = 0
smax(2) = 20
;smax and smin in kR for ch1,2,3


;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130400SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130500SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050916073009_DATA_SC.dat'
;fna='20050916221033_DATA_SC.dat'
;fna='20050917074903_DATA_SC.dat'
;fna='20050917222943_DATA_SC.dat'
;fna='20050918080801_DATA_SC.dat'
;fna='20050918211145_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050919\'
;fna='L0_0509190400SCA-N_DATA_SC.dat'
;fna='050919195333_DATA_SC.dat'
;exposure=40.0

fdir = 'C:\Usr\tsakanoi\Index\obs\050921\'
fna='050921072855_DATA_SC.dat'
exposure=40.0
;exposure time in msec

num_ch=2

;---plot image size factor(nominal:7.5, one image large plot:30)
fac=7.5
;fac=30.0

;if fac=7.5, then pnus and pnume are ignored.
  pnums=0
  pnume=7
if fac ne 30.0 then begin
  pnums=0
  pnume=0
endif

psdir='C:\Usr\tsakanoi\index\ps\'

hiniti=''
year=''
datec=''

igrey=0
;if igrey=1 then plot in grey scale
;col=0 is grey
;col=3 is red
;col=1 is blue
;col=13 is rainbow

;--col 0 or 13

;iut=1, then plot UT
iut=0
;iti=1, then plot TI
iti=1

;===========================

pdate=0l
ptime=0l

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'


for pnum=pnums,pnume do begin

;--- pdate and ptime for data selection which is avairable when fac=30.0

;pdate=20000319
;ptime=210748

if fac lt 30 then begin
  fact=1.0
  factc=''
  psl='_kR_2ch'
endif else begin
  fact=1.8
  if pnum le 9 then begin
    psl='l_kR_2ch'+'000'+strmid(pnum,7,1)
  endif else if pnum le 99 then begin
    psl='l_kR_2ch'+'00'+strmid(pnum,6,2)
  endif else if pnum le 999 then begin
    psl='l_kR_2ch'+'0'+strmid(pnum,5,3)
  endif else begin
    psl='l_kR_2ch'+strmid(pnum,4,4)
  endelse
endelse

;---image resolution(nominal:100, one image large plot:512)
if fac eq 30 then begin
  res = 512
;  res=64
endif else begin
;  res = 100
  res=64
endelse
;res = 512
;res=64

;irot = 5
irot=7
;irot=2

;=====parameter end=====

close,/all

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
fn=''
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l
image1=intarr(res,res)

sub_read_si_mem,fname,res,imode,ibin,ich,mode,time,imagetotal1,fnum,pnume+1

print, 'file number = ',fnum

count_to_rayleigh,imagetotal1,imode,ich,res,exposure,fnum,imagetotal



anum=0

pch=3
resh=res
resv=res

imagetotal_a=intarr(resh,resv,pch,fnum)
imagetotal_a(*,*,*,*)=0

;image1=intarr(res,res)
ich_a=intarr(fnum,3)
cpara=strarr(fnum,3)
time_a=lonarr(fnum,3)
cbin=strarr(fnum)

for i=0,fnum-1 do begin
  if iscale eq 1 then begin
    imax=max(imagetotal(*,*,i))
    imin=min(imagetotal(*,*,i))
  endif

;  image1(*,*)=rotate(imagetotal(*,*,i),1)

  imagetotal_a(*,*,ich(i),anum)=congrid(rotate(imagetotal(*,*,i),0),resv,resv,fnum)
  time_a(anum,ich(i))=time(i)
  ich_a(anum,ich(i))=1

  if imode(i) eq 0 then begin
    cbin(anum)='Mode-S, Exp.'+strmid(fix(exposure),4,4)+'msec.'
  endif else if imode(i) eq 1 then begin
    cbin(anum)='Mode-H, Exp.'+strmid(fix(exposure),4,4)+'msec.'
  endif else if imode(i) eq 2 then begin
    cbin(anum)='Mode-IH, Exp.'+strmid(fix(exposure),4,4)+'msec.'
  endif else if imode(i) eq 3 then begin
    cbin(anum)='Mode-IM, Exp.'+strmid(fix(exposure),4,4)+'msec.'
  endif

  if ich(i) eq 0 then begin
    ch=' Ch.1 (427.8 mm)'
  endif else if ich(i) eq 1 then begin
    ch=' Ch.2 (557.7 nm)'
  endif else if ich(i) eq 2 then begin
    ch=' Ch.3 (670 nm)'
  endif

  cpara(anum,ich(i))=ch


  if i ne fnum-1 then begin
;    print, time(i+1),time(i)
    if time(i+1)-time(i) gt 2 then begin
      anum=anum+1
    endif
  endif

;  imagetotal_a(*,*,i-pnums)=congrid(rotate(imagetotal(*,*,i),irot),anime_res,anime_res,pnume-pnums+1)*factor
;  print, i-pnums,anum
endfor

print, 'animation number=',anum


if iscale eq 1 then begin
  smin(*)=fix(min(imagetotal_a)/5)*5l
  smax(*)=fix((max(imagetotal_a))/5)*5l
endif



plot:

;------------------- PS PROT ------------------

SET_PLOT, 'PS'

l1=11
k1=4-num_ch

e0=fix((fnum-1)/((l1+1)*(k1+1)))+1
s0=0
es=e0

FOR s=s0,es DO BEGIN

fo=STRING(s+1)
fo=STRTRIM(fo,1)

st=0+20*s
et=st+20-1

if et gt fnum-1 then et=fnum-2



;------------------ DRAW IMAGE DATA  --------------
;

xs=3000
xd=2000.0
ys=-500.0
cm=''
yd=4000.0
;if fac eq 30 then begin
;  xd=0.0
;  yd=0.0
;endif
if fact ne 30.0 then ys=ys+yd+1500
pix=0.0
xpi=0.0
ypi=0.0
xpx=256
ypx=256


;---plotting images
FOR k=0, k1 DO BEGIN

FOR l=0, l1 DO BEGIN

n=s*(l1+1)*(k1*1)+(k1+1)*k+l

;print,s,l,k,n,imode(n)

 IF n ge anum THEN GOTO, NODATA

if igrey eq 1 then col=0


 if (fac eq 30.0 and n eq pnum) or (fac ne 30.0 and l eq 0 and k eq 0) then begin

DEVICE, BITS_PER_PIXEL=16, /COLOR, $
 FILENAME=psdir+strmid(fna,0,strlen(fna)-4)+psl+fo+'.ps', /portrait, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
 print,psdir+strmid(fna,0,strlen(fna)-4)+psl+fo+'.ps'
 print, fo,n,psl,pnum

 LOADCT, 0
!P.FONT=0

XYOUTS, 1100, 2800, '!8MAC image  ' + hiniti,  CHARSIZE=1.5,  CHARTHICK=1.5,orientation=90.0,  /DEVICE
if fac eq 30 then begin
  XYOUTS, 2200, 2700, 'filename='+fna+'      page = '+string(pnum)+' /'+string(pnume), CHARSIZE=1.0,orientation=90.0, /DEVICE
endif else begin
  XYOUTS, 2200, 2700, 'filename='+fna+'      page = '+fo+'  /'+string(es), CHARSIZE=0.7,orientation=90.0, /DEVICE
endelse

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=800.0
xsc=2000.0
ysc=20500.0
yd1=(ysi)/3.0
loadct,3
if igrey eq 1 then loadct,0
TV, rotate(colorbar,1), xsc, ysc, XSIZE=yd1, YSIZE=xsi, /DEVICE
xyouts, xsc+yd1, ysc-1200.0, 'Ch.3:'+strmid(fix(smin(2)),5,3), charsize=0.8, charthick=1,orientation=90, /device
xyouts, xsc+yd1, ysc+xsi-500, long(smax(2)), charsize=0.8, charthick=1,orientation=90, /device
loadct,8
if igrey eq 1 then loadct,0
TV, rotate(colorbar,1), xsc-yd1, ysc, XSIZE=yd1, YSIZE=xsi, /DEVICE
xyouts, xsc,ysc-1200.0, 'Ch.2:'+strmid(fix(smin(1)),5,3), charsize=0.8, charthick=1,orientation=90, /device
xyouts, xsc, ysc+xsi-500, long(smax(1)), charsize=0.8, charthick=1,orientation=90, /device
loadct,1
if igrey eq 1 then loadct,0
TV, rotate(colorbar,1), xsc-yd1*2, ysc, XSIZE=yd1, YSIZE=xsi, /DEVICE
xyouts, xsc-yd1, ysc-1200.0, 'Ch.1:'+strmid(fix(smin(0)),5,3), charsize=0.8, charthick=1,orientation=90, /device
xyouts, xsc-yd1, ysc+xsi-500, long(smax(0)), charsize=0.8, charthick=1,orientation=90, /device

plots, [xsc-2*yd1,xsc-2*yd1-100],[ysc,ysc],/device
plots, [xsc-2*yd1,xsc-2*yd1-100],[ysc+xsi,ysc+xsi],/device

XYOUTS, xsc-2.5*yd1, ysc+1000.0, 'intensity (kR)', CHARSIZE=0.8,  CHARTHICK=1,orientation=90.0,   /DEVICE

endif

  if (fac eq 30.0 and n eq pnum) then begin

     sx=xs
     sy=ys-((xpx)*fac+yd)*(1)
;     XYOUTS, xs+xd*k+20*fac, ys+fac*50, 'filename='+fna,CHARSIZE=0.8*fact, /DEVICE
     XYOUTS,  2100, 26800, datec,CHARSIZE=0.8*fact,  CHARTHICK=1.0,   /DEVICE
     XYOUTS, 5000, 8500, 'TI='+string(time(n))+', No.='+string(n),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, 5000,7500, cbin,CHARSIZE=0.8*fact, /DEVICE
     TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin(ich(n)),max=smax(ich(n))),irot), sx, sy, $
       XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   endif else if fac ne 30 then begin
     sx=xs+((xpx)*fac+yd)*(k)
     sy=ys+xd*(l)
     ap=0
     timin=min(time_a(n,where(time_a(n,*) ne 0)))
     if iut eq 1 then begin
       XYOUTS, sx+num_ch*xpx*fac+300, sy, 'UT='+string(185005),CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
     endif
     if iti eq 1 then begin
       XYOUTS, sx+num_ch*xpx*fac+600, sy, 'TI='+string(timin),CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
     endif
     XYOUTS, sx+num_ch*xpx*fac+900, sy,cbin(n),CHARSIZE=0.45*fact,orientation=90.0, /DEVICE
     for m=0,2 do begin
       if ich_a(n,m) ne 0 then begin
         if m eq 0 then begin
           col=1
         endif else if m eq 1 then begin
           col=8
         endif else begin
           col=3
         endelse
         loadct,col
         TV, ROTATE(bytscl(imagetotal_a(*,*,m,n),min=smin(m),max=smax(m)),4), sx+ap*((num_ch-1)*xpx+5)*fac, sy, XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
         XYOUTS, sx+num_ch*(xpx)*fac+1200+300*ap, sy,cpara(n,m),CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
         ap=ap+1
       endif
     endfor
  endif




ENDFOR
ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE

endfor

print, 'Normal End! '
END
