;******************************************************************
;    program MACimage_si_mem.pro
;
;       MAC successive plot for SI memory data
;
;          by TS on July 31, 2003
;******************************************************************

PRO MACimage_si_mem_kR_multi

close,/all

;exposure time manual-1
exman=01
expos=60.0

iscale=0
;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
smin=fltarr(3)
smax=fltarr(3)
smin1=fltarr(3)
smax1=fltarr(3)
smin1(0) = 5
smax1(0) = 10
smin1(1) = 5
smax1(1) = 70
smin1(2) = 5
smax1(2) = 70
;smax and smin in kR for ch1,2,3

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130400SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050913\'
;fna='L0_0509130500SCA-N_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050917\'
;fna='20050916073009_DATA_SC.dat'
;fna='20050916221033_DATA_SC.dat'
;fna='20050917074903_DATA_SC.dat'
;fna='20050917222943_DATA_SC.dat'
;fna='20050918080801_DATA_SC.dat'
;fna='20050918211145_DATA_SC.dat'

;fdir = 'C:\Usr\tsakanoi\Index\obs\050919\'
;fna='L0_0509190400SCA-N_DATA_SC.dat'
;fna='050919195333_DATA_SC.dat'
;

;fdir = 'C:\Usr\tsakanoi\Index\obs\050921\'
;fna='0509210400SCA-N_DATA_SC.dat'
;fna='050921072855_DATA_SC.dat'
;exposure=40.0
;exposure time in msec


;fdir = 'C:\Usr\tsakanoi\Index\obs\051029\'
;fna='051029112946_DATA_SC.dat'
;simul=3
;exposure=40.0

;fdir = 'C:\Usr\tsakanoi\Index\obs\051030\'
;fna='051030003341_DATA_SC.dat'
;fna='051030034659_DATA_SC.dat'
;fna='051030052306_DATA_SC.dat'
;fna='051030065847_DATA_SC.dat'
;fna='051030083459_DATA_SC.dat'
;exposure=40.0
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051031\'
;fna='051031005244_DATA_SC.dat'
;fna='051031054201_DATA_SC.dat'
;fna='051031071737_DATA_SC.dat'
;exposure=40.0
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051102\'
;fna='051102013046_DATA_SC.dat'
;stafile='C:\Usr\tsakanoi\index\obs\051102\IDX_STA_0511012229_L1'
;simul=3

;fdir = 'C:\Usr\tsakanoi\Index\obs\051104\'
;fna='051104065721_DATA_SC.dat'
;fna='051104083327_DATA_SC.dat'
;fna='051104114716_DATA_SC.dat'
;fna='051104132458_DATA_SC.dat'

;fdir = 'G:\Index\obs\051105\'
;fna='051105054030_DATA_SC.dat'

;fdir = 'G:\Index\obs\051201\'
;fna='051201135544_DATA_SC.dat'
;stafile='G:\Index\obs\051201\IDX_STA_0512010916_L1'
;simul=3

;fdir = 'G:\Index\obs\051202\'
;fna='051202123710_DATA_SC.dat'
;stafile='G:\Index\obs\051202\IDX_STA_0512020934_L1'
;simul=3

;fdir = 'G:\Index\obs\051204\'
;fna='051204131533_DATA_SC.dat'
;stafile='G:\Index\obs\051204\IDX_STA_0512041012_L1'
;simul=3

fdir = 'G:\Index\obs\051222\'
fna='051222222026_DATA_SC.dat'
stanum=2
stafile=strarr(stanum)
stafile(0)=fdir+'IDX_STA_0512220755_L1'
stafile(1)=fdir+'IDX_STA_0512220931_L1'
simul=3



;fdir = 'C:\Usr\tsakanoi\index\obs\060101\'
;fdir1 = 'C:\Usr\tsakanoi\index\obs\060101\'
;fna='060101042439_DATA_SC(Mode-IH).dat'
;;fna='051226215940_DATA_SC.dat'
;;fna='051227011323_DATA_SC.dat'
;stanum=2
;stafile=strarr(stanum)
;;stafile(0)=fdir1+'IDX_STA_051231-13-33_L1'
;stafile(0)=fdir1+'IDX_STA_0512311544_L1'
;stafile(1)=fdir1+'IDX_STA_0601010618_L1'
;simul=3

;fdir = 'C:\Usr\tsakanoi\index\obs\051205\'
;fna='051205133449_DATA_SC.dat'
;stafile='c:\Usr\tsakanoi\index\obs\051205\IDX_STA_0512051031_L1'
;simul=3

;fdir = 'C:\Usr\tsakanoi\index\obs\051206\'
;fna='051206220611_DATA_SC.dat'
;stafile='c:\Usr\tsakanoi\index\obs\051206\IDX_STA_0512060914_L1'
;simul=3

;fdir = 'C:\Usr\tsakanoi\index\obs\051207\'
;fna='051207092118_DATA_SC.dat'
;stafile='c:\Usr\tsakanoi\index\obs\051207\IDX_STA_0512070757_L1'
;simul=3

;fdir = 'C:\Usr\tsakanoi\index\obs\051207\'
;fna='051207123536_DATA_SC.dat'
;stafile='c:\Usr\tsakanoi\index\obs\051207\IDX_STA_0512070757_L1'
;stafile='c:\Usr\tsakanoi\index\obs\051207\IDX_STA_0512070933_L1'
;simul=3


radimagefile='C:\Usr\tsakanoi\Index\obs\051110\051110004943_radcorrect_flame2.dat'

; radiation noise correction with rayleigh conversion yes=1
radcorrect=0
; count to rayleigh convertion yes=1
rayleigh=01
; radiation noise correction with simple difference estimation in log scale
simple_radcorrect=0

if radcorrect eq 1 then rayleigh=1



;---plot image size factor(nominal:7.5, one image large plot:30)
fac=7.5
;fac=30.0

;if fac=7.5, then pnus and pnume are ignored.
  pnums=0
  pnume=7
if fac ne 30.0 then begin
  pnums=0
  pnume=0
endif

psdir='C:\Usr\tsakanoi\index\ps\'

hiniti=''
year=''
datec=''

igrey=0
;if igrey=1 then plot in grey scale
;col=0 is grey
;col=3 is red
;col=1 is blue
;col=13 is rainbow

;--col 0 or 13

;log plot ilog=1
ilog=1

if ilog eq 1 then begin
  for i=0,2 do begin
    smin(i)=alog10(smin1(i))
    smax(i)=alog10(smax1(i))
  endfor
endif else begin
  for i=0,2 do begin
    smin(i)=(smin1(i))
    smax(i)=(smax1(i))
  endfor
endelse

;iut=1, then plot UT
iut=1
;iti=1, then plot TI
iti=1

ti_unit=31.25
;ti_unit is 1 TI in msec

;------start time and TI
;sh=19
;sm=17
;ss=04
;sti=41338

;ihh=0l
;shhmmss=sh*10000l+sm*100+ss
;hhtosec_hhmmss, shhmmss, ssec,ih,im,is

timsec=0.0d
dt=0.0d
;===========================

pdate=0l
ptime=0l

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'

num_ch=simul

for pnum=pnums,pnume do begin

;--- pdate and ptime for data selection which is avairable when fac=30.0

;pdate=20000319
;ptime=210748

if fac lt 30 then begin
  fact=1.0
  factc=''
  psl='_kR_m'
endif else begin
  fact=1.8
  if pnum le 9 then begin
    psl='l_kR_m'+'000'+strmid(pnum,7,1)
  endif else if pnum le 99 then begin
    psl='l_kR_m'+'00'+strmid(pnum,6,2)
  endif else if pnum le 999 then begin
    psl='l_kR_m'+'0'+strmid(pnum,5,3)
  endif else begin
    psl='l_kR_m'+strmid(pnum,4,4)
  endelse
endelse

;---image resolution(nominal:100, one image large plot:512)
if fac eq 30 then begin
  res = 512
;  res=64
endif else begin
;  res = 100
  res=64
endelse
;res = 512
;res=64

;irot = 5
irot=4
;irot=2

;=====parameter end=====

close,/all

if res eq 64 then begin
  ibin=16
endif else if res eq 512 then begin
  ibin=2
endif else begin
  ibin=8
endelse

fname=''
fname=fdir+fna

print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
fn=''
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l
image1=intarr(res,res)

sub_read_si_mem_newti,fname,res,imode,ibin,ich,mode,time,imagetotal_o,fnum,pnume+1

print, 'file number = ',fnum
;reading status parameters from L1 status file --------------
status_read_multi_newti,stanum,stafile,yyr,mor,ddr,hhr,mmr,ssr,tir,sitir,shu_pwrr,sdr_pwrr,p3vr,p15vr,m15vr,p20vr,a5vr,d5vr,$
  mac_pwrr,mac_moder,mac_tmonr,mac_datar,mac_errr,mac_exposurer,mac_cam1r,mac_cam2r,mac_cam3r,$
  mac_tr,mac_c1_tr,mac_f1_tr,mac_c2_tr,mac_f2_tr,mac_c3_tr,mac_f3_tr,esa_pwrr,isa_pwrr,eisa_calr,$
  esa_hv_pwrr,isa_hv_pwrr,esa_sv_pwrr,isa_sv_pwrr,esa_hv_enar,isa_hv_enar,esa_sv_enar,isa_sv_enar,$
  esa_hv_bsyr,isa_hv_bsyr,esa_sv_bsyr,isa_sv_bsyr,esa_hv_lvlr,isa_hv_lvlr,eisa_sv_lvlr,$
  esa_tr,isa_tr,esa_hvr,isa_hvr,esa_svr,isa_svr,eisa_mvr,crm_pwrr,sdr_recaddr,sdr_repaddr,rdr_sizer,$
  rdr_recaddr,rdr_repaddr,suspendr,cmd_mac_ansr

;stop

est_to_sec,mac_exposurer,expor
for i=0, n_elements(expor)-2 do begin
  if expor(i) eq 0 and expor(i+1) ne 0 then expor(i)=expor(i+1)
  if expor(i) ne 0 and expor(i+1) eq 0 then expor(i+1)=expor(i)
endfor

if exman eq 1 then begin
  expor(*)=expos
endif

;stop

find_obstime,yyr,mor,ddr,hhr,mmr,ssr,expor,sitir,time,tsec_obs,$
  yy_obs,mo_obs,dd_obs,hh_obs,mm_obs,ss_obs,expo_obs



if max(tsec_obs) eq 0 then begin
  print,'STA file is not matched to SC.dat file.'
  stop
endif


if rayleigh eq 1 then begin

  count_to_rayleigh,imagetotal_o,radcorrect,radimagefile,imode,ich,res,expo_obs,fnum,imagetotal_linear,imagetotal_log10

  imagetotal=fltarr(res,res,fnum)
 ; imagetotal=imagetotal_log10
  imagetotal=imagetotal_linear

endif else begin
  imagetotal=fltarr(res,res,fnum)
 ; imagetotal=imagetotal_log10
  imagetotal=imagetotal_o
endelse

if simple_radcorrect eq 1 then begin
  radimage=fltarr(3,res,res)
  openr,2,radimagefile
  readf,2,radimage
  close,2

;imagetotal(*,*,where(ich eq 0))=imagetotal(*,*,where(ich eq 0))-radimage(0,*,*)
;imagetotal(*,*,where(ich eq 1))=imagetotal(*,*,where(ich eq 1))-radimage(1,*,*)
;imagetotal(*,*,where(ich eq 2))=imagetotal(*,*,where(ich eq 2))-radimage(2,*,*)
 for i=0,fnum-1 do begin
  if ich(i) eq 0 then begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(0,*,*)*0.8
  endif else if ich(i) eq 1 then begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(1,*,*)*0.6
  endif else begin
    imagetotal(*,*,i)=imagetotal(*,*,i)-radimage(2,*,*)*0.9
  endelse
 endfor
 imagetotal(where(imagetotal lt 0)) =0

endif

;count_to_rayleigh_n,imagetotal1,imode,ich,res,expo_obs,fnum,imagetotal

;stop

;---------------------
if res eq 64 then begin
  dtime=2
endif else if res eq 512 then begin
  dtime=83
endif else if res eq 128 then begin
  dtime=40
  ;this dtime will be revised later
endif



anum=0
aflg=0

pch=3
resh=res
resv=res

imagetotal_a=fltarr(resh,resv,pch,fnum)
imagetotal_a(*,*,*,*)=0
hh_obs_a=intarr(fnum)
mm_obs_a=intarr(fnum)
ss_obs_a=dblarr(fnum)
yy_obs_a=intarr(fnum)
mo_obs_a=strarr(fnum)
dd_obs_a=intarr(fnum)

;image1=intarr(res,res)
ich_a=intarr(fnum,3)
cpara=strarr(fnum,3)
time_a=lonarr(fnum,3)
cbin=strarr(fnum)
expo_obs_a=intarr(fnum)

for i=0,fnum-1 do begin
  if iscale eq 1 then begin
    imax=max(imagetotal(*,*,i))
    imin=min(imagetotal(*,*,i))
  endif

;  image1(*,*)=rotate(imagetotal(*,*,i),1)

if ilog eq 0 then begin
  imagetotal_a(*,*,ich(i),anum)=congrid(rotate(imagetotal(*,*,i),0),resv,resv,fnum)
endif else begin
  imagetotal_a(*,*,ich(i),anum)=congrid(rotate(alog10(imagetotal(*,*,i)),0),resv,resv,fnum)
endelse

  time_a(anum,ich(i))=time(i)
  ich_a(anum,ich(i))=1
  hh_obs_a(anum)=hh_obs(i)
  mm_obs_a(anum)=mm_obs(i)
  ss_obs_a(anum)=ss_obs(i)
;  stop
  yy_obs_a(anum)=yy_obs(i)
  mo=mo_obs(i)
  mon_to_cmon,mo,cmon
  mo_obs_a(anum)=cmon
  dd_obs_a(anum)=dd_obs(i)
  expo_obs_a(anum)=expo_obs(i)

print, i,hh_obs(i),mm_obs(i),ss_obs(i),expo_obs(i),ich(i),anum,mo,cmon


  if imode(i) eq 0 then begin
    cbin(anum)='Mode-0, Exp.'+strmid(expo_obs(i),4,4)+'msec.'
  endif else if imode(i) eq 1 then begin
    cbin(anum)='Mode-1, Exp.'+strmid(expo_obs(i),4,4)+'msec.'
  endif else if imode(i) eq 2 then begin
    cbin(anum)='Mode-2, Exp.'+strmid(expo_obs(i),4,4)+'msec.'
  endif else if imode(i) eq 3 then begin
    cbin(anum)='Mode-3, Exp.'+strmid(expo_obs(i),4,4)+'msec.'
  endif

  if ich(i) eq 0 then begin
    ch=' Ch.1 (428 mm)'
  endif else if ich(i) eq 1 then begin
    ch=' Ch.2 (558 nm)'
  endif else if ich(i) eq 2 then begin
    ch=' Ch.3 (670 nm)'
  endif

  cpara(anum,ich(i))=ch


  if i ne 0 and i ne fnum-1 then begin
;    print, time(i+1),time(i),time(i+1)-time(i),dtime,ich(i)
    if time(i+1)-time(i) ge dtime then begin
      anum=anum+1
      aflg=0
    endif else if time(i)-time(i-1) ge dtime then begin
      aflg=1
    endif else begin
      aflg=0
    endelse

;    if time(i)-time(i-1) ge dtime then begin
;   if time(i+1)-time(i) le dtime and time(i+1)-time(i) lt time(i+2)-time(i+1) then begin
;      print, 'anime'
;    if time(i+1)-time(i) gt 2 then begin
;      anum=anum+1
;    endif
  endif

;  imagetotal_a(*,*,i-pnums)=congrid(rotate(imagetotal(*,*,i),irot),anime_res,anime_res,pnume-pnums+1)*factor
;  print, i-pnums,anum
endfor

print, 'animation number=',anum

;stop

if iscale eq 1 then begin
  smin(*)=fix(min(imagetotal_a)/5)*5l
  smax(*)=fix((max(imagetotal_a))/5)*5l
endif


;stop

plot:

;------------------- PS PROT ------------------

SET_PLOT, 'PS'

l1=11
k1=4-num_ch

e0=fix((anum)/((l1+1)*(k1+1)))+1
s0=0
es=e0

FOR s=s0,es DO BEGIN

fo=STRING(s+1)
fo=STRTRIM(fo,1)

;st=0+20*s
;et=st+20-1

;if et gt fnum-1 then et=fnum-2



;------------------ DRAW IMAGE DATA  --------------
;

xs=3000
xd=2000.0
ys=-2000.0
cm=''
yd=4000.0
;if fac eq 30 then begin
;  xd=0.0
;  yd=0.0
;endif
if fact ne 30.0 then ys=ys+yd+1500
pix=0.0
xpi=0.0
ypi=0.0
xpx=256
ypx=256


;---plotting images
FOR k=0, k1 DO BEGIN

FOR l=0, l1 DO BEGIN

n=(s)*(l1+1)*(k1+1)+(l1+1)*k+l

print,s,l,k,n,imode(n),anum

 IF n gt anum THEN GOTO, NODATA

if igrey eq 1 then col=0


 if (fac eq 30.0 and n eq pnum) or (fac ne 30.0 and l eq 0 and k eq 0) then begin

DEVICE, BITS_PER_PIXEL=16, /COLOR, $
 FILENAME=psdir+strmid(fna,0,strlen(fna)-4)+psl+fo+'.ps', /portrait, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
 print,psdir+strmid(fna,0,strlen(fna)-4)+psl+fo+'.ps'
 print, fo,n,psl,pnum

 LOADCT, 0
!P.FONT=0

XYOUTS, 1100, 2800, '!8MAC image  ' + hiniti,  CHARSIZE=1.5,  CHARTHICK=1.5,orientation=90.0,  /DEVICE
if fac eq 30 then begin
  XYOUTS, 2200, 2700, 'filename='+fna+'      page = '+string(pnum)+' /'+string(pnume), CHARSIZE=1.0,orientation=90.0, /DEVICE
endif else begin
  XYOUTS, 2200, 2700, 'filename='+fna+'      page = '+fo+'  /'+string(es), CHARSIZE=0.7,orientation=90.0, /DEVICE
endelse

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=800.0
xsc=2000.0
ysc=20500.0
yd1=(ysi)/3.0
loadct,3
if igrey eq 1 then loadct,0
TV, rotate(colorbar,1), xsc, ysc, XSIZE=yd1, YSIZE=xsi, /DEVICE
xyouts, xsc+yd1, ysc-2200.0, 'N2 670 nm:'+strmid(fix(smin1(2)),5,3), charsize=0.8, charthick=1,orientation=90, /device
xyouts, xsc+yd1, ysc+xsi-500, long(smax1(2)), charsize=0.8, charthick=1,orientation=90, /device

loadct,8
if igrey eq 1 then loadct,0
TV, rotate(colorbar,1), xsc-yd1, ysc, XSIZE=yd1, YSIZE=xsi, /DEVICE
xyouts, xsc,ysc-2200.0, 'OI 558 nm:'+strmid(fix(smin1(1)),5,3), charsize=0.8, charthick=1,orientation=90, /device
xyouts, xsc, ysc+xsi-500, long(smax1(1)), charsize=0.8, charthick=1,orientation=90, /device

loadct,1
if igrey eq 1 then loadct,0
TV, rotate(colorbar,1), xsc-yd1*2, ysc, XSIZE=yd1, YSIZE=xsi, /DEVICE
xyouts, xsc-yd1, ysc-2400.0, 'N2+ 428 nm:'+strmid(fix(smin1(0)),5,3), charsize=0.8, charthick=1,orientation=90, /device
xyouts, xsc-yd1, ysc+xsi-500, long(smax1(0)), charsize=0.8, charthick=1,orientation=90, /device

plots, [xsc-2*yd1,xsc-2*yd1-100],[ysc,ysc],/device
plots, [xsc-2*yd1,xsc-2*yd1-100],[ysc+xsi,ysc+xsi],/device

if ilog eq 0 then begin
XYOUTS, xsc-2.5*yd1, ysc+1000.0, 'intensity (kR)', CHARSIZE=0.8,  CHARTHICK=1,orientation=90.0,   /DEVICE
endif else begin
XYOUTS, xsc-2.5*yd1, ysc, 'intensity in log_10 scale (kR)', CHARSIZE=0.8,  CHARTHICK=1,orientation=90.0,   /DEVICE
endelse

endif

  if (fac eq 30.0 and n eq pnum) then begin

     sx=xs
     sy=ys-((xpx)*fac+yd)*(1)
;     XYOUTS, xs+xd*k+20*fac, ys+fac*50, 'filename='+fna,CHARSIZE=0.8*fact, /DEVICE
     XYOUTS,  2100, 26800, datec,CHARSIZE=0.8*fact,  CHARTHICK=1.0,   /DEVICE
     XYOUTS, 5000, 8500, 'TI='+string(time(n))+', No.='+string(n),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, 5000,7500, cbin,CHARSIZE=0.8*fact, /DEVICE
     TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin(ich(n)),max=smax(ich(n))),irot), sx, sy, $
       XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
   endif else if fac ne 30 then begin
     sx=xs+((xpx+10)*fac*(num_ch+1))*(k)
     sy=ys+xd*(l)
     ap=0
     sssbin=''
     mmmbin=''
     hhhbin=''
     timin=min(time_a(n,where(time_a(n,*) ne 0)))
     if iut eq 1 then begin
       hhh=hh_obs_a(n)
       mmm=mm_obs_a(n)
       sss=ss_obs_a(n)
       if sss lt 10 then begin
         sssbin='0'+strmid(sss,7,5)
       endif else begin
         sssbin=strmid(sss,6,7)
       endelse
       if mmm lt 10 then begin
         mmmbin='0'+strmid(mmm,7,1)
       endif else begin
         mmmbin=strmid(mmm,6,2)
       endelse
       if hhh lt 10 then begin
         hhhbin='0'+strmid(hhh,7,1)
       endif else begin
         hhhbin=strmid(hhh,6,2)
       endelse

       ihhh=hhh*10000l+mmm*100+sss
 ;      print,hhh,mmm,sss,ihhh
 ;      print, tim_sec,ihhh,hhh,mmm,sss,sssbin
       XYOUTS, sx+num_ch*xpx*fac+300, sy, 'UT='+hhhbin+':'+mmmbin+':'+sssbin,CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
      if l eq 0 then begin
       XYOUTS, sx+num_ch*xpx*fac+600, sy, 'Date='+strmid(yy_obs_a(n),4,4)+' '+mo_obs_a(n)+' '+strmid(dd_obs_a(n),6,2),CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
      endif
     endif
     if iti eq 1 then begin
       XYOUTS, sx+num_ch*xpx*fac+900, sy, 'TI='+string(timin),CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
     endif
;     if l eq 0 then begin
       XYOUTS, sx+num_ch*xpx*fac+1200, sy,cbin(n),CHARSIZE=0.45*fact,orientation=90.0, /DEVICE
;     endif
     for m=0,2 do begin
       if ich_a(n,m) ne 0 then begin
         if m eq 0 then begin
           col=1
         endif else if m eq 1 then begin
           col=8
         endif else begin
           col=3
         endelse
         loadct,col
         TV, ROTATE(bytscl(imagetotal_a(*,*,m,n),min=smin(m),max=smax(m)),irot), sx+ap*(xpx+5)*fac, sy, XSIZE=(xpx)*fac, YSIZE=(ypx)*fac, /DEVICE
         if l eq 0 then XYOUTS, sx+num_ch*(xpx)*fac+1500+300*ap, sy,cpara(n,m),CHARSIZE=0.6*fact,orientation=90.0, /DEVICE
         ap=ap+1
       endif
     endfor
  endif




ENDFOR
ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE

endfor

print, 'Normal End! '
END
