pro SC_make_MAC_EISA

; coded by T. Sakanoi on 28 Oct, 2005
;

;--- Input/Output files -------------------------------------------------------------
;--- orbit file with invlat
;ofile='C:\Usr\tsakanoi\Index\orb_pre\orbt0020_stn_20051014_1111_ft_inv.txt'
ofile='C:\Usr\tsakanoi\Index\orb_pre\orbt0031_stn_20051118000000_ft_inv.txt'

;  if orbit file is made by asamura, then chose below and set asamura=1
asamura=0
;ofile='C:\Usr\tsakanoi\Index\orb_pre\orbt0022_invlat_20051021000000.txt'

;--- sunshine start/end file
sfile='C:\Usr\tsakanoi\Index\orb_pre\sunlight1111-1230.csv'

;--- output files
;  obs start/end list file
pfile='C:\Usr\tsakanoi\Index\orb_pre\orbt0020_stn_20051021_1111_start_end.txt'
;  SC file
cfile='C:\Usr\tsakanoi\Index\orb_pre\SC_MAC_EISAon_1128.sct'

;--- Input start and end time --------------------------------------------------------

syy=2005
smo=11
sdd=28
shh=03
smm=00
sss=00
;sss should be zero
eyy=2005
emo=11
edd=30
ehh=23
emm=59
ess=59
;ess should be zero

;--- Input higher and lower limits of invlat for start and end of observation ---------
;   for MAC
invlimitl=67.0
invlimith=73.0
;   for EISA
invlimh_day=80.0
invliml_day=60.0
;invlimh_night=75.0
;invliml_night=60.0
invlimh_night=75.0
invliml_night=65.0

;--- mergin time of MAC start time when entering the shadow of the earth
delayt=20.0

;--- Observation will be made only in he nothern and/or southern hemisphere? Yes=1 ----
;   for MAC
nobs=1
sobs=0
;   for EISA
nobs_eisa=1
sobs_eisa=0

;--- Commands and delay time(dt) in sec -----------------------------------------------
iini=1
initial_command,initial_com,initial_dt,numi
ishus=1
SHU_start_command,shu_s_com,shu_s_dt,numshs
imac=1
MAC_start_command,mac_s_com,mac_s_dt,numrs
MAC_end_command,mac_e_com,mac_e_dt,numre
MAC_rad_command,mac_r_com,mac_r_dt,numrr
ieisa=1
EISA_start_command,eisa_s_com,eisa_s_dt,numps
EISA_end_command,eisa_e_com,eisa_e_dt,numpe
ishue=1
SHU_end_command,shu_e_com,shu_e_dt,numshe
ifin=0
final_command,end_com,end_dt,nume


;===main routine start=====================================================================

;--- total day and total second calclation for start and end times ------------------------
totalday,syy,smo,sdd,smd,std
totalday,eyy,emo,edd,emd,etd

totalsec,shh,smm,sss,stsec
totalsec,ehh,emm,ess,etsec

etsec=etsec+86400l*(etd-std)

print,'start & end time ',stsec,etsec

tnum=0l
tnum=(etsec-stsec)/4+1
tsec=lonarr(tnum)

for i=0l, tnum-1 do begin
  tsec(i)=stsec+4l*i
endfor

;--- Reading orbit file --------------------------------------------------------

close,/all


openr,1,ofile

yy2=intarr(2678400l)
mo2=intarr(2678400l)
dd2=intarr(2678400l)
hh2=intarr(2678400l)
mm2=intarr(2678400l)
ss2=intarr(2678400l)
glat2=fltarr(2678400l)
glon2=fltarr(2678400l)
alt2=fltarr(2678400l)
glatf2=fltarr(2678400l)
glonf2=fltarr(2678400l)
altf2=fltarr(2678400l)
invlat2=fltarr(2678400l)
td2=intarr(2678400l)
tsec2=lonarr(2678400l)

onum1=0l
onum=0l
jflg=0
td0=0l


cdum=''
readf,1,cdum


readfile:

;on_ioerror, readfile

if asamura eq 0 then begin
  readf,1,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,geolatf1,geolonf1,altf1,invlat1
endif else begin
  readf,1,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,2x,f7.3,1x,f7.3,1x,f7.3)',$
    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,invlat1
    if invlat1 gt 90.0 then goto, readfile
endelse

totalday,y1,mo1,dd1,md1,td1
totalsec,hh1,mm1,ss1,tsec1

;print, td1,std,etd,tsec1,stsec,etsec

if td1 ge etd and tsec1 gt etsec then goto, nextstep

if (td1 eq std and tsec1 ge stsec) then begin
  td0=td1
  jflg=1
endif
if jflg eq 1 then begin
  tsec1=tsec1+(td1-td0)*86400l
;  print, td1,std,etd,tsec1,stsec,etsec
  if (td1 eq etd and tsec1 gt etsec+60) then goto, nextstep
endif

if jflg eq 1 then begin
; if asamura eq 0 then begin
;  print,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
;    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,geolatf1,geolonf1,altf1,invlat1
; endif else begin
;  print,format='(i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
;    y1,mo1,dd1,hh1,mm1,ss1,glat1,glon1,alt1,invlat1
; endelse

  yy2(onum1)=y1
  mo2(onum1)=mo1
  dd2(onum1)=dd1
  hh2(onum1)=hh1
  mm2(onum1)=mm1
  ss2(onum1)=ss1
  td2(onum1)=td1
  tsec2(onum1)=tsec1
  glat2(onum1)=glat1
  glon2(onum1)=glon1
  alt2(onum1)=alt1
  glatf2(onum1)=glat1
  glonf2(onum1)=glon1
  altf2(onum1)=alt1
  invlat2(onum1)=invlat1

  onum1=onum1+1

endif

if eof(1) ne 1 then goto, readfile

nextstep:


onum=onum1

glat=fltarr(onum)
glon=fltarr(onum)
alt=fltarr(onum)
glatf=fltarr(onum)
glonf=fltarr(onum)
altf=fltarr(onum)
invlat=fltarr(onum)
td=intarr(onum)
tsecr=lonarr(onum)

td(0:onum-1)=td2(0:onum-1)
tsecr(0:onum-1)=tsec2(0:onum-1)
glat(0:onum-1)=glat2(0:onum-1)
glon(0:onum-1)=glon2(0:onum-1)
alt(0:onum-1)=alt2(0:onum-1)
glatf(0:onum-1)=glatf2(0:onum-1)
glonf(0:onum-1)=glonf2(0:onum-1)
altf(0:onum-1)=altf2(0:onum-1)
invlat(0:onum-1)=invlat2(0:onum-1)

glatp=fltarr(tnum)
glonp=fltarr(tnum)
altp=fltarr(tnum)
glatfp=fltarr(tnum)
glonfp=fltarr(tnum)
altfp=fltarr(tnum)
invlatp=fltarr(tnum)

glatp=INTERPOL( glat, tsecr, tsec )
glonp=INTERPOL( glon, tsecr, tsec )
altp=INTERPOL( alt, tsecr, tsec )
glatfp=INTERPOL( glatf, tsecr, tsec )
glonfp=INTERPOL( glonf, tsecr, tsec )
altfp=INTERPOL( altf, tsecr, tsec )
invlatp=INTERPOL( invlat, tsecr, tsec )

;--- Reading a file of sunlight start and end times
;
cdum=''
susd1=0
susmon1=''
susy1=0
sush1=0
susm1=0
suss1=0.0
sued1=0
suemon1=''
suey1=0
sueh1=0
suem1=0
sues1=0.0
dur1=0.0
sustsec1=0l
suetsec1=0l
sustsec=lonarr(1000)
suetsec=lonarr(1000)

snum=0
;

;print, sfile,ii
;on_ioerror,nextstep2

openr,5,sfile

readf,5,cdum

readsunfile:

readf,5,format='(i2,1x,a3,1x,i4,1x,i2,a1,i2,a1,f6.3,1x,i2,1x,a3,1x,i4,1x,i2,a1,i2,a1,f6.3,1x,f8.3)',$
    susd1,susmon1,susy1,sush1,cdum,susm1,cdum,suss1,sued1,suemon1,suey1,sueh1,cdum,suem1,cdum,sues1,dur1

mon_char_to_num,suemon1,suemonn1
mon_char_to_num,susmon1,susmonn1

totalday,susy1,susmonn1,susd1,susmd,sustd
totalday,suey1,suemonn1,sued1,suemd,suetd

totalsec,sush1,susm1,suss1,sustsec1
totalsec,sueh1,suem1,sues1,suetsec1

sustsec(snum)=sustsec1+(sustd-std)*86400
suetsec(snum)=suetsec1+(suetd-std)*86400

if suetsec(snum) ge etsec then goto, nextstep2
print, snum,sustsec(snum),suetsec(snum),    susd1,susmon1,susy1,sush1,cdum,susm1,cdum,suss1,sued1,suemon1,suey1,sueh1,cdum,suem1,cdum,sues1,dur1

snum=snum+1

if eof(5) ne 1 then goto, readsunfile

nextstep2:
;snum=0

;=== Out put parameters to files ===========================================================

;--- output headers
iflg=0
hh=0
mm=0
ss=0

openw,11,pfile
printf,11, syy,smo,sdd,shh,smm,sss
printf,11, eyy,emo,edd,ehh,emm,ess
printf,11, invlimitl,invlimith
if nobs eq 1 and sobs eq 0 then begin
  printf,11,'only northern hemi.'
endif else if nobs eq 0 and sobs eq 0 then begin
  printf,11,'only southern hemi.'
endif else begin
  printf,11,'northern and southern hemispheres.'
endelse

printf,11,'s/e,yy,mm,dd,hh,mm,ss,glatp,glonp,altp,glatfp,glonfp,altfp,invlatp'
printf,11,'format=(a2,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)'


openw,21,cfile
printf,21,'s,Type,CMD,SM-CODE-H,SM-CODE-L,Comment'

;--- Output obs start and end times

ptd=0
lasttsec=0l

kflg=0
cyy=strarr(4)
cmo=strarr(2)
cdd=strarr(2)
ch=strarr(2)
cm=strarr(2)
cs=strarr(2)
i1=0
i2=0
i3=0
i4=0
iflg=0
eflg=0

;--- observation start and end times search

MAC_stsec=lonarr(100)
MAC_etsec=lonarr(100)
EISA_stsec=lonarr(100)
EISA_etsec=lonarr(100)
MAC_ns=intarr(100)
EISA_ns=intarr(100)


for i=1l, tnum-1 do begin

;--- northern hemisphere case ------------------------------------------------------------------
  if (nobs eq 1 and glatp(i) gt 0) then begin

;--- start time defined by crossing higher invlat for MAC
   if imac eq 1 and invlatp(i-1) gt invlimith and invlatp(i) le invlimith and iflg eq 0 then begin

;--- if satellite exists in sunlight at the start time, then
;      start time is shfted 30 sec after the time entering the shadow of the earth
     sunflgs=0
     for j=0, snum-1 do begin
      if tsec(i) ge sustsec(j) and tsec(i) le suetsec(j) then begin
        tsec(i)=long((suetsec(j)+delayt)/4)*4
        print,'!!!!!!!!! MAC on/off time shift due to sunlight'
        sunflgs=1
      endif
     endfor

     iflg=1
     MAC_stsec(i1)=tsec(i)
     MAC_ns(i1)=0
     i1=i1+1

   endif

 ;--- end time defined by crossing lower invlat (northern hemi. case)
    if invlatp(i-1) ge invlimitl and invlatp(i) lt invlimitl and iflg eq 1 then begin
      sunflge=0
      for j=0, snum-1 do begin
        if tsec(i) ge sustsec(j) and tsec(i) le suetsec(j) then begin
          sunflge=1
        endif
      endfor

      if sunflgs eq 1 and sunflge eq 1 then begin
        print, 'MAC path under the sunshine ',MAC_stsec(i1),tsec(i)
        i1=i1-1
        goto, nextstep3
      endif

      iflg=0
      MAC_etsec(i2)=tsec(i)
      MAC_ns(i2)=0
      i2=i2+1

      nextstep3:

     endif

  endif
;---- for EISA
  if ieisa eq 1 and nobs_eisa eq 1 and glatp(i) ge 0 then begin
   tsectohhmmss,tsec(i),hh,mm,ss,aday

;   print, i,invlatp(i),invlimh_night,eflg,tsec(i),hh,mm,ss

     if invlatp(i-1) gt invlimh_night and invlatp(i) le invlimh_night and eflg eq 0 then begin
       EISA_stsec(i3)=tsec(i)
       EISA_ns(i3)=0
       eflg=1
       i3=i3+1
     endif

     if invlatp(i-1) ge invliml_night and invlatp(i) lt invliml_night and eflg eq 1 then begin
       EISA_etsec(i4)=tsec(i)
       EISA_ns(i4)=0
       eflg=0
       i4=i4+1
     endif

     if invlatp(i-1) lt invliml_day and invlatp(i) ge invliml_day and eflg eq 0 then begin
       EISA_stsec(i3)=tsec(i)
       EISA_ns(i3)=2
       eflg=1
       i3=i3+1
     endif

     if invlatp(i-1) le invlimh_day and invlatp(i) gt invlimh_day and eflg eq 1 then begin
       EISA_etsec(i4)=tsec(i)
       EISA_ns(i4)=2
       eflg=0
       i4=i4+1
     endif

  endif

;--- southern hemisphere case ------------------------------------------------------------------
  if (sobs eq 1 and glatp(i) lt 0) then begin

;--- start time defined by crossing higher invlat for MAC
   if imac eq 1 and invlatp(i-1) lt invlimitl and invlatp(i) ge invlimitl and iflg eq 0 then begin

;--- if satellite exists in sunlight at the start time, then
;      start time is shfted delayt sec after the time entering the shadow of the earth
   sunflgs=0
   for j=0, snum-1 do begin
    if tsec(i) ge sustsec(j) and tsec(i) le suetsec(j) then begin
      sunflgs=1
      goto, nextstep4
    endif
   endfor

   iflg=1
   MAC_stsec(i1)=tsec(i)
   MAC_ns(i1)=1
   i1=i1+1


  endif

 ;--- end time defined by crossing lower invlat (northern hemi. case)
  if invlatp(i-1) le invlimith and invlatp(i) gt invlimith and iflg eq 1 then begin
   sunflge=0
   for j=0, snum-1 do begin
    if tsec(i) ge sustsec(j) and tsec(i) le suetsec(j) then begin
      tsec(i)=long((suetsec(j)-delayt)/4)*4
      print,'!!!!!!!!! MAC on/off time shift due to sunlight'
      sunflge=1
    endif
   endfor

   iflg=0
   MAC_etsec(i2)=tsec(i)
   MAC_ns(i2)=1
   i2=i2+1

   nextstep4:
   if sunflgs eq 1 then begin
     print, 'MAC path under the sunshine ',MAC_stsec(i1),tsec(i)
   endif

  endif

 endif
;---- for EISA
 if ieisa eq 1 and sobs_eisa eq 1 and glatp(i) le 0 then begin

     if invlatp(i-1) gt invlimh_day and invlatp(i) le invlimh_day and eflg eq 0 then begin
       EISA_stsec(i3)=tsec(i)
       EISA_ns(i3)=3
       eflg=1
       i3=i3+1
     endif

     if invlatp(i-1) ge invliml_day and invlatp(i) lt invliml_day and eflg eq 1 then begin
       EISA_etsec(i4)=tsec(i)
       EISA_ns(i4)=3
       eflg=0
       i4=i4+1
     endif

     if invlatp(i-1) lt invliml_night and invlatp(i) ge invliml_night and eflg eq 0 then begin
       EISA_stsec(i3)=tsec(i)
       EISA_ns(i3)=1
       eflg=1
       i3=i3+1
     endif

     if invlatp(i-1) le invlimh_night and invlatp(i) gt invlimh_night and eflg eq 1 then begin
       EISA_etsec(i4)=tsec(i)
       EISA_ns(i4)=1
       eflg=0
       i4=i4+1
     endif

  endif

endfor

;-----------------------------------------------------------------------------------
macnum=i2
eisanum=i4

if i1 ne i2 then print, 'MAC time selection abnormal?'

for i=0,macnum-1 do begin
  for j=0,eisanum do begin
    if MAC_stsec(i) eq EISA_stsec(j) then begin
      EISA_stsec(j)=EISA_stsec(j)-60.0
    endif
    if MAC_etsec(i) eq EISA_etsec(j) then begin
      EISA_etsec(j)=EISA_etsec(j)+60.0
    endif
  endfor
endfor

;--- initial commands of SC

if macnum ne 0 and eisanum ne 0 then begin
  if MAC_stsec(0) le EISA_stsec(0) then begin
    tsecp=MAC_stsec(0)
  endif else begin
    tsecp=EISA_stsec(0)
  endelse
endif else if eisanum eq 0 then begin
    tsecp=MAC_stsec(0)
endif else begin
    tsecp=EISA_stsec(0)
endelse

if kflg eq 0 then begin
  for j=0, numi-1 do begin
    dt1=initial_dt(j)
    tsectohhmmss,tsecp+dt1,hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,syy,pm,pd

    cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',initial_com(j)

      kflg = 1
   endfor
 endif

mnums=0
mnume=0
enums=0
enume=0
mflg=0
eflg=0
radflg=0

;--- MAC ---------------------------------------------------------------------------------

print, '--- writing SC file'


for i=1l, tnum-1 do begin

;print, i, tsec(i),MAC_stsec(mnums),mnums

if mnume le macnum-1 then begin

  if tsec(i) eq MAC_stsec(mnums) then begin

   tsectohhmmss,tsec(i),hh,mm,ss,aday

;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,syy,pm,pd

;--- output start time
    printf,11,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's-mac  ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's-mac  ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)

;--- output SC file

;--- main body of SC

;--- SHU command
   if eflg eq 0 then begin
    for j=0, numshs-1 do begin
      dt1=shu_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_s_com(j)+cdt
      lasttsec=tsec(i)
    endfor
   endif

;--- MAC command
    for j=0, numrs-1 do begin
      dt1=mac_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        if MAC_ns(mnums) eq 0 then begin
          cdt='obs-north'
        endif else begin
          cdt='obs-south'
        endelse
      endif else begin
          cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_s_com(j)+cdt
      lastmtsec=tsec(i)
    endfor

    mflg=1
    mnums=mnums+1

  endif

  if tsec(i) eq MAC_etsec(mnume) then begin

    tsectohhmmss,tsec(i),hh,mm,ss,aday
;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,eyy,pm,pd

;--- output end time list
    printf,11,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e-mac  ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e-mac  ',syy,pm,pd,hh,mm,ss,glatp(i-1),glonp(i-1),altp(i-1),glatfp(i-1),glonfp(i-1),altfp(i-1),invlatp(i-1)
    iflg = 0

;--- output SC ---

;--- MAC command

;--rad cal command
  if radflg eq 0 then begin

    for j=0, numrr-1 do begin
      dt1=mac_r_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='MAC rad check'
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_r_com(j)+cdt
      lastrtsec=tsec(i)

    endfor

    radflg=1
  endif



;--- end commands
    for j=0, numre-1 do begin
      dt1=mac_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='MAC ON '+strmid(string(tsec(i)-lastmtsec),9,4)+'sec'
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',mac_e_com(j)+cdt
      lastmtsec=tsec(i)

    endfor

   if eflg eq 0 then begin
    for j=0, numshe-1 do begin
      dt1=shu_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_e_com(j)+cdt
      lasttsec=tsec(i)

    endfor
   endif

   mflg=0
   mnume=mnume+1

  endif

endif

;---- EISA ------------------------------------------------------------------

if enume le eisanum-1 then begin
;  print, enums,enume,eisanum,EISA_stsec(enums),EISA_etsec(enume)
  if tsec(i) eq EISA_stsec(enums) then begin

   tsectohhmmss,tsec(i),hh,mm,ss,aday

;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,syy,pm,pd

;--- output start time
    printf,11,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's-eisa ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      's-eisa ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)

;--- output SC file

;--- main body of SC

;--- SHU command
   if mflg eq 0 then begin
    for j=0, numshs-1 do begin
      dt1=shu_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_s_com(j)+cdt
      lastetsec=tsec(i)
    endfor
   endif

;--- EISA command
    for j=0, numps-1 do begin
      dt1=eisa_s_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
       if EISA_ns(enums) eq 0 then begin
        cdt='obs-north-night'
       endif else if EISA_ns(enums) eq 2 then begin
        cdt='obs-north-day'
       endif else if EISA_ns(enums) eq 3 then begin
        cdt='obs-south-day'
       endif else if EISA_ns(enums) eq 1 then begin
        cdt='obs-south-night'
       endif
      endif else begin
        cdt=''
      endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',eisa_s_com(j)+cdt
      lasttsec=tsec(i)
    endfor

    eflg=1
    enums=enums+1

  endif

  if tsec(i) eq EISA_etsec(enume) then begin

    tsectohhmmss,tsec(i),hh,mm,ss,aday
;    print, hh,mm,ss,aday
    ptd=std+aday
    totaldaytoyymmdd,ptd,eyy,pm,pd

;--- output end time list
    printf,11,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e-eisa ',syy,pm,pd,hh,mm,ss,glatp(i),glonp(i),altp(i),glatfp(i),glonfp(i),altfp(i),invlatp(i)
    print,format='(a7,i4,i2,i2,i2,i2,f6.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3,1x,f7.3)',$
      'e-eisa ',syy,pm,pd,hh,mm,ss,glatp(i-1),glonp(i-1),altp(i-1),glatfp(i-1),glonfp(i-1),altfp(i-1),invlatp(i-1)
    iflg = 0

;--- output SC ---

;--- EISA command
    for j=0, numre-1 do begin
      dt1=eisa_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt='EISA ON '+strmid(string(tsec(i)-lastetsec),9,4)+'sec'
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',eisa_e_com(j)+cdt
      lastetsec=tsec(i)

    endfor

   if mflg eq 0 then begin
    for j=0, numshe-1 do begin
      dt1=shu_e_dt(j)
      tsectohhmmss,tsec(i)+dt1,hh,mm,ss,aday
      ptd=std+aday
      totaldaytoyymmdd,ptd,syy,pm,pd
      cyy=strmid(string(syy),4,4)

      if pm ge 10 then begin
        cmo=strmid(string(pm),6,2)
      endif else begin
        cmo=strmid(string(pm),7,1)
      endelse
      if pd ge 10 then begin
        cdd=strmid(string(pd),6,2)
      endif else begin
        cdd=strmid(string(pd),7,1)
      endelse

      if hh ge 10 then begin
        ch=strmid(string(hh),6,2)
      endif else begin
        ch='0'+strmid(string(hh),7,1)
      endelse
      if mm ge 10 then begin
        cm=strmid(string(mm),6,2)
      endif else begin
        cm='0'+strmid(string(mm),7,1)
      endelse
      if ss ge 10 then begin
        cs=strmid(string(fix(ss)),6,2)
      endif else begin
        cs='0'+strmid(string(fix(ss)),7,1)
      endelse

      if j eq 0 then begin
        cdt=''
      endif else begin
        cdt=''
      endelse
;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
      printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',shu_e_com(j)+cdt
      lasttsec=tsec(i)

    endfor
   endif

   eflg=0
   enume=enume+1

  endif

endif

endfor

;--- output SCs in the end of sc file -----------------------------------------------------------
if ifin eq 1 then begin

for j=0, nume-1 do begin
  dt1=end_dt(j)
  tsectohhmmss,lasttsec+dt1,hh,mm,ss,aday
  ptd=std+aday
  totaldaytoyymmdd,ptd,syy,pm,pd
  cyy=strmid(string(syy),4,4)

  if pm ge 10 then begin
    cmo=strmid(string(pm),6,2)
  endif else begin
    cmo=strmid(string(pm),7,1)
  endelse
  if pd ge 10 then begin
    cdd=strmid(string(pd),6,2)
  endif else begin
    cdd=strmid(string(pd),7,1)
  endelse

  if hh ge 10 then begin
    ch=strmid(string(hh),6,2)
  endif else begin
    ch='0'+strmid(string(hh),7,1)
  endelse
  if mm ge 10 then begin
    cm=strmid(string(mm),6,2)
  endif else begin
    cm='0'+strmid(string(mm),7,1)
  endelse
  if ss ge 10 then begin
    cs=strmid(string(fix(ss)),6,2)
  endif else begin
    cs='0'+strmid(string(fix(ss)),7,1)
  endelse

;      printf,21,format='(i4,a1,i2,a1,i2,1x,a2,a1,a2,a1,a2,a1,a?',$
  printf,21, cyy,'/',cmo,'/',cdd,' ',ch,':',cm,':',cs,',',end_com(j)

endfor

endif

close,/all
print,'normal end'


end
