;******************************************************************
;    program SHUbin_image
;
;    revised from KOBAimage
;         on May 1, 2002 by TS
;
;    revised from imagespectro.pro
;         on Apr 8,2002 by TS
;
;    revised from imagesakanoi.pro
;      for plotting 'Auroral Spectrograph' data
;      developed at NIPR and now at LYR
;      on Apr. 20, 2000 by Takeshi Sakanoi
;
;    imagesakanoi.pro
;         revised from image20ps by Takeshi Sakanoi
;
;    image20ps
;    draws 20 airglow emission images and Japanese map
;    as a PostScript file. For Zao All-Sky Imager
;
;                              Mar . 21, 1997
;                               programed by K. Nakajima
;******************************************************************

pro SHUbin_image

close,/all

;fdir = 'C:\Documents and Settings\pparc\My Documents\obuchi\Index\MAC_FM\INDEX_MAC\DL\DL_512x512\'
;fdir = 'C:\Usr\tsakanoi\Data_analysis\index\data\bin\'
;fdir = 'C:\Usr\tsakanoi\Index\CCD_FM_Thermal_Test\SHUmemory_binary\'
fdir = 'C:\Usr\tsakanoi\Index\Kobayashi\INDEX_MAC\'

testnum='#1'
fna='Hira.dat'
;expo='9500f(480ms)'
expo='9500f(480ms)'
hiniti='Mar. 23, 2002'
;mode='al'
mode='ca'
iscale=0
smin = 40l
smax = 180l

;testnum='#12'
;fna='020804CAL1fMAC123.dat'
;expo='1flame'
;hiniti='Aug. 4, 2002 @ ISAS'
;mode='ca'
;iscale=1
;drawpagemax=1

;testnum='#14'
;fna='020804CA4500fMAC1.dat'
;expo='4500flame'
;hiniti='Aug. 4, 2002 @ ISAS'
;mode='ca'
;iscale=0
;smin = 0l
;smax = 50l
;drawpagemax=13

;testnum='#16'
;fna='020804CA4500fMAC3.dat'
;expo='4500flame'
;hiniti='Aug. 4, 2002 @ ISAS'
;mode='ca'
;iscale=0
;smin = 0l
;smax = 255l
;drawpagemax=10

;testnum='#21'
;fna='020805CAC4500fMAC1.dat'
;expo='4500flame'
;hiniti='Aug. 5, 2002 @ ISAS'
;mode='ca'
;iscale=0
;smin = 0l
;smax = 255l
;drawpagemax=7

;testnum='#21'
;fna='020805CAC4500fMAC2.dat'
;expo='4500flame'
;hiniti='Aug. 5, 2002 @ ISAS'
;mode='ca'
;iscale=0
;smin = 0l
;smax = 255l
;drawpagemax=7

;testnum='#22'
;fna='020805CAC4500fMAC3.dat'
;expo='4500flame'
;hiniti='Aug. 5, 2002 @ ISAS'
;mode='ca'
;iscale=0
;smin = 0l
;smax = 255l
;drawpagemax=7

;testnum='EISA on'
;fna='02071703.dat'
;hiniti='Jul. 17, 2002 @ ISAS'
;expo=''
;mode='pa'
;iscale=1
;drawpagemax=10

;testnum='EISA on #2'
;fna='02071702.dat'
;hiniti='Jul. 17, 2002 @ ISAS'
;expo=''
;mode='pa'
;iscale=1
;drawpagemax=10

;testnum='EISA CRM on'
;fna='020729allon.dat'
;hiniti='Jul. 29, 2002 @ ISAS'
;expo=''
;mode='pa'
;iscale=1
;drawpagemax=10


;if iscale =1, then autoscale, if iscale=0 then manual setting as bellow
;smin = 40l
;smax = 140

fna2=strmid(fna,0,strlen(fna)-4)
fname=fdir+fna

;---plot image size factor(small(9images/paper):12.0, one image large plot:30)
fac=12.0
;fac=30.0
;drawpagemax=30

psdir='C:\Usr\tsakanoi\Data_analysis\ps\'

;col=13
col=1
;--col 0 or 13

;===========================

if mode eq 'pa' then begin
  ibin=16
endif else if mode eq 'al' then begin
  ibin=16
endif else if mode eq 'ca' then begin
  ibin=2
endif else begin
  ibin=8
endelse

xpx0=1024
ypx0=1024

xpx=xpx0/ibin
ypx=ypx0/ibin

pdate=0l
ptime=0l

;fdir = 'C:\Usr\tsakanoi\Index\Kobayashi\INDEX_MAC\'
;fdir = 'I:\Lyr\'
;fdir = 'I:\LYRASG_OBS_Oct00\'

;--- ihiniti automatic - 1
ihiniti=1
;if ihiniti eq 0 then hiniti='Oct 24, 2000 neon lamp after re-inst.'


;--- pdate and ptime for data selection which is avairable when fac=30.0
;pdate=20000319
;ptime=210748

if fac lt 30 then begin
  fact=1.0
  factc=''
endif else begin
  fact=1.8
  factc='l'
endelse

;---image resolution(nominal:100, one image large plot:512)
if fac eq 30 then begin
  res = xpx
endif else begin
;  res = 100
  res=xpx
endelse
;res = 512
;res=100


irot = 5


;=====parameter end=====

;fname1=fdir+fna


print, fname
;
print, '---data process start---'
;
;----------  TIME AND IMAGE DATA FORMAT ------------------
;---image pixels
time1=''
date1=''
time2=''
date2=''
expo1=''
pdate1=0l
ptime1=0l


hp_img_SHUbin, fname,xpx,ypx,mode,fac,drawpagemax,fnum,data,ch,time

if fac eq 30.0 then begin
  imagetotal=intARR(res,res,1)
endif else begin
  imagetotal=intARR(res,res,fnum)
endelse
data1=intarr(xpx,ypx)
image1=intarr(res,res)

for i=0, fnum-1 do begin
  data1(*,*)=data(i,*,*)
  if res ne xpx then begin
    image1=CONGRID(data1, res, res, /INTERP)
  endif else begin
    image1=data1
  endelse
  imagetotal(*,*,i)=image1(*,*)
endfor

if iscale eq 1 then begin
  smin=long(min(imagetotal)/10-4)*10l
  smax=long(max(imagetotal)/10)*10l
  if smin lt 0 then smin=0
endif


plot:

;if ihiniti eq 1 then hiniti=date(0)+' to '+date(fnum-1)
;year=(date(0)+strmid(time(0),0,2)+strmid(time(0),3,2)+factc


if ibin eq 2 then begin
  cbin='2x2'
endif else if ibin eq 4 then begin
  cbin='4x4'
endif else if ibin eq 8 then begin
  cbin='8x8'
endif else if ibin eq 16 then begin
  cbin='16x16'
endif


;------------------- PS PROT ------------------

SET_PLOT, 'PS'


if fac eq 30 then begin
  lnum=1
  knum=1
endif else begin
  lnum=3
  knum=3
endelse

e0=(fnum-1)/lnum/knum
s0=0
es=e0

xas=intarr(3)
yas=intarr(3)
xae=intarr(3)
yae=intarr(3)

xas(2)=0
yas(2)=0
xae(2)=fix(xpx/5)-1
yae(2)=fix(ypx/5)-1
xas(1)=fix(2*xpx/5)
yas(1)=fix(2*ypx/5)
xae(1)=fix(3*xpx/5)-1
yae(1)=fix(3*ypx/5)-1
xas(0)=fix(4*xpx/5)
yas(0)=fix(4*ypx/5)
xae(0)=xpx-1
yae(0)=ypx-1

ave=fltarr(3)
rms=fltarr(3)


FOR s=s0,es DO BEGIN

if s lt 10 then begin
  fo='00'+strmid(s,7,1)
endif else if s lt 100 then begin
  fo='0'+strmid(s,6,2)
endif else begin
  fo=strmid(s,5,3)
endelse

pnum=lnum*knum

st=0+pnum*s
et=st+pnum-1

if et gt fnum-1 then et=fnum-1

cch=''
cch2=''



DEVICE, BITS_PER_PIXEL=8, /COLOR, $
 FILENAME=psdir+fna2+fo+'.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
 print, psdir+fna2+fo+'.ps'
LOADCT, col


!P.FONT=0
XYOUTS, 2100, 28000, '!8MAC test data '+testnum, CHARSIZE=2.0,  CHARTHICK=1.5,  /DEVICE
XYOUTS, 2100, 25900, cbin+'  binning', CHARSIZE=1.5,  CHARTHICK=1.0,  /DEVICE
datec=''
if fac eq 30.0 then begin
  datec=hiniti
endif else begin
  datec=hiniti
endelse
XYOUTS,  2100, 26800, datec,CHARSIZE=2.0,  CHARTHICK=1.0,   /DEVICE
XYOUTS, 2500,25000,'filename='+fna,CHARSIZE=2.0, /DEVICE



colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=ysi, /DEVICE
plots, [xsc,xsc],[ysc+ysi,ysc+ysi+80],/device
plots, [xsc+xsi/2,xsc+xsi/2],[ysc+ysi,ysc+ysi+80],/device
plots, [xsc+xsi,xsc+xsi],[ysc+ysi,ysc+ysi+80],/device

  XYOUTS, xsc+1000.0, ysc+ysi+500.0, 'intensity (cts)', $
   CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
  xyouts, xsc-700.0, ysc+ysi+120.0, smin, charsize=0.8, charthick=1, /device
  xyouts, xsc-700.0+xsi/2, ysc+ysi+120.0, long((smax-smin)/2), charsize=0.8, charthick=1, /device
  xyouts, xsc-700.0+xsi, ysc+ysi+120.0, long(smax), charsize=0.8, charthick=1, /device


;------------------ DRAW IMAGE DATA  --------------
;

xs=1000.0+1000*(fact-1.0)
xd=6300.0
ys=24500.0
cm=''
yd=1200.0
pix=0.0
xpi=0.0
ypi=0.0
xpxp=xpx*float(ibin)/2.0
ypxp=ypx*float(ibin)/2.0

;---plotting images
FOR l=0, lnum-1 DO BEGIN
 FOR k=0, knum-1 DO BEGIN

  n=fix(s*pnum+lnum*l+k)

  if n ge fnum then goto, nodata


  if ch(n) eq 1 then begin
    cch='Ch.1'
    cch2='ch1'
  endif else if ch(n) eq 2 then begin
    cch='Ch.2'
    cch2='ch2'
  endif else begin
    cch='Ch.3'
    cch2='ch3'
  endelse

;  print,n
 IF n EQ fnum THEN GOTO, NODATA
   sx=xs+xd*k
   sy=ys-((xpxp)*fac+yd)*(l+1)
   if fac eq 30.0 then begin
     XYOUTS, xs+xd*k, (ys-400.0)-((xpxp)*fac+yd+500*(fact-1))*(l+1),cch+' / TI='+string(time(n))+' / Exp='+expo,CHARSIZE=0.8*fact, /DEVICE
   endif else begin
     XYOUTS, xs+xd*k, (ys-400.0)-((xpxp)*fac+yd+500*(fact-1))*(l+1),cch+' / TI='+string(time(n))+' / Exp='+expo,CHARSIZE=0.8*fact, /DEVICE
   endelse

   TV, ROTATE(bytscl(imagetotal(*,*,n),min=smin,max=smax),irot), sx, sy, $
      XSIZE=(xpxp)*fac, YSIZE=(ypxp)*fac, /DEVICE

   for j=0,2 do begin
     result=moment(imagetotal(xas(j):xae(j),yas(j):yae(j),n))
     ave(j)=result(0)
     rms(j)=sqrt(result(1))
     if l eq 0 and k eq 0 then begin
       plots,[sx+xas(j)*float(ibin)/2.0*fac,sx+(xae(j)+1)*float(ibin)/2.0*fac],[sy+ypxp*fac-yas(j)*float(ibin)/2.0*fac,sy+ypxp*fac-yas(j)*float(ibin)/2.0*fac],color=255,/device
       plots,[sx+xas(j)*float(ibin)/2.0*fac,sx+(xae(j)+1)*float(ibin)/2.0*fac],[sy+ypxp*fac-(yae(j)+1)*float(ibin)/2.0*fac,sy+ypxp*fac-(yae(j)+1)*float(ibin)/2.0*fac],color=255,/device
       plots,[sx+(xae(j)+1)*float(ibin)/2.0*fac,sx+(xae(j)+1)*float(ibin)/2.0*fac],[sy+ypxp*fac-yas(j)*float(ibin)/2.0*fac,sy+ypxp*fac-(yae(j)+1)*float(ibin)/2.0*fac],color=255,/device
       plots,[sx+xas(j)*float(ibin)/2.0*fac,sx+xas(j)*float(ibin)/2.0*fac],[sy+ypxp*fac-yas(j)*float(ibin)/2.0*fac,sy+ypxp*fac-(yae(j)+1)*float(ibin)/2.0*fac],color=255,/device
     endif

   endfor

   if fac eq 30.0 then begin
     XYOUTS, xs+xd*k, (ys-700.0)-((xpxp)*fac+yd+500*(fact-1))*(l+1),'Ave.:'+string(ave(0))+string(ave(1))+string(ave(2)),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, xs+xd*k, (ys-1000.0)-((xpxp)*fac+yd+500*(fact-1))*(l+1),'SD(rms): '+string(rms(0))+string(rms(1))+string(rms(2)),CHARSIZE=0.8*fact, /DEVICE
   endif else begin
     XYOUTS, xs+xd*k, (ys-700.0)-((xpxp)*fac+yd+500*(fact-1))*(l+1),'Ave.:'+string(ave(0))+string(ave(1))+string(ave(2)),CHARSIZE=0.8*fact, /DEVICE
     XYOUTS, xs+xd*k, (ys-1000.0)-((xpxp)*fac+yd+500*(fact-1))*(l+1),'SD(rms):'+string(rms(0))+string(rms(1))+string(rms(2)),CHARSIZE=0.8*fact, /DEVICE
   endelse


ENDFOR
ENDFOR

ENDFOR

NODATA:

;------------------- END ---------------------------

DEVICE, /CLOSE

print, 'Normal End! '
END











