pro cal_geomag_igrf,nmax,gcoef,hcoef,glat,glon,alt,Bx,By,Bz,TotalF
; glat : geodetic latitude (deg)
; glon : geodetic longitude (deg)
; alt : altitude from the ground (km)

gcolat=0.0d

Re=6371.0d
gcolat=90.0-glat
gcolatr=gcolat*2.0*3.14159/360.0
glonr=glon*2.0*3.14159/360.0
altr=alt+Re

TotalF=0.0d
Bx=0.0d
By=0.0d
Bz=0.0d
Xsum2=0.0d
Ysum2=0.0d
Zsum2=0.0d
P_nm=dblarr(nmax+1,nmax+1)
Q_nm=dblarr(nmax+1,nmax+1)
P_nm(0,0)=1.0
P_nm(1,0)=cos(gcolatr)

for n=1,nmax do begin
  Q_nm(n,0)=n/sin(gcolatr)*(cos(gcolatr)*P_nm(n,0)-P_nm(n-1,0))
  if n gt 1 then begin
    P_nm(n,0)=1.0/double(n)*((2*n-1)*cos(gcolatr)*P_nm(n-1,0)-(n-1)*P_nm(n-2,0))
;    P_nm(n,0)=LEGENDRE(cos(gcolatr),n,0,/double)
  endif
endfor

for n=1, nmax do begin
  for l=0, n do begin
    if l eq 0 then begin
      ep=1.0
      P_nm(n,l)=P_nm(n,l)
;      P_nm(n,l)=LEGENDRE(cos(gcolatr),n,l,/double)
      Q_nm(n,l)=Q_nm(n,l)

    endif else if l ge 1 then begin
      ep=2.0
      P_nm(n,l)=1.0/sin(gcolatr)*((n+l-1)*P_nm(n-1,l-1)-(n-l+1)*cos(gcolatr)*P_nm(n,l-1))
;      P_nm(n,l)=LEGENDRE(cos(gcolatr),n,l,/double)
      Q_nm(n,l)=(n+l)*(n-l+1)*P_nm(n,l-1)-l*cos(gcolatr)/sin(gcolatr)*P_nm(n,l)
;      P_le=LEGENDRE(cos(gcolatr),n,l,/double)
;      P_le1=LEGENDRE(cos(gcolatr),n,l-1,/double)*sqrt(ep*factorial(n-l-1)/factorial(n+l-1))
;      Q_le=(n+l)*(n-l+1)*P_le1-l*cos(gcolatr)/sin(gcolatr)*P_le
    endif
  endfor
endfor

for n=1, nmax do begin
  sumX=0.0d
  sumY=0.0d
  sumZ=0.0d
  for l=0, n do begin
    if l eq 0 then begin
      ep=1.0
    endif else begin
      ep=2.0
  endelse
;    P_le=LEGENDRE(cos(gcolatr),n,m,/double)*sqrt(ep*factorial(n-m)/factorial(n+m))
;    P_le1=LEGENDRE(cos(gcolatr),n,m-1,/double)*sqrt(ep*factorial(n-m-1)/factorial(n+m-1))
;    Q_le=(n+m)*(n-m+1)*P_le1-m*cos(gcolatr)/sin(gcolatr)*P_le
    sumX=sumX+(gcoef(n,l)*cos(l*glonr)+hcoef(n,l)*sin(l*glonr))*Q_nm(n,l)*sqrt(ep*factorial(n-l)/factorial(n+l))
    sumY=sumY+l*(gcoef(n,l)*cos(l*glonr)-hcoef(n,l)*sin(l*glonr))*P_nm(n,l)*sqrt(ep*factorial(n-l)/factorial(n+l))
    sumZ=sumZ+(gcoef(n,l)*cos(l*glonr)+hcoef(n,l)*sin(l*glonr))*P_nm(n,l)*sqrt(ep*factorial(n-l)/factorial(n+l))
  endfor
  Xsum2=Xsum2+(Re/altr)^(n+2)*sumX
  Ysum2=Ysum2+(Re/altr)^(n+2)*sumY
  Zsum2=Zsum2+(Re/altr)^(n+2)*sumZ
endfor

Bx=Xsum2
By=1/sin(gcolat)*Ysum2
Bz=-Zsum2
TotalF=sqrt(Bx^2+By^2+Bz^2)

;print, Bx,By,Bz,TotalF,glat,glon,alt

end