; Calculate Geomagnetic field vector using the IGRF 9th model
;
;

pro cal_igrf

igrfcof='c:\Usr\tsakanoi\Index\geomag\igrf9coeffs.prn'

year=2000
;glat(deg), glon(deg), alt(km)
glats=60.0
glate=80.0
dglat=1.0
glons=0.0
glone=360.0
dglon=1.0
alts=100.0
alte=700
dalt=10.0
nmax=8

r_igrfcoeff,igrfcof,year,gcoef,hcoef

; glat : geodetic latitude (deg)
; glon : geodetic longitude (deg)
; alt : altitude from the ground (km)

n_glat=fix((glate-glats)/dglat)+1
n_glon=fix((glone-glons)/dglon)+1
n_alt=fix((alte-alts)/dalt)+1

Bxi=dblarr(n_glat,n_glon,n_alt)
Byi=dblarr(n_glat,n_glon,n_alt)
Bzi=dblarr(n_glat,n_glon,n_alt)


for alt=alts,alte,dalt do begin
  for glon=glons,glone,dglon do begin
    for glat=glats,glate,dglat do begin

      cal_geomag_igrf,nmax,gcoef,hcoef,glat,glon,alt,Bx,By,Bz,TotalF
      nx=fix((glat-glats)/dglat)
      ny=fix((glon-glons)/dglon)
      nz=fix((alt-alts)/dalt)
      Bxi(nx,ny,nz)=Bx
      Byi(nx,ny,nz)=By
      Byi(nx,ny,nz)=By
      print, nx,'/',n_glat,ny,'/',n_glon,nz,'/',n_alt
;      print,bx,by,bz,glat,glon,alt,atan(bz/bx)*360/2/3.14
    endfor
  endfor
endfor







end