;
; ***************************************************************
;
;   ce\ntroid.pro
;    for calculating the centroid of selected area on the image
;
; ***************************************************************
;

Pro centroid

close,/all

;
; input file name
;

nums=1
nume=26
lens='Lens_data'
phase=''
ang=''
fdir='C:\Usr\tsakanoi\Index\Focus\2004_06_29\cam3_-135_+4_re\'


nummax=nume-nums+1

xc1=intarr(nummax)
xc2=intarr(nummax)
yc1=intarr(nummax)
yc2=intarr(nummax)
xcen=fltarr(nummax)
ycen=fltarr(nummax)
peakn=intarr(nummax)
xmax=intarr(nummax)
ymax=intarr(nummax)


cnum=''

chtxt=lens+'_'+phase+'_'+ang+'.txt'

for numi=0,nummax-1 do begin

numc=nums+numi

if numc lt 10 then begin
  cnum='Acquire ('+strmid(numc,7,1)+')'
endif else if numi lt 100 then begin
  cnum='Acquire ('+strmid(numc,6,2)+')'
endif else begin
  cnum='Acquire ('+strmid(numc,5,3)+')'
endelse

;fna='200.img'
fna=cnum+'.img'
psfile =fdir+cnum+'.ps'


;x1=370
;x2=390
;y1=240
;y2=260

dx=20
dy=20
xp=512
yp=512

fn=''
fn=fdir+fna

print,numc, fn,psfile
;
; read data file
;
dum=bytarr(10240)
datar=intarr(xp,yp)
data=lonarr(xp,yp)

Openr,1,fn
 readu,1,dum
 readu,1,datar
Close,1
data(*,*)=long(datar(*,*))
;

 ; calculation of centroid (origin=(0,0))
 ; x-coordinate of centroid

peak=max(data)
xmax0=0
xmax1=0
ymax1=0
x1=0
x2=0
y1=0
y2=0

for i=0,xp-1 do begin
 for j=0,yp-1 do begin
  if data(i,j) eq peak then begin
    xmax1=fix(i)
    ymax1=fix(j)
  endif
 endfor
endfor

print, xmax1,ymax1

x1=xmax1-dx
x2=xmax1+dx
y1=ymax1-dy
y2=ymax1+dy

if x1 lt 0 then x1=0
if y1 lt 0 then y1=0
if x2 ge 511 then x2=511
if y2 ge 511 then y2=511

 mass=0l
 mm=0l
 for i=x1,x2 do begin
  for j=y1,y2 do begin
   mm=long64(mm)+i*data(i,j)
   mass=long64(mass)+data(i,j)
  endfor
 endfor
 xc=float(mm)/float(mass)

 ; y-coordinate of centroid
 mass=0l
 mm=0l


 for i=y1,y2 do begin
  for j=x1,x2 do begin
   mm=mm+long64(i)*data(j,i)
   mass=long64(mass)+data(j,i)
   ;Print, 'x', j, 'y', i, data(j,i), i*data(j,i)
  endfor
 endfor
 yc=float(mm)/float(mass)



 Print, 'Centroid of Selected Area', x1,x2,y1,y2, '  : X-coordinate', xc, ',  Y-coordinate', yc,xmax1,ymax1
 xc1(numi)=x1
 xc2(numi)=x2
 yc1(numi)=y1
 yc2(numi)=y2
 xcen(numi)=xc
 ycen(numi)=yc
 peakn(numi)=peak
 xmax(numi)=xmax1
 ymax(numi)=ymax1
;endfor

data(x1,y1:y2)=4095
data(x2,y1:y2)=4095
data(x1:x2,y1)=4095
data(x1:x2,y2)=4095

data(100,*)=4000
data(200,*)=4000
data(300,*)=4000
data(400,*)=4000
data(500,*)=4000
;data(600,*)=4000
data(*,100)=4000
data(*,200)=4000
data(*,300)=4000
data(*,400)=4000
data(*,500)=4000

sx=3000
sy=12000

xpx=xp*25
ypx=yp*25

SET_PLOT, 'PS'
DEVICE, BITS_PER_PIXEL=16, /COLOR, $
 FILENAME=psfile, /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
;print, psdir+year+strmid(fna,0,3)+cbin+'.ps'
LOADCT, 39

TVscl, data,sx, sy, XSIZE=xpx, YSIZE=ypx, /DEVICE
;TVSCL, data,sx, sy, XSIZE=xpx, YSIZE=ypx, /DEVICE


XYOUTS, 2100, 28000, 'File: '+fn , $
 CHARSIZE=1.0,  CHARTHICK=1.5,  /DEVICE

XYOUTS, 2200, 27000, 'Centroid of Selected Area:X('+$
string(x1)+string(x2)+'),Y('+string(y1)+string(y2)+')', CHARSIZE=1.0, /DEVICE

XYOUTS, 2200, 26000, 'Result: X '+string(xc)+$
' / Y '+string(yc),CHARSIZE=1.0, /DEVICE
DEVICE, /CLOSE



endfor

openw,2,fdir+chtxt
print,fdir+chtxt

for i=0,nummax-1 do begin
  printf,2,i,xc1(i),xc2(i),yc1(i),yc2(i),xcen(i),ycen(i),peakn(i)
endfor

for i=0,nummax-2,2 do begin
  print,i,xcen(i)-xcen(i+1),ycen(i)-ycen(i+1),xmax(i)-xmax(i+1),ymax(i)-ymax(i+1)
endfor

close,/all


print, 'normal end'
end
