       pro DIP,PS,X,Y,Z,BX,BY,BZ
;C
;C
;C  CALCULATES GSM COMPONENTS OF A GEODIPOLE FIELD WITH THE DIPOLE MOMENT
;C  CORRESPONDING TO THE EPOCH OF 2000.
;C
;C----INPUT PARAMETERS:
;C     PS - GEODIPOLE TILT ANGLE IN RADIANS,
;C     X,Y,Z - GSM COORDINATES IN RE (1 RE = 6371.2 km)
;C
;C----OUTPUT PARAMETERS:
;C     BX,BY,BZ - FIELD COMPONENTS IN GSM SYSTEM, IN NANOTESLA.
;C
;C  LAST MODIFICATION: JAN. 5, 2001. THE VALUE OF THE DIPOLE MOMENT WAS UPDATED TO 2000.
;C    AND A "SAVE" STATEMENT HAS BEEN ADDED, TO AVOID POTENTIAL PROBLEMS WITH SOME
;C    FORTRAN COMPILERS
;C
;C  WRITTEN BY: N. A. TSYGANENKO
;C
;      SAVE M,PSI
      M=0
      PSI=0.5

      IF (M EQ 1 AND ABS(PS-PSI) LT 1.E-5) then GOTO, lavel1
      SPS=SIN(PS)
      CPS=COS(PS)
      PSI=PS
      M=1
  lavel1:
      P=X^2
      U=Z^2
      V=3.*Z*X
      T=Y^2
      Q=30115./SQRT(P+T+U)^5
      BX=Q*((T+U-2.*P)*SPS-V*CPS)
      BY=-3.*Y*Q*(X*SPS+Z*CPS)
      BZ=Q*((P+T-2.*U)*CPS-V*SPS)
      RETURN
      END