pro draw_aurora
;on Sep 20,2004 by TS

close,/all
deg_rad=2.0*3.141592654d/360.0d
Re=6371.0d

ifile1='C:\Usr\tsakanoi\Index\trace\200101emi3d'
ene='_10000'

for ii=0, 2 do begin

  if ii eq 0 then begin
    ;emission (lat,lon,alt)
     emipara='VE427'
     cemi='427.8 nm'
     cnum='_dum'
    ;1 blue, 3 red,7 purple, 8 green
     icol=1
 endif else if ii eq 1 then begin
     emipara='VE557'
     cemi='557.7 nm'
     cnum='_dum'
    ;1 blue, 3 red,7 purple, 8 green
     icol=8
  endif else if ii eq 2 then begin
     emipara='VE670'
     cemi='670 nm'
     cnum='_dum'
    ;1 blue, 3 red,7 purple, 8 green
     icol=7
  endif else if ii eq 3 then begin
     emipara='VE630'
     cemi='630 nm'
     cnum='_4'
    ;1 blue, 3 red,7 purple, 8 green
     icol=3
  endif

;ps
psdir='C:\Usr\tsakanoi\Index\ps\'
year='20010101'

;emission (lat,lon,alt)
;emipara='VE427'
ifile=ifile1+emipara+ene+'.dat'

;ps
psdir='C:\Usr\tsakanoi\Index\ps\'
;cnum='_2'
year='20010101'
;cemi='427.8 nm'
;1 blue, 3 red,7 purple, 8 green
;icol=1
;scale: 1 is auto scale
iscale=1
smax=100.0
smin=0.0

;sat mode
xpix=1024
ypix=1024
ibin=128
;lov calculation averating factor for lat (km)
xstep=10.0
;xsteplat=xstep/(2.0*3.141592654d*re/360.0)
;xstep2=100.0
;xstep2level=200.0
;xsteplim=2.0
xstep2=xstep
;xstep2level=xstep
;xsteplim=xstep

;sat look-down angle and position
ang=45.0
satalt=700.0
satlat=70.0-(satalt-100.0)/tan(ang*deg_rad)*0.4/(2.0*3.141592654d*re/360.0)
satlon=5.0
;sat fov
satfov=7.6
;satpix=64
satpix=fix(xpix/ibin)

satres=satfov/(float(satpix)-1.0)
altlowlim=100.0
althighlim=500.0
;
print, 'parameters: ang(deg)=',ang,' / satalt(km)=',satalt,' / satlat(deg)=',satlat,$
       ' / satlon(deg)=',satlon,' / FOV(deg)=',satfov,' / pixel=',satpix

;-------------------------------------------------------------------------------------

latnum=0
lonnum=0
altnum=0

openr,1,ifile
print, 'read file',ifile
readf,1,latnum,lonnum,altnum
readf,1,lats,latrange,latres,lons,lonrange,lonres,alts,altrange,altres
print,latnum,lonnum,altnum
print,lats,latrange,latres,lons,lonrange,lonres,alts,altrange,altres


emission=dblarr(latnum,lonnum,altnum)
lat=fltarr(latnum,lonnum,altnum)
lon=fltarr(latnum,lonnum,altnum)
alt=fltarr(latnum,lonnum,altnum)

readf,1,emission
readf,1,lat
readf,1,lon
readf,1,alt

close,1

;--

satxgeo=0.0d
satygeo=0.0d
satzgeo=0.0d

sphcar,re+satalt,(90.0-satlat)*deg_rad,satlon*deg_rad,satxgeo,satygeo,satzgeo,1
satxgeof=fix(satxgeo)
satygeof=fix(satygeo)
satzgeof=fix(satzgeo)

emission_total=dblarr(satpix,satpix)
lat_total=dblarr(satpix,satpix)
lon_total=dblarr(satpix,satpix)
dxyz=0.0d
dxyz1=0.0d

xpos=0.0d
ypos=0.0d
zpos=0.0d
xpos1=0.0d
ypos1=0.0d
zpos1=0.0d
ix=0.0d
jflg=0
xstep3=0

for iy=0,satpix-1 do begin
  for iz=0,satpix-1 do begin
    zang=(ang+satfov/2.0)-iz*satres
    yang=iy*satres-satfov/2.0
    emission_total1=0.0d
    iflg=0
    print, emipara,iy,'/',satpix-1,iz,'/',satpix-1,yang,zang
    ix=0.0
    xstep3=xstep2
    nextstep3:
      if ix ge abs(satxgeof)-1 then goto, nextstep1
      ix=ix+xstep3
      xsteplat=xstep3/(2.0*3.141592654d*re/360.0)

      xpos=double(satxgeof-satxgeof/abs(satxgeof)*ix)
      zpos=satzgeof-double(ix)*tan(zang*deg_rad)
      ypos=satygeof+double(ix)*tan(yang*deg_rad)
      sphcar,r,teta,phi,xpos,ypos,zpos,-1
      if (r-re) lt altlowlim then goto, nextstep1
      if (r-re) gt althighlim then goto, nextstep2
      iro=where(fix(alt/altres) eq fix((r-re)/altres))
      ilato=where(fix(lat/latres) eq fix((90.0-teta/deg_rad)/latres))
      ilono=where(fix(lon/lonres) eq fix((phi/deg_rad)/lonres))
      ilatos=where(fix(lat/latres) eq fix(((90.0-teta/deg_rad-xsteplat/2))/latres))
      ilatoe=where(fix(lat/latres) eq fix(((90.0-teta/deg_rad+xsteplat/2))/latres))
      ilatoc= where(emission(ilatos:ilatoe,ilono,iro) gt 0)
;      print, dxyz,ix,xstep3,xsteplat,r-re,90.0-teta/deg_rad,xpos,ypos,zpos,ilatos,ilatoe,ilatoc
      xstep1=xstep*2
      if xstep lt 10 then xstep1=10.0
      if (r-re) ge 105 and alt(iro) lt 115 then begin
        lat_total(iy,iz)=90.0-teta/deg_rad
        lon_total(iy,iz)=phi/deg_rad
      endif
      if iflg eq 1 and iro ge 0 then begin
        dxyz=sqrt((xpos-xpos1)^2+(ypos-ypos1)^2+(zpos-zpos1)^2)
        if ilono ge 0 then begin
          if ilatos ge 0 and ilatoe ge 0 and ilatoc ge 0 then begin
            if abs(ilatoe-ilatos) le 1 and xstep3 eq xstep then begin
              emission_total1=emission_total1+emission(ilatos+ilatoc,ilono,iro)*dxyz
;              print, '!!',ilatos,ilatoe,ilatoc,emission(ilatos+ilatoc,ilono,iro),emission_total1,dxyz,xstep3,dxyz1
              xpos1=xpos
              ypos1=ypos
              zpos1=zpos
              goto, nextstep3
            endif else begin
              if ilatoc gt abs(ilatoe-ilatos)/2 then begin
                ix=ix-float(xstep3)/2.0
              endif else begin
                ix=ix-xstep3
              endelse
              xstep3=fix(xstep3/2)
              if xstep3 le xstep then xstep3=xstep
              xpos1=xpos
              ypos1=ypos
              zpos1=zpos
              dxyz1=dxyz
              goto, nextstep3
            endelse
          endif
        endif
      endif
      nextstep2:
      iflg=1
      xpos1=xpos
      ypos1=ypos
      zpos1=zpos
;      xstep3=xstep2
;      dxyz=0
    goto, nextstep3
    nextstep1:
    emission_total(iy,iz)=emission_total1

  endfor
endfor

if ibin ge 100 then begin
  cbin=strmid(ibin,5,3)
endif else if ibin ge 10 then begin
  cbin=strmid(ibin,6,2)
endif else begin
  cbin=strmid(ibin,7,1)
endelse

ofile=ifile1+emipara+cbin+cnum+ene+'_out.dat'

openw,2,ofile

printf,2,ifile
printf,2,year
printf,2,cemi
printf,2,ibin,xstep
printf,2,ang,satalt,satlat,satlon,satfov,satpix
printf,2,emission_total
printf,2,lat_total
printf,2,lon_total

close,2
;----------



fact=1.8
xpx=satpix
ypx=satpix


SET_PLOT, 'PS'

DEVICE, BITS_PER_PIXEL=8, /COLOR, $
 FILENAME=psdir+year+emipara+cbin+cnum+ene+'.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
print, psdir+year+emipara+cbin+'.ps'
LOADCT, icol

!P.FONT=0
datec='Date: '+year

XYOUTS, 2100, 28000, 'Simulated Auroral Image by INDEX/MAC',$
 CHARSIZE=2.0,  CHARTHICK=1.5,  /DEVICE
XYOUTS,  4000, 26800, datec+' / '+cemi+' / '+cbin+'pix. binning',CHARSIZE=1.2, /DEVICE
XYOUTS, 4000, 26000, 'Sat. Position: GLat(deg)='+strmid(satlat,4.7)+' / GLon(deg)='+$
  strmid(satlon,4,7)+' / Alt(km)='+strmid(satalt,4,7),CHARSIZE=1.0, /DEVICE
;XYOUTS, 4000, 25200,'Look-down angle(deg)='+strmid(ang,4,6)+' / xstep(km)='+strmid(xstep,4,7),CHARSIZE=1.0, /DEVICE
XYOUTS, 4000, 25200,'Look-down angle(deg)='+strmid(ang,4,6),CHARSIZE=1.0, /DEVICE

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=ysi,/DEVICE
plots, [xsc,xsc],[ysc,ysc+ysi+60],/device
plots, [xsc+xsi,xsc+xsi],[ysc,ysc+ysi+60],/device

if iscale eq 1 then begin
  smin=min(emission_total(*,*))
  smax=max(emission_total(*,*))
endif

XYOUTS, xsc+1000.0, ysc+ysi+500.0, 'column emission rate (R)', CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
xyouts, xsc-700.0, ysc+ysi+100.0, fix(smin), charsize=0.8, charthick=1, /device
xyouts, xsc-1200.0+xsi, ysc+ysi+100.0, long(smax), charsize=0.8, charthick=1, /device


;------------------ DRAW IMAGE DATA  --------------
;

xs=3300.0
xd=4300.0
ys=24500.0
yd=800.0
pix=0.0
xpi=0.0
ypi=0.0
xpx=xpx*float(ibin)/2.0
ypx=ypx*float(ibin)/2.0
;---plotting images

sx=xs
sy=ys-((xpx)*30+yd)


TV, bytscl(emission_total(*,*),min=smin,max=smax), sx, sy, XSIZE=(xpx)*30, YSIZE=(ypx)*30, /DEVICE

clat00=strmid(lat_total(0,0),3,9)
clat01=strmid(lat_total(0,satpix-1),3,9)
clat10=strmid(lat_total(satpix-1,0),3,9)
clat11=strmid(lat_total(satpix-1,satpix-1),3,9)
clon00=strmid(lon_total(0,0),3,9)
clon01=strmid(lon_total(0,satpix-1),3,9)
clon10=strmid(lon_total(satpix-1,0),3,9)
clon11=strmid(lon_total(satpix-1,satpix-1),3,9)

xyouts, sx-1500, sy-400, '('+clat00+','+clon00+')',charsize=1.0,/device
xyouts, sx-1500, sy+150+ypx*30, '('+clat01+','+clon01+')',charsize=1.0,/device
xyouts, sx-1500+xpx*30, sy-400, '('+clat10+','+clon10+')',charsize=1.0,/device
xyouts, sx-1500+xpx*30, sy+150+ypx*30, '('+clat11+','+clon11+')',charsize=1.0,/device

if satpix lt 10 then begin
  istep=1
endif else begin
  istep=fix(satpix/10)
endelse
for m=1, satpix, istep do begin
  pix=float(m)
  xpi=sx+xpx*30*pix/xpx*(xpx/satpix)
  plots, [xpi,xpi], [sy,sy-100*fact],/device
  cm=strmid(string(fix(m)),4,4)
  xyouts, xpi-220*fact, sy-700*fact, cm, charsize=1.0,/device
   xyouts, xs+800*fact+5000*(fact-1), sy-1700,'  CCD bin', charsize=1.2,/device
endfor

DEVICE, /CLOSE

endfor

print,'normal end'
end
