pro draw_aurora_polygon
;on Sep 20,2004 by TS

close,/all
deg_rad=2.0*3.141592654d/360.0d
Re=6371.0d

ifile1='C:\Usr\tsakanoi\Index\trace\200101emi3d'

;emission (lat,lon,alt)
emipara='VE427_3'
ifile=ifile1+emipara+'.dat'

;ps
psdir='C:\Usr\tsakanoi\Index\ps\'
year='20010101'
cemi='427.8 nm'
;1 blue, 3 red,7 purple, 8 green
icol=1
;scale: 1 is auto scale
iscale=1
smax=100.0
smin=0.0

;sat mode
xpix=1024
ypix=1024
ibin=1024/8
;lov calculation averating factor for lat (km)
xstep=100.0
xsteplat=xstep/(2.0*3.141592654d*re/360.0)

;sat look-down angle and position
ang=45.0
satalt=700.0
satlat=70.0-(satalt-100.0)/tan(ang*deg_rad)*0.4/(2.0*3.141592654d*re/360.0)
satlon=5.0
;sat fov
satfov=7.6
;satpix=64
satpix=fix(xpix/ibin)

satres=satfov/(float(satpix)-1.0)
altlowlim=80.0
althighlim=500.0
;
print, 'parameters: ang(deg)=',ang,' / satalt(km)=',satalt,' / satlat(deg)=',satlat,$
       ' / satlon(deg)=',satlon,' / FOV(deg)=',satfov,' / pixel=',satpix

;------------------

latnum=0
lonnum=0
altnum=0

openr,1,ifile
print, 'read file',ifile
readf,1,latnum,lonnum,altnum
readf,1,lats,latrange,latres,lons,lonrange,lonres,alts,altrange,altres
print,latnum,lonnum,altnum
print,lats,latrange,latres,lons,lonrange,lonres,alts,altrange,altres


emission=dblarr(latnum,lonnum,altnum)
lat=fltarr(latnum,lonnum,altnum)
lon=fltarr(latnum,lonnum,altnum)
alt=fltarr(latnum,lonnum,altnum)

readf,1,emission
readf,1,lat
readf,1,lon
readf,1,alt

close,1


;--
for j=0,200 do begin

clevel=0.1*float(j)

shade_volume,emission,0.01,v,p,/low
s=size(emission)
scale3,xrange=[0,s(1)],yrange=[0,s(2)],zrange=[0,s(3)],ax=0,az=ang
nframes=20
;for i=0,nframes-1 do begin
  t3d,tr=[-.5,-.5,-.5],rot=[1.8*2*j,1.8*4*j,1.8*j]
  t3d,tr=[.5,.5,.5]
;window,0
tv,polyshade(v,p,/t3d)
;endfor

endfor

print,'normal end'
end
