pro emission_ratio
;on Sep 20,2004 by TS

close,/all
deg_rad=2.0*3.141592654d/360.0d
Re=6371.0d

ifile='C:\Usr\tsakanoi\Index\trace\200101emi3d'
cnum='_4_10000'
;cnum='_3_500'
;cnum='_3'
ene='10keV'
pix=32
ibin=32

;ratio select num 0:428 1:558 2:670 3:630
num1=0
num2=1

icol=17

;ps
psdir='C:\Usr\tsakanoi\Index\ps\'
;cnum='_2'
;year='20010101'
;cemi='427.8 nm'
;1 blue, 3 red,7 purple, 8 green
;icol=1
;scale: 1 is auto scale
iscale=0
smax=2.0
;smin=-2.0
smin=smax-2.0
;--set to (smax-smin) is even

if ibin ge 100 then begin
  cbin=strmid(ibin,5,3)
endif else if ibin ge 10 then begin
  cbin=strmid(ibin,6,2)
endif else begin
  cbin=strmid(ibin,7,1)
endelse

emission_total=dblarr(pix,pix,4)
lat_total=dblarr(pix,pix,4)
lon_total=dblarr(pix,pix,4)
cemi=strarr(4)

for ii=0, 2 do begin

  if ii eq 0 then begin
    ;emission (lat,lon,alt)
     emipara='VE427'
     cemi(0)='427.8 nm'
    ;1 blue, 3 red,7 purple, 8 green
 endif else if ii eq 1 then begin
     emipara='VE557'
     cemi(1)='557.7 nm'
    ;1 blue, 3 red,7 purple, 8 green
  endif else if ii eq 2 then begin
     emipara='VE670'
     cemi(2)='670 nm'
    ;1 blue, 3 red,7 purple, 8 green
  endif else if ii eq 3 then begin
     emipara='VE630'
     cemi(3)='630 nm'
    ;1 blue, 3 red,7 purple, 8 green
  endif

;reading a file
ifile1=''
year1=''
cemi1=''
ibin=0
xstep=0
ang=0.0
satalt=0.0
satlat=0.0
satlon=0.0
satfov=0.0

satpix=0


ofile=ifile+emipara+cbin+cnum+'_out.dat'

openr,2,ofile

readf,2,ifile1
readf,2,year1
readf,2,cemi1
readf,2,ibin,xstep
readf,2,ang,satalt,satlat,satlon,satfov,satpix

emission_total1=dblarr(satpix,satpix)
lat_total1=dblarr(satpix,satpix)
lon_total1=dblarr(satpix,satpix)

readf,2,emission_total1
readf,2,lat_total1
readf,2,lon_total1

close,2
;----------

emission_total(*,*,ii)=emission_total1(*,*)
lat_total(*,*,ii)=lat_total1(*,*)
lon_total(*,*,ii)=lon_total1(*,*)


endfor

;--------------------------------------------------------

year=year1

emission_r=dblarr(satpix,satpix)
for i=0, satpix-1 do begin
    l=where(emission_total(i,*,num2) ne 0)
    emission_r(i,l)=emission_total(i,l,num1)/emission_total(i,l,num2)
endfor
fact=1.8
xpx=satpix
ypx=satpix


psnum=strmid(num1,7,1)+strmid(num2,7,1)

SET_PLOT, 'PS'

DEVICE, BITS_PER_PIXEL=8, /COLOR, $
 FILENAME=psdir+year+emipara+cbin+cnum+'_'+psnum+'.ps', /PORTRAIT, $
 XSIZE=21.0, YSIZE=29.7, XOFFSET=0.0, YOFFSET=0.0
print, psdir+year+emipara+cbin+'.ps'
LOADCT, icol

!P.FONT=0
datec='Date: '+year

XYOUTS, 2100, 28000, 'Simulated Auroral Image by INDEX/MAC',$
 CHARSIZE=2.0,  CHARTHICK=1.5,  /DEVICE
XYOUTS,  2100, 26800, 'Ratio('+cemi(num1)+')/('+cemi(num2)+'), Ele. Eg='+ene,CHARSIZE=1.5, /DEVICE
XYOUTS,  4000, 26000, datec+', Ratio of '+cemi(num1)+'/'+cemi(num2)+', '+cbin+'pix. bin.',CHARSIZE=1.0, /DEVICE
XYOUTS, 4000, 25200, 'Sat. Position: GLat(deg)='+strmid(satlat,4.7)+' / GLon(deg)='+$
  strmid(satlon,4,7)+' / Alt(km)='+strmid(satalt,4,7),CHARSIZE=1.0, /DEVICE
;XYOUTS, 4000, 25200,'Look-down angle(deg)='+strmid(ang,4,6)+' / xstep(km)='+strmid(xstep,4,7),CHARSIZE=1.0, /DEVICE
XYOUTS, 4000, 24400,'Look-down angle(deg)='+strmid(ang,4,6),CHARSIZE=1.0, /DEVICE

colorbar=BYTSCL(FINDGEN(100))#REPLICATE(1,16)
xsi=4500*0.9
ysi=400.0
xsc=15000.0
ysc=26500.0
TV, colorbar, xsc, ysc, XSIZE=xsi, YSIZE=ysi,/DEVICE
plots, [xsc,xsc],[ysc,ysc+ysi+60],/device
plots, [xsc+xsi,xsc+xsi],[ysc,ysc+ysi+60],/device
plots, [xsc+xsi/2,xsc+xsi/2],[ysc+ysi,ysc+ysi+60],/device

if iscale eq 1 then begin
  smin=min(alog10(emission_r(*,*)))
  smax=max(alog10(emission_r(*,*)))
endif

if fix((smax-smin)/2) ne float((smax-smin)/2) then smin=smin-1
XYOUTS, xsc, ysc+ysi+500.0, 'log10(column emission ratio)', CHARSIZE=0.8,  CHARTHICK=1,   /DEVICE
xyouts, xsc-700.0, ysc+ysi+100.0, fix(smin), charsize=0.8, charthick=1, /device
xyouts, xsc-700.0+xsi/2, ysc+ysi+100.0,fix(smin)+fix((smax-smin)/2), charsize=0.8, charthick=1, /device
xyouts, xsc-1200.0+xsi, ysc+ysi+100.0, long(smax), charsize=0.8, charthick=1, /device


;------------------ DRAW IMAGE DATA  --------------
;

xs=3300.0
xd=4300.0
ys=24500.0
yd=800.0
pix=0.0
xpi=0.0
ypi=0.0
xpx=xpx*float(ibin)/2.0
ypx=ypx*float(ibin)/2.0
;---plotting images

sx=xs
sy=ys-((xpx)*30+yd)


TV, bytscl(alog10(emission_r),min=smin,max=smax), sx, sy, XSIZE=(xpx)*30, YSIZE=(ypx)*30, /DEVICE

clat00=strmid(lat_total(0,0),3,9)
clat01=strmid(lat_total(0,satpix-1),3,9)
clat10=strmid(lat_total(satpix-1,0),3,9)
clat11=strmid(lat_total(satpix-1,satpix-1),3,9)
clon00=strmid(lon_total(0,0),3,9)
clon01=strmid(lon_total(0,satpix-1),3,9)
clon10=strmid(lon_total(satpix-1,0),3,9)
clon11=strmid(lon_total(satpix-1,satpix-1),3,9)

xyouts, sx-1500, sy-400, '('+clat00+','+clon00+')',charsize=1.0,/device
xyouts, sx-1500, sy+150+ypx*30, '('+clat01+','+clon01+')',charsize=1.0,/device
xyouts, sx-1500+xpx*30, sy-400, '('+clat10+','+clon10+')',charsize=1.0,/device
xyouts, sx-1500+xpx*30, sy+150+ypx*30, '('+clat11+','+clon11+')',charsize=1.0,/device

if satpix lt 10 then begin
  istep=1
endif else begin
  istep=fix(satpix/10)
endelse
for m=1, satpix, istep do begin
  pix=float(m)
  xpi=sx+xpx*30*pix/xpx*(xpx/satpix)
  plots, [xpi,xpi], [sy,sy-100*fact],/device
  cm=strmid(string(fix(m)),4,4)
  xyouts, xpi-220*fact, sy-700*fact, cm, charsize=1.0,/device
   xyouts, xs+800*fact+5000*(fact-1), sy-1700,'  CCD bin', charsize=1.2,/device
endfor

DEVICE, /CLOSE


print,'normal end'


;stop
end