pro example2

close,/all

rfile='C:\Usr\tsakanoi\Index\trace\200101tra.dat'
emifile='C:\Usr\tsakanoi\Index\trace\emission20010101.dat'
outfile='C:\Usr\tsakanoi\Index\trace\200101emi3d.dat'

Re=6371.0

;auroral appearance
latdef=70.0

;emission (lat,lon,alt)
emipara='VE427'

;start range, and res of grid(lat, lon, alt)
lats=67.5
latrange=5.0
latres=0.01
lons=0.0
lonrange=10.0
;lonres=0.05
lonres=2.0
alts=80.0
altrange=520.0
altres=4.0

;--------------
read_emifile,emifile,c_energy,e_flux,te_flux,dalt,VE427,VE557,VE630,VEN21PG,VE844
e_num=n_elements(dalt)

;---------------
latnum=fix(latrange/latres)
lonnum=fix(lonrange/lonres)
altnum=fix(altrange/altres)
print, 'latnum,lonnum,altnum=',latnum,lonnum,altnum

emission=dblarr(latnum,lonnum,altnum)
lat=fltarr(latnum,lonnum,altnum)
lon=fltarr(latnum,lonnum,altnum)
alt=fltarr(latnum,lonnum,altnum)

for i=0,latnum-1 do begin
  lat(i)=lats+float(i)*latres
endfor
for i=0,lonnum-1 do begin
  lon(i)=lons+float(i)*lonres
endfor
for i=0,altnum-1 do begin
  alt(i)=alts+float(i)*altres
endfor

latdefnum=where(lat(*,0,0) eq latdef)

for i=0,lonnum-1 do begin
  lat0=double(latdef)
  lon0=double(lon(i))

   geomag_trace_sub,lat0,lon0

   read_tracedata,rfile,xgsmo,ygsmo,zgsmo,alto
   t_num=n_elements(alto)
   lato=fltarr(t_num)
   lono=fltarr(t_num)
   alto=fltarr(t_num)
   emio=dblarr(t_num)
   xgeo1=0.0
   ygeo1=0.0
   zgeo1=0.0
   for j=0,t_num-1 do begin
     xgsm1=xgsmo(j)
     ygsm1=ygsmo(j)
     zgsm1=zgsmo(j)
     GEOGSM,XGEO1,YGEO1,ZGEO1,XGSM1,YGSM1,ZGSM1,-1
     sphcar,R,TETA,PHI,Xgeo1,Ygeo1,Zgeo1,-1
     lato(j)=90.0-teta*360.0/2.0/3.141592654
     lono(j)=phi*360.0/2.0/3.141592654
     alto(j)=r-re
     latonum=fix((float(lato(j)-lats))/latres)
     lononum=fix((float(lono(j)-lons))/lonres)
     altonum=fix((float(alto(j)-alts))/altres)
     emio=interpol(ve427,dalt,alto(j))
     emission(latonum,lononum,altonum)=emio
     print, j,lato(j),lono(j),alto(j),latonum,lononum,altonum,emio
   endfor

endfor

openw,3,outfile
print, 'outputfile',outfile
printf,3,latnum,lonnum,altnum
printf,3,emission
printf,3,lat
printf,3,lon
printf,3,alt

close,3

print,'normal end!'

end
