pro fft_power,datain,timin,num,windows,steps,maxfreq,minfreq,smn,power,dataout_real,dataout_img,timout,dy,logpower,lnpower

;--- FFT parameters for SEARCHCOIL MAGNETOMETER----------------
;windows=128
;  data window for FFT(data points)
;steps=60
;  data number (=sec) interval for FFT
;minfreq=0.1
;maxfreq=4
;  plotting min and max frequency (Hz)
;smn=2
;  smooting factor after FFT for freq and time
;iprs=01
;  scale autormatic yes ipr=1, no ipr=0
;soff0s=6.0
;soff1s=-1.0
; if ipr= 1 then set contrast (for high-contrast, large soff0 and small soff1)
;maxss=-3.0
;minss=-6.0
; if ipr=0 then set scale above (log nT^2*sec)------------

;dsmake, sx,ti*3600,lnum,windows,steps,maxfreqs,minfreqs,smoothns,sxp_f,sxr_f,sxi_f,ti_f,freqs,lsxp_f,lnsxp_f
;pro dsmake, datain,timin,num,window,step,maxfreq,minfreq,smn,power,dataout_real,dataout_img,timout,dy,logpower,lnpower

;num=1024
;tt=10
;ii=indgen(num)
;jj=fltarr(num)
;jj=sin(2*3.141592d/tt*ii)
;datain=fltarr(num)
;datain(*)=jj(*)
;timin=fltarr(num)
;timin(*)=ii(*)

dataout_real=fltarr(num/steps,windows/2)
power0=fltarr(num/steps,windows/2)
power=fltarr(num/steps,windows/2)
logpower=fltarr(num/steps,windows/2)
dataout_img=fltarr(num/steps,windows/2)
dataout1=complexarr(windows)
timout=fltarr(num/steps)
datain1=fltarr(windows)
dy=fltarr(windows/2)


j=0l
is=0l
ie=0l
ave=0.0
avem=mean(datain(*))
hf=hanning(windows)

for i=0l,num-1,steps do begin
    is=i-windows/2
    ie=i+windows/2-1
    if (is lt 0) then begin
      ave=mean((datain(0:ie-is)))
      datain1(*)=hf(*)*(datain(0:ie-is)-ave)
      dataout1(*)=fft(datain1(*))
      dataout_real(j,*)=float(dataout1(0:windows/2-1))
      dataout_img(j,*)=imaginary(dataout1(0:windows/2-1))
      timout(j)=timin(i)
      j=j+1
      if j ge num/steps then goto, nextstep
    endif else if ie gt num-1 then begin
      ave=mean((datain(num-1-(ie-is):num-1)))
      datain1(*)=hf(*)*(datain(num-1-(ie-is):num-1)-ave)
      dataout1(*)=fft(datain1(*))
      dataout_real(j,*)=float(dataout1(0:windows/2-1))
      dataout_img(j,*)=imaginary(dataout1(0:windows/2-1))
      timout(j)=timin(i)
      j=j+1
      if j ge num/steps then goto, nextstep
    endif else begin
      ave=mean((datain(is:ie)))
      datain1(*)=hf(*)*(datain(is:ie)-ave)
      dataout1(*)=fft(datain1(*))
      dataout_real(j,*)=float(dataout1(0:windows/2-1))
      dataout_img(j,*)=imaginary(dataout1(0:windows/2-1))
      timout(j)=timin(i)
      j=j+1
      if j ge num/steps then goto, nextstep
    endelse
endfor

nextstep:

dt=timin(1)-timin(0)
n=findgen(windows/2)
dy=n/(windows*dt)
print, dt,'dt'

power0(*,*)=(1.0/0.875)*float(dt*windows)*(dataout_real(*,*)^2+dataout_img(*,*)^2)
;factor 0.875 ; refer to Spector kaiseki by Hino p. 201-202.

if smn eq 1 then begin
  power=power0
endif else begin
  power=smooth(power0,smn)
endelse

logpower(*,*)=alog10(power(*,*))

nf0=fix(windows/2*(minfreq-dy(0))/(dy(windows/2-1)-dy(0)))
nf1=fix(windows/2*(maxfreq-dy(0))/(dy(windows/2-1)-dy(0)))
if nf1 gt windows/2 then nf1=windows/2
nfreq=nf1-nf0
;print, dy(windows/2-1),dy(0)
lnpower=fltarr(num/steps,nfreq)
nf11=nf1-1

lnpower(*,*)=logpower(*,nf0:nf11)

end