pro fovdet_ino_n_alt,res,ich,fnum,nstep,ymd,time,satglat2,satglon2,satalt2,q1c,q2c,q3c,q4c,$
    macfovx,macfovy,macfovz,macfovgeix,macfovgeiy,macfovgeiz,glat1,glon1,galt1,errorsum,imapalt,mapalt

Re=6371.0d
pai=3.14159265358979d
rl=6378.137d
;rs=6356.752d
rs=0.0d
fg=1/298.257222101d
rs=rl-fg*rl
e2=0.0d
e2=fg*(2-fg)

fang=7.568543d
hang=fang/2.0

if imapalt eq 0 then mapalt=0.0

bin=res
errorsum=0l

satglat1=dblarr(fnum)
satglon1=dblarr(fnum)
glat1=dblarr(bin,bin,fnum)
glon1=dblarr(bin,bin,fnum)
galt1=dblarr(bin,bin,fnum)
mlt1=dblarr(bin,bin,fnum)
fplat1=dblarr(fnum)
fplon1=dblarr(fnum)

;calcutrate pixel vector in satellite coordinate
macfovx=dblarr(bin,bin)
macfovy=dblarr(bin,bin)
macfovz=dblarr(bin,bin)

macfovx1=dblarr(bin,bin)
macfovy1=dblarr(bin,bin)
macfovz1=dblarr(bin,bin)

for l=0,bin-1 do begin
  for l2=0,bin-1 do begin

    teta1=atan(3302.4-12.9*(l+1)*512/res,50000.0)
    teta2=atan(3302.4-12.9*(l2-1)*512/res,50000.0)
;    teta1=atan(3259.6-12.935*(l)*512/res,50000.0)
;    teta2=atan(3259.6-12.935*(l2)*512/res,50000.0)
;    teta1=atan(3300.0-12.9*(l)*512/res,50000.0)
;    teta2=atan(3300.0-12.9*(l2)*512/res,50000.0)

    macfovx1(l2,l)=sqrt(1/(1+(tan(teta1))^2+(tan(teta2))^2))
    macfovy1(l2,l)=macfovx1(l2,l)*tan(teta2)
    macfovz1(l2,l)=macfovx1(l2,l)*tan(teta1)

;CH1 tetaoffset=4 phioffset=18
;CH2 tetaoffset=46,phioffset=17
;CH3 tetaoffset=21 phioffset=-19
    if ich eq 0 then begin
      tetaoffset1=4
      phioffset1=18
    endif else if ich eq 1 then begin
      tetaoffset1=46
      phioffset1=17
    endif else if ich eq 2 then begin
      tetaoffset1=21
      phioffset1=-19
    endif
;    if ich eq 0 then begin
;      tetaoffset1=8
;      phioffset1=43
;    endif else if ich eq 1 then begin
;      tetaoffset1=6
;      phioffset1=37
;    endif else if ich eq 2 then begin
;      tetaoffset1=8
;      phioffset1=36
;    endif

    tetam=(45.0+0.0148437*tetaoffset1)/180d*pai
    phim=(0.0148437*phioffset1)/180d*pai

    MX=[sin(tetam)*cos(phim),sin(tetam)*sin(phim),cos(tetam)]
    MY=[-sin(phim),cos(phim),0]
    MZ=[-cos(tetam)*cos(phim),-cos(tetam)*sin(phim),sin(tetam)]
    macfovx(l2,l)=MX(0)*macfovx1(l2,l)+MY(0)*macfovy1(l2,l)+MZ(0)*macfovz1(l2,l)
    macfovy(l2,l)=MX(1)*macfovx1(l2,l)+MY(1)*macfovy1(l2,l)+MZ(1)*macfovz1(l2,l)
    macfovz(l2,l)=MX(2)*macfovx1(l2,l)+MY(2)*macfovy1(l2,l)+MZ(2)*macfovz1(l2,l)

  endfor
endfor


for j=0,fnum-1 do begin
;  if j/10d eq fix(j/10d) then begin
  if float(j)/float(nstep) eq fix(j/nstep) then begin
    ;rsat=re+orbsatalt2(j)
    ;satteta=(90-orbsatglat2(j))/360d*2*pai
    ;satphi=orbsatglon2(j)/360d*2*pai
    ;sphcar,rsat,satteta,satphi,satxgeo,satygeo,satzgeo,1
 ;   ng=rl/sqrt(1-e2*(sin(rs))^2)
    ng=rl/sqrt(1-e2*(sin(satglat2(j)/360d*2*pai))^2)

    satxgeo=(ng+satalt2(j))*cos(satglat2(j)/360d*2*pai)*cos(satglon2(j)/360d*2*pai)
    satygeo=(ng+satalt2(j))*cos(satglat2(j)/360d*2*pai)*sin(satglon2(j)/360d*2*pai)
    satzgeo=(ng*(1-e2)+satalt2(j))*sin(satglat2(j)/360d*2*pai)
    q1=q1c(j)
    q2=q2c(j)
    q3=q3c(j)
    q4=q4c(j)
;    print,j,q1,q2,q3,q4,satglat2(j),'!!!!!!!!!!!!!!!!!!!'
    I=dblarr(3)
    X=dblarr(3)
    Y=dblarr(3)
    Z=dblarr(3)
    M=dblarr(3)
;    if q1 eq 0 then stop

    geo_to_gei,long64(ymd(j)),time(j),satxgeo,satygeo,satzgeo,satxgei,satygei,satzgei

    I(0)=satxgei
    I(1)=satygei
    I(2)=satzgei

    X(0)=1.-2d*(q2*q2+q3*q3)
    X(1)=2d*(q1*q2+q4*q3)
    X(2)=2d*(q1*q3-q4*q2)

    Y(0)=2d*(q1*q2-q4*q3)
    Y(1)=1.-2d*(q1*q1+q3*q3)
    Y(2)=2d*(q2*q3+q4*q1)
;print,x
;print,y

    Z(0)=X(1)*Y(2)-X(2)*Y(1)
    Z(1)=X(2)*Y(0)-X(0)*Y(2)
    Z(2)=X(0)*Y(1)-X(1)*Y(0)
;calculate MAC vector
    l=sqrt(((X(0)+Z(0))/2)^2+((X(1)+Z(1))/2)^2+((X(2)+Z(2))/2)^2)
    M(0)=(X(0)+Z(0))/2/l
    M(1)=(X(1)+Z(1))/2/l
    M(2)=(X(2)+Z(2))/2/l
;print,M

    macfovgeix=dblarr(bin,bin)
    macfovgeiy=dblarr(bin,bin)
    macfovgeiz=dblarr(bin,bin)

;-----
;----------------------------------------------------
;transform stellite coordinate to gei coordinate

    if q1 eq 0 and q2 eq 0 and q3 eq 0 and q4 eq 0 then begin
        macfovgeix(*,*)=-999.9
        macfovgeiy(*,*)=-999.9
        macfovgeiz(*,*)=-999.9
        glat1(*,*,j)=-999.9
        glon1(*,*,j)=-999.9
    endif else begin
      for i2=0,bin-1 do begin
        for i3=0,bin-1 do begin
          macfovgeix(i2,i3)=X(0)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(0)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(0)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
          macfovgeiy(i2,i3)=X(1)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(1)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(1)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
          macfovgeiz(i2,i3)=X(2)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(2)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(2)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
        endfor
      endfor


;=========================================
rln=rl+mapalt
rsn=rs+mapalt
      for l=0,bin-1 do begin
        for k=0,bin-1 do begin

          mx=macfovgeix(k,l)
          my=macfovgeiy(k,l)
          mz=macfovgeiz(k,l)

;b=(0)*mx+I(1)*my+I(2)*mz
;c=2*re*(satalt2(j)-footalt)+(satalt2(j)^2+footalt^2)

          c1=mx^2+my^2+(rln/rsn)^2*mz^2
          c2=I(0)*mx+I(1)*my+(rln/rsn)^2*I(2)*mz
          c3=I(0)^2+I(1)^2+(rln/rsn)^2*I(2)^2-rln^2

          if c2^2-c1*c3 lt 0 then begin
 ;           print,"Error.... "
            glat1(k,l,j)=0
            glon1(k,l,j)=0
            errorsum=errorsum+1
            goto,step6
          endif

          a1=(-c2+sqrt(c2^2-c1*c3))/c1
          a2=(-c2-sqrt(c2^2-c1*c3))/c1

          xf1=I(0)+a1*mx
          yf1=I(1)+a1*my
          zf1=I(2)+a1*mz
          dis1=(xf1-I(0))^2+(yf1-I(1))^2+(zf1-I(2))^2
          xf2=I(0)+a2*mx
          yf2=I(1)+a2*my
          zf2=I(2)+a2*mz
          dis2=(xf2-I(0))^2+(yf2-I(1))^2+(zf2-I(2))^2
          if dis1 gt dis2 then begin
            xf1=xf2
            yf1=yf2
            zf1=zf2
          endif

;          print, 'dis1,dis2',dis1,dis2
;------------------------------------
;transform gei to geo
;        print, long64(ymd(j)),time(j),j

          gei_to_geo,long(ymd(j)),long(time(j)),xf1,yf1,zf1,xg1,yg1,zg1
;sphcar,r1,teta1,phai1,xg1,yg1,zg1,-1
          glon1(k,l,j)=atan(yg1/xg1)/(2*pai)*360
          if xg1 lt 0 and yg1 lt 0 then begin
;            stop
            glon1(k,l,j)=glon1(k,l,j)+180.0
          endif
          if xg1 lt 0 and yg1 gt 0 then begin
;            stop
            glon1(k,l,j)=glon1(k,l,j)+180.0
          endif
;-- add by TS on Aug. 12, 2006

          pg=sqrt(xg1^2+yg1^2)
          rg=sqrt(xg1^2+yg1^2+zg1^2)
          mu=atan(zg1/pg*((1-fg)+e2*rl/rg))

          glat1(k,l,j)=atan((zg1*(1-fg)+e2*rl*(sin(mu))^3)/(1-fg)/(pg-e2*rl*(cos(mu))^3))/(2*pai)*360
          galt1(k,l,j)=pg*cos(glat1(k,l,j)*2*pai/360)+zg1*sin(glat1(k,l,j)*2*pai/360)-rl*sqrt(1-e2*sin(glat1(k,l,j)*2*pai/360)^2)

;print,"mac fov center is",k,l,glat1(l,j),glon1(l,j)
step6:
        endfor
      endfor
 ;     print,j,glat1(bin/2,bin/2,j)

    endelse

  endif

endfor

step10:
close,10

return
end
