pro gei_to_geo,idate,itime,xgei,ygei,zgei,xgeo,ygeo,zgeo


;Purpose transform gei to geo
;
;INPUT idate=yyyymmdd
;      itime=hhmmss
;      gei (x,y,z)
;
;OUTPUT geo(x,y,z)
;
;GEI is Geocentric Equatorial Inertial System(J2000)
;GEO is Geographic coordinate system



    pi2 = 2.0 * acos(-1.0)
	rad = 360.0/pi2
    i=1

	iyr=fix(idate/10000)
    mon=fix(idate/100-iyr*100)
    day=fix(idate-iyr*10000-mon*100)
    month=intarr(2,12)
    month(0,*)=[0,31,59,90,120,151,181,212,243,273,304,334]
    month(1,*)=[0,31,60,91,121,152,182,213,244,274,305,335]
    if ((iyr mod 4) eq 0) then i=2
	in=day+month(i-1,mon-1)
    h=fix(itime/10000)
    m=fix(itime/100-h*100)
    s=fix(itime-h*10000-m*100)
    secs=h*60.*60.+m*60.+s

    solar_pos, iyr,in,secs, gst, slong, srasn, sdec, S


    teta=gst/rad


    xgeo   = xgei*cos(teta)+ygei*sin(teta)
    ygeo   = -xgei*sin(teta)+ygei*cos(teta)
    zgeo   = zgei

 end