pro geo_to_gei,idate,itime,xgeo,ygeo,zgeo,xgei,ygei,zgei
; /** coodinate change to grinidge **/

;  /* get Julian date */
    pi2 = 2.0 * acos(-1.0)
	rad = 360.0/pi2
    i=1
    secs=0.0

	iyr=fix(idate/10000)
    mon=fix(idate/100-iyr*100)
    day=fix(idate-iyr*10000-mon*100)
    month=intarr(2,12)
    month(0,*)=[0,31,59,90,120,151,181,212,243,273,304,334]
    month(1,*)=[0,31,60,91,121,152,182,213,244,274,305,335]
    if ((iyr mod 4) eq 0) then i=2
	in=day+month(i-1,mon-1)
    h=fix(itime/10000)
    m=fix(itime/100-h*100)
    ss=fix(itime-h*10000l-m*100)
    secs=float(h)*60.*60.+float(m)*60.+float(ss)
    solar_pos, iyr,in,secs, gst, slong, srasn, sdec, S

    ;print,'gst=',gst
    teta=gst/rad
    ;asn   = (asn-sang) mod pi2
    ;print,asn*rad,(sang mod pi2)*rad
    xgei   = xgeo*cos(teta)-ygeo*sin(teta)
    ygei   = xgeo*sin(teta)+ygeo*cos(teta)
    zgei   = zgeo

 end