      pro GEOGSM,XGEO,YGEO,ZGEO,XGSM,YGSM,ZGSM,J
;C
;C CONVERTS GEOGRAPHIC (GEO) TO SOLAR MAGNETOSPHERIC (SM) COORDINATES OR VICA VERSA.
;C
;C                   J &Gt 0                   J &Lt 0
;C----- INPUT:  J,XGEO,YGEO,ZGEO    J,XGSM,YGSM,ZGSM
;C---- OUTPUT:    XGSM,YGSM,ZGSM      XGEO,YGEO,ZGEO
;C
;C  ATTENTION:  SUBROUTINE  RECALC  MUST BE INVOKED BEFORE GEOGSM IN TWO CASES:
;C     /A/  BEFORE THE FIRST INVOCATION OF GEOGSM
;C     /B/  IF THE VALUES OF IYEAR,IDAY,IHOUR,MIN,ISEC  HAVE BEEN CHANGED
;C
;C     LAST MODIFICATION:  JAN 5, 2001 (NO ESSENTIAL CHANGES, BUT
;C                            SOME REDUNDANT STATEMENTS TAKEN OUT)
;C
;C     WRITTEN BY:  N. A. TSYGANENKO

      COMMON GEOPACK, ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,SFI,CFI,SPS,$
       CPS,SHI,CHI,HI,PSI,XMUT,A11,A21,A31,A12,A22,A32,A13,A23,A33,DS3,$
       K,IY,CGST,SGST
;C
      IF (J LT 0) then GOTO, lavel1
      XGSM=A11*XGEO+A12*YGEO+A13*ZGEO
      YGSM=A21*XGEO+A22*YGEO+A23*ZGEO
      ZGSM=A31*XGEO+A32*YGEO+A33*ZGEO
      RETURN
  lavel1:
      XGEO=A11*XGSM+A21*YGSM+A31*ZGSM
      YGEO=A12*XGSM+A22*YGSM+A32*ZGSM
      ZGEO=A13*XGSM+A23*YGSM+A33*ZGSM
      RETURN
      END
