pro geomag_trace

;progam geomag_trace
;  for caluclating the geomagnetic field tracing by
;  using the IGRF model based on GEOPACK.
;
;          2004.Sep.16 by TS


     COMMON GEOPACK, ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,SFI,CFI,SPS,$
       CPS,SHI,CHI,HI,PSI,XMUT,A11,A21,A31,A12,A22,A32,A13,A23,A33,DS3,$
       K,IY,CGST,SGST

close,/all

extern="IGRF"
Re=6371.0

;output file
ofile='C:\Usr\tsakanoi\Index\trace\200101tra.dat'
; nmax: IGRF harmonic order (0-10)
nmax=08
; geographical latitude and longitude (deg)
geolat=66.9
geolon=0.0
;   alts starting altitude (km)
alts=640.0
;   alte ending altitude (km)
alte=600000.0
;   dir=1 tracing anti-para to B, -1 para to B
dir=1.0
;   step factor for tracing B (set bigger fac for smaller step of tracing distance)
fac=30.0
;   date (UT)
iyr=2001
mon=1
day=1
ihr=0
imin=0
isec=0
;   np: max step number for tracing
np=500

;---------------------

xx=fltarr(np)
yy=fltarr(np)
zz=fltarr(np)

totalday,iyr,mon,day,md,td

recalc_n,iyr,td,mon,day,ihr,imin,isec

iopt=1

colat=(90.0-geolat)*0.01745329
xlon=geolon*0.01745329

rstr=0.0
rend=0.0
rstr=(Re+alts)/Re
rend=(Re+alte)/Re

sphcar,rstr,colat,xlon,xgeo,ygeo,zgeo,1

geogsm,xgeo,ygeo,zgeo,xgsm,ygsm,zgsm,1

print, 'xgsm,ygsm,zgsm(km)=',xgsm*re,ygsm*re,zgsm*re

openw,1,ofile

trace_small,xgsm,ygsm,zgsm,dir,rend,1.,nmax,np,iopt,parmod,extern,xf,yf,zf,xx,yy,zz,m,fac
;trace,xgsm,ygsm,zgsm,dir,rend,1.,nmax,500,iopt,parmod,extern,xf,yf,zf,xx,yy,zz,m


close,/all
print, '*** normal end ***'
plot,xx,zz
dist0=0.0d
distr0=0.0d
rr0=0.0d
num=n_elements(xx)
rr=dblarr(num)
dist=dblarr(num)
distr=dblarr(num)
for i=1,num-1 do begin
  rr(i)=sqrt(xx(i)^2+yy(i)^2+zz(i)^2)*re
  dist(i)=dist0+sqrt((xx(i)-xx(i-1))^2+(yy(i)-yy(i-1))^2+(zz(i)-zz(i-1))^2)*re
  distr(i)=distr0+rr(i)-rr(i-1)
;  print, dist(i),rr(i),distr(i)
  if rr0 ge rr(i) then begin
    n=i-1
    goto, nextstep
  endif
  dist0=dist(i)
  distr0=distr(i)
  rr0=rr(i)

endfor

nextstep:
print,'distance along field line between alt=',alts,'(km) and equator is ',dist(i),'(km) when glat=',geolat,'(deg) and glon=',geolon,'(deg)

end
