pro geomag_trace_sub,lat0,lon0,alts,alte,dir,nmax,np,fac,iyr,mon,day,ihr,imin,isec,geolatf,geolonf,altf,invlat

;progam geomag_trace
;  for caluclating the geomagnetic field tracing by
;  using the IGRF model based on GEOPACK.
;
;          2004.Sep.16 by TS


     COMMON GEOPACK, ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,SFI,CFI,SPS,$
       CPS,SHI,CHI,HI,PSI,XMUT,A11,A21,A31,A12,A22,A32,A13,A23,A33,DS3,$
       K,IY,CGST,SGST

;close,/all

extern="IGRF"
Re=6371.0

;output file
;ofile='C:\Usr\tsakanoi\Index\trace\200101tra.dat'
; nmax: IGRF harmonic order (0-10)
;nmax=08
; geographical latitude and longitude (deg)
geolat=lat0
geolon=lon0
geolatf=0.0
geolonf=0.0
;   alts starting altitude (km)
;alts=80.0
;   alte ending altitude (km)
;alte=500.0
;   dir=1 tracing anti-para to B, -1 para to B
;dir=1.0
;   step factor for tracing B (set bigger fac for smaller step of tracing distance)
;fac=3000.0
;   date (UT)
;iyr=2001
;mon=1
;day=1
;ihr=0
;imin=0
;isec=0
;   np: max step number for tracing
;np=500

;---------------------

xx=fltarr(np)
yy=fltarr(np)
zz=fltarr(np)


totalday,iyr,mon,day,md,td

recalc_n,iyr,td,mon,day,ihr,imin,isec

iopt=1

colat=(90.0-geolat)*0.01745329
xlon=geolon*0.01745329

rstr=0.0
rend=0.0
rstr=(Re+alts)/Re
rend=(Re+alte)/Re

sphcar,rstr,colat,xlon,xgeo,ygeo,zgeo,1

geogsm,xgeo,ygeo,zgeo,xgsm,ygsm,zgsm,1

;geomag, XGEO,YGEO,ZGEO,XMAG,YMAG,ZMAG,1,IYR

;print, 'xgsm,ygsm,zgsm(km)=',xgsm*re,ygsm*re,zgsm*re

;openw,1,ofile

trace_small,xgsm,ygsm,zgsm,dir,rend,1.,nmax,np,iopt,parmod,extern,xf,yf,zf,xx,yy,zz,m,fac
;trace,xgsm,ygsm,zgsm,dir,rend,1.,nmax,500,iopt,parmod,extern,xf,yf,zf,xx,yy,zz,m


geogsm,xgeof,ygeof,zgeof,xf,yf,zf,-1
sphcar,rf,colatf,xlonf,xgeof,ygeof,zgeof,-1

geolatf=90.0-colatf/0.01745329
if geolatf gt 90 then geolatf=geolatf-180
geolonf=xlon/0.01745349
altf=rf*re-re

print, 'geolats,geolons,alts,geolatf,geolonf,alte=',geolat,geolon,alts,geolatf,geolonf,altf


colat=(90.0-geolat)*0.01745329
xlon=geolon*0.01745329

rstr=0.0
rend=0.0
rstr=(Re+alts)/Re
rend=(Re+50000000)/Re

sphcar,rstr,colat,xlon,xgeo,ygeo,zgeo,1

geogsm,xgeo,ygeo,zgeo,xgsm,ygsm,zgsm,1
;print, 'xgsm,ygsm,zgsm(km)=',xgsm*re,ygsm*re,zgsm*re

dir=dir*(-1)
trace_small_inv,xgsm,ygsm,zgsm,dir,rend,1.,nmax,np,iopt,parmod,extern,xf,yf,zf,xx,yy,zz,m,5

lval=max(sqrt(xx^2+yy^2+zz^2))

invlat=0.0
invlat=acos(1.0/sqrt(lval))*180.0/3.14

;print,'invlat',invlat

;close,1
;print, '*** normal end ***'
;plot,xx,zz


end
