pro gse_to_gei,idate,itime,axgse,aygse,azgse,xgei,ygei,zgei

    dtor = acos(-1.0)/180.0

	vsun=dblarr(3)
	xgse=dblarr(3)
	ygse=dblarr(3)
	zgse=dblarr(3)

    zgse(*)=[0.0,-0.3978,0.9175]

    i=1
    iyr=fix(idate/10000)
    mon=fix(idate/100-iyr*100)
    day=fix(idate-iyr*10000-mon*100)
    month=intarr(2,12)
    month(0,*)=[0,31,59,90,120,151,181,212,243,273,304,334]
    month(1,*)=[0,31,60,91,121,152,182,213,244,274,305,335]
    if ((iyr mod 4) eq 0) then i=2
	in=day+month(i-1,mon-1)
    h=fix(itime/10000)
    m=fix(itime/100-h*100)
    s=fix(itime-h*10000-m*100)

; /** solar vector in GEI coordinate **/
 ;/**slat and slon eq solar lat and lon in GEI **/

	solar_pos, iyr,in,h*60.*60.+m*60.+s, gst, slong, slon, slat, S

	tet = slat*dtor
	fai = slon*dtor

	sdlat=fix(slat)
	smlat=fix((slat-sdlat)*60)
	sslat=slat*60.0*60.0-sdlat*60.0*60.0-smlat*60.0
	shlon=fix(slon/360*24)
	smlon=fix((slon/360*24-shlon)*60)
	sslon=(slon/360*24)*60.0*60.0-shlon*60.0*60.0-smlon*60.0
	;print,'solar lat=',sdlat,'d',smlat,'m',sslat,'s'
	;print,'solar lon=',shlon,'h',smlon,'m',sslon,'s'

	xgse[0]=cos(tet)*cos(fai)
	xgse[1]=cos(tet)*sin(fai)
	xgse[2]=sin(tet)

	ygse[0] = zgse[1]*xgse[2] - zgse[2]*xgse[1]
	ygse[1] = zgse[2]*xgse[0] - zgse[0]*xgse[2]
	ygse[2] = zgse[0]*xgse[1] - zgse[1]*xgse[0]

;change gse(x,y,z) to gei(x,y,z)
xgei=xgse[0]*axgse+ygse[0]*aygse+zgse[0]*azgse
ygei=xgse[1]*axgse+ygse[1]*aygse+zgse[1]*azgse
zgei=xgse[2]*axgse+ygse[2]*aygse+zgse[2]*azgse
stop
end