pro height_emi



;filename
date='20010101'
infile1='C:\Usr\tsakanoi\Index\trace\'
;emifile1='emission20010101'
;emifile1='emi_20010101_10000'
emifile1='emi_20010101_500'

emifile=infile1+emifile1+'.dat'
psdir='C:\Usr\tsakanoi\Index\ps\'



;read file

read_emifile_o,emifile,c_energy,e_flux,dalt,VE427,VE557,VE630,VEN21PG,VE844
;read_emifile,emifile,c_energy,e_flux,te_flux,dalt,VE427,VE557,VE630,VEN21PG,VE844
;

SET_PLOT, 'WIN'
LOADCT, 12
blue=7.0*255.0/16.0
gre=3.0*255.0/16.0
red1=13.0*255.0/16.0
red2=10.0*255.0/16.0
;
!P.Multi=[0,2,2]
  Window, 1, xsize=900,ysize=700
  device, retain=2, decomposed=0
plot,VE427,dalt,pos=[0.3,0.1,0.8,0.9],$
linestyle=1,$
charsize=1.5,thick=2,xrange=[10.0d^(-2),10.0d^(4)],/xlog,/NODATA
oplot,VE427,dalt,color=blue,thick=4
oplot,VE557,dalt,color=gre,thick=4
oplot,VEN21PG,dalt,linestyle=3,color=red1,thick=4
oplot,VE630,dalt,color=red1


;LOADCT, 39
;stretch,0,255



set_plot,'PS'
DEVICE, BITS_PER_PIXEL=8, /COLOR, $
; FILENAME=psdir1+keofname+'.ps', /Portrait, $
FILENAME=psdir+emifile1+'.ps', /Portrait, $
XSIZE=20.0, YSIZE=27.0, XOFFSET=0.0, YOFFSET=0

LOADCT, 12
blue=7.0*255.0/16.0
gre=3.0*255.0/16.0
red1=13.0*255.0/16.0
red2=10.0*255.0/16.0
;
!P.Multi=[0,2,2]

plot,VE427,dalt,pos=[0.3,0.1,0.8,0.9],$
linestyle=1,$
charsize=1.0,thick=6,xrange=[10.0d^(-2),10.0d^(4)],/xlog,/NODATA,$
xtitle= 'Volume emission rate[/cm3/sec]' ,ytitle='Height [km]',$
title=c_energy+'   '+e_flux, xthick=5,ythick=5,charthick=5
oplot,VE427,dalt,color=blue,thick=6
oplot,VE557,dalt,color=gre,thick=6
oplot,VEN21PG,dalt,linestyle=3,color=red1,thick=6
oplot,VE630,dalt,color=red1,thick=6


DEVICE, /CLOSE

print,'noramal end'






end



PRO read_emifile_o,emifile,c_energy,e_flux,dalt,VE427,VE557,VE630,VEN21PG,VE844


 header=' '
 temp0=0.0d
 temp1=0.0d
 temp2=0.0d
 temp3=0.0d
 temp4=0.0d
 temp5=0.0d


c_energy=''
e_flux=''
dalt=dblarr(100)
VE427=dblarr(100)
VE557=dblarr(100)
VE630=dblarr(100)
VEN21PG=dblarr(100)
VE844=dblarr(100)



;read file
 unit=1
 close,unit
 openr, unit, emifile

;skip
 readf, unit,header
 print,header
 ;average enegy & energy flux

readf, unit,header
c_energy=strmid(header,35,15)

readf, unit,header
e_flux=strmid(header,35,25)


;skip

readf, unit,header
print,header

;read v emi rate

 for i=0,99 do begin
     readf, unit,temp0,temp1,temp2,temp3,temp4,temp5
     dalt(i)=temp0
     VE427(i)=temp1
     VE557(i)=temp2
     VE630(i)=temp3
     VEN21PG(i)=temp4
     VE844(i)=temp5
 endfor

close, unit


end