     pro igrf_geopack,IY,NM,R,T,F,BR,BT,BF
;c
;C     CALCULATES COMPONENTS OF THE MAIN (INTERNAL) GEOMAGNETIC FIELD IN SPHERICAL
;C     GEOGRAPHICAL COORDINATE SYSTEM, USING IAGA INTERNATIONAL GEOMAGNETIC REFERENCE
;C     MODEL COEFFICIENTS (e.g., http://www.ngdc.noaa.gov/IAGA/wg8/igrf2000.html)
;C
;C     UPDATING THE COEFFICIENTS TO A GIVEN EPOCH IS MADE AUTOMATICALLY UPON THE FIRST
;C     CALL AND AFTER EVERY CHANGE OF THE PARAMETER IY.
;C
;C-----INPUT PARAMETERS:
;C
;C     IY  -  YEAR NUMBER (FOUR-DIGIT; 1965 &LE IY &LE 2005)
;C     NM  -  HIGHEST ORDER OF SPHERICAL HARMONICS IN THE SCALAR POTENTIAL (NM &LE 10)
;C     R,T,F -  SPHERICAL COORDINATES (RADIUS R IN UNITS RE=6371.2 KM, GEOGRAPHIC
;C                COLATITUDE  T  AND LONGITUDE  F  IN RADIANS)
;C
;C-----OUTPUT PARAMETERS:
;C
;C     BR,BT,BF - SPHERICAL COMPONENTS OF THE MAIN GEOMAGNETIC FIELD IN NANOTESLA
;C
;C     LAST MODIFICATION:  JANUARY 5, 2001.
;C     THE CODE WAS MODIFIED TO ACCEPT DATES THROUGH 2005.
;C     IT HAS ALSO BEEN SLIGHTLY SIMPLIFIED BY TAKING OUT SOME REDUNDANT STATEMENTS,
;C     AND A "SAVE" STATEMENT WAS ADDED, TO AVOID POTENTIAL PROBLEMS WITH SOME
;C     FORTRAN COMPILERS.
;c
;C     WRITTEN BY: N. A. TSYGANENKO
;C
;      SAVE MA,IYR,IPR
;C
      A=fltarr(11)
      B=fltarr(11)
      G=fltarr(66)
      H=fltarr(66)
      REC=fltarr(66)

      BR=0.0
      BT=0.0
      BF=0.0
      DT=0.0
      F2=0.0
      F1=0.0
      S=0.0
      P=0.0
      AA=0.0
      PP=0.0
      D=0.0
      BBR=0.0
      BBF=0.0
      U=0.0
      CF=0.0
      SF=0.0
      C=0.0
      W=0.0
      X=0.0
      Y=0.0
      Z=0.0
      Q=0.0
      BI=0.0
      P2=0.0
      D2=0.0
      AN=0.0
      E=0.0
      HH=0.0
      BBT=0.0
      QQ=0.0
      XK=0.0
      DP=0.0
      PM=0.0


;C
      coef,g65,h65,g70,h70,g75,h75,g80,h80,g95,h95,g00,h00,dg00,dh00
;C
      MA=0
      IYR=0
      IPR=0

      IF (MA NE 1) then GOTO, lavel10
      IF (IY NE IYR) then GOTO, lavel30
      GOTO, lavel130
lavel10:
      MA=1
;C
      for N=1,11 do begin
         N2=2*N-1
         N2=N2*(N2-2)
         for M=1,N do begin
            MN=N*(N-1)/2+M
;            print, mn
            REC(MN-1)=FLOAT((N-M)*(N+M-2))/FLOAT(N2)
         endfor
       endfor
;C
lavel30:
      IYR=IY
      IF (IYR LT 1965) then IYR=1965
      IF (IYR GT 2005) then IYR=2005
      IF (IY NE IYR AND IPR EQ 0) then print, $
      'IGRF WARNS:**** YEAR IS OUT OF INTERVAL 1965-2005: IY =',IY,$
      ',        CALCULATIONS WILL BE DONE FOR IYR =',IYR,' ****'

      IF (IYR NE IY) then IPR=1
      IF (IYR LT 1970) then GOTO, lavel50
;  		!INTERPOLATE BETWEEN 1965 - 1970
      IF (IYR LT 1975) then GOTO, lavel60
;  		!INTERPOLATE BETWEEN 1970 - 1975
      IF (IYR LT 1980) then GOTO, lavel70
      ;		!INTERPOLATE BETWEEN 1975 - 1980
      IF (IYR LT 1985) then GOTO, lavel80
      ;		!INTERPOLATE BETWEEN 1980 - 1985
      IF (IYR LT 1990) then GOTO, lavel90
      ;		!INTERPOLATE BETWEEN 1985 - 1990
      IF (IYR LT 1995) then GOTO, lavel100
      ;		!INTERPOLATE BETWEEN 1990 - 1995
      IF (IYR LT 2000) then GOTO, lavel110
      ;         !INTERPOLATE BETWEEN 1995 - 2000
;C
;C       EXTRAPOLATE BEYOND 2000:
;C
      DT=FLOAT(IYR)-2000.
      for N=0,65 do begin
         G(N)=G00(N)
         H(N)=H00(N)
         IF (N GT 44) then GOTO, lavel40
         G(N)=G(N)+DG00(N)*DT
         H(N)=H(N)+DH00(N)*DT
lavel40:
      endfor
      GOTO, lavel300
;C
;C       INTERPOLATE BETWEEEN 1965 - 1970:
;C
lavel50:
      F2=(IYR-1965)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G65(N)*F1+G70(N)*F2
         H(N)=H65(N)*F1+H70(N)*F2
      endfor
      GOTO, lavel300
;C
;C       INTERPOLATE BETWEEN 1970 - 1975:
;C
lavel60:
      F2=(IYR-1970)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G70(N)*F1+G75(N)*F2
         H(N)=H70(N)*F1+H75(N)*F2
      endfor
      GOTO, lavel300
;C
;C       INTERPOLATE BETWEEN 1975 - 1980:
;C
lavel70:
      F2=(IYR-1975)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G75(N)*F1+G80(N)*F2
         H(N)=H75(N)*F1+H80(N)*F2
      endfor
      GOTO, lavel300
;C
;C       INTERPOLATE BETWEEN 1980 - 1985:
;C
lavel80:
      F2=(IYR-1980)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G80(N)*F1+G85(N)*F2
         H(N)=H80(N)*F1+H85(N)*F2
      endfor
      GOTO, lavel300
;C
;C       INTERPOLATE BETWEEN 1985 - 1990:
;C
lavel90:
      F2=(IYR-1985)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G85(N)*F1+G90(N)*F2
         H(N)=H85(N)*F1+H90(N)*F2
      endfor
      GOTO, lavel300
;C
;C       INTERPOLATE BETWEEN 1990 - 1995:
;C
lavel100:
      F2=(IYR-1990)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G90(N)*F1+G95(N)*F2
         H(N)=H90(N)*F1+H95(N)*F2
      endfor
     GOTO, lavel300
;C
;C       INTERPOLATE BETWEEN 1995 - 2000:
;C
lavel110:
      F2=(IYR-1995)/5.
      F1=1.-F2
      for N=0,65 do begin
         G(N)=G95(N)*F1+G00(N)*F2
         H(N)=H95(N)*F1+H00(N)*F2
      endfor
      GOTO, lavel300
;C
;C   COEFFICIENTS FOR A GIVEN YEAR HAVE BEEN CALCULATED; NOW MULTIPLY
;C   THEM BY SCHMIDT NORMALIZATION FACTORS:
;C
lavel300:
      S=1.
      for N=2,11 do begin
         MN=N*(N-1)/2+1
;         print, mn
         S=S*FLOAT(2*N-3)/FLOAT(N-1)
         G(MN-1)=G(MN-1)*S
         H(MN-1)=H(MN-1)*S
         P=S
         for M=2,N do begin
            AA=1.
            IF (M EQ 2) then AA=2.
            P=P*SQRT(AA*FLOAT(N-M+1)/FLOAT(N+M-2))
            MNN=MN+M-1
            G(MNN-1)=G(MNN-1)*P
            H(MNN-1)=H(MNN-1)*P
         endfor
      endfor
;C
;C     NOW CALCULATE THE FIELD COMPONENTS
;C     (IN CASE OF MULTIPLE INVOCATIONS WITH THE SAME VALUES OF IY AND NM,
;C      CALCULATIONS START RIGHT HERE):
;C
lavel130:
      PP=1./R
      P=PP

      K=NM+1
      for N=1,K do begin
         P=P*PP
         A(N-1)=P
         B(N-1)=P*N
      endfor
      P=1.
      D=0.
      BBR=0.
      BBT=0.
      BBF=0.
      U=T
      CF=COS(F)
      SF=SIN(F)
      C=COS(U)
      S=SIN(U)
      for M=1,K do begin
         IF (M EQ 1) then GOTO, lavel160
         MM=M-1
         W=X
         X=W*CF+Y*SF
         Y=Y*CF-W*SF
         GOTO, lavel170
lavel160:
         X=0.
         Y=1.
lavel170:
         Q=P
         Z=D
         BI=0.
         P2=0.
         D2=0.
         for N=M,K do begin
            AN=A(N-1)
            MN=N*(N-1)/2+M
            E=G(MN-1)
            HH=H(MN-1)
            W=E*Y+HH*X
            BBR=BBR+B(N-1)*W*Q
            BBT=BBT-AN*W*Z
            IF (M EQ 1) then GOTO, lavel180
            QQ=Q
            IF (S LT 1.E-5) then QQ=Z
            BI=BI+AN*(E*X-HH*Y)*QQ
lavel180:
            XK=REC(MN-1)
            DP=C*Z-S*Q-XK*D2
            PM=C*Q-XK*P2
            D2=Z
            P2=Q
            Z=DP
            Q=PM
         endfor
         D=S*D+C*P
         P=S*P
         IF (M EQ 1) then GOTO, lavel200
         BI=BI*MM
         BBF=BBF+BI
lavel200:
      endfor
;C
      BR=BBR
      BT=BBT
      IF (S LT 1.E-5) then GOTO, lavel210
      BF=BBF/S
      RETURN
lavel210:
      IF (C LT 0.) then BBF=-BBF
      BF=BBF

      RETURN
;C
      END
