macfov_det_ino,fnum,bin,orbsatglat2,orbsatglon2,orbsatalt2,q1c,q2c,q3c,q4c,ymd,time,ich1,

datanum=fnum
pai=3.14159265358979d
ich=ich1-1

satglat1=dblarr(datanum)
satglon1=dblarr(datanum)
glat1=dblarr(bin,bin,datanum)
glon1=dblarr(bin,bin,datanum)
galt1=dblarr(bin,bin,datanum)
mlt1=dblarr(bin,bin,datanum)
fplat1=dblarr(datanum)
fplon1=dblarr(datanum)

for j=0,datanum-1 do begin
  if j/10d eq fix(j/10d) then begin
    ;rsat=re+orbsatalt2(j)
    ;satteta=(90-orbsatglat2(j))/360d*2*pai
    ;satphi=orbsatglon2(j)/360d*2*pai
    ;sphcar,rsat,satteta,satphi,satxgeo,satygeo,satzgeo,1
    ng=rl/sqrt(1-e2*(sin(rs))^2)

    satxgeo=(ng+orbsatalt2(j))*cos(orbsatglat2(j)/360d*2*pai)*cos(orbsatglon2(j)/360d*2*pai)
    satygeo=(ng+orbsatalt2(j))*cos(orbsatglat2(j)/360d*2*pai)*sin(orbsatglon2(j)/360d*2*pai)
    satzgeo=(ng*(1-e2)+orbsatalt2(j))*sin(orbsatglat2(j)/360d*2*pai)
    q1=q1c(j)
    q2=q2c(j)
    q3=q3c(j)
    q4=q4c(j)
    print,j,q1,q2,q3,q4,orbsatglat2(j)
    I=dblarr(3)
    X=dblarr(3)
    Y=dblarr(3)
    Z=dblarr(3)
    M=dblarr(3)

    geo_to_gei,ymd(j),time(j),satxgeo,satygeo,satzgeo,satxgei,satygei,satzgei

    I(0)=satxgei
    I(1)=satygei
    I(2)=satzgei

    X(0)=1.-2d*(q2*q2+q3*q3)
    X(1)=2d*(q1*q2+q4*q3)
    X(2)=2d*(q1*q3-q4*q2)

    Y(0)=2d*(q1*q2-q4*q3)
    Y(1)=1.-2d*(q1*q1+q3*q3)
    Y(2)=2d*(q2*q3+q4*q1)
;print,x
;print,y

    Z(0)=X(1)*Y(2)-X(2)*Y(1)
    Z(1)=X(2)*Y(0)-X(0)*Y(2)
    Z(2)=X(0)*Y(1)-X(1)*Y(0)
;calculate MAC vector
    l=sqrt(((X(0)+Z(0))/2)^2+((X(1)+Z(1))/2)^2+((X(2)+Z(2))/2)^2)
    M(0)=(X(0)+Z(0))/2/l
    M(1)=(X(1)+Z(1))/2/l
    M(2)=(X(2)+Z(2))/2/l
;print,M
;calcutrate pixel vector in satellite coordinate
    macfovx=dblarr(bin+1,bin+1)
    macfovy=dblarr(bin+1,bin+1)
    macfovz=dblarr(bin+1,bin+1)

    macfovx1=dblarr(bin+1,bin+1)
    macfovy1=dblarr(bin+1,bin+1)
    macfovz1=dblarr(bin+1,bin+1)

    macfovgeix=dblarr(bin+1,bin+1)
    macfovgeiy=dblarr(bin+1,bin+1)
    macfovgeiz=dblarr(bin+1,bin+1)

    for l=0,bin do begin
      for l2=0,bin do begin

        teta1=atan(3302.4-12.9*(l+1)*512/res,50000.0)
        teta2=atan(3302.4-12.9*(l2-1)*512/res,50000.0)

        macfovx1(l2,l)=sqrt(1/(1+(tan(teta1))^2+(tan(teta2))^2))
        macfovy1(l2,l)=macfovx1(l2,l)*tan(teta2)
        macfovz1(l2,l)=macfovx1(l2,l)*tan(teta1)

;CH1 tetaoffset=4 phioffset=18
;CH2 tetaoffset=46,phioffset=17
;CH3 tetaoffset=21 phioffset=-19
        if ich eq 1 then begin
          tetaoffset1=4
          phioffset1=18
        endif else if ich eq 2 then begin
          tetaoffset1=46
          phioffset1=17
        endif else if ich eq 3 then begin
          tetaoffset1=21
          phioffset1=-19
        endif

        tetam=(45.0+0.0148437*tetaoffset1)/180d*pai
        phim=(0.0148437*phioffset1)/180d*pai

        MX=[sin(tetam)*cos(phim),sin(tetam)*sin(phim),cos(tetam)]
        MY=[-sin(phim),cos(phim),0]
        MZ=[-cos(tetam)*cos(phim),-cos(tetam)*sin(phim),sin(tetam)]
        macfovx(l2,l)=MX(0)*macfovx1(l2,l)+MY(0)*macfovy1(l2,l)+MZ(0)*macfovz1(l2,l)
        macfovy(l2,l)=MX(1)*macfovx1(l2,l)+MY(1)*macfovy1(l2,l)+MZ(1)*macfovz1(l2,l)
        macfovz(l2,l)=MX(2)*macfovx1(l2,l)+MY(2)*macfovy1(l2,l)+MZ(2)*macfovz1(l2,l)

      endfor
    endfor
;----------------------------------------------------
;transform stellite coordinate to gei coordinate

    for i2=0,bin-1 do begin
      for i3=0,bin-1 do begin

        macfovgeix(i2,i3)=X(0)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(0)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(0)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
        macfovgeiy(i2,i3)=X(1)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(1)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(1)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
        macfovgeiz(i2,i3)=X(2)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(2)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(2)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
      endfor
    endfor


;=========================================
    for l=0,bin-1 do begin
      for k=0,bin-1 do begin

        mx=macfovgeix(k,l)
        my=macfovgeiy(k,l)
        mz=macfovgeiz(k,l)

;b=I(0)*mx+I(1)*my+I(2)*mz
;c=2*re*(orbsatalt2(j)-footalt)+(orbsatalt2(j)^2+footalt^2)

        c1=mx^2+my^2+(rl/rs)^2*mz^2
        c2=I(0)*mx+I(1)*my+(rl/rs)^2*I(2)*mz
        c3=I(0)^2+I(1)^2+(rl/rs)^2*I(2)^2-rl^2
        if c2^2-c1*c3 lt 0 then begin
          print,"Error.... "
          glat1(k,l,j)=0
          glon1(k,l,j)=0
          goto,step6
        endif

        a1=(-c2+sqrt(c2^2-c1*c3))/c1
        a2=(-c2-sqrt(c2^2-c1*c3))/c1

        xf1=I(0)+a1*mx
        yf1=I(1)+a1*my
        zf1=I(2)+a1*mz
        dis1=(xf1-I(0))^2+(yf1-I(1))^2+(zf1-I(2))^2
        xf2=I(0)+a2*mx
        yf2=I(1)+a2*my
        zf2=I(2)+a2*mz
        dis2=(xf2-I(0))^2+(yf2-I(1))^2+(zf2-I(2))^2
        if dis1 gt dis2 then begin
          xf1=xf2
          yf1=yf2
          zf1=zf2
        endif


;------------------------------------
;transform gei to geo
        gei_to_geo,ymd(j),time(j),xf1,yf1,zf1,xg1,yg1,zg1
;sphcar,r1,teta1,phai1,xg1,yg1,zg1,-1
        glon1(k,l,j)=atan(yg1/xg1)/(2*pai)*360

        pg=sqrt(xg1^2+yg1^2)
        rg=sqrt(xg1^2+yg1^2+zg1^2)

        mu=atan(zg1/pg*((1-fg)+e2*rl/rg))

        glat1(k,l,j)=atan((zg1*(1-fg)+e2*rl*(sin(mu))^3)/(1-fg)/(pg-e2*rl*(cos(mu))^3))/(2*pai)*360
;print,"mac fov center is",k,l,glat1(l,j),glon1(l,j)
step6:
      endfor
    endfor
;print,j,glat1(bin/2,bin/2,j)

;=============================================================================
  endif
endfor
step10:


satglat2=dblarr(datanum)
satglon2=dblarr(datanum)

for k=0,datanum-1 do begin
satglat2(k)=orbsatglat2(k)
satglon2(k)=orbsatglon2(k)
endfor

return

end
