pro plot_indexdata_on_map_L1

;
;   INDEX
;   satxgeo,satygeo,satzgeo
;   idate1=yyyymmdd
;   itime1=hhmmss
;   q parameters q1,q2,q3,q4

close,/all

mapdatafile = 'C:\RSI\IDL56\lib\gshhs_1.3\gshhs_h.b'
citydata='C:\Usr\tsakanoi\Index\idl\ino_program\plot_indexdata_on_map\citydata.dat'
psdir='c:\usr\tsakanoi\index\ps\'

Re=6371.0d
pai=3.141592d
rl=6378.137
rs=6356.752
fg=1/298.25722
e2=fg*(2-fg)

macfov=7.557566d

footalt=0
;ch1 ch=0,ch2,ch=1,ch3 ch=2
ch=2
attdatanum=10000
datayear='2005';yyyy
datamonth='12';mm
datadate='2209';ddhhmm
datasel='a\'
datadir='D:\Usr\tsakanoi\Index\Darts\Level-1\'+datayear+'\'+datamonth+'\'+datasel
cd,datadir
datafname=findfile('RE_MAC3_M0_*'+datadate+'*.L1')
obsdata=datadir+datafname

attdir='D:\Usr\tsakanoi\Index\Darts\Level-1\'+datayear+'\'+datamonth+'\'
;attdir=datadir
cd,attdir
orbitdata=findfile('RE_orbit_*.L1')
orbitfile=orbitdata(max(where(strmid(orbitdata,9,8) le datayear+datamonth+strmid(datadate,0,2))))
cd,attdir
attfile=findfile('RE_ATT_'+datayear+datamonth+strmid(datadate,0,2)+'*.L1')
orbdata=attdir+orbitfile
attdata=attdir+attfile
qfiletime=0
imode=long(strmid(datafname,9,1))
;stop

dataintarval=8000
if imode eq 0 then begin
res=64l
nmode='S'
endif else if imode eq 1 then begin
res=64l
nmode='H'
endif else if imode eq 2 then begin
res=512l
nmode='IH'
endif else if imode eq 3 then begin
res=128l
nmode='IM'
endif
bin=res
ich=long(strmid(datafname,6,1))

;obsdata=FINDFILE(datadir+'IDX_MAC3_M0_*.L1')
;attdata=FINDFILE(datadir+'IDX_ATT_200512.dat')
;orbdata=FINDFILE(datadir+'IDX_orbit_200512160000.L1')



;------datafile------





;read MAC data and pick up one channel data and ti-------

read_MAC_L1_data,obsdata,res,datanum,date2,time2,ds2,totaldata3
;datanum=30
totaldata2=lonarr(res,res,datanum)

totaldata2(*,*,*)=totaldata3(*,*,0:datanum-1)


colordata=dblarr(res,res,datanum)

;===================================================

;===================================================




;-----------------------------------------------------

colordata(*,*,*)=fix(10d^(alog10(75d)+(alog10(4096d)-alog10(75d))/256d*double(totaldata2(*,*,*))))

minlight=min(colordata)
maxlight=max(colordata)
;=========================
