pro make_map

Re=6371.0d
pai=3.141592d

;INPUT parameter
;   INDEX position geographic coordinate
;   satxgeo,satygeo,satzgeo
;   idate=yyyymmdd
;   itime=hhmmss
;   q parameters q1,q2,q3,q4



macfov=7.6
bin=64
pass='05110406SVL'
orbitdata='D:\INDEX\orbit\orb051105.prn'
outdata='D:\INDEX\map\latlon051105.txt'

satglat1=dblarr(1000)
satglon1=dblarr(1000)
fnum=51
glat1=dblarr(bin,fnum)
glon1=dblarr(bin,fnum)
glat2=dblarr(bin,fnum)
glon2=dblarr(bin,fnum)
glat3=dblarr(bin,fnum)
glon3=dblarr(bin,fnum)
glat4=dblarr(bin,fnum)
glon4=dblarr(bin,fnum)

fplat1=dblarr(1000)
fplon1=dblarr(1000)

openr,10,orbitdata
openw,30,outdata
printf,30,'time satlat satlon (0,0) (0,64) (64,0) (64,64)'
for j=0,50 do begin
data=''
datanum=j
if eof(10) then goto,step10
readf,10,idate,itime,satxgeo,satygeo,satzgeo,q1,q2,q3,q4
I=dblarr(3)
X=dblarr(3)
Y=dblarr(3)
Z=dblarr(3)
M=dblarr(3)

geo_to_gei,idate,itime,satxgeo,satygeo,satzgeo,satxgei,satygei,satzgei

I(0)=satxgei
I(1)=satygei
I(2)=satzgei

;q1=0.579576d
;q2=0.431768d
;q3=-0.688727d
;q4=-0.057598d

X(0)=1.-2d*(q2*q2+q3*q3)
X(1)=2d*(q1*q2+q4*q3)
X(2)=2d*(q1*q3-q4*q2)

Y(0)=2d*(q1*q2-q4*q3)
Y(1)=1.-2d*(q1*q1+q3*q3)
Y(2)=2d*(q2*q3+q4*q1)
print,x
print,y
;Z(0)=2d*(q1*q3+q4*q2)
;Z(1)=2d*(q2*q3-q4*q1)
;Z(2)=1.-2d*(q1*q1+q2*q2)

;09201920
;X(0)=0.03480222
;X(1)=0.4734869577
;X(2)=0.8801130076
;Y(0)=0.0194377299
;Y(1)=0.8801592125
;Y(2)=-0.474280439
;0830
;X(0)=0.1435530
;X(1)=0.6737339
;X(2)=-0.7248966
;Y(0)=-0.3742647
;Y(1)=-0.6411234
;Y(2)=-0.66998999

;X(0)=-0.0429358809139557
;X(1)=-0.0370007130740747
;X(2)=-0.998392436550955
;Y(0)=-0.103090220300919
;Y(1)=-0.993815701217518
;Y(2)=0.0412644943243125
;09161759


Z(0)=X(1)*Y(2)-X(2)*Y(1)
Z(1)=X(2)*Y(0)-X(0)*Y(2)
Z(2)=X(0)*Y(1)-X(1)*Y(0)
;calculate MAC vector
l=sqrt(((X(0)+Z(0))/2)^2+((X(1)+Z(1))/2)^2+((X(2)+Z(2))/2)^2)
M(0)=(X(0)+Z(0))/2/l
M(1)=(X(1)+Z(1))/2/l
M(2)=(X(2)+Z(2))/2/l
print,M
;calcutrate pixel vector in satellite coordinate
macfovx=dblarr(bin,bin)
macfovy=dblarr(bin,bin)
macfovz=dblarr(bin,bin)
macfovgeix=dblarr(bin,bin)
macfovgeiy=dblarr(bin,bin)
macfovgeiz=dblarr(bin,bin)
for l=0,bin-1 do begin
k=0
macfovx(k,l)=1
macfovy(k,l)=tan((3.8-7.6/bin*k)/180d*pai)
macfovz(k,l)=tan((45+3.8-7.6/bin*l)/180d*pai)
k=63
macfovx(k,l)=1
macfovy(k,l)=tan((3.8-7.6/bin*k)/180d*pai)
macfovz(k,l)=tan((45+3.8-7.6/bin*l)/180d*pai)
endfor
for k=0,bin-1 do begin
l=0
macfovx(k,l)=1
macfovy(k,l)=tan((3.8-7.6/bin*k)/180d*pai)
macfovz(k,l)=tan((45+3.8-7.6/bin*l)/180d*pai)
l=63
macfovx(k,l)=1
macfovy(k,l)=tan((3.8-7.6/bin*k)/180d*pai)
macfovz(k,l)=tan((45+3.8-7.6/bin*l)/180d*pai)
endfor
;----------------------------------------------------
;transform stellite coordinate to gei coordinate
for i2=0,bin-1 do begin
for i3=0,bin-1 do begin
macfovgeix(i2,i3)=X(0)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(0)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(0)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
macfovgeiy(i2,i3)=X(1)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(1)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(1)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
macfovgeiz(i2,i3)=X(2)/sqrt(X(0)^2+X(1)^2+X(2)^2)*macfovx(i2,i3)+Y(2)/sqrt(Y(0)^2+Y(1)^2+Y(2)^2)*macfovy(i2,i3)+Z(2)/sqrt(Z(0)^2+Z(1)^2+Z(2)^2)*macfovz(i2,i3)
endfor
endfor
;sphcar,re+sheight,(90-gslat)/180.*pai,gslon/180*pai,satxgeo,satygeo,satzgeo,1
;geo_to_gei,idate,itime,satxgeo,satygeo,satzgeo,satxgei,satygei,satzgei

gei_to_geo,idate,itime,I(0),I(1),I(2),satxgeo,satygeo,satzgeo
sphcar,satr,satteta,satphai,satxgeo,satygeo,satzgeo,-1
satglon1(j)=satphai/(2*pai)*360
if satteta ge 0 then begin
satglat1(j)=90-satteta/(2*pai)*360
endif
if satteta lt 0 then begin
satglat1(j)=-90-satteta/(2*pai)*360
endif
printf,30,itime,satglat1(j),satglon1(j)
;print,"INDEX position (geolat,lon)=",satglat1(j),satglon1(j)
;print,"INDEX height=",sqrt(I(0)^2+I(1)^2+I(2)^2)-re

;=========================================
;=========================================
;=========================================
;=========================================
for l=0,bin-1 do begin
k=0
xf1=I(0)
yf1=I(1)
zf1=I(2)
sh=sqrt(I(0)^2+I(1)^2+I(2)^2)
r1=sqrt(I(0)^2+I(1)^2+I(2)^2)
step1:
xf1=xf1+macfovgeix(k,l)
yf1=yf1+macfovgeiy(k,l)
zf1=zf1+macfovgeiz(k,l)
p1=sqrt(xf1^2+yf1^2+zf1^2)

;print,p1-re
if p1 gt r1 then begin
print,"Error.... "
print,p1-re,itime
glat1(l,j)=0
glon1(l,j)=0
goto,step5
endif
r1=sqrt(xf1^2.+yf1^2.+zf1^2.)
if sqrt(xf1^2.+yf1^2.+zf1^2.) gt re then goto, step1
;(xf,yf,zf) is gse coordinate at mac center

;------------------------------------
;transform gei to geo
gei_to_geo,idate,itime,xf1,yf1,zf1,xg1,yg1,zg1
sphcar,r1,teta1,phai1,xg1,yg1,zg1,-1
glon1(l,j)=phai1/(2*pai)*360
if teta1 ge 0 then begin
glat1(l,j)=90-teta1/(2*pai)*360
endif
if teta1 lt 0 then begin
glat1(l,j)=-90-teta1/(2*pai)*360
endif
;print,"mac fov center is",k,l,glat1(l,j),glon1(l,j)
step5:
k=bin-1
xf2=I(0)
yf2=I(1)
zf2=I(2)
sh=sqrt(I(0)^2+I(1)^2+I(2)^2)
r2=sqrt(I(0)^2+I(1)^2+I(2)^2)
step2:
xf2=xf2+macfovgeix(k,l)
yf2=yf2+macfovgeiy(k,l)
zf2=zf2+macfovgeiz(k,l)
p2=sqrt(xf2^2+yf2^2+zf2^2)
;print,p1-re
if p2 gt r2 then begin
print,"Error.... "
print,p2-re,itime
glat2(l,j)=0
glon2(l,j)=0
goto,step6
endif
r2=sqrt(xf2^2.+yf2^2.+zf2^2.)
if sqrt(xf2^2.+yf2^2.+zf2^2.) gt re then goto, step2
;(xf,yf,zf) is gse coordinate at mac center


;------------------------------------
;transform gei to geo
gei_to_geo,idate,itime,xf2,yf2,zf2,xg2,yg2,zg2
sphcar,r2,teta2,phai2,xg2,yg2,zg2,-1
glon2(l,j)=phai2/(2*pai)*360
if teta2 ge 0 then begin
glat2(l,j)=90-teta2/(2*pai)*360
endif
if teta2 lt 0 then begin
glat2(l,j)=-90-teta2/(2*pai)*360
endif
;print,"mac fov center is",k,l,glat2(l,j),glon2(l,j)
step6:
endfor
;=============================================================================
;=============================================================================
;=============================================================================
;=============================================================================
for k=0,bin-1 do begin
l=0
xf3=I(0)
yf3=I(1)
zf3=I(2)
sh=sqrt(I(0)^2+I(1)^2+I(2)^2)
r3=sqrt(I(0)^2+I(1)^2+I(2)^2)
step3:
xf3=xf3+macfovgeix(k,l)
yf3=yf3+macfovgeiy(k,l)
zf3=zf3+macfovgeiz(k,l)
p3=sqrt(xf3^2+yf3^2+zf3^2)
;print,p1-re
if p3 gt r3 then begin
print,"Error.... "
print,p3-re,itime
glat3(l,j)=0
glon3(l,j)=0
goto,step7
endif
r3=sqrt(xf3^2.+yf3^2.+zf3^2.)
if sqrt(xf3^2.+yf3^2.+zf3^2.) gt re then goto, step3
;(xf,yf,zf) is gse coordinate at mac center


;------------------------------------
;transform gei to geo
gei_to_geo,idate,itime,xf3,yf3,zf3,xg3,yg3,zg3
sphcar,r3,teta3,phai3,xg3,yg3,zg3,-1
glon3(k,j)=phai3/(2*pai)*360
if teta3 ge 0 then begin
glat3(k,j)=90-teta3/(2*pai)*360
endif
if teta3 lt 0 then begin
glat3(k,j)=-90-teta3/(2*pai)*360
endif
;print,"mac fov center is",k,l,glat3(k,j),glon3(k,j)


step7:
l=bin-1
xf4=I(0)
yf4=I(1)
zf4=I(2)
sh=sqrt(I(0)^2+I(1)^2+I(2)^2)
r4=sqrt(I(0)^2+I(1)^2+I(2)^2)
step4:
xf4=xf4+macfovgeix(k,l)
yf4=yf4+macfovgeiy(k,l)
zf4=zf4+macfovgeiz(k,l)
p4=sqrt(xf4^2+yf4^2+zf4^2)
;print,p1-re
if p4 gt r4 then begin
print,"Error.... "
print,p4-re,itime
glat4(l,j)=0
glon4(l,j)=0
goto,step8
endif
r4=sqrt(xf4^2.+yf4^2.+zf4^2.)
if sqrt(xf4^2.+yf4^2.+zf4^2.) gt re then goto, step4
;(xf,yf,zf) is gse coordinate at mac center


;------------------------------------
;transform gei to geo
gei_to_geo,idate,itime,xf4,yf4,zf4,xg4,yg4,zg4
sphcar,r4,teta4,phai4,xg4,yg4,zg4,-1
glon4(k,j)=phai4/(2*pai)*360
if teta4 ge 0 then begin
glat4(k,j)=90-teta4/(2*pai)*360
endif
if teta4 lt 0 then begin
glat4(k,j)=-90-teta4/(2*pai)*360
endif
;print,"mac fov center is",k,l,glat4(k,j),glon4(k,j)
step8:
endfor
;================================================
;================================================
;================================================
;================================================
printf,30,glat1(0,j),glon1(0,j),glat1(bin-1,j),glon1(bin-1,j),glat2(0,j),glon2(0,j),$
glat2(bin-1,j),glon2(bin-1,j)
endfor
step10:
close,10
close,30
satglat2=dblarr(datanum)
satglon2=dblarr(datanum)
maclat=dblarr(bin,bin)
maclon=dblarr(bin,bin)
for k=0,datanum-1 do begin
satglat2(k)=satglat1(k)
satglon2(k)=satglon1(k)
endfor
;fplat2(k)=fplat1(k)
;fplon2(k)=fplon1(k)
;-----------------------------------------------------
;define map center point and map limit
cplat=satglat2(long((datanum)/2))
cplon=satglon2(long((datanum)/2))
lowlat=cplat-5
uplat=cplat+5
lowlon=cplon-5
uplon=cplon+5
stop
;=========================
;make map
set_plot,'win'
Window, 1, xsize=900,ysize=700
loadct,39
map_set,satglat2(long((datanum)/2)),satglon2(long((datanum)/2)), /CYLINDRICAL ,/grid,/continents,Limit=[lowlat, lowlon, uplat, uplon]
oplot,satglon2,satglat2,psym=7,symsize=1,color=16711680
oplot,glon1,glat1,psym=3,symsize=4,color=255
oplot,glon2,glat2,psym=3,symsize=4,color=255
oplot,glon3,glat3,psym=3,symsize=4,color=255
oplot,glon4,glat4,psym=3,symsize=4,color=255*256
;oplot,fplon2,fplat2,psym=3,symsize=4,color=65280



set_plot,'ps'
loadct,39
DEVICE, BITS_PER_PIXEL=8,/Landscape,/Color,  $
; FILENAME=psdir1+keofname+'.ps', /Portrait, $
FILENAME='D:/INDEX/map/macpoint_fov051105mer.ps', $
XSIZE=-27.0, YSIZE=-15.0, XOFFSET=18, YOFFSET=1
;Xsize=27,YSIZE=14,XOFFSET=18,YOFFSET=1
ick=8

map_set,satglat2(long((datanum)/2)),satglon2(long((datanum)/2)),/SATELLITE ,/grid,/continents,Limit=[50, 5, 85,45]

;Place a plotting symbol at the location of each city.
blue=2.0*255.0/8
gre=5.0*255.0/8
red1=7.0*255.0/8
oplot,satglon2,satglat2,psym=2,symsize=0.5,color=blue
oplot,glon1,glat1,psym=3,symsize=2,color=red1
oplot,glon2,glat2,psym=3,symsize=2,color=red1
oplot,glon3,glat3,psym=3,symsize=2,color=red1
oplot,glon4,glat4,psym=3,symsize=2,color=gre
;oplot,fplon2,fplat2,psym=3,symsize=4,color=gre

DEVICE, /CLOSE
;-------------------------------------

print,'normal end'
end
