pro sphcar,R,TETA,PHI,X,Y,Z,J
;C
;C   CONVERTS SPHERICAL COORDS INTO CARTESIAN ONES AND VICA VERSA
;C    (TETA AND PHI IN RADIANS).
;C
;C                  J &Gt 0            J &Lt 0
;C-----INPUT:   J,R,TETA,PHI     J,X,Y,Z
;C----OUTPUT:      X,Y,Z        R,TETA,PHI
;C
;C   LAST MOFIFICATION:  JAN 5, 2001 (NO ESSENTIAL CHANGES, BUT
;C                        SOME REDUNDANT STATEMENTS TAKEN OUT)
;C
;C   WRITTEN BY:  N. A. TSYGANENKO
;C
      IF(J GT 0) then GOTO, lavel3
      SQ=X^2+Y^2
      R=SQRT(SQ+Z^2)
      IF (SQ NE 0.) then GOTO, lavel2
      PHI=0.
      IF (Z LT 0.) then GOTO, lavel1
      TETA=0.
      goto, nextstep

lavel1:
      TETA=3.141592654
      goto, nextstep
lavel2:

      SQ=SQRT(SQ)
      if x ge 0 and y ge 0 then begin
        PHI=ATAN(Y/X)
      endif else if x lt 0 and y ge 0 then begin
        phi=atan(y/x)+3.141592654
      endif else if x ge 0 and y lt 0 then begin
        phi=atan(y/x)+6.28318531
      endif else if x lt 0 and y lt 0 then begin
        phi=atan(y/x)+3.141592654
      endif

      TETA=ATAN(SQ/Z)
 ;     IF (PHI LT 0.) then PHI=PHI+6.28318531
      goto, nextstep

lavel3:
      SQ=R*SIN(TETA)
      X=SQ*COS(PHI)
      Y=SQ*SIN(PHI)
      Z=R*COS(TETA)
      goto, nextstep

nextstep:

      END