      pro STEP_small, N,X,Y,Z,DS,ERRIN,IOPT,PARMOD,EXNAME,fac
;C
;C RE-CALCULATES COORDS X,Y,Z FOR ONE STEP ALONG FIELD LINE. N IS MAXIMUM
;C ORDER OF HARMONICS IN MAIN FIELD EXPANSION, DS IS STEP SIZE, ERRIN IS
;C PERMISSIBLE ERROR VALUE, IOPT AND EXNAME - SEE COMMENTS TO SUBROUTINE TRACE
;C  ALL THE PARAMETERS ARE INPUT ONES; OUTPUT IS THE RENEWED TRIPLET X,Y,Z
;C
;C     LAST MODIFICATION:  JAN 5, 2001 (NO ESSENTIAL CHANGES, BUT
;C                            SOME REDUNDANT STATEMENTS TAKEN OUT)
;C
;C     WRITTEN BY:  N. A. TSYGANENKO
;C
;C
;      DIMENSION PARMOD(10)
;      COMMON /GEOPACK/ A(26),DS3,K,IY,B(8)
      COMMON GEOPACK, ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,SFI,CFI,SPS,$
       CPS,SHI,CHI,HI,PSI,XMUT,A11,A21,A31,A12,A22,A32,A13,A23,A33,DS3,$
       K,IY,CGST,SGST
 ;     EXTERNAL EXNAME
Re=6371.0

;
      K=N
  lavel1:
      DS3=-DS/3.
      RHAND_small,X,Y,Z,R11,R12,R13,IOPT,PARMOD,EXNAME,fac
;      print,'Bx/B=',R11,'     By/B=',R12,'     Bz/B=',R13,abs(r13)/r13*(R11^2+R12^2+R13^2)
      RHAND_small,X+R11,Y+R12,Z+R13,R21,R22,R23,IOPT,PARMOD,EXNAME,fac
      RHAND_small,X+.5*(R11+R21),Y+.5*(R12+R22),Z+.5*(R13+R23),R31,R32,R33,IOPT,PARMOD,EXNAME,fac
      RHAND_small,X+.375*(R11+3.*R31),Y+.375*(R12+3.*R32),Z+.375*(R13+3.*R33),R41,R42,R43,IOPT,PARMOD,EXNAME,fac
      RHAND_small,X+1.5*(R11-3.*R31+4.*R41),Y+1.5*(R12-3.*R32+4.*R42),Z+1.5*(R13-3.*R33+4.*R43),R51,R52,R53,IOPT,PARMOD,EXNAME,fac
      ERRCUR=ABS(R11-4.5*R31+4.*R41-.5*R51)+ABS(R12-4.5*R32+4.*R42-.5*R52)+ABS(R13-4.5*R33+4.*R43-.5*R53)
        IF (ERRCUR LT ERRIN) then GOTO, lavel2
      DS=DS*.5
      GOTO, lavel1
  lavel2:
      X=X+.5*(R11+4.*R41+R51)
      Y=Y+.5*(R12+4.*R42+R52)
      Z=Z+.5*(R13+4.*R43+R53)
;      print,'Xgsm(km)=',x*Re,'  /  Ygsm(km)=',y*Re,'  /  Zgsm(km)=',z*Re,'  /  r(km)=',sqrt((x*Re)^2+(y*Re)^2+(z*Re)^2)-re,'  /  r(Re)=',sqrt((x*Re)^2+(y*Re)^2+(z*Re)^2)/re
;      printf,1,x*Re,y*re,z*re,sqrt((x*Re)^2+(y*Re)^2+(z*Re)^2)-re
      IF (ERRCUR LT ERRIN*.04 AND ABS(DS) LT 1.33) then DS=DS*1.5
      RETURN
      END
