pro SUN,IYR,IDAY,IHOUR,MINU,ISEC,GST,SLONG,SRASN,SDEC
;C
;C  CALCULATES FOUR QUANTITIES NECESSARY FOR COORDINATE TRANSFORMATIONS
;C  WHICH DEPEND ON SUN POSITION (AND, HENCE, ON UNIVERSAL TIME AND SEASON)
;C
;C-------  INPUT PARAMETERS:
;C  IYR,IDAY,IHOUR,MIN,ISEC -  YEAR, DAY, AND UNIVERSAL TIME IN HOURS, MINUTES,
;C    AND SECONDS  (IDAY=1 CORRESPONDS TO JANUARY 1).
;C
;C-------  OUTPUT PARAMETERS:
;C  GST - GREENWICH MEAN SIDEREAL TIME, SLONG - LONGITUDE ALONG ECLIPTIC
;C  SRASN - RIGHT ASCENSION,  SDEC - DECLINATION  OF THE SUN (RADIANS)
;C  ORIGINAL VERSION OF THIS SUBROUTINE HAS BEEN COMPILED FROM:
;C  RUSSELL, C.T., COSMIC ELECTRODYNAMICS, 1971, V.2, PP.184-196.
;C
;C     LAST MODIFICATION:  JAN 5, 2001 (NO ESSENTIAL CHANGES, BUT
;C     SOME REDUNDANT STATEMENTS TAKEN OUT FROM THE PREVIOUS VERSION)
;C
;C     ORIGINAL VERSION WRITTEN BY:    Gilbert D. Mead
;C
      DJ=0.0d
      FDAY=0.0d
      RAD=57.295779513
;C
      IF (IYR LT 1901) OR (IYR GT 2099) then goto, nextstep
      FDAY=double(IHOUR*3600l+MINU*60l+ISEC)/86400.0d
      DJ=365*(IYR-1900)+(IYR-1901)/4+IDAY-0.5D0+FDAY
      T=double(DJ/36525.)
      VL=double((279.696678+0.9856473354*DJ) mod 360.0)
      GST=double((279.690983+.9856473354*DJ+360.*FDAY+180.) mod 360.0)/RAD
      gst1=double((279.690983+.9856473354*DJ+360.*FDAY+180.)-(fix((279.690983+.9856473354*DJ+360.*FDAY+180.)/360.d)*360.d))
      print, gst, gst1/rad
      stop
      G=double((358.475845+0.985600267*DJ) mod 360.0)/RAD
      SLONG=double((VL+(1.91946-0.004789*T)*SIN(G)+0.020094*SIN(2.*G)))/RAD
      IF (SLONG GT 6.2831853) then SLONG=SLONG-6.2831853
      IF (SLONG LT 0.) then SLONG=SLONG+6.2831853
      OBLIQ=double(23.45229-0.0130125*T)/RAD
      SOB=SIN(OBLIQ)
      SLP=SLONG-9.924E-5
;C
;C   THE LAST CONSTANT IS A CORRECTION FOR THE ANGULAR ABERRATION  DUE TO
;C   THE ORBITAL MOTION OF THE EARTH
;C
      SIND=SOB*SIN(SLP)
      COSD=SQRT(1.-SIND^2)
      SC=SIND/COSD
      SDEC=ATAN(SC)
      SRASN=double(3.141592654-ATAN((COS(OBLIQ)/SOB*SC)/(-COS(SLP)/COSD)))
nextstep:
      END