      pro TRACE_small, XI,YI,ZI,DIR,RLIM,R0,IHARM,NP,IOPT,PARMOD,EXNAME,XF,YF,ZF,XX,YY,ZZ,L,fac
;C
;C   TRACES A FIELD LINE FROM AN ARBITRARY POINT OF SPACE TO THE EARTH'S
;C   SURFACE OR TO A MODEL LIMITING BOUNDARY.
;C
;C------------- INPUT PARAMETERS:
;C
;C   XI,YI,ZI - GSM COORDS OF INITIAL POINT (IN EARTH RADII),
;C
;C   DIR - SIGN OF TRACING DIRECTION: IF DIR=1. THEN ANTIPARALLEL TO
;C     B VECTOR (E.G. FROM NORTHERN TO SOUTHERN CONJUGATE POINT),
;C     AND IF DIR=-1. THEN PARALLEL TO B.
;C
;C   R0 -  RADIUS OF A SPHERE (IN RE) FOR WHICH FOOTPOINT POINT COORDINATES
;C     XF,YF,ZF  ARE TO BE CALCULATED.
;C
;C   RLIM - UPPER LIMIT OF THE GEOCENTRIC DISTANCE, WHERE THE TRACING IS TERMINATED.
;C
;C   IHARM - THE HIGHEST ORDER OF SPHERICAL HARMONICS IN THE MAIN FIELD EXPANSION,
;C     THIS PARAMETER DEPENDS ON A VERSION OF THE MAIN GEOMAGNETIC FIELD MODEL.
;C     THE SUBROUTINE IGRF INCLUDED IN THIS PACKAGE HAS IHARM=10.
;C     IF THE MAIN FIELD CAN BE ASSUMED PURELY DIPOLAR, THEN TAKE IHARM=0
;C     AND SPECIFY A VALUE OF THE GEODIPOLE TILT ANGLE PSI (IN RADIANS)
;C     IN THE 16-TH ELEMENT OF THE COMMON BLOCK /GEOPACK/ BEFORE INVOKING TRACE.
;C     OTHERWISE INVOKE  RECALC  BEFORE USING  TRACE.
;C
;C   NP - UPPER ESTIMATE OF THE NUMBER OF STEPS ALONG A FIELD LINE
;C     (IN MOST CASES, NP=500 IS SUFFICIENT).
;C
;C   IOPT - A MODEL INDEX; CAN BE USED FOR SPECIFYING AN OPTION OF THE EXTERNAL FIELD
;C       MODEL (E.G., INTERVAL OF THE KP-INDEX). ALTERNATIVELY, ONE CAN USE THE ARRAY
;C       PARMOD FOR THAT PURPOSE (SEE BELOW); IN THAT CASE IOPT CAN BE JUST IGNORED.
;C
;C    PARMOD -  A 10-ELEMENT ARRAY CONTAINING MODEL PARAMETERS, NEEDED FOR A UNIQUE
;C      SPECIFICATION OF THE EXTERNAL FIELD. THE CONCRETE MEANING OF THE COMPONENTS
;C      OF PARMOD DEPENDS ON A SPECIFIC VERSION OF THE EXTERNAL FIELD MODEL.
;C
;C    EXNAME - NAME OF A SUBROUTINE PROVIDING COMPONENTS OF THE EXTERNAL MAGNETIC FIELD.
;C
;C-------------- OUTPUT PARAMETERS:
;C
;C   XF,YF,ZF - GSM COORDS OF THE LAST CALCULATED POINT OF A FIELD LINE
;C   XX,YY,ZZ - ARRAYS, CONTAINING COORDS OF FIELD LINE POINTS. THEIR SIZE SHOULD BE
;C      NOT LESS THAN  NP.
;C   L - ACTUAL NUMBER OF THE CALCULATED FIELD LINE POINTS. IF L EXCEEDS NP, THE TRACING
;C     TERMINATES, AND A WARNING IS DISPLAYED.
;C
;C
;C     LAST MODIFICATION:  JAN 5, 2001 (NO ESSENTIAL CHANGES)
;C
;C     WRITTEN BY:  N. A. TSYGANENKO
;C
      COMMON GEOPACK, ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,SFI,CFI,SPS,$
       CPS,SHI,CHI,HI,PSI,XMUT,A11,A21,A31,A12,A22,A32,A13,A23,A33,DD,$
       K1,K2,CGST,SGST

  ;    XX=fltarr(np)
  ;    yy=fltarr(np)
  ;    zz=fltarr(np)
      parmod=fltarr(10)
      xr=0.0
      yr=0.0
      zr=0.0

   ;   EXNAME='IGRF'

      J=IHARM
      ERR=0.0005
      L=0
      DS=0.5*DIR
      X=XI
      Y=YI
      Z=ZI
      DD=DIR
      K1=IHARM
      AL=0.
      RHAND,X,Y,Z,R1,R2,R3,IOPT,PARMOD,exname
       if (X*R1+Y*R2+Z*R3) ge 0.0 then begin
        ad=0.01
      endif else begin
        ad=-0.01
      endelse
;      AD=SIGN(0.01,X*R1+Y*R2+Z*R3)
      RR=SQRT(X^2+Y^2+Z^2)+AD

      R1=sqrt(X^2+Y^2+Z^2)
      if r1 gt rlim then begin
        ialt=1
;        print, 'target point is the point below satellite'
      endif else begin
        ialt=0
;        print, 'target is the point above satellite'
      endelse


  lavel1:
      L=L+1
      IF (L GT NP) then GOTO, lavel7
      XX(L-1)=X
      YY(L-1)=Y
      ZZ(L-1)=Z
      RYZ=Y^2+Z^2
      R2=X^2+RYZ
      R=SQRT(R2)
;      print, r, rlim,rr,r0,x,y,z,l
      if ialt eq 0 then begin
        IF (R GT RLIM OR RYZ GT 1600. OR X GT 20.) then GOTO, lavel8
      endif else begin
        IF (R LT RLIM OR RYZ GT 1600. OR X GT 20.) then GOTO, lavel8
      endelse
      IF (R LT R0 AND RR GT R) then GOTO, lavel6
      IF (R GE RR) then GOTO, lavel5
      IF (R GT 5.) then GOTO, lavel5
      IF (R GE 3.) then GOTO, lavel3
      FC=0.2
      IF (R-R0 LT 0.05) then FC=0.05
      AL=FC*(R-R0+0.2)
      DS=DIR*AL
      GOTO, lavel4
  lavel3:
      DS=DIR
      AL=1.
  lavel4:
      XR=X
      YR=Y
      ZR=Z
  lavel5:
      RR=R
      IF (IHARM NE 0) then J=1+20./(R-AL)
      IF (J GT IHARM) then J=IHARM
      STEP_small, J,X,Y,Z,DS,ERR,IOPT,PARMOD,EXNAME,fac
      GOTO, lavel1
  lavel6:
      R1=(R0-R)/(RR-R)
      X=X-(X-XR)*R1
      Y=Y-(Y-YR)*R1
      Z=Z-(Z-ZR)*R1
      GOTO, lavel8
  lavel7:
      print, '**** COMPUTATIONS IN THE SUBROUTINE TRACE ** ARE TERMINATED: NP IS TOO SMALL ****'
      L=NP
      RETURN
  lavel8:
      XF=X
      YF=Y
      ZF=Z
      for I=L,NP do begin
        XX(I-1)=XF
        YY(I-1)=YF
        ZZ(I-1)=ZF
      endfor
  lavel9:
;  stop
      RETURN
      END
