#
# FLOW spec
#
%define         name    flow
%define         version 1.5
%define         release 1.el7
%define         prefix  /usr
%define         cspice  /usr/local/cspice
# %define         cfitsio /usr/local/cfitsio

Summary:        Field Of View Visualizer for SPICE Toolkit
Name:           %{name}
Version:        %{version}
Release:        %{release}
#Copyright:      Japan Aerospace Exploration Agency
License:        BSD License (no advertising)
Group:          Applications/Multimedia
Url:            https://darts.isas.jaxa.jp/planet/tools/flow/
Vendor:         Japan Aerospace Exploration Agency
Source:         https://darts.jaxa.jp/planet/tools/flow/%{name}-%{version}.tar.gz
Packager:       Yukio Yamamoto
BuildRoot:      /var/tmp/%{name}-%{version}-root
Requires:       lua, libxml2, zlib, glibc, libcurl, libjpeg-turbo, libpng, ncompress

%description
FLOW is a field-of-view simulator of an instrument on-boarda spacecraft. This software is designed based on SPICE Toolkit developed by NASA JPL.

%prep
%setup -q

%build
rm -rf $RPM_BUILD_ROOT
CFLAGS=$RPM_OPT_FLAGS \
        ./configure --prefix=%{prefix} --with-cspice=%{cspice} --enable-wms --enable-spice-dsk
make

%install
[ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;
make -e prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
[ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;

%files
%defattr(-,root,root)
%doc ChangeLog COPYING README
%{prefix}/bin/flow_se
%{prefix}/bin/flow_ig
%{prefix}/bin/flow_cov

%changelog
* Sat Dec 5 2020 Yukio Yamamoto 1.5-1.el7
- Fix color order from BGR to RGB for polygon
* Sun Aug 13 2017 Yukio Yamamoto 1.4-1.el6
- Support SPICE N0066
- Fix projection plane
* Thu Sep 1 2015 Yukio Yamamoto 1.3-1.el6
- Change the Z-axis of a depiction from the Z-axis of an instrument frame to a boresight vector
- Use Mars B.C. instead of the Mars mass center for DE43x
- Fix coverage listing bug in flow_cov
* Fri May 15 2015 Yukio Yamamoto 1.2-1.el6
- Fix WCS header in FITS using flow_ig -f option
- Add flow_cov program to check time coverage
* Thu Jun 19 2014 Yukio Yamamoto 1.1.1-1.el6
- Fix the start index corresponding to magnitude
* Mon May 19 2014 Yukio Yamamoto 1.1-1.el6
- Fix the simulation when FOV shape is CIRCLE or ELLIPSE
- Fix the star sizes corresponding to magnitude
- Support sky_color option in the configuration
- Show effective options when the configure script ends
* Thu Jun 20 2013 Yukio Yamamoto 1.0-1.el6
- Initial RPM release
