AC_DEFUN([AX_WITH_CSPICE],
[
have_spicedsk=no
AC_ARG_WITH(cspice,
  AC_HELP_STRING([--with-cspice=DIR],
                 [Specify location of cspice]),
  [
	case "$withval" in
	*)
	CSPICE_DIR="$withval"
	;;
	esac
  ],[CSPICE_WANT_VERSION=any])

case $CSPICE_DIR in
  /* ) ;;
  *) CSPICE_DIR=`pwd`"/$CSPICE_DIR" ;;
esac
CSPICE_LIBDIR="$CSPICE_DIR/lib"
CSPICE_INCDIR="$CSPICE_DIR/include"

AC_ARG_WITH(cspice-inc,
  AC_HELP_STRING([--with-cspice-inc=DIR],
                 [Specify location of cspice headers]),
                 CSPICE_INCDIR="$withval")
case $CSPICE_INCDIR in
 /* ) ;;
 *) CSPICE_INCDIR=`pwd`"/$CSPICE_INCDIR" ;;
esac

AC_ARG_WITH(cspice-lib,
  AC_HELP_STRING([--with-cspice-lib=DIR],
                 [Specify location of cspice libraries]),
                 CSPICE_LIBDIR="$withval")
case $CSPICE_LIBDIR in
 /* ) ;;
 *) CSPICE_LIBDIR=`pwd`"/$CSPICE_LIBDIR" ;;
esac

for INCDIR in $CSPICE_INCDIR ; do
  AC_CHECK_FILE([$INCDIR/SpiceUsr.h], [CSPICE_INC=-I$INCDIR; break])
done

for LIBDIR in $CSPICE_LIBDIR; do
  AC_CHECK_FILE([$LIBDIR/cspice.a], [CSPICE_LIB="$LIBDIR/cspice.a"; break])
done

if test "x$CSPICE_LIB" = x; then
  AC_MSG_ERROR([*** install the cspice or check --with-cspice option.],[1])
fi

AC_ARG_ENABLE(spice-dsk,
  AC_HELP_STRING(
    [--enable-spice-dsk],
    [Enable SPICE DSK format (DSK library is required)]),
  [use_spice_dsk=$enableval], [use_spice_dsk=auto])

if test "x$use_spice_dsk" = "xyes"; then
  for _dsk_path in $CSPICE_DIR/include $CSPICE_DIR/src/dsklib_c; do
    AC_CHECK_FILE(
      [$_dsk_path/SpiceDSK.h],
      [DSK_INC=$_dsk_path; break])
  done

  if test "x$DSK_INC" = x; then
      AC_MSG_ERROR([*** cspice dsk requires SpiceDSK.h])
  fi

  CSPICE_INC="$CSPICE_INC -I$DSK_INC"

  old_CFLAGS="$CFLAGS"
  CFLAGS="$CSPICE_INC"
  AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
  [[#include <SpiceUsr.h>
  void func () {
    SpiceInt handle=0, nv, np;
    SpiceDLADescr dladsc;
    dskz02_c(handle, &dladsc, &nv, &np);
  }]])], [dsk_lib=yes], [dsk_lib=no])
  CFLAGS="$old_CFLAGS"

  if test $dsk_lib = "no"; then
    AC_CHECK_FILE(
      [$LIBDIR/dsklib_c.a],
      [CSPICE_LIB="$LIBDIR/dsklib_c.a $CSPICE_LIB"],
      AC_MSG_ERROR([*** cspice dsk requires dsklib_c.a]))
  fi

  AC_DEFINE(ENABLE_SPICE_DSK, 1, [Define to 1 if you use SPICE DSK])
  have_spicedsk=yes
fi

AC_SUBST(CSPICE_CFLAGS,$CSPICE_INC)
AC_SUBST(CSPICE_LIBS,$CSPICE_LIB)
])
