AC_DEFUN([AX_WITH_CFITSIO],
[
  have_libcfitsio=no
  AC_ARG_WITH([cfitsio],
    [AS_HELP_STRING([--with-cfitsio@<:@=ARG@:>@],
      [Include FITS support (ARG=no or libcfitsio path)])])

  if test "$with_cfitsio" = "no"; then
    echo "FITS support disabled."
  elif test "$with_cfitsio" = "yes" -o "$with_cfitsio" = ""; then
    AC_LANG_PUSH([C])
    CFITSIO_INCDIRS="/usr/include /usr/local/include /usr/include/cfitsio /usr/local/include/cfitsio /usr/include/libcfitsio0"
    CFITSIO_LIBDIRS="/lib /lib64 /usr/lib /usr/lib64 /usr/local/lib /usr/local/lib64"
  else
    AC_MSG_NOTICE([Using directory "$withval"])
    CFITSIO_INCDIRS="$withval $withval/include"
    CFITSIO_LIBDIRS="$withval $withval/lib $withval/lib64"
  fi

  if ! test "$with_cfitsio" = "no"; then
    AC_ARG_WITH(cfitsio-inc,
      [AC_HELP_STRING([--with-cfitsio-inc=DIR],
        [Specify location of cfitsio headers])])

    if test "x$with_cfitsio_inc" != "x"; then
      CFITSIO_INCDIRS="$withval"
    fi

    case $CFITSIO_INCDIRS in
     /* ) ;;
     *) CFITSIO_INCDIRS=`pwd`"/$CFITSIO_INCDIRS" ;;
    esac

    AC_ARG_WITH(cfitsio-lib,
      [AC_HELP_STRING([--with-cfitsio-lib=DIR],
        [Specify location of cfitsio libraries])])

    if test "x$with_cfitsio_lib" != "x"; then
      CFITSIO_LIBDIRS="$withval"
    fi

    case $CFITSIO_LIBDIRS in
     /* ) ;;
     *) CFITSIO_LIBDIRS=`pwd`"/$CFITSIO_LIBDIRS" ;;
    esac

    for i in $CFITSIO_INCDIRS ; do
      AC_CHECK_FILE([$i/fitsio.h], [CFITSIO_INC=$i; break;])
      i=$i/cfitsio
      AC_CHECK_FILE([$i/fitsio.h], [CFITSIO_INC=$i; break;])
    done

    if test "x$CFITSIO_INC" = x ; then
      AC_MSG_ERROR([fitsio.h is not found. Try --with-cfitsio or --without-cfitsio options.])
    fi

    check_ldflag="no"
    save_CFLAGS=$CFLAGS
    CFLAGS="-I$CFITSIO_INC $CFLAGS"
    save_LIBS=$LIBS
    for i in $CFITSIO_LIBDIRS ; do
      AC_MSG_CHECKING([for libcfitsio in $i])
      LIBS="$save_LIBS -L$i -lcfitsio $LDFLAGS"
      AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <fitsio.h>
int main() {
  int d,m,y,s;
  ffgsdt(&d,&m,&y,&s);
  exit (0);
}
]])],
      [check_ldflag=yes],[check_ldflag=no])
      if test $check_ldflag = "yes"; then
        AC_MSG_RESULT([yes])
        CFITSIO_LIB=$LIBS
        have_libcfitsio=yes
        break;
      else
        AC_MSG_RESULT([no])
      fi
    done
    if test "x$check_ldflag" = "xno" ; then
      AC_MSG_ERROR(libcfitsio cannot be linked)
    fi
    CFLAGS=$save_CFLAGS
    LIBS=$save_LIBS
    AC_DEFINE(HAVE_CFITSIO, [1], [Define to 1 if you have libcfitsio])
    AC_SUBST(CFITSIO_CFLAGS,"-I$CFITSIO_INC")
    AC_SUBST(CFITSIO_LIBS,$CFITSIO_LIB)
  fi
])
