AC_DEFUN([AX_WITH_LIBJPEG],
[
AC_MSG_CHECKING(for libjpeg)
JPEG_LIBS=""
have_libjpeg=no

AC_ARG_WITH(libjpeg,AC_HELP_STRING([--with-libjpeg@<:@=DIR@:>@], [path to libjpeg]),,)

save_CFLAGS=$CFLAGS
save_LDFLAGS=$LDFLAGS

if test "x$with_libjpeg" != "xno"; then
  if test "x$with_libjpeg" != "xyes"; then
    JPEG_INC=$with_libjpeg/include
    JPEG_LIB=$with_libjpeg/lib
    CFLAGS="$CFLAGS -I$JPEG_INC"
    LDFLAGS="$LDFLAGS -ljpeg -L$JPEG_LIB"
  fi

  AC_CHECK_LIB(jpeg, jpeg_start_decompress,
  [
    AC_CHECK_HEADERS(jpeglib.h,
    [
      AC_DEFINE(HAVE_LIBJPEG, 1, [Define to 1 if you have libjpeg])
      have_libjpeg=yes
      AC_SUBST(JPEG_CFLAGS,"-I$JPEG_INC")
      AC_SUBST(JPEG_LIBS,"-ljpeg -L$JPEG_LIB")
    ])])
fi
#if test "x$have_libjpeg" != "xyes"; then
#  AC_MSG_FAILURE([*** install the libjpeg or check --with-libjpeg option.])
#fi

CFLAGS=$save_CFLAGS
LDFLAGS=$save_LDFLAGS
])
